/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.storedProcedures;

import edu.udo.cs.miningmart.storedProcedures.Attribute;
import edu.udo.cs.miningmart.storedProcedures.BusinessDbConnectionSource;
import edu.udo.cs.miningmart.storedProcedures.DataType;
import edu.udo.cs.miningmart.storedProcedures.DbConnector;
import edu.udo.cs.miningmart.storedProcedures.OutputColumnset;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import edu.udo.cs.miningmart.storedProcedures.Windowing;
import java.sql.SQLException;

public class SMF {
    private final DbConnector connector;
    private final Windowing window;
    private final OutputColumnset out;
    private static final int INDEXONATTRIB = 2;

    public SMF(BusinessDbConnectionSource dbc, String source, String time, String column, String target, String timeStartOut, String timeEndOut, String columnOut, int windowSize, int distance) throws SQLException, TimeOperatorException {
        this.connector = new DbConnector(dbc);
        String timeDT = DataType.getColumnDataType(source, time, this.connector);
        String columnDT = DataType.getColumnDataType(source, column, this.connector);
        Attribute timeAttr = new Attribute(time, timeDT, timeDT);
        Attribute columnAttr = new Attribute(column, columnDT, dbc.getNameOfNumericDatatype());
        if (!timeAttr.isConvertable()) {
            DataType.wrongDataType(target, timeAttr);
        }
        if (!columnAttr.isConvertable()) {
            DataType.wrongDataType(target, columnAttr);
        }
        Attribute timeStartAttr = new Attribute(timeStartOut, timeDT, timeDT);
        Attribute timeEndAttr = new Attribute(timeEndOut, timeDT, timeDT);
        Attribute columnOutAttr = new Attribute(columnOut, columnDT, dbc.getNameOfNumericDatatype());
        Attribute[] allAttributes = new Attribute[]{timeStartAttr, timeEndAttr, columnOutAttr};
        this.out = new OutputColumnset(target, allAttributes, this.connector.getConnection());
        this.window = new Windowing(windowSize, distance, this.connector);
        if (!this.window.open("SELECT " + columnAttr.getConvertedInput() + ", " + timeAttr.getConvertedInput() + " FROM " + source)) {
            DbConnector.infoOutput("Error while opening " + source);
            throw new TimeOperatorException("Could not read from table '" + source + "'!");
        }
    }

    public void calc() throws TimeOperatorException {
        String[] ret = null;
        do {
            if ((ret = this.getWindow().getNextWnd()) == null) continue;
            Long start = new Long(this.getWindow().getTimeFirstEntry());
            Long end = new Long(this.getWindow().getTimeLastEntry());
            Double val = new Double(this.calcSum(ret) / (double)ret.length);
            this.getOutputColumnset().insert(new Object[]{start, end, val});
        } while (ret != null);
        this.getWindow().close();
        this.connector.close();
    }

    protected Windowing getWindow() {
        return this.window;
    }

    protected OutputColumnset getOutputColumnset() {
        return this.out;
    }

    private double calcSum(String[] array) {
        double ret = 0.0;
        for (int i = 0; i < array.length; ++i) {
            ret += Double.parseDouble(array[i]);
        }
        return ret;
    }

    public static void dbSMF(Object dbc, String source, String time, String column, String target, String timeStartOut, String timeEndOut, String columnOut, int windowSize, int distance) throws SQLException, TimeOperatorException {
        BusinessDbConnectionSource dbcCasted = dbc instanceof BusinessDbConnectionSource ? (BusinessDbConnectionSource)dbc : null;
        SMF smf = new SMF(dbcCasted, source, time, column, target, timeStartOut, timeEndOut, columnOut, windowSize, distance);
        smf.calc();
        smf = null;
    }
}

