/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.storedProcedures;

import edu.udo.cs.miningmart.storedProcedures.BusinessDbConnectionSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DbConnector {
    private static final boolean debugMessages = false;
    private final Connection con;
    private BusinessDbConnectionSource myDbc = null;

    public DbConnector(BusinessDbConnectionSource dbc) throws SQLException {
        try {
            if (dbc == null) {
                this.con = DriverManager.getConnection("jdbc:default:connection:");
            } else {
                this.con = dbc.getDatabaseConnectionForData();
                this.myDbc = dbc;
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception in class miningmart.storedProcedures.DbConnector when trying to connect to DB: " + e.getMessage());
        }
        if (this.con == null) {
            throw new SQLException("Database connection failed!");
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    public void close() {
        Connection c = this.getConnection();
        try {
            if (c != null && !c.isClosed()) {
                c.commit();
                c.close();
            }
        }
        catch (SQLException e) {
            DbConnector.infoOutput("Closing Connection in class DbConnector failed:\n" + e);
        }
    }

    public static void infoOutput(String out) {
    }

    public String getSelectStringColumnDataType(String tableName, String owner, String columnName) {
        if (this.myDbc != null) {
            return this.myDbc.getSelectStringForColumnDataType(owner, tableName, columnName);
        }
        return null;
    }
}

