/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.m4.core.Value;
import edu.udo.cs.miningmart.schemamatching.MatchingResult;
import edu.udo.cs.miningmart.schemamatching.NameAndTypeBasedSchemaMatcher;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import java.util.Collection;
import java.util.Vector;

public class NgramMatcher
extends NameAndTypeBasedSchemaMatcher {
    private int n = 3;

    public NgramMatcher(int n) {
        this.n = n;
    }

    public double getNameSimilarity(String str1, String str2) throws SchemaMatchException {
        Value v;
        int maxIndex;
        if (str1 == null || str2 == null) {
            return 0.0;
        }
        if (str1.length() <= this.n && str2.length() <= this.n) {
            return this.getStringSimilarity(str1, str2);
        }
        Vector<Value> firstNGrams = new Vector<Value>();
        Vector<Value> secondNGrams = new Vector<Value>();
        boolean numberOfActualMatches = false;
        for (int i = 0; i < str1.length(); ++i) {
            maxIndex = Math.min(i + this.n, str1.length());
            String first = str1.substring(i, maxIndex);
            v = new Value();
            v.setValue(first);
            firstNGrams.add(v);
        }
        for (int j = 0; j < str2.length(); ++j) {
            maxIndex = Math.min(j + this.n, str2.length());
            String second = str2.substring(j, maxIndex);
            v = new Value();
            v.setValue(second);
            secondNGrams.add(v);
        }
        MatchingResult<E>[][] matrix = this.getSimilarityMatrix(firstNGrams, secondNGrams);
        Collection maps = this.getSimilarMatchingsGreedy(matrix, true);
        return this.getGlobalSimilarity(firstNGrams, secondNGrams, maps);
    }

    public double getStringSimilarity(String ngram1, String ngram2) {
        String n1 = ngram1.toLowerCase();
        String n2 = ngram2.toLowerCase();
        if (n1.length() < n2.length() && n2.startsWith(n1)) {
            return 0.75;
        }
        if (n1.length() > n2.length() && n1.startsWith(n2)) {
            return 0.75;
        }
        if (n1.length() == n2.length() && n2.equals(n1)) {
            return 1.0;
        }
        return 0.0;
    }
}

