/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.schemamatching.MmSchemaMatcher;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;

public abstract class NameAndTypeBasedSchemaMatcher
extends MmSchemaMatcher {
    public double getDirectSimilarity(BaseAttribute ba1, BaseAttribute ba2) throws SchemaMatchException {
        double nameSimilarity = this.getNameSimilarity(ba1.getName(), ba2.getName());
        double typeSimilarity = this.getDatatypeSimilarity(ba1, ba2);
        if (typeSimilarity < 0.5) {
            nameSimilarity *= 0.75;
        }
        return nameSimilarity;
    }

    public double getStringSimilarity(String str1, String str2) throws SchemaMatchException {
        if (str1 == null || str2 == null) {
            return 0.0;
        }
        if (str1.equalsIgnoreCase(str2)) {
            return 1.0;
        }
        return 0.0;
    }

    public double getDirectSimilarity(Concept con1, Concept con2) throws SchemaMatchException {
        return this.getNameSimilarity(con1.getName(), con2.getName());
    }

    public double getSimilarityInvolvingConcepts(BaseAttribute ba1, BaseAttribute ba2) throws SchemaMatchException {
        try {
            Concept con1 = ba1.getConcept();
            if (con1 == null) {
                throw new SchemaMatchException("BaseAttribute '" + ba1.getName() + "' does not have a concept!");
            }
            Concept con2 = ba2.getConcept();
            if (con2 == null) {
                throw new SchemaMatchException("BaseAttribute '" + ba2.getName() + "' does not have a concept!");
            }
            return (this.getNameSimilarity(ba1.getName(), ba2.getName()) + this.getNameSimilarity(con1.getName(), con2.getName())) / 2.0;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("Error accessing concept of BA: " + m4e.getMessage());
        }
    }
}

