/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.core.ConceptualDatatypes;
import edu.udo.cs.miningmart.schemamatching.MatchingResult;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MmSchemaMatcher {
    protected static final double THRESHOLD = 0.5;

    public abstract double getDirectSimilarity(BaseAttribute var1, BaseAttribute var2) throws SchemaMatchException;

    public abstract double getDirectSimilarity(Concept var1, Concept var2) throws SchemaMatchException;

    public abstract double getSimilarityInvolvingConcepts(BaseAttribute var1, BaseAttribute var2) throws SchemaMatchException;

    public double getDatatypeSimilarity(BaseAttribute ba1, BaseAttribute ba2) throws SchemaMatchException {
        if (ba1 == null || ba2 == null) {
            return 0.0;
        }
        try {
            String type1 = ba1.getConceptualDataTypeName();
            String type2 = ba2.getConceptualDataTypeName();
            if (type1.equalsIgnoreCase(type2)) {
                return 1.0;
            }
            if (ConceptualDatatypes.checkDatatypeCompatibility(type1, type2) || ConceptualDatatypes.checkDatatypeCompatibility(type2, type1)) {
                return 0.9;
            }
            return 0.0;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("M4 error matching data types of BaseAttributes '" + ba1.getName() + "' and '" + ba2.getName() + "': " + m4e.getMessage());
        }
    }

    public abstract double getNameSimilarity(String var1, String var2) throws SchemaMatchException;

    public abstract double getStringSimilarity(String var1, String var2) throws SchemaMatchException;

    public double getSimilarity(Relation rel1, Relation rel2) throws SchemaMatchException {
        if (rel1 == null || rel2 == null) {
            return 0.0;
        }
        try {
            Concept from1 = rel1.getTheFromConcept();
            Concept to1 = rel1.getTheToConcept();
            Concept from2 = rel2.getTheFromConcept();
            Concept to2 = rel2.getTheToConcept();
            double fromSimilarity = this.getSimilarity(from1, from2);
            double toSimilarity = this.getSimilarity(to1, to2);
            double firstSim = (fromSimilarity + toSimilarity) / 2.0;
            if (rel1.isOneToManyRelation() && rel2.isOneToManyRelation()) {
                return firstSim;
            }
            fromSimilarity = this.getSimilarity(from1, to2);
            toSimilarity = this.getSimilarity(from2, to1);
            double secondSim = (fromSimilarity + toSimilarity) / 2.0;
            double bestSim = Math.max(firstSim, secondSim);
            if (rel1.isManyToManyRelation() && rel2.isManyToManyRelation()) {
                return bestSim;
            }
            return bestSim * 0.6;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("M4 error matching Relations '" + rel1.getName() + "' and '" + rel2.getName() + "': " + m4e.getMessage());
        }
    }

    public double getSimilarity(Concept con1, Concept con2) throws SchemaMatchException {
        if (con1 == null || con2 == null) {
            return 0.0;
        }
        try {
            boolean conceptNamesMatch = false;
            double conceptSimilarity = this.getDirectSimilarity(con1, con2);
            conceptNamesMatch = conceptSimilarity >= 0.5;
            Collection basOfCon1 = con1.getAllBaseAttributes();
            Collection basOfCon2 = con2.getAllBaseAttributes();
            MatchingResult<U>[][] baMatrix = this.getSimilarityMatrix(basOfCon1, basOfCon2);
            Collection baMapping = this.getSimilarMatchingsGreedy(baMatrix, true);
            double baBasedSim = this.getGlobalSimilarity(basOfCon1, basOfCon2, baMapping);
            if (!conceptNamesMatch) {
                return 0.75 * baBasedSim;
            }
            return baBasedSim;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("MmSchemaMatcher.getSimilarity(Concept, Concept): M4Exception caught: " + m4e.getMessage());
        }
    }

    public <U extends ParameterObject> double getGlobalSimilarity(Collection<U> singleObjects1, Collection<U> singleObjects2, Collection<MatchingResult<U>> singleMappings) throws SchemaMatchException {
        if (singleObjects1 == null || singleObjects2 == null || singleMappings == null) {
            return 0.0;
        }
        int numberOfPossibleMatches = Math.min(singleObjects1.size(), singleObjects2.size());
        int differenceInNoOfObjects = Math.abs(singleObjects1.size() - singleObjects2.size());
        if (singleMappings.size() > numberOfPossibleMatches) {
            throw new SchemaMatchException("MmSchemaMatcher.getGlobalSimilarity: got more mappings than single objects!");
        }
        double sum = 0.0;
        for (MatchingResult<U> singleMapping : singleMappings) {
            sum += singleMapping.getSimilarity();
        }
        double globalSim = sum / (double)numberOfPossibleMatches;
        if (differenceInNoOfObjects == 0) {
            return globalSim;
        }
        double penaltyFactor = Math.pow(0.95, differenceInNoOfObjects);
        return globalSim * penaltyFactor;
    }

    public <U extends ParameterObject> MatchingResult<U>[][] getSimilarityMatrix(Collection<U> oneDimension, Collection<U> secondDimension) throws SchemaMatchException {
        if (oneDimension == null || secondDimension == null) {
            return null;
        }
        int n = oneDimension.size();
        int m = secondDimension.size();
        MatchingResult[][] result = new MatchingResult[n][m];
        Iterator<U> it1 = oneDimension.iterator();
        int n_index = 0;
        int m_index = 0;
        while (it1.hasNext()) {
            ParameterObject myObj1 = (ParameterObject)it1.next();
            Iterator<U> it2 = secondDimension.iterator();
            m_index = 0;
            while (it2.hasNext()) {
                ParameterObject myObj2 = (ParameterObject)it2.next();
                result[n_index][m_index] = new MatchingResult();
                result[n_index][m_index].setObjectOfFirstSchema(myObj1);
                result[n_index][m_index].setObjectOfSecondSchema(myObj2);
                double sim = Double.NaN;
                if (myObj1 instanceof BaseAttribute && myObj2 instanceof BaseAttribute) {
                    sim = this.getDirectSimilarity((BaseAttribute)myObj1, (BaseAttribute)myObj2);
                } else if (myObj1 instanceof Concept && myObj2 instanceof Concept) {
                    sim = this.getSimilarity((Concept)myObj1, (Concept)myObj2);
                } else if (myObj1 instanceof Relation && myObj2 instanceof Relation) {
                    sim = this.getSimilarity((Relation)myObj1, (Relation)myObj2);
                } else if (myObj1 instanceof Value && myObj2 instanceof Value) {
                    String name1 = ((Value)myObj1).getValue();
                    String name2 = ((Value)myObj2).getValue();
                    if (name1 != null && name2 != null) {
                        sim = this.getStringSimilarity(name1, name2);
                    }
                } else {
                    throw new SchemaMatchException("Error trying to create a similarity matrix: unknown or uncompatible objects!");
                }
                result[n_index][m_index].setSimilarity(sim);
                ++m_index;
            }
            ++n_index;
        }
        return result;
    }

    public MatchingResult<BaseAttribute>[][] getSimilarityMatrix(Concept con1, Concept con2) throws SchemaMatchException {
        if (con1 == null || con2 == null) {
            return null;
        }
        try {
            MatchingResult<U>[][] mr;
            Collection coll1 = con1.getAllBaseAttributes();
            Collection coll2 = con2.getAllBaseAttributes();
            MatchingResult<U>[][] mr2 = mr = this.getSimilarityMatrix(coll1, coll2);
            return mr2;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("MmSchemaMatcher.getSimilarityMatrix(Concept, Concept): M4Exception caught: " + m4e.getMessage());
        }
    }

    public boolean objectsAreSimilar(ParameterObject obj1, ParameterObject obj2) throws SchemaMatchException {
        double sim;
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof BaseAttribute && obj2 instanceof BaseAttribute) {
            sim = this.getDirectSimilarity((BaseAttribute)obj1, (BaseAttribute)obj2);
        } else if (obj1 instanceof Concept && obj2 instanceof Concept) {
            sim = this.getSimilarity((Concept)obj1, (Concept)obj2);
        } else if (obj1 instanceof Relation && obj2 instanceof Relation) {
            sim = this.getSimilarity((Relation)obj1, (Relation)obj2);
        } else {
            return false;
        }
        return sim >= 0.5;
    }

    public <U extends ParameterObject> Collection<MatchingResult<U>> getSimilarMatchingsGreedy(MatchingResult<U>[][] similarityMatrix, boolean useThreshold) {
        if (similarityMatrix == null) {
            return null;
        }
        Vector<MatchingResult<U>> ret = new Vector<MatchingResult<U>>();
        while (similarityMatrix.length > 0 && similarityMatrix[0].length > 0) {
            double bestOfAllMatchingSimilarities = -1.0;
            int bestRow = 0;
            int bestColumn = 0;
            int currentNoOfRows = similarityMatrix.length;
            int noOfColumns = similarityMatrix[0].length;
            for (int n = 0; n < similarityMatrix.length; ++n) {
                for (int m = 0; m < similarityMatrix[n].length; ++m) {
                    if (!(similarityMatrix[n][m].getSimilarity() >= bestOfAllMatchingSimilarities)) continue;
                    bestOfAllMatchingSimilarities = similarityMatrix[n][m].getSimilarity();
                    bestRow = n;
                    bestColumn = m;
                }
            }
            MatchingResult<U> result = similarityMatrix[bestRow][bestColumn];
            if (result.getSimilarity() >= 0.5 || !useThreshold) {
                ret.add(result);
            }
            if (useThreshold && result.getSimilarity() < 0.5) {
                return ret;
            }
            MatchingResult[][] newMatrix = new MatchingResult[currentNoOfRows - 1][noOfColumns - 1];
            int rowIndexForNewMatrix = 0;
            for (int n = 0; n < similarityMatrix.length; ++n) {
                int colIndexForNewMatrix = 0;
                if (n == bestRow) continue;
                for (int m = 0; m < similarityMatrix[n].length; ++m) {
                    if (m == bestColumn) continue;
                    newMatrix[rowIndexForNewMatrix][colIndexForNewMatrix] = similarityMatrix[n][m];
                    ++colIndexForNewMatrix;
                }
                ++rowIndexForNewMatrix;
            }
            similarityMatrix = newMatrix;
        }
        return ret;
    }
}

