/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.schemamatching;

import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.schemamatching.MatchingResult;
import edu.udo.cs.miningmart.schemamatching.MmSchemaMatcher;
import edu.udo.cs.miningmart.schemamatching.SchemaMatchException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModelMatcher {
    private MmSchemaMatcher theMatcherToUse;

    public DataModelMatcher(MmSchemaMatcher useThisMatcher) {
        this.theMatcherToUse = useThisMatcher;
    }

    public static Collection<Concept> addJoinsToCase(Case someCase) throws M4Exception {
        if (someCase == null) {
            return null;
        }
        Vector<Concept> theNewConcepts = new Vector<Concept>();
        for (Relation oneRel : someCase.getAllRelations()) {
            Concept joinConcept;
            Columnset joinCs = oneRel.getResultOfJoin();
            if (joinCs == null || (joinConcept = someCase.createConceptFromColumnset(joinCs)) == null) continue;
            theNewConcepts.add(joinConcept);
        }
        return theNewConcepts;
    }

    public Collection<MatchingResult<Concept>> getDataModelMatching(Collection<Concept> conceptualModel, Collection<Concept> targetModel) throws SchemaMatchException {
        if (conceptualModel == null || targetModel == null) {
            return null;
        }
        try {
            Collection<Concept> conceptualStars = this.findStarsInDataModel(conceptualModel);
            Collection<Concept> targetStars = this.findStarsInDataModel(targetModel);
            Collection<MatchingResult<Concept>> conceptsMatchedBasedOnStars = this.findMatchingsBasedOnStars(conceptualStars, targetStars);
            Collection<Relation> conceptualRelations = this.findRelationsInDataModel(conceptualModel);
            Collection<Relation> targetRelations = this.findRelationsInDataModel(targetModel);
            conceptualRelations = this.removeRelationsAlreadyMatched(conceptsMatchedBasedOnStars, conceptualRelations, true);
            targetRelations = this.removeRelationsAlreadyMatched(conceptsMatchedBasedOnStars, targetRelations, false);
            MatchingResult<Relation>[][] relationSimilarityMatrix = this.theMatcherToUse.getSimilarityMatrix(conceptualRelations, targetRelations);
            Collection<MatchingResult<Relation>> matchedRelations = this.theMatcherToUse.getSimilarMatchingsGreedy(relationSimilarityMatrix, true);
            Vector<MatchingResult<Concept>> allConceptMappings = new Vector<MatchingResult<Concept>>();
            allConceptMappings.addAll(conceptsMatchedBasedOnStars);
            allConceptMappings.addAll(this.getConceptMappingsFromRelationMappings(matchedRelations));
            Collection<Concept> remainingConceptualConcepts = this.removeConceptsAlreadyMatched(conceptualModel, allConceptMappings, true);
            Collection<Concept> remainingTargetConcepts = this.removeConceptsAlreadyMatched(targetModel, allConceptMappings, false);
            MatchingResult<Concept>[][] conceptSimilarityMatrix = this.theMatcherToUse.getSimilarityMatrix(remainingConceptualConcepts, remainingTargetConcepts);
            Collection<MatchingResult<Concept>> matchedConcepts = this.theMatcherToUse.getSimilarMatchingsGreedy(conceptSimilarityMatrix, true);
            allConceptMappings.addAll(matchedConcepts);
            if (allConceptMappings.size() > Math.min(conceptualModel.size(), targetModel.size())) {
                throw new SchemaMatchException("DataModelMatcher.getDataModelMatching(): got more mappings than single objects!");
            }
            return allConceptMappings;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("M4 error when computing data model similarity: " + m4e.getMessage());
        }
    }

    public boolean isSimilarityGoodEnough(double similarity) {
        return similarity >= 0.5;
    }

    private Collection<MatchingResult<Concept>> getConceptMappingsFromRelationMappings(Collection<MatchingResult<Relation>> relationMaps) throws SchemaMatchException {
        Vector<MatchingResult<Concept>> ret = new Vector<MatchingResult<Concept>>();
        if (relationMaps == null) {
            return ret;
        }
        try {
            for (MatchingResult<Relation> relMR : relationMaps) {
                MatchingResult<Concept> fromConceptMR = new MatchingResult<Concept>();
                Relation firstRel = relMR.getObjectOfFirstSchema();
                Relation secondRel = relMR.getObjectOfSecondSchema();
                Concept from1 = firstRel.getTheFromConcept();
                Concept from2 = secondRel.getTheFromConcept();
                fromConceptMR.setObjectOfFirstSchema(from1);
                fromConceptMR.setObjectOfSecondSchema(from2);
                fromConceptMR.setSimilarity(this.theMatcherToUse.getSimilarity(from1, from2));
                MatchingResult<Concept> toConceptMR = new MatchingResult<Concept>();
                Concept to1 = firstRel.getTheToConcept();
                Concept to2 = secondRel.getTheToConcept();
                toConceptMR.setObjectOfFirstSchema(to1);
                toConceptMR.setObjectOfSecondSchema(to2);
                toConceptMR.setSimilarity(this.theMatcherToUse.getSimilarity(to1, to2));
                if (firstRel.isManyToManyRelation() && secondRel.isManyToManyRelation()) {
                    double similarityFrom2To1;
                    double averageSimilarityNow = (fromConceptMR.getSimilarity() + toConceptMR.getSimilarity()) / 2.0;
                    double similarityFrom1To2 = this.theMatcherToUse.getSimilarity(from1, to2);
                    if ((similarityFrom1To2 + (similarityFrom2To1 = this.theMatcherToUse.getSimilarity(to1, from2))) / 2.0 > averageSimilarityNow) {
                        fromConceptMR.setObjectOfFirstSchema(from1);
                        fromConceptMR.setObjectOfSecondSchema(to2);
                        fromConceptMR.setSimilarity(similarityFrom1To2);
                        toConceptMR.setObjectOfFirstSchema(to1);
                        toConceptMR.setObjectOfSecondSchema(from2);
                        toConceptMR.setSimilarity(similarityFrom2To1);
                    }
                }
                ret.add(fromConceptMR);
                ret.add(toConceptMR);
            }
            return ret;
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("M4 error when matching concepts of matched relations: " + m4e.getMessage());
        }
    }

    private Collection<Concept> removeConceptsAlreadyMatched(Collection<Concept> givenDataModel, Collection<MatchingResult<Concept>> conceptMatchings, boolean useConceptualLevelFromMatchings) {
        Vector<Concept> ret = new Vector<Concept>();
        if (givenDataModel == null || conceptMatchings == null) {
            return ret;
        }
        for (Concept oneConcept : givenDataModel) {
            boolean oneConceptIsMatched = false;
            for (MatchingResult<Concept> mr : conceptMatchings) {
                Concept matched = useConceptualLevelFromMatchings ? mr.getObjectOfFirstSchema() : mr.getObjectOfSecondSchema();
                if (!matched.equals(oneConcept)) continue;
                oneConceptIsMatched = true;
            }
            if (oneConceptIsMatched) continue;
            ret.add(oneConcept);
        }
        return ret;
    }

    private Collection<Relation> removeRelationsAlreadyMatched(Collection<MatchingResult<Concept>> matchedConcepts, Collection<Relation> theRelations, boolean useFirstSchemaOfMapping) throws SchemaMatchException {
        Collection<Relation> ret = theRelations;
        if (matchedConcepts == null) {
            return ret;
        }
        Vector<Concept> matchedConceptsOfOneModel = new Vector<Concept>();
        for (MatchingResult<Concept> map : matchedConcepts) {
            Concept matched = useFirstSchemaOfMapping ? map.getObjectOfFirstSchema() : map.getObjectOfSecondSchema();
            matchedConceptsOfOneModel.add(matched);
        }
        try {
            for (Concept oneConcept : matchedConceptsOfOneModel) {
                for (Relation rel : oneConcept.getTheFromRelationships()) {
                    if (!matchedConceptsOfOneModel.contains(rel.getTheToConcept())) continue;
                    ret.remove(rel);
                }
                for (Relation rel : oneConcept.getTheToRelationships()) {
                    if (!matchedConceptsOfOneModel.contains(rel.getTheFromConcept())) continue;
                    ret.remove(rel);
                }
            }
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("M4 error caught when removing star-matched relations from other relations: " + m4e.getMessage());
        }
        return ret;
    }

    private Collection<MatchingResult<Concept>> findMatchingsBasedOnStars(Collection<Concept> starsOfConceptualModel, Collection<Concept> starsOfTargetModel) throws SchemaMatchException {
        if (starsOfConceptualModel == null || starsOfTargetModel == null) {
            return null;
        }
        HashSet<MatchingResult<Concept>> conceptsMatchedBasedOnStars = new HashSet();
        MatchingResult[][] simMatrix = new MatchingResult[starsOfConceptualModel.size()][starsOfTargetModel.size()];
        int row = 0;
        for (Concept conceptualStar : starsOfConceptualModel) {
            Iterator<Concept> targetStarsIt = starsOfTargetModel.iterator();
            int col = 0;
            while (targetStarsIt.hasNext()) {
                Concept targetStar = targetStarsIt.next();
                double sim = this.getStarSimilarity(conceptualStar, targetStar);
                MatchingResult<Concept> mr = new MatchingResult<Concept>();
                mr.setObjectOfFirstSchema(conceptualStar);
                mr.setObjectOfSecondSchema(targetStar);
                mr.setSimilarity(sim);
                simMatrix[row][col] = mr;
                ++col;
            }
            ++row;
        }
        conceptsMatchedBasedOnStars = this.theMatcherToUse.getSimilarMatchingsGreedy(simMatrix, true);
        return conceptsMatchedBasedOnStars;
    }

    private Collection<Relation> findRelationsInDataModel(Collection<Concept> dataModel) throws M4Exception {
        if (dataModel == null) {
            return null;
        }
        HashSet<Relation> ret = new HashSet<Relation>();
        for (Concept oneConcept : dataModel) {
            for (Relation myRel : oneConcept.getTheFromRelationships()) {
                if (!dataModel.contains(myRel.getTheToConcept())) continue;
                ret.add(myRel);
            }
            for (Relation myRel : oneConcept.getTheToRelationships()) {
                if (!dataModel.contains(myRel.getTheFromConcept())) continue;
                ret.add(myRel);
            }
        }
        return ret;
    }

    private Collection<Concept> findStarsInDataModel(Collection<Concept> dataModel) throws M4Exception {
        if (dataModel == null) {
            return null;
        }
        HashSet<Concept> ret = new HashSet<Concept>();
        for (Concept oneConcept : dataModel) {
            int noOfRelsThatCountForStar = 0;
            for (Relation fromRel : oneConcept.getTheFromRelationships()) {
                if (!dataModel.contains(fromRel.getTheToConcept())) continue;
                ++noOfRelsThatCountForStar;
            }
            for (Relation toRel : oneConcept.getTheToRelationships()) {
                if (!dataModel.contains(toRel.getTheFromConcept())) continue;
                ++noOfRelsThatCountForStar;
            }
            if (noOfRelsThatCountForStar <= 1) continue;
            ret.add(oneConcept);
        }
        return ret;
    }

    private double getStarSimilarity(Concept one, Concept two) throws SchemaMatchException {
        if (one == null || two == null) {
            return 0.0;
        }
        try {
            Concept oneTo;
            int firstNoOfRels = one.getTheFromRelationships().size() + one.getTheToRelationships().size();
            int secondNoOfRels = two.getTheFromRelationships().size() + two.getTheToRelationships().size();
            if (firstNoOfRels <= 1 || secondNoOfRels <= 1) {
                return 0.0;
            }
            Vector<Concept> conceptsReachedFromFirst = new Vector<Concept>();
            Vector<Concept> conceptsReachedFromSecond = new Vector<Concept>();
            for (Relation oneRel : one.getTheFromRelationships()) {
                oneTo = oneRel.getTheToConcept();
                conceptsReachedFromFirst.add(oneTo);
            }
            for (Relation oneRel : one.getTheToRelationships()) {
                oneTo = oneRel.getTheFromConcept();
                conceptsReachedFromFirst.add(oneTo);
            }
            for (Relation oneRel : two.getTheFromRelationships()) {
                oneTo = oneRel.getTheToConcept();
                conceptsReachedFromSecond.add(oneTo);
            }
            for (Relation oneRel : two.getTheToRelationships()) {
                oneTo = oneRel.getTheFromConcept();
                conceptsReachedFromSecond.add(oneTo);
            }
            MatchingResult<E>[][] matrix = this.theMatcherToUse.getSimilarityMatrix(conceptsReachedFromFirst, conceptsReachedFromSecond);
            Collection maps = this.theMatcherToUse.getSimilarMatchingsGreedy(matrix, true);
            return this.theMatcherToUse.getGlobalSimilarity(conceptsReachedFromFirst, conceptsReachedFromSecond, maps);
        }
        catch (M4Exception m4e) {
            throw new SchemaMatchException("M4 error computing star similarity between concepts '" + one.getName() + "' and '" + two.getName() + "': " + m4e.getMessage());
        }
    }

    public static Case readSchemaToMatch(Collection<String> tableNames, M4Interface theM4Interface, String nameForTheCase) throws M4Exception {
        try {
            if (tableNames != null) {
                boolean setAsCurrentCase = false;
                if (nameForTheCase == null) {
                    nameForTheCase = "__TemporaryCaseWithSchemaToMatch";
                }
                Case newCase = theM4Interface.createCase(nameForTheCase, setAsCurrentCase);
                boolean conceptsCreated = false;
                for (String tableName : tableNames) {
                    if (tableName.indexOf("$") != -1 || DataModelMatcher.conceptExistsInCase(newCase, tableName)) continue;
                    if (!DataModelMatcher.checkForManyToManyRelation(tableName, tableNames, newCase, theM4Interface)) {
                        newCase.createConceptAndRelationsFromTables(tableName);
                    }
                    conceptsCreated = true;
                }
                if (conceptsCreated) {
                    return newCase;
                }
                return null;
            }
            return null;
        }
        catch (M4Exception e) {
            throw new M4Exception("M4 error when trying to create a temporary Case representing a part of the business schema: " + e.getMessage());
        }
    }

    private static boolean conceptExistsInCase(Case theCase, String nameOfConcept) throws M4Exception {
        for (String oneConceptName : theCase.getAllConceptNames()) {
            if (!oneConceptName.equalsIgnoreCase(nameOfConcept)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForManyToManyRelation(String dbTableName, Collection<String> allAllowedTableNames, Case theCase, M4Interface theM4Interface) throws M4Exception {
        try {
            if (theM4Interface.getM4db().isCrossTable(dbTableName)) {
                Collection createdRelations = theCase.createManyToManyRelationsFromCrossTable(dbTableName, allAllowedTableNames);
                return createdRelations != null && !createdRelations.isEmpty();
            }
            Collection crossTablesReferring = theM4Interface.getM4db().getCrossTablesReferringTo(dbTableName);
            if (crossTablesReferring == null || crossTablesReferring.isEmpty()) {
                return false;
            }
            Iterator crossIt = crossTablesReferring.iterator();
            boolean anythingCreated = false;
            while (crossIt.hasNext()) {
                String crossTable = (String)crossIt.next();
                if (allAllowedTableNames != null && !allAllowedTableNames.contains(crossTable)) continue;
                Collection createdRels = theCase.createManyToManyRelationsFromCrossTable(crossTable, allAllowedTableNames);
                anythingCreated = createdRels != null && !createdRels.isEmpty();
            }
            return anythingCreated;
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error occurred when trying to see if '" + dbTableName + "' is a cross table: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("Suddenly closed connection to DB when trying to see if '" + dbTableName + "' is a cross table: " + dbc.getMessage());
        }
    }
}

