/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.FeatureConstruction;

public abstract class Grouping
extends FeatureConstruction {
    boolean defaultValue = false;

    abstract String[] generateGroups(Column var1) throws M4CompilerError;

    private String createUniqueLabel(String[] labels, int currentLabel) {
        String s = "" + currentLabel;
        boolean unique = false;
        block0: while (!unique) {
            s = "_" + s;
            unique = true;
            for (int i = 0; labels.length < i; ++i) {
                if (!s.equalsIgnoreCase(labels[i])) continue;
                unique = false;
                continue block0;
            }
        }
        return s;
    }

    public String[] generateLabels(int num) throws M4CompilerError {
        String[] labels = new String[num];
        for (int i = 0; i < num; ++i) {
            labels[i] = this.createUniqueLabel(labels, i + 1);
        }
        return labels;
    }

    public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError {
        String sql = "CASE ";
        String[] myG = this.generateGroups(theTargetAttributeColumn);
        if (myG == null) {
            return null;
        }
        String[] myL = this.defaultValue ? this.generateLabels(myG.length + 1) : this.generateLabels(myG.length);
        for (int i = 0; i < myG.length; ++i) {
            sql = sql + "WHEN " + theTargetAttributeColumn.getSQLPlusLocation() + " IN (" + myG[i] + ") THEN '" + myL[i] + "' ";
        }
        sql = this.defaultValue ? sql + "ELSE ('" + myL[myG.length] + "') END" : sql + "ELSE " + theTargetAttributeColumn.getSQLPlusLocation() + " END";
        this.doPrint(Print.OPERATOR, "String returned by grouping: " + sql);
        return "(" + sql + ")";
    }

    protected boolean useQuotes(Column targetAttribCol, Value[] theValues) throws M4CompilerError {
        try {
            if (targetAttribCol.getColumnDataTypeName().equals("STRING")) {
                return true;
            }
            if (theValues != null && theValues.length > 0) {
                boolean allValuesAreNumeric = true;
                for (int i = 0; i < theValues.length; ++i) {
                    if (theValues[i].getTypeName().equals("NUMERIC")) continue;
                    allValuesAreNumeric = false;
                    break;
                }
                return !allValuesAreNumeric;
            }
            String[] valuesOfTargetCol = this.getM4Db().getDistinctElementsWithoutNull(targetAttribCol);
            boolean allValuesAreNumeric = true;
            for (int i = 0; i < valuesOfTargetCol.length; ++i) {
                try {
                    Double.parseDouble(valuesOfTargetCol[i]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    allValuesAreNumeric = false;
                    break;
                }
            }
            return !allValuesAreNumeric;
        }
        catch (DbConnectionClosed c) {
            throw new M4CompilerError(c.getMessage());
        }
        catch (M4Exception m) {
            throw new M4CompilerError(m.getMessage());
        }
    }
}

