/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.uep.Grouping;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ErrorBasedGroupingGivenNoOfGroups
extends Grouping {
    private final int SORT_BY_LABEL = 1;
    private final int SORT_BY_COUNT = 2;

    public Value getNoOfGroups() throws M4CompilerError {
        return (Value)this.getSingleParameter("NoOfGroups", this.getCurrentLoopNumber());
    }

    public Value[] getLabels() throws M4CompilerError {
        return (Value[])this.getParameter("Labels", this.getCurrentLoopNumber());
    }

    public Value[] getSampleSize() throws M4CompilerError {
        return (Value[])this.getParameter("SampleSize", this.getCurrentLoopNumber());
    }

    private long sampleSize() throws M4CompilerError {
        Value[] tmp = this.getSampleSize();
        if (tmp.length == 0) {
            return 10000L;
        }
        return Long.parseLong(tmp[0].getValue());
    }

    public BaseAttribute getTheClassAttribute() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheClassAttribute", this.getCurrentLoopNumber());
    }

    public String[] generateLabels(int num) throws M4CompilerError {
        Value[] l = this.getLabels();
        String[] labels = new String[num];
        boolean gen = true;
        if (l.length != 0) {
            if (l.length > 0 && l.length != num) {
                this.doPrint(Print.OPERATOR, "Incorrect number of given labels, labels generated automaticaly!");
            } else {
                gen = false;
            }
        }
        for (int i = 0; i < num; ++i) {
            labels[i] = gen ? "_" + (i + 1) : l[i].getValue();
        }
        return labels;
    }

    public String[] generateGroups(Column theTargetAttributeColumn) throws M4CompilerError {
        int i;
        Column theClassAttributeColumn;
        TreeMap<cmpMyData, myData> cutPointSort = new TreeMap<cmpMyData, myData>();
        TreeMap<String, Long> clss = new TreeMap<String, Long>();
        this.defaultValue = true;
        this.doPrint(Print.OPERATOR, "ErrorBasedGroupingGivenNoOfGroups:");
        try {
            theClassAttributeColumn = this.getTheClassAttribute().getCurrentColumn();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        String[] classes = this.getM4Db().getDistinctElementsWithoutNull(theClassAttributeColumn);
        for (i = 0; i < classes.length; ++i) {
            clss.put(classes[i], new Long(i + 1));
        }
        String[] elements = this.getM4Db().getCountOfElements(theClassAttributeColumn, theTargetAttributeColumn, this.sampleSize());
        myData val = null;
        for (i = 0; i < elements.length; ++i) {
            StringTokenizer t = new StringTokenizer(elements[i], ",");
            long cnt = Long.parseLong(t.nextToken());
            String s = t.nextToken();
            String v = "'" + t.nextToken() + "'";
            if (i == 0) {
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.count = 0L;
                val.sortBy = 1;
            } else if (!v.equals(val.value)) {
                cutPointSort.put(new cmpMyData(val), val);
                val = new myData();
                val.value = v;
                val.maxfreq = 0L;
                val.label = 0L;
                val.count = 0L;
                val.sortBy = 1;
            }
            val.count += cnt;
            if (cnt < val.maxfreq) continue;
            if (cnt == val.maxfreq) {
                val.label += (long)(1 << (int)((Long)clss.get(s) - 1L));
                ++val.maxgrps;
                continue;
            }
            val.maxfreq = cnt;
            val.label = 1 << (int)((Long)clss.get(s) - 1L);
            val.maxgrps = 1;
        }
        cutPointSort.put(new cmpMyData(val), val);
        ArrayList cutPoint = new ArrayList(cutPointSort.values());
        i = 0;
        while (i < cutPoint.size() - 1) {
            myData x1 = (myData)cutPoint.get(i);
            myData x2 = (myData)cutPoint.get(i + 1);
            if (x1.label == x2.label) {
                x1.maxfreq += x2.maxfreq;
                x1.count += x2.count;
                x1.value = x1.value + ", " + x2.value;
                cutPoint.remove(i + 1);
                continue;
            }
            ++i;
        }
        long minGroups = Long.parseLong(this.getNoOfGroups().getValue());
        if (minGroups < (long)cutPoint.size()) {
            this.doPrint(Print.OPERATOR, "Satrting FullMerge ...");
            TreeMap<cmpMyData, myData> singleMax = new TreeMap<cmpMyData, myData>();
            TreeMap<cmpMyData, myData> multiMax = new TreeMap<cmpMyData, myData>();
            for (i = 0; i < cutPoint.size(); ++i) {
                myData tmp = (myData)cutPoint.get(i);
                tmp.sortBy = 2;
                if (tmp.maxgrps == 1) {
                    singleMax.put(new cmpMyData(tmp), tmp);
                    continue;
                }
                multiMax.put(new cmpMyData(tmp), tmp);
            }
            long min = minGroups - (long)singleMax.size();
            if (min < 0L) {
                min = 0L;
            }
            while ((long)multiMax.size() > min) {
                myData attach = null;
                myData tmp = (myData)multiMax.get(multiMax.firstKey());
                multiMax.remove(multiMax.firstKey());
                ArrayList tmplst = new ArrayList(singleMax.values());
                for (i = 0; i < tmplst.size(); ++i) {
                    if ((tmp.label & ((myData)tmplst.get((int)i)).label) <= 0L) continue;
                    attach = (myData)tmplst.get(i);
                    break;
                }
                if (attach == null) {
                    singleMax.put(new cmpMyData(tmp), tmp);
                    continue;
                }
                singleMax.remove(new cmpMyData(attach));
                attach.label &= tmp.label;
                attach.maxfreq += tmp.maxfreq;
                attach.count += tmp.count;
                attach.value = attach.value + ", " + tmp.value;
                singleMax.put(new cmpMyData(attach), attach);
            }
            if (minGroups < (long)singleMax.size()) {
                while ((long)singleMax.size() > minGroups) {
                    myData x1 = (myData)singleMax.get(singleMax.firstKey());
                    singleMax.remove(singleMax.firstKey());
                    myData x2 = (myData)singleMax.get(singleMax.firstKey());
                    singleMax.remove(singleMax.firstKey());
                    x1.count += x2.count;
                    x1.label = 0L;
                    x1.maxfreq = 0L;
                    x1.value = x1.value + ", " + x2.value;
                    singleMax.put(new cmpMyData(x1), x1);
                }
                cutPoint = new ArrayList(singleMax.values());
            } else {
                cutPoint = new ArrayList(singleMax.values());
                if (multiMax.size() > 0) {
                    cutPoint.addAll(multiMax.values());
                }
            }
        }
        this.doPrint(Print.OPERATOR, "New groups:");
        for (i = 0; i < cutPoint.size(); ++i) {
            this.doPrint(Print.OPERATOR, ((myData)cutPoint.get(i)).Text());
        }
        String[] gr = new String[cutPoint.size()];
        for (i = 0; i < cutPoint.size(); ++i) {
            gr[i] = ((myData)cutPoint.get((int)i)).value;
        }
        return gr;
    }

    public class cmpMyData
    implements Comparable {
        public myData value;

        public cmpMyData(myData val) {
            this.value = val;
        }

        public int compareTo(Object Obj) {
            return this.value.compareTo(((cmpMyData)Obj).value);
        }

        public boolean equals(Object Obj) {
            return this.value.equals(((cmpMyData)Obj).value);
        }
    }

    public class myData {
        public final int SORT_BY_LABEL = 1;
        public final int SORT_BY_COUNT = 2;
        public String value;
        public long label;
        public long maxfreq;
        public long count;
        public int sortBy;
        public int maxgrps;

        public String Text() {
            return this.value + " - " + this.count + " items.";
        }

        public int compareTo(Object Obj) {
            int ret = 1;
            switch (this.sortBy) {
                case 1: {
                    ret = new Long(this.label).compareTo(new Long(((myData)Obj).label));
                    break;
                }
                case 2: {
                    ret = new Long(this.count).compareTo(new Long(((myData)Obj).count));
                }
            }
            if (ret == 0) {
                ret = this.value.compareTo(((myData)Obj).value);
            }
            return ret;
        }

        public boolean equals(Object Obj) {
            boolean ret = false;
            switch (this.sortBy) {
                case 1: {
                    ret = this.label == ((myData)Obj).label;
                    break;
                }
                case 2: {
                    ret = this.count == ((myData)Obj).count;
                }
            }
            return ret && this.value.equals(((myData)Obj).value);
        }
    }
}

