/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator.uep;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.uep.Discretization;

public class EquidistantDiscretizationGivenNoOfIntervals
extends Discretization {
    public Value getNoOfIntervals() throws M4CompilerError {
        return (Value)this.getSingleParameter("NoOfIntervals", this.getCurrentLoopNumber());
    }

    public Value getClosedTo() throws M4CompilerError {
        return (Value)this.getSingleParameter("ClosedTo", this.getCurrentLoopNumber());
    }

    public Value[] getLabels() throws M4CompilerError {
        return (Value[])this.getParameter("Labels", this.getCurrentLoopNumber());
    }

    public double[] generateCutPoints(Column theTargetAttributeColumn) throws M4CompilerError {
        this.doPrint(Print.OPERATOR, "EquidistantDiscretizationGivenNoOfIntervals:");
        try {
            String Min = theTargetAttributeColumn.readOrComputeMinimum();
            double min = Double.parseDouble(Min);
            int numOfIntervals = Integer.parseInt(this.getNoOfIntervals().getValue());
            String Max = theTargetAttributeColumn.readOrComputeMaximum();
            double max = Double.parseDouble(Max);
            double width = (max - min) / (double)numOfIntervals;
            double[] cutPoints = new double[numOfIntervals - 1];
            for (int i = 1; i < numOfIntervals; ++i) {
                cutPoints[i - 1] = min + (double)i * width;
            }
            return cutPoints;
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
    }

    public String[] generateLabels(int num) throws M4CompilerError {
        Value[] l = this.getLabels();
        if (l == null) {
            l = new Value[]{};
        }
        String[] labels = new String[num];
        boolean gen = true;
        if (l.length != 0) {
            if (l.length > 0 && l.length != num) {
                this.doPrint(Print.OPERATOR, "Incorrect number of given labels, labels generated automaticaly!");
            } else {
                gen = false;
            }
        }
        for (int i = 0; i < num; ++i) {
            labels[i] = gen ? "_" + (i + 1) : l[i].getValue();
        }
        return labels;
    }
}

