/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.sql.SQLException;
import java.util.Collection;

public class Windowing
extends SingleCSOperator {
    private static final String TIMEBASEATTRIB = "TimeBaseAttrib";
    private static final String VALUEBASEATTRIB = "ValueBaseAttrib";
    private static final String WINDOWSIZE = "WindowSize";
    private static final String OUTTIMESTARTBA = "OutputTimeStartBA";
    private static final String OUTTIMEENDBA = "OutputTimeEndBA";
    private String nameOfTempView = null;
    private static String windowNumExpr = null;

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError, M4CompilerWarning {
        String sqlDef = "(SELECT " + selectPart + " FROM " + this.nameOfTempView + " group by windownumber)";
        return sqlDef;
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        try {
            this.nameOfTempView = this.createTemporaryView(this.getInputConcept().getCurrentColumnSet().getSchemaPlusName(), this.getTimeBA(), this.getValueBA());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Windowing: could not create intermediate view, M4Exception caught: " + m4e.getMessage());
        }
        if (this.nameOfTempView == null) {
            throw new M4CompilerError("Operator Windowing: could not create intermediate view!");
        }
        String columnExpr = "";
        BaseAttribute theInputTimeBA = this.getTimeBA();
        BaseAttribute theInputValueBA = this.getValueBA();
        try {
            Collection outFeatures = this.getOutputConcept().getFeatures();
            if (outFeatures == null || outFeatures.isEmpty()) {
                throw new M4CompilerError("Operator Windowing: No Features found in the output concept!");
            }
            for (Feature outF : outFeatures) {
                if (!(outF instanceof BaseAttribute)) {
                    throw new M4CompilerError("Windowing ('" + this.getStep().getName() + "'): cannot handle MultiColumnFeatures like '" + outF.getName() + "!");
                }
                if (outF.correspondsTo(this.getOutStartTimeBA()) || outF.correspondsTo(this.getOutEndTimeBA())) {
                    columnExpr = this.createTimeColumn(theInputTimeBA, (BaseAttribute)outF, csForOutputConcept, columnExpr);
                    continue;
                }
                columnExpr = this.createWindowedColumn(theInputValueBA, (BaseAttribute)outF, csForOutputConcept, columnExpr);
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Pivotize: M4 Exception caught when generating metadata: " + m4e.getMessage());
        }
        if (columnExpr.length() <= 2) {
            throw new M4CompilerError("Operator Pivotize: No columns created for output concept!");
        }
        columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
        return columnExpr;
    }

    public boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    private String createWindowedColumn(BaseAttribute inputValueBA, BaseAttribute windowedBA, Columnset csForOutputConcept, String columnExpr) throws M4CompilerError {
        Column inputCol;
        String when = null;
        try {
            inputCol = inputValueBA.getCurrentColumn();
            if (inputCol == null) {
                throw new M4CompilerError("Operator Windowing: Could not find column for input value BA '" + inputValueBA.getName() + "!");
            }
            when = this.getTimeBA().getCurrentColumn().getSQLDefinition();
            when = when + " - (" + this.getWindowNumExpr() + " * " + this.getWinSize() + ")";
            when = when + " = " + this.getWindowPosition(windowedBA);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Windowing: M4 Exception caught when accessing column of input or windowed attribute: " + m4e.getMessage());
        }
        String colDef = "MAX(CASE WHEN " + when + " THEN " + this.nameOfTempView + "." + inputCol.getName() + " ELSE null END)";
        try {
            Column outputColumn = inputCol.copyColToCS(csForOutputConcept);
            this.getStep().addToTrash(outputColumn);
            outputColumn.setBaseAttribute(windowedBA);
            outputColumn.setSQLDefinition(windowedBA.getName());
            outputColumn.setName(windowedBA.getName());
            return columnExpr + colDef + " AS " + windowedBA.getName() + ", ";
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Windowing: M4 exception caught when creating column for output BaseAttribute '" + windowedBA.getName() + "': " + m4e.getMessage());
        }
    }

    private String createTimeColumn(BaseAttribute inputTimeBA, BaseAttribute outputTimeBA, Columnset csForOutputConcept, String columnExpr) throws M4CompilerError {
        Column inputCol;
        try {
            inputCol = inputTimeBA.getCurrentColumn();
            if (inputCol == null) {
                throw new M4CompilerError("Operator Windowing: Could not find column for input value BA '" + inputTimeBA.getName() + "!");
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Windowing: M4 Exception caught when accessing column of input or windowed attribute: " + m4e.getMessage());
        }
        boolean isStart = false;
        if (outputTimeBA.correspondsTo(this.getOutStartTimeBA())) {
            isStart = true;
        } else if (outputTimeBA.correspondsTo(this.getOutEndTimeBA())) {
            isStart = false;
        } else {
            throw new M4CompilerError("Operator Windowing, Step '" + this.getStep().getName() + "': output time attribute could not be matched!");
        }
        String colName = isStart ? "start_index" : "end_index";
        String colDef = "MAX(" + colName + ")";
        try {
            Column outputColumn = inputCol.copyColToCS(csForOutputConcept);
            this.getStep().addToTrash(outputColumn);
            outputColumn.setBaseAttribute(outputTimeBA);
            outputColumn.setSQLDefinition(outputTimeBA.getName());
            outputColumn.setName(outputTimeBA.getName());
            return columnExpr + colDef + " AS " + outputTimeBA.getName() + ", ";
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Windowing: M4 exception caught when creating column for output BaseAttribute '" + outputTimeBA.getName() + "': " + m4e.getMessage());
        }
    }

    private String createTemporaryView(String inputCsName, BaseAttribute inputTimeBA, BaseAttribute inputValueBA) throws M4CompilerError {
        String tempViewName = null;
        if (inputTimeBA == null || inputValueBA == null) {
            return null;
        }
        try {
            Column inputTimeCol = inputTimeBA.getCurrentColumn();
            Column inputValueCol = inputValueBA.getCurrentColumn();
            if (inputTimeCol == null || inputValueCol == null) {
                return null;
            }
            String n = this.getWinSize();
            if (n == null) {
                throw new M4CompilerError("Operator Windowing, Step '" + this.getStep().getName() + "': Window size is invalid!");
            }
            String viewDef = "(SELECT " + inputTimeCol.getSQLDefinition() + ", " + inputValueCol.getSQLDefinition() + ", " + this.getWindowNumExpr() + " AS windownumber, " + "(" + this.getWindowNumExpr() + " * " + n + ") AS start_index, " + "(" + this.getWindowNumExpr() + " * " + n + " + " + n + " - 1) AS end_index " + "FROM " + inputCsName + ")";
            tempViewName = inputCsName + "_TMP";
            if (tempViewName.indexOf(46) > -1) {
                tempViewName = tempViewName.substring(tempViewName.lastIndexOf(46) + 1);
            }
            String viewCreation = "CREATE OR REPLACE VIEW " + tempViewName + " AS " + viewDef;
            this.getM4Db().executeBusinessSqlWrite(viewCreation);
            this.getM4Db().addViewToTrash(tempViewName, this.getM4Db().getBusinessSchemaName(), this.getStep().getId());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator Windowing (Step '" + this.getStep().getName() + "': M4 Exception caught trying to create temporary view: " + m4e.getMessage());
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator Windowing (Step '" + this.getStep().getName() + "': SQL Exception caught trying to create temporary view in business data schema: " + sqle.getMessage());
        }
        return tempViewName;
    }

    private int getWindowPosition(BaseAttribute windowedBA) throws M4CompilerError {
        String baName = windowedBA.getName();
        int separatorPos = baName.lastIndexOf(95);
        if (separatorPos < 0) {
            throw new M4CompilerError("Operator Windowing (Step '" + this.getStep().getName() + "': could not determine position in window of output attribute " + baName + "!");
        }
        int winpos = -1;
        String suffix = baName.substring(separatorPos + 1);
        try {
            winpos = Integer.parseInt(suffix);
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("Operator Windowing (Step '" + this.getStep().getName() + "': could not determine position in window of output attribute " + baName + "!");
        }
        return winpos - 1;
    }

    private String getWindowNumExpr() throws M4CompilerError {
        if (windowNumExpr == null) {
            try {
                windowNumExpr = this.getM4Db().getFloorExpression() + "(" + this.getTimeBA().getCurrentColumn().getSQLDefinition() + " / " + this.getWinSize() + ")";
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError("Operator Windowing, Step '" + this.getStep().getName() + "': M4 Exception caught when computing floor expression: " + m4e.getMessage());
            }
        }
        return windowNumExpr;
    }

    private BaseAttribute getTimeBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(TIMEBASEATTRIB);
    }

    private BaseAttribute getValueBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(VALUEBASEATTRIB);
    }

    private String getWinSize() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter(WINDOWSIZE);
        if (v == null) {
            return null;
        }
        String s = v.getValue();
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return s;
    }

    private BaseAttribute getOutStartTimeBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTTIMESTARTBA);
    }

    private BaseAttribute getOutEndTimeBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTTIMEENDBA);
    }
}

