/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.TimeOperator;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import edu.udo.cs.miningmart.storedProcedures.WMF;
import java.sql.SQLException;

public class WeightedMovingFunction
extends TimeOperator {
    private static final String INPUTTIMEBA = "InputTimeBA";
    private static final String INPUTVALUEBA = "InputValueBA";
    private static final String OUTPUTTIMESTARTBA = "OutputTimeStartBA";
    private static final String OUTPUTTIMEENDBA = "OutputTimeEndBA";
    private static final String OUTPUTVALUEBA = "OutputValueBA";
    private static final String WEIGHTS = "Weights";
    private static final String DISTANCE = "Distance";
    private static final String procedureName = "WMA";
    private static final String columnSetSuffix = "_CS";

    protected String getColumnSetSuffix() {
        return columnSetSuffix;
    }

    public BaseAttribute getTimeBaIn() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INPUTTIMEBA);
    }

    public BaseAttribute getValueBaIn() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INPUTVALUEBA);
    }

    public BaseAttribute getTimeBaStartOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTTIMESTARTBA);
    }

    public BaseAttribute getTimeBaEndOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTTIMEENDBA);
    }

    public BaseAttribute getValueBaOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTVALUEBA);
    }

    public Value getDistance() throws M4CompilerError {
        return (Value)this.getSingleParameter(DISTANCE);
    }

    public Value[] getWeights() throws M4CompilerError {
        return (Value[])this.getParameter(WEIGHTS);
    }

    public Value getWeight(int i) throws M4CompilerError {
        Value[] weights = this.getWeights();
        if (weights != null && i < weights.length && i >= 0) {
            return weights[i];
        }
        return null;
    }

    public int getNumberOfWeights() throws M4CompilerError {
        Value[] weights = this.getWeights();
        if (weights != null) {
            return weights.length;
        }
        return 0;
    }

    protected void createJavaColumns(Columnset newCS) throws M4CompilerError {
        try {
            Column timeColumnForType = this.getTimeBaIn().getColumn(0);
            this.createM4Column(this.getTimeBaStartOut(), newCS, timeColumnForType);
            this.createM4Column(this.getTimeBaEndOut(), newCS, timeColumnForType);
            Column valueColumnForType = this.getValueBaIn().getColumn(0);
            this.createM4Column(this.getValueBaOut(), newCS, valueColumnForType);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void runStoredProcedure(String newColumnsetName) throws SQLException, M4CompilerError, TimeOperatorException {
        this.valueIsLong(this.getDistance(), DISTANCE);
        int numWeights = this.getNumberOfWeights();
        if (numWeights == 0) {
            throw new M4CompilerError("Parameter array 'Weights' of step " + this.getStep().getId() + " could not be loaded!");
        }
        for (int i = 0; i < numWeights; ++i) {
            this.valueIsDouble(this.getWeight(i), WEIGHTS);
        }
        this.baseattribHasColumns(this.getTimeBaIn(), INPUTTIMEBA);
        this.baseattribHasColumns(this.getValueBaIn(), INPUTVALUEBA);
        String[] parameters = new String[]{WeightedMovingFunction.getQuotedColSetNameforCon(this.getInputConcept()), WeightedMovingFunction.getQuotedColNameforInpBA(this.getTimeBaIn()), WeightedMovingFunction.getQuotedColNameforInpBA(this.getValueBaIn()), DB.quote(newColumnsetName), WeightedMovingFunction.getQuotedColNameforOutBA(this.getTimeBaStartOut()), WeightedMovingFunction.getQuotedColNameforOutBA(this.getTimeBaEndOut()), WeightedMovingFunction.getQuotedColNameforOutBA(this.getValueBaOut()), DB.quote(this.weightsToString()), this.getDistance().getValue().trim()};
        if (this.storedProceduresAvailable()) {
            this.executeDbProcedure(procedureName, parameters);
        } else {
            WMF.dbWMA(this.getM4Db(), WeightedMovingFunction.unquote(parameters[0]), WeightedMovingFunction.unquote(parameters[1]), WeightedMovingFunction.unquote(parameters[2]), WeightedMovingFunction.unquote(parameters[3]), WeightedMovingFunction.unquote(parameters[4]), WeightedMovingFunction.unquote(parameters[5]), WeightedMovingFunction.unquote(parameters[6]), WeightedMovingFunction.unquote(parameters[7]), Integer.parseInt(parameters[8]));
        }
    }

    private String weightsToString() throws M4CompilerError {
        String r = "";
        int numWeights = this.getNumberOfWeights();
        for (int i = 0; i < numWeights; ++i) {
            r = r + this.getWeight(i).getValue().trim() + " ";
        }
        return r.trim();
    }
}

