/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterDeselectedError;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public class UnionByKey
extends SingleCSOperator {
    private BaseAttribute theOutputId = null;
    private Vector conceptsData;

    public Concept[] getTheConcepts() throws M4CompilerError {
        return (Concept[])this.getParameter("TheConcepts");
    }

    public BaseAttribute[] getTheKeys() throws M4CompilerError {
        return (BaseAttribute[])this.getParameter("TheKeys");
    }

    protected Feature[][] getInOutMap() throws M4CompilerError {
        Feature[] inputF = (Feature[])this.getParameter("MapInput");
        Feature[] outputF = (Feature[])this.getParameter("MapOutput");
        Feature[] inKeys = (Feature[])this.getParameter("TheKeys");
        int noMapParams = inputF != null ? inputF.length : 0;
        int noOfMappings = noMapParams + inKeys.length;
        Feature[][] theMap = new Feature[2][noOfMappings];
        if (inputF != null) {
            for (int l = 0; l < inputF.length; ++l) {
                theMap[0][l] = inputF[l];
                theMap[1][l] = outputF[l];
                if (theMap[0][l] != null && theMap[1][l] != null) continue;
                throw new M4CompilerError("Operator UnionByKey: mapping information is incomplete!");
            }
        }
        Feature keyInOutput = this.getOutputKeyFeature(inKeys);
        for (int l = noMapParams; l < noOfMappings; ++l) {
            theMap[0][l] = inKeys[l - noMapParams];
            theMap[1][l] = keyInOutput;
        }
        return theMap;
    }

    private Feature getOutputKeyFeature(Feature[] inputKeys) throws M4CompilerError {
        try {
            for (Feature outF : this.getOutputConcept().getFeatures()) {
                for (int i = 0; i < inputKeys.length; ++i) {
                    if (!inputKeys[i].correspondsTo(outF)) continue;
                    return outF;
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator UnionByKey: M4 error accessing output features: " + m4e.getMessage());
        }
        throw new M4CompilerError("Operator UnionByKey: could not identify which of the output features is the Key!");
    }

    public BaseAttribute getOutputIdAttribute() throws M4CompilerError {
        if (this.theOutputId != null) {
            return this.theOutputId;
        }
        BaseAttribute[] keys = this.getTheKeys();
        for (int i = 0; i < keys.length; ++i) {
            Feature f = this.getMappedFeature(keys[i]);
            if (f == null || !(f instanceof BaseAttribute)) continue;
            this.theOutputId = (BaseAttribute)f;
            return this.theOutputId;
        }
        throw new M4CompilerError("Operator UnionByKey: No Key found in output Concept!");
    }

    public void load(Step st) throws ParameterDeselectedError, M4CompilerError {
        super.load(st);
        this.checkKeys();
    }

    public Concept getInputConcept() throws M4CompilerError {
        return this.getTheConcepts()[0];
    }

    private void checkKeys() throws M4CompilerError {
        if (this.getTheKeys().length != this.getTheConcepts().length) {
            throw new M4CompilerError("UnionByKey: number of JoinAttributes and number of Concepts must be equal!");
        }
        for (int i = 0; i < this.getTheKeys().length; ++i) {
            Concept theConcept;
            try {
                theConcept = this.getTheKeys()[i].getConcept();
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
            }
            boolean found = false;
            if (theConcept.getId() == this.getTheConcepts()[i].getId()) {
                found = true;
            }
            if (found) continue;
            throw new M4CompilerError("Attribute " + this.getTheKeys()[i].getName() + " does not belong to the concept " + this.getTheConcepts()[i].getName() + " !");
        }
    }

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return false;
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        return this.getNewCSName();
    }

    private String determineDBTypeOfColumn(Column col) throws M4CompilerError {
        boolean useBusinessDBMS = true;
        if (col.getColumnDataType() == 12L) {
            return this.getM4Db().getDbNameOfM4Datatype("NUMBER", 0, useBusinessDBMS);
        }
        if (col.getColumnDataType() == 13L || col.getColumnDataType() == 15L) {
            return this.getM4Db().getDbNameOfM4Datatype("STRING", 500, useBusinessDBMS);
        }
        if (col.getColumnDataType() == 14L) {
            return this.getM4Db().getDbNameOfM4Datatype("DATE", 0, useBusinessDBMS);
        }
        return this.getM4Db().getDbNameOfM4Datatype("STRING", 500, useBusinessDBMS);
    }

    private void checkOutputConceptFeatures() throws M4CompilerError {
        try {
            Iterator outConFeas = this.getOutputConcept().getFeatures().iterator();
            Concept[] cons = this.getTheConcepts();
            while (outConFeas.hasNext()) {
                Feature outF = (Feature)outConFeas.next();
                if (outF.getId() == this.getOutputIdAttribute().getId()) continue;
                boolean found = false;
                for (int j = 0; j < cons.length; ++j) {
                    Iterator it = cons[j].getFeatures().iterator();
                    while (it.hasNext()) {
                        if (!outF.correspondsTo((Feature)it.next())) continue;
                        found = true;
                    }
                }
                if (found) continue;
                this.doPrint(Print.OPERATOR, "UnionByKey: No Feature with id " + outF.getId() + " (" + outF.getName() + ") found in any of the input concepts. Skipping.");
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        Column oldColumn = null;
        Column copiedColumn = null;
        try {
            oldColumn = this.getTheKeys()[0].getCurrentColumn();
            copiedColumn = oldColumn.copyColToCS(csForOutputConcept);
            this.getStep().addToTrash(copiedColumn);
            copiedColumn.setBaseAttribute(this.getOutputIdAttribute());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        copiedColumn.setSQLDefinition(this.getOutputIdAttribute().getName());
        this.conceptsData = new Vector();
        for (int i = 0; i < this.getTheConcepts().length; ++i) {
            this.generateConceptData(this.getTheConcepts()[i], this.getTheKeys()[i], csForOutputConcept);
        }
        this.workOnDb(csForOutputConcept);
        return "";
    }

    private boolean isAKey(Feature f) throws M4CompilerError {
        for (int i = 0; i < this.getTheKeys().length; ++i) {
            if (f.getId() != this.getTheKeys()[i].getId()) continue;
            return true;
        }
        return false;
    }

    private void generateConceptData(Concept current, BaseAttribute idBA, Columnset csForOutputConcept) throws M4CompilerError {
        try {
            ConceptData cData = new ConceptData();
            this.conceptsData.add(cData);
            Vector<Feature> selectedFeaturesOfCurrentConcept = new Vector<Feature>();
            block2: for (Feature currentFeature : current.getFeatures()) {
                for (int j = 0; j < this.getOutputConcept().getFeatures().size(); ++j) {
                    if (this.getMappedFeature(currentFeature) == null) {
                        this.doPrint(Print.OPERATOR, "UnionByKey: Feature '" + currentFeature.getName() + "' not found in Mapping or in output concept; skipping!");
                        continue block2;
                    }
                    if (!this.getMappedFeature(currentFeature).correspondsTo(this.getOutputConcept().getFeature(j)) || this.isAKey(currentFeature) || this.isDeselectedParameter(currentFeature)) continue;
                    selectedFeaturesOfCurrentConcept.add(currentFeature);
                }
            }
            cData.setConcept(current);
            cData.setIdAttribute(idBA);
            for (int i = 0; i < selectedFeaturesOfCurrentConcept.size(); ++i) {
                Column copiedColumn;
                Column oldColumn;
                BaseAttribute oldBA;
                BaseAttribute newBA;
                Feature oldF = (Feature)selectedFeaturesOfCurrentConcept.get(i);
                Feature newF = this.getMappedFeature(oldF);
                if (oldF instanceof BaseAttribute) {
                    newBA = (BaseAttribute)newF;
                    oldBA = (BaseAttribute)oldF;
                    oldColumn = oldBA.getCurrentColumn();
                    copiedColumn = oldColumn.copyColToCS(csForOutputConcept);
                    this.getStep().addToTrash(copiedColumn);
                    copiedColumn.setBaseAttribute(newBA);
                    copiedColumn.setName(newBA.getName());
                    copiedColumn.setSQLDefinition(newBA.getName());
                    cData.addBA(oldBA);
                    continue;
                }
                if (oldF instanceof MultiColumnFeature) {
                    if (!newF.correspondsTo(oldF)) {
                        throw new M4CompilerError("Operator UnionByKey: Mapping of MultiColumnFeatures not implemented, yet!");
                    }
                    MultiColumnFeature newMCF = (MultiColumnFeature)newF;
                    MultiColumnFeature oldMCF = (MultiColumnFeature)oldF;
                    Iterator theBAs = newMCF.getBaseAttributes().iterator();
                    if (theBAs == null) continue;
                    while (theBAs.hasNext()) {
                        newBA = (BaseAttribute)theBAs.next();
                        oldBA = oldMCF.getBaseAttributeByName(newBA.getName());
                        oldColumn = oldBA.getCurrentColumn();
                        copiedColumn = oldColumn.copyColToCS(csForOutputConcept);
                        this.getStep().addToTrash(copiedColumn);
                        copiedColumn.setBaseAttribute(newBA);
                        copiedColumn.setSQLDefinition(newBA.getName());
                        cData.addBA(oldBA);
                    }
                    continue;
                }
                throw new M4CompilerError("Unknown Feature type found in Concept with id: " + current.getId() + "; Feature id is " + oldF.getId());
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private String getMappedName(BaseAttribute ba) throws M4CompilerError {
        Feature outF = this.getMappedFeature(ba);
        if (outF == null || !(outF instanceof BaseAttribute)) {
            throw new M4CompilerError("UnionByKey.getMappedName: No output BaseAttribute found for InputBA: " + ba.getName() + ", id: " + ba.getId());
        }
        return outF.getName();
    }

    private Feature getMappedFeature(Feature oldF) throws M4CompilerError {
        Feature[][] theMap = this.getInOutMap();
        for (int i = 0; i < theMap[0].length; ++i) {
            Feature feature = theMap[0][i];
            if (!feature.equals(oldF)) continue;
            return theMap[1][i];
        }
        Feature newF = null;
        try {
            Iterator it = this.getOutputConcept().getFeatures().iterator();
            while (it.hasNext() && !(newF = (Feature)it.next()).correspondsTo(oldF)) {
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        if (newF.correspondsTo(oldF)) {
            return newF;
        }
        return null;
    }

    private void workOnDb(Columnset csForOutputConcept) throws M4CompilerError {
        this.createTable(csForOutputConcept);
        if (this.conceptsData.size() == 2) {
            this.twoTableSolution(csForOutputConcept);
        } else {
            this.collectKeys(csForOutputConcept);
            this.fillAttributes(csForOutputConcept);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void twoTableSolution(Columnset csForOutputConcept) throws M4CompilerError {
        String inTable2Name;
        String inTable1Name;
        String tmpTable = csForOutputConcept.getName() + "_TMP";
        ConceptData first = (ConceptData)this.conceptsData.get(0);
        ConceptData second = (ConceptData)this.conceptsData.get(1);
        Column firstKey = null;
        Column secondKey = null;
        Columnset firstCS = null;
        Columnset secondCS = null;
        try {
            Concept con;
            BaseAttribute id = first.getIdAttribute();
            if (id != null) {
                firstKey = id.getCurrentColumn();
            }
            if ((id = second.getIdAttribute()) != null) {
                secondKey = id.getCurrentColumn();
            }
            if ((con = first.getConcept()) != null) {
                firstCS = con.getCurrentColumnSet();
            }
            if ((con = second.getConcept()) != null) {
                secondCS = con.getCurrentColumnSet();
            }
            if (firstKey == null || secondKey == null || firstCS == null || secondCS == null) {
                throw new M4CompilerError("UnionByKey: Found Key Attribute without Column or InputConcept without Columnset!");
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
        String outTableName = csForOutputConcept.getSchemaPlusName();
        try {
            String viewPrefix = "TMP_" + this.getStep().getId() + "_";
            inTable1Name = this.createViewIfNecessary(firstCS, viewPrefix + "1");
            inTable2Name = this.createViewIfNecessary(secondCS, viewPrefix + "2");
        }
        catch (Exception e) {
            throw new M4CompilerError("UnionByKey: Could not create a view for one of the input Columnset.Exception message is:\n" + e.getMessage());
        }
        String inTable1Key = this.curColNameForBa(first.getIdAttribute());
        String inTable2Key = this.curColNameForBa(second.getIdAttribute());
        String outTableKey = this.getOutputIdAttribute().getName();
        this.createTmpKeyTable(tmpTable, firstKey);
        try {
            String tmpKeyAttr = firstKey.getName();
            String query = "INSERT INTO " + tmpTable + " ( " + tmpKeyAttr + " ) " + " ( SELECT CS1." + inTable1Key + " FROM " + inTable1Name + " CS1, " + inTable2Name + " CS2" + " WHERE CS1." + inTable1Key + " = CS2." + inTable2Key + ")";
            try {
                this.executeBusinessSqlWrite(query);
            }
            catch (SQLException e) {
                throw new M4CompilerError("SQLException when executing '" + query + "'\n:" + e.getMessage());
            }
            this.copyTuples(first, inTable1Name, outTableName);
            this.removeIntersection(tmpTable, tmpKeyAttr, outTableName, outTableKey);
            this.copyTuples(second, inTable2Name, outTableName);
            this.removeIntersection(tmpTable, tmpKeyAttr, outTableName, outTableKey);
            try {
                boolean secondTable;
                String toAttr;
                String fromAttr;
                String[] tga = this.getTargetAttributes(first, "CS1.");
                String firstFromAttr = tga[0];
                String firstToAttr = tga[1];
                tga = this.getTargetAttributes(second, "CS2.");
                String secondFromAttr = tga[0];
                String secondToAttr = tga[1];
                int firstComma = secondFromAttr.indexOf(44);
                if (firstComma == -1) {
                    fromAttr = firstFromAttr;
                    toAttr = firstToAttr;
                    secondTable = false;
                } else {
                    secondFromAttr = secondFromAttr.substring(firstComma);
                    secondToAttr = secondToAttr.substring(secondToAttr.indexOf(44));
                    fromAttr = firstFromAttr + secondFromAttr;
                    toAttr = firstToAttr + secondToAttr;
                    secondTable = true;
                }
                query = "INSERT INTO " + outTableName + " ( " + toAttr + " ) " + "( SELECT " + fromAttr + " FROM " + inTable1Name + " CS1, " + (secondTable ? inTable2Name + " CS2, " : "") + tmpTable + " T" + " WHERE CS1." + inTable1Key + " = T." + tmpKeyAttr + (secondTable ? " AND CS2." + inTable2Key + " = T." + tmpKeyAttr : "") + " )";
                this.executeBusinessSqlWrite(query);
            }
            catch (M4Exception e) {
                throw new M4CompilerError("UnionByKey: Could not get attribute lists from ConceptData!\n" + e.getMessage());
            }
            catch (SQLException e) {
                throw new M4CompilerError("UnionByKey: Error executing write statement\n'" + query + "'\non business data!");
            }
        }
        finally {
            try {
                this.getM4Db().dropBusinessTable(tmpTable);
            }
            catch (Exception e) {
                this.doPrint(Print.MAX, "UnionByKey: Tryied to remove '" + tmpTable + "' from business schema!");
                e.printStackTrace();
            }
        }
    }

    private String createViewIfNecessary(Columnset inputCs, String viewName) throws M4Exception, DbConnectionClosed, SQLException, M4CompilerError {
        Iterator it = inputCs.getColumns().iterator();
        StringBuffer sbuf = new StringBuffer();
        boolean necessary = false;
        while (it.hasNext()) {
            Column cur = (Column)it.next();
            String sqlDef = cur.getSQLDefinition();
            if (sqlDef != null && sqlDef.length() > 0 && !sqlDef.equals(cur.getName())) {
                sbuf.append("( " + sqlDef + " ) AS " + cur.getName() + ", ");
                necessary = true;
                continue;
            }
            sbuf.append(cur.getName() + ", ");
        }
        if (necessary) {
            String viewSql = "SELECT " + sbuf.substring(0, sbuf.length() - 2) + " FROM " + inputCs.getSchemaPlusName();
            String create = "CREATE OR REPLACE VIEW " + viewName + " AS ( " + viewSql + " )";
            this.getM4Db().executeBusinessSqlWrite(create);
            String schema = inputCs.getSchema();
            this.getM4Db().addViewToTrash(viewName, schema, this.getStep().getId());
            return schema + "." + viewName;
        }
        return inputCs.getSchemaPlusName();
    }

    private String curColNameForBa(BaseAttribute ba) throws M4CompilerError {
        if (ba == null) {
            return null;
        }
        Column column = null;
        try {
            column = ba.getCurrentColumn();
        }
        catch (M4Exception e) {
            throw new M4CompilerError("UnionByKey: Could not get current column of BaseAttribute '" + ba.getName() + "'!\n" + e.getMessage());
        }
        return column == null ? null : column.getName();
    }

    private void copyTuples(ConceptData cd, String inTableName, String outTableName) throws M4CompilerError {
        String[] tga;
        try {
            tga = this.getTargetAttributes(cd, null);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("UnionByKey:\n" + e.getMessage());
        }
        String fromAttr = tga[0];
        String toAttr = tga[1];
        String innerQ = "SELECT " + fromAttr + " FROM " + inTableName;
        String query = "INSERT INTO " + outTableName + " ( " + toAttr + " ) ( " + innerQ + " )";
        try {
            this.executeBusinessSqlWrite(query);
        }
        catch (SQLException e) {
            throw new M4CompilerError("UnionByKey: Error executing write statement\n'" + query + "'\non business data!");
        }
    }

    private void removeIntersection(String tmpTable, String tmpKeyName, String tableOut, String outKeyName) throws M4CompilerError {
        String query = "DELETE FROM " + tableOut + " WHERE " + outKeyName + " IN ( SELECT " + tmpKeyName + " FROM " + tmpTable + " )";
        try {
            this.getM4Db().commitBusinessTransactions();
            this.executeBusinessSqlWrite(query);
        }
        catch (SQLException e) {
            throw new M4CompilerError("UnionByKey: SQLException when writing\n'" + query + "'\nto the business data:\n" + e.getMessage());
        }
    }

    private void createTmpKeyTable(String tableName, Column key) throws M4CompilerError {
        String idxName = tableName + "_PK";
        try {
            this.getM4Db().dropBusinessTable(tableName);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
        String cQuery = "CREATE TABLE " + tableName + " ( " + key.getName() + " " + this.determineDBTypeOfColumn(key) + ", CONSTRAINT " + idxName + " PRIMARY KEY ( " + key.getName() + " ))";
        try {
            this.executeBusinessSqlWrite(cQuery);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("UnionByKey: SQL error: " + sqle.getMessage());
        }
    }

    private String[] getTargetAttributes(ConceptData cd, String tablePrefix) throws M4CompilerError, M4Exception {
        if (tablePrefix == null || tablePrefix.trim().length() == 0) {
            tablePrefix = "";
        } else if ((tablePrefix = tablePrefix.trim()).charAt(tablePrefix.length() - 1) != '.') {
            tablePrefix = tablePrefix + ".";
        }
        StringBuffer sbufFrom = new StringBuffer();
        StringBuffer sbufTo = new StringBuffer();
        String idNameFrom = cd.getIdAttribute().getCurrentColumn().getName();
        sbufFrom.append(tablePrefix + idNameFrom + ", ");
        Feature f = this.getMappedFeature(cd.getIdAttribute());
        if (f == null || !(f instanceof BaseAttribute)) {
            throw new M4CompilerError("UnionByKey: No target BaseAttribute key found for input key!");
        }
        BaseAttribute mappedId = (BaseAttribute)f;
        String idNameTo = mappedId.getName();
        sbufTo.append(idNameTo + ", ");
        cd.resetBA();
        while (cd.hasNextBA()) {
            BaseAttribute outBa;
            BaseAttribute ba = cd.nextBA();
            sbufFrom.append(tablePrefix + ba.getCurrentColumn().getName() + ", ");
            Feature outF = this.getMappedFeature(ba);
            if (outF == null || !(outF instanceof BaseAttribute) || (outBa = (BaseAttribute)outF).getCurrentColumn() == null) continue;
            sbufTo.append(outBa.getName() + ", ");
        }
        String[] ret = new String[]{sbufFrom.substring(0, sbufFrom.length() - 2), sbufTo.substring(0, sbufTo.length() - 2)};
        return ret;
    }

    private void createTable(Columnset cs) throws M4CompilerError {
        String tableName = cs.getName();
        String schema = cs.getSchema();
        String idxName = tableName + "_PK";
        long stepId = this.getStep().getId();
        try {
            this.getM4Db().dropBusinessTable(tableName);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
        String cQuery = "CREATE TABLE " + tableName + " (";
        try {
            String idOutAttribute = this.getOutputIdAttribute().getName();
            cQuery = cQuery + idOutAttribute + " " + this.determineDBTypeOfColumn(this.getTheKeys()[0].getCurrentColumn()) + ", ";
            for (int i = 0; i < this.conceptsData.size(); ++i) {
                ConceptData cd = (ConceptData)this.conceptsData.get(i);
                cd.resetBA();
                while (cd.hasNextBA()) {
                    BaseAttribute attr = cd.nextBA();
                    cQuery = cQuery + this.getMappedName(attr) + " " + this.determineDBTypeOfColumn(attr.getCurrentColumn()) + ", ";
                }
            }
            cQuery = cQuery + " CONSTRAINT " + idxName + " PRIMARY KEY ( " + idOutAttribute + " ))";
            try {
                this.executeBusinessSqlWrite(cQuery);
                this.getM4Db().addTableToTrash(tableName, schema, stepId);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("UnionByKey: SQL error: " + sqle.getMessage());
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void collectKeys(Columnset cs) throws M4CompilerError {
        try {
            String iQuery = "INSERT INTO " + cs.getName() + " (" + this.getOutputIdAttribute().getName() + ") (SELECT ID FROM (";
            for (int i = 0; i < this.conceptsData.size(); ++i) {
                ConceptData cd = (ConceptData)this.conceptsData.get(i);
                iQuery = iQuery + "(SELECT " + cd.getIdAttribute().getCurrentColumn().getSQLDefinition() + " AS ID FROM " + cd.getConcept().getCurrentColumnSet().getSQLDefinition() + ") UNION ";
            }
            iQuery = iQuery.substring(0, iQuery.length() - 7) + "))";
            this.getM4Db().executeBusinessSqlWrite(iQuery);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("UnionByKey: SQL error occured: " + sqle.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void fillAttributes(Columnset cs) throws M4CompilerError {
        String commonPart = "UPDATE " + cs.getName() + " CS " + " SET ";
        try {
            for (int i = 0; i < this.conceptsData.size(); ++i) {
                ConceptData cd = (ConceptData)this.conceptsData.get(i);
                String csSql = cd.getConcept().getCurrentColumnSet().getName();
                cd.resetBA();
                while (cd.hasNextBA()) {
                    BaseAttribute ba = cd.nextBA();
                    String iQuery = this.getMappedName(ba) + " = (SELECT " + ba.getCurrentColumn().getSQLDefinition() + " FROM " + csSql + " WHERE CS." + this.getOutputIdAttribute().getName() + " = " + cd.getIdAttribute().getCurrentColumn().getSQLDefinition() + ")";
                    this.getM4Db().executeBusinessSqlWrite(commonPart + iQuery);
                }
            }
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("UnionByKey: SQL exception occured: " + sqle.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private class ConceptData {
        private Concept concept;
        private Vector attributes = new Vector();
        private BaseAttribute attribId;
        private Iterator it = null;

        public Concept getConcept() {
            return this.concept;
        }

        public void setConcept(Concept cs) {
            this.concept = cs;
        }

        public BaseAttribute getIdAttribute() {
            return this.attribId;
        }

        public void setIdAttribute(BaseAttribute id) {
            this.attribId = id;
        }

        public void resetBA() {
            this.it = this.attributes.iterator();
        }

        public boolean hasNextBA() {
            if (this.it == null) {
                this.it = this.attributes.iterator();
            }
            return this.it.hasNext();
        }

        public BaseAttribute nextBA() {
            if (this.it.hasNext()) {
                return (BaseAttribute)this.it.next();
            }
            this.it = null;
            return null;
        }

        public void addBA(BaseAttribute ba) {
            this.attributes.add(ba);
        }
    }
}

