/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.operator.ModelApplier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public abstract class TupleWiseModelApplier
extends ModelApplier {
    protected void predict() throws M4Exception, M4CompilerError {
        Long fromRowNum = null;
        Long toRowNum = null;
        String sql = this.getDatabaseQueryForRows(fromRowNum, toRowNum);
        Vector keyNameCol = this.getKeyColumnNames();
        String keyNames = TupleWiseModelApplier.stringCollectionToCommaSeparatedString(keyNameCol);
        Vector predByNameCol = this.getPredictionColumnNames();
        Vector<String> predTargetsCol = new Vector<String>();
        for (int loop = 0; loop < this.getNumberOfLoops(); ++loop) {
            BaseAttribute curPredBa = this.getPredictedAttribute(loop);
            String predColName = curPredBa.getName();
            predTargetsCol.add(predColName);
            this.createPredictedAttributeInDb(loop);
        }
        String predTargets = TupleWiseModelApplier.stringCollectionToCommaSeparatedString(predTargetsCol);
        String targetTable = this.getTargetTableName();
        String sqlPre = "INSERT INTO " + targetTable + " ( " + keyNames + ", " + predTargets + " ) VALUES ( ";
        String sqlPost = " )";
        try {
            ResultSet rs = this.executeBusinessSqlRead(sql);
            while (rs.next()) {
                int i;
                String[] targetTableValues = new String[keyNameCol.size() + predTargetsCol.size()];
                for (int i2 = 0; i2 < keyNameCol.size(); ++i2) {
                    targetTableValues[i2] = rs.getString((String)keyNameCol.get(i2));
                }
                String[] predInfo = new String[predByNameCol.size()];
                for (i = 0; i < predByNameCol.size(); ++i) {
                    predInfo[i] = rs.getString((String)predByNameCol.get(i));
                }
                for (i = 0; i < predTargetsCol.size(); ++i) {
                    targetTableValues[i + keyNameCol.size()] = this.getPredictionFor(predInfo);
                }
                this.insertIntoDb(targetTableValues, sqlPre, sqlPost);
            }
        }
        catch (SQLException e) {
            throw new M4CompilerError(e.getMessage());
        }
    }

    protected void insertIntoDb(String[] valueArray, String sqlPrefix, String sqlSuffix) throws M4CompilerError, SQLException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < valueArray.length; ++i) {
            buf.append(valueArray[i] + ", ");
        }
        String sql = sqlPrefix + buf.substring(0, buf.length() - 2) + sqlSuffix;
        this.executeBusinessSqlWrite(sql);
    }

    protected abstract String getPredictionFor(String[] var1);
}

