/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.ManualDiscretization;

public class TimeIntervalManualDiscretization
extends ManualDiscretization {
    public Value getTimeFormat() throws M4CompilerError {
        return (Value)this.getSingleParameter("TimeFormat");
    }

    public String generateSQL(Column theTargetAttributeColumn) throws M4CompilerError {
        String timeFormat = this.getTimeFormat().getValue();
        int numberOfIntervals = this.getIntervalStart().length;
        String sql = "(CASE ";
        for (int i = 0; i < numberOfIntervals; ++i) {
            String oneIntervalQuery = "WHEN (";
            boolean inclusion = this.getInclusion(i, true);
            String startComparison = this.getM4Db().getDateComparisonAsSqlString(true, theTargetAttributeColumn.getSQLDefinition(), this.getIntervalStart()[i].getValue(), true, inclusion, timeFormat);
            inclusion = this.getInclusion(i, false);
            String endComparison = this.getM4Db().getDateComparisonAsSqlString(true, theTargetAttributeColumn.getSQLDefinition(), this.getIntervalStart()[i].getValue(), false, inclusion, timeFormat);
            oneIntervalQuery = oneIntervalQuery + startComparison + ") AND (" + endComparison + ") THEN '" + this.getMapTo()[i].getValue() + "' ";
            sql = sql + oneIntervalQuery;
        }
        sql = sql + "ELSE '" + this.getDefaultValue().getValue() + "' END)";
        return sql;
    }

    private boolean getInclusion(int intervalNumber, boolean start) throws M4CompilerError {
        String parameterName;
        String incOrExc = start ? this.getStartIncExc()[intervalNumber].getValue() : this.getEndIncExc()[intervalNumber].getValue();
        String string = parameterName = start ? "StartIncExc" : "EndIncExc";
        if (incOrExc.equals(ManualDiscretization.INTERVAL_EXCLUSION)) {
            return false;
        }
        if (incOrExc.equals(ManualDiscretization.INTERVAL_INCLUSION)) {
            return true;
        }
        throw new M4CompilerError("TimeIntervalManualDiscretization: Found unknown value for parameter '" + parameterName + "': '" + incOrExc + "'; expected '" + ManualDiscretization.INTERVAL_EXCLUSION + "' or '" + ManualDiscretization.INTERVAL_INCLUSION + "'!");
    }
}

