/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class SpecifiedStatistics
extends SingleCSOperator {
    public static final String SUM_SUFFIX = "_SUM";
    public static final String COUNT_SUFFIX = "_COUNT";
    public static final String UNIQUE_SUFFIX = "_UNIQUE";
    public static final String MIN_SUFFIX = "_MIN";
    public static final String MAX_SUFFIX = "_MAX";
    public static final String AVG_SUFFIX = "_AVG";
    public static final String PARAMETER_ATTR_SUM = "AttributesComputeSum";
    public static final String PARAMETER_ATTR_GROUPBY = "GroupBy";
    public static final String PARAMETER_ATTR_AVG = "AttributesComputeAvg";
    public static final String PARAMETER_ATTR_MIN = "AttributesComputeMin";
    public static final String PARAMETER_ATTR_MAX = "AttributesComputeMax";
    public static final String PARAMETER_ATTR_COUNT = "AttributesComputeCount";
    public static final String PARAMETER_ATTR_UNIQUE = "AttributesComputeUnique";
    public static final String PARAMETER_ATTR_DISTRIB = "AttributesComputeDistrib";
    public static final String PARAMETER_DISTRIB_VAL = "DistribValues";
    private final Vector columnNames = new Vector();
    private final Vector columnTypes = new Vector();
    private final Vector sqlDefs = new Vector();

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        try {
            String columnExpr = "";
            Feature inF = null;
            int iIn = 0;
            Feature outF2 = null;
            for (Feature outF2 : this.getOutputConcept().getFeatures()) {
                Column outputColumn;
                Column inputColumn;
                BaseAttribute outBA;
                BaseAttribute inBA;
                if (!this.mustCopyFeature(outF2.getName())) continue;
                iIn = 0;
                do {
                    inF = this.getInputConcept().getFeature(iIn);
                } while (++iIn < this.getInputConcept().getNumberOfFeatures() && !this.correspondsTo(outF2, inF));
                if (!this.correspondsTo(outF2, inF)) {
                    this.doPrint(Print.OPERATOR, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF2.getName() + "' because no corresponding input feature was found.");
                    continue;
                }
                if (this.isDeselectedParameter(inF)) {
                    this.doPrint(Print.PARAM, "Output Concept '" + this.getOutputConcept().getName() + "': skipped feature '" + outF2.getName() + "' because the corresponding input feature was deselected by " + "a FeatureSelection operator.");
                    continue;
                }
                if (outF2 instanceof BaseAttribute) {
                    inBA = (BaseAttribute)inF;
                    outBA = (BaseAttribute)outF2;
                    inputColumn = inBA.getCurrentColumn();
                    outputColumn = inputColumn.copyColToCS(csForOutputConcept);
                    this.getStep().addToTrash(outputColumn);
                    outputColumn.setBaseAttribute(outBA);
                    outputColumn.setSQLDefinition(outBA.getName());
                    outputColumn.setName(outBA.getName());
                    continue;
                }
                if (!(outF2 instanceof MultiColumnFeature)) {
                    throw new M4CompilerError("Unknown Feature type found in Concept with id: " + this.getOutputConcept().getId() + "; Feature id: " + outF2.getId());
                }
                MultiColumnFeature outMCF = (MultiColumnFeature)outF2;
                MultiColumnFeature inMCF = (MultiColumnFeature)inF;
                Iterator theBAs = outMCF.getBaseAttributes().iterator();
                if (theBAs == null) continue;
                try {
                    while (theBAs.hasNext()) {
                        outBA = (BaseAttribute)theBAs.next();
                        inBA = inMCF.getBaseAttributeByName(outBA.getName());
                        inputColumn = inBA.getCurrentColumn();
                        outputColumn = inputColumn.copyColToCS(csForOutputConcept);
                        outputColumn.setBaseAttribute(outBA);
                        outputColumn.setSQLDefinition(outBA.getName());
                        outputColumn.setName(outBA.getName());
                    }
                }
                catch (NullPointerException nfe) {
                    throw new M4CompilerError("ConceptOperator: Mismatch between MultiColumnFeatures in in- and output concept!");
                }
                catch (ArrayIndexOutOfBoundsException aie) {
                    throw new M4CompilerError("ConceptOperator: Mismatch between MultiColumnFeatures in in- and output concept!");
                }
            }
            return columnExpr;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private boolean correspondsTo(Feature out, Feature in) throws M4CompilerError {
        Value[] theDistribValues;
        if (out == null) {
            return false;
        }
        String outName = out.getName().toUpperCase();
        String inName = in.getName().toUpperCase();
        if (outName.endsWith(SUM_SUFFIX)) {
            outName = outName.substring(0, outName.length() - SUM_SUFFIX.length());
        }
        if (outName.endsWith(COUNT_SUFFIX)) {
            outName = outName.substring(0, outName.length() - COUNT_SUFFIX.length());
        }
        if (outName.endsWith(UNIQUE_SUFFIX)) {
            outName = outName.substring(0, outName.length() - UNIQUE_SUFFIX.length());
        }
        if (outName.endsWith(MIN_SUFFIX)) {
            outName = outName.substring(0, outName.length() - MIN_SUFFIX.length());
        }
        if (outName.endsWith(MAX_SUFFIX)) {
            outName = outName.substring(0, outName.length() - MAX_SUFFIX.length());
        }
        if (outName.endsWith(AVG_SUFFIX)) {
            outName = outName.substring(0, outName.length() - AVG_SUFFIX.length());
        }
        if ((theDistribValues = (Value[])this.getParameter(PARAMETER_DISTRIB_VAL)) != null) {
            for (int i = 0; i < theDistribValues.length; ++i) {
                String[] vals = this.getSingleValues(theDistribValues[i]);
                for (int j = 0; j < vals.length; ++j) {
                    if (!outName.endsWith("_" + vals[j].toUpperCase())) continue;
                    outName = outName.substring(0, outName.length() - vals[j].length() - 1);
                }
            }
        }
        return out.getClass() == in.getClass() && outName.equalsIgnoreCase(inName);
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        this.doPrint(Print.OPERATOR, "Operator SpecifiedStatistics is computing...");
        String groupBy = this.getGroupByExpr();
        this.getStatisticsSQLFor(PARAMETER_ATTR_SUM, "SUM(", SUM_SUFFIX);
        this.getStatisticsSQLFor(PARAMETER_ATTR_COUNT, "COUNT(", COUNT_SUFFIX);
        this.getStatisticsSQLFor(PARAMETER_ATTR_UNIQUE, "COUNT(DISTINCT ", UNIQUE_SUFFIX);
        this.getStatisticsSQLFor(PARAMETER_ATTR_MIN, "MIN(", MIN_SUFFIX);
        this.getStatisticsSQLFor(PARAMETER_ATTR_MAX, "MAX(", MAX_SUFFIX);
        this.getStatisticsSQLFor(PARAMETER_ATTR_AVG, "AVG(", AVG_SUFFIX);
        this.getStatisticsSQLFor(PARAMETER_ATTR_DISTRIB, null, null);
        String tableName = this.getNewCSName();
        StringBuffer query = new StringBuffer("INSERT INTO " + tableName + " ( ");
        Iterator it = this.columnNames.iterator();
        while (it.hasNext()) {
            query.append((String)it.next());
            if (it.hasNext()) {
                query.append(", ");
                continue;
            }
            query.append(" ) ( SELECT ");
        }
        it = this.sqlDefs.iterator();
        while (it.hasNext()) {
            Columnset inCs;
            String sqlDef = (String)it.next();
            query.append("(" + sqlDef + ")");
            if (it.hasNext()) {
                query.append(", ");
                continue;
            }
            try {
                inCs = this.getInputConcept().getCurrentColumnSet();
            }
            catch (M4Exception e) {
                throw new M4CompilerError("Specified Statistics: Could not get current Columnset of Concept '" + this.getInputConcept().getName() + "'!");
            }
            String inSqlFrom = " FROM " + inCs.getSchemaPlusName();
            query.append(inSqlFrom + groupBy + " )");
        }
        String inserts = query.toString();
        this.createTable(tableName);
        try {
            this.executeBusinessSqlWrite(inserts);
        }
        catch (SQLException e) {
            throw new M4CompilerError("SQLException for M4 write statement: " + inserts);
        }
        this.doPrint(Print.OPERATOR, "Operator SpecifiedStatistics has finished.");
        return this.getNewCSName();
    }

    private String getGroupByExpr() throws M4CompilerError {
        BaseAttribute[] theBAs = (BaseAttribute[])this.getParameter(PARAMETER_ATTR_GROUPBY);
        StringBuffer buf = new StringBuffer();
        if (theBAs != null && theBAs.length >= 0) {
            for (int i = 0; i < theBAs.length; ++i) {
                BaseAttribute curBa = theBAs[i];
                if (curBa == null) continue;
                String name = curBa.getName();
                String sql = this.getColumnSQLForBaseAttribute(curBa);
                buf.append(sql + ", ");
                this.addColumnToTable(name);
                this.sqlDefs.add(sql);
            }
        }
        if (buf.length() > 2) {
            return " GROUP BY " + buf.substring(0, buf.length() - 2);
        }
        return "";
    }

    private void getStatisticsSQLFor(String m4ParameterName, String operator, String attributeSuffix) throws M4CompilerError {
        block6: {
            BaseAttribute[] theBAs;
            block5: {
                theBAs = (BaseAttribute[])this.getParameter(m4ParameterName);
                if (theBAs == null) {
                    return;
                }
                if (operator == null) break block5;
                for (int i = 0; i < theBAs.length; ++i) {
                    BaseAttribute curBa = theBAs[i];
                    if (curBa == null) continue;
                    String name = curBa.getName() + attributeSuffix;
                    String sql = operator + this.getColumnSQLForBaseAttribute(curBa) + ")";
                    this.addColumnToTable(name);
                    this.sqlDefs.add(sql);
                }
                break block6;
            }
            Value[] theDistribValues = (Value[])this.getParameter(PARAMETER_DISTRIB_VAL);
            if (theBAs != null && theBAs.length > 0 && theDistribValues == null || theBAs != null && theDistribValues != null && theBAs.length != theDistribValues.length) {
                throw new M4CompilerError("Operator SpecifiedStatistics: expected as many parameters 'DistribValues' as 'AttributesComputeDistrib'!");
            }
            if (theBAs == null) break block6;
            for (int i = 0; i < theBAs.length; ++i) {
                String[] vals = this.getSingleValues(theDistribValues[i]);
                boolean useQuotesForValues = this.needsQuotes(theBAs[i]);
                for (int j = 0; j < vals.length; ++j) {
                    String name = theBAs[i].getName() + "_" + vals[j];
                    this.addColumnToTable(name);
                    String quotedValue = useQuotesForValues ? "'" + vals[j] + "'" : vals[j];
                    String sql = "SUM(CASE WHEN " + this.getColumnSQLForBaseAttribute(theBAs[i]) + " = " + quotedValue + " THEN 1 ELSE 0 END)";
                    this.sqlDefs.add(sql);
                }
            }
        }
    }

    private boolean needsQuotes(BaseAttribute ba) throws M4CompilerError {
        if (ba == null) {
            return false;
        }
        try {
            Column c = ba.getCurrentColumn();
            return c.getColumnDataTypeName().equalsIgnoreCase("STRING");
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator SpecifiedStatistics: could not access column data type of BaseAttribute '" + ba.getName() + "'!");
        }
    }

    private String computeDistributions() throws M4CompilerError {
        BaseAttribute[] theBAs = (BaseAttribute[])this.getParameter(PARAMETER_ATTR_DISTRIB);
        Value[] theDistribValues = (Value[])this.getParameter(PARAMETER_DISTRIB_VAL);
        if (theBAs != null && theBAs.length > 0 && theDistribValues == null || theBAs != null && theDistribValues != null && theBAs.length != theDistribValues.length) {
            throw new M4CompilerError("Operator SpecifiedStatistics: expected as many parameters 'DistribValues' as 'AttributesComputeDistrib'!");
        }
        if (theBAs != null) {
            StringBuffer distrib = new StringBuffer();
            for (int i = 0; i < theBAs.length; ++i) {
                String[] vals = this.getSingleValues(theDistribValues[i]);
                for (int j = 0; j < vals.length; ++j) {
                    String count = this.computeDistCount(theBAs[i], vals[j]);
                    String name = theBAs[i].getName() + "_" + vals[j];
                    this.addColumnToTable(name);
                    distrib.append(name + "=" + count + ", ");
                }
                if (distrib.length() <= 2) continue;
                return distrib.substring(0, distrib.length() - 2);
            }
        }
        return null;
    }

    private Column getColumnForBaseAttribute(BaseAttribute ba) throws M4CompilerError {
        Column column;
        try {
            column = ba.getCurrentColumn();
        }
        catch (M4Exception e) {
            throw new M4CompilerError("SpecifiedStatistics: Exception when trying to get current column for BaseAttribute '" + ba.getName() + "'!");
        }
        return column;
    }

    private String getColumnSQLForBaseAttribute(BaseAttribute ba) throws M4CompilerError {
        String sql;
        Column column = this.getColumnForBaseAttribute(ba);
        if (column == null || (sql = column.getSQLDefinition()) == null) {
            throw new M4CompilerError("SpecifiedStatistics: Found <null> Column for BaseAttribute that is NOT deselected!\nBaseAttribute name is " + ba.getName());
        }
        return sql;
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return true;
    }

    private void addColumnToTable(String columnName) throws M4CompilerError {
        if (columnName == null) {
            return;
        }
        try {
            Concept outC = this.getOutputConcept();
            Iterator it = outC.getFeatures().iterator();
            boolean found = false;
            String columnType = null;
            while (it.hasNext()) {
                Feature f = (Feature)it.next();
                if (!f.getName().equalsIgnoreCase(columnName)) continue;
                if (!(f instanceof BaseAttribute)) {
                    throw new M4CompilerError("Operator SpecifiedStatistics: Found a MCF, cannot handle it.");
                }
                columnType = ((BaseAttribute)f).getCurrentColumn().getColumnDataTypeName();
                found = true;
            }
            if (!found) {
                throw new M4CompilerError("Operator SpecifiedStatistics: TheOutputConcept must contain a BaseAttribute named '" + columnName + "'!");
            }
            this.columnNames.add(columnName);
            this.columnTypes.add(columnType);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private void createTable(String tableName) throws M4CompilerError {
        String create = "";
        try {
            this.getM4Db().dropBusinessTable(tableName);
            String numericDatatype = this.getM4Db().getNameOfNumericDatatype();
            create = "create table " + tableName + " (";
            for (int i = 0; i < this.columnNames.size(); ++i) {
                int columnTypeSize = 100;
                String dataType = this.getM4Db().getDbNameOfM4Datatype((String)this.columnTypes.get(i), columnTypeSize, true);
                if (dataType.startsWith(numericDatatype)) {
                    dataType = numericDatatype;
                }
                create = create + (String)this.columnNames.get(i) + " " + dataType + ", ";
            }
            create = create.substring(0, create.length() - 2) + ")";
            this.getM4Db().executeBusinessSqlWrite(create);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator SpecifiedStatistics: could not create table with the computed values, SQL error: " + sqle.getMessage() + "\n" + create);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
        try {
            this.getM4Db().addTableToTrash(tableName, this.getInputConcept().getCurrentColumnSet().getSchema(), this.getStep().getId());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private String[] getSingleValues(Value v) {
        String s = v.getValue();
        StringTokenizer st = new StringTokenizer(s, ",");
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i] = st.nextToken().trim();
            ret[i] = ret[i].replace(' ', '_');
            ++i;
        }
        return ret;
    }

    private String computeDistCount(BaseAttribute distBA, String value) throws M4CompilerError {
        String d = null;
        Column c = this.getColumnForBaseAttribute(distBA);
        d = this.getM4Db().computeNumberOfElementsForValue(c, value);
        if (d == null) {
            this.doPrint(Print.OPERATOR, "Warning: Operator SpecifiedStatistics: output table contains NULL values!");
        }
        return d;
    }
}

