/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.TimeOperator;
import edu.udo.cs.miningmart.storedProcedures.SMF;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import java.sql.SQLException;

public class SimpleMovingFunction
extends TimeOperator {
    private static final String INPUTTIMEBA = "InputTimeBA";
    private static final String INPUTVALUEBA = "InputValueBA";
    private static final String OUTPUTTIMESTARTBA = "OutputTimeStartBA";
    private static final String OUTPUTTIMEENDBA = "OutputTimeEndBA";
    private static final String OUTPUTVALUEBA = "OutputValueBA";
    private static final String WINDOWSIZE = "WindowSize";
    private static final String DISTANCE = "Distance";
    private static final String procedureName = "SMA";
    private static final String columnSetSuffix = "_CS";

    protected String getColumnSetSuffix() {
        return columnSetSuffix;
    }

    public BaseAttribute getTimeBaIn() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INPUTTIMEBA);
    }

    public BaseAttribute getValueBaIn() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INPUTVALUEBA);
    }

    public BaseAttribute getTimeBaStartOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTTIMESTARTBA);
    }

    public BaseAttribute getTimeBaEndOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTTIMEENDBA);
    }

    public BaseAttribute getValueBaOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTVALUEBA);
    }

    public Value getWindowSize() throws M4CompilerError {
        return (Value)this.getSingleParameter(WINDOWSIZE);
    }

    public Value getDistance() throws M4CompilerError {
        return (Value)this.getSingleParameter(DISTANCE);
    }

    protected void createJavaColumns(Columnset newCS) throws M4CompilerError {
        try {
            Column timeColumnForType = this.getTimeBaIn().getColumn(0);
            this.createM4Column(this.getTimeBaStartOut(), newCS, timeColumnForType);
            this.createM4Column(this.getTimeBaEndOut(), newCS, timeColumnForType);
            Column valueColumnForType = this.getValueBaIn().getColumn(0);
            this.createM4Column(this.getValueBaOut(), newCS, valueColumnForType);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void runStoredProcedure(String newColumnsetName) throws SQLException, M4CompilerError, TimeOperatorException {
        this.valueIsLong(this.getWindowSize(), WINDOWSIZE);
        this.valueIsLong(this.getDistance(), DISTANCE);
        this.baseattribHasColumns(this.getTimeBaIn(), INPUTTIMEBA);
        this.baseattribHasColumns(this.getValueBaIn(), INPUTVALUEBA);
        String[] parameters = new String[]{SimpleMovingFunction.getQuotedColSetNameforCon(this.getInputConcept()), SimpleMovingFunction.getQuotedColNameforInpBA(this.getTimeBaIn()), SimpleMovingFunction.getQuotedColNameforInpBA(this.getValueBaIn()), DB.quote(newColumnsetName), SimpleMovingFunction.getQuotedColNameforOutBA(this.getTimeBaStartOut()), SimpleMovingFunction.getQuotedColNameforOutBA(this.getTimeBaEndOut()), SimpleMovingFunction.getQuotedColNameforOutBA(this.getValueBaOut()), this.getWindowSize().getValue().trim(), this.getDistance().getValue().trim()};
        if (this.storedProceduresAvailable()) {
            this.executeDbProcedure(procedureName, parameters);
        } else {
            SMF.dbSMF(this.getM4Db(), SimpleMovingFunction.unquote(parameters[0]), SimpleMovingFunction.unquote(parameters[1]), SimpleMovingFunction.unquote(parameters[2]), SimpleMovingFunction.unquote(parameters[3]), SimpleMovingFunction.unquote(parameters[4]), SimpleMovingFunction.unquote(parameters[5]), SimpleMovingFunction.unquote(parameters[6]), Integer.parseInt(parameters[7]), Integer.parseInt(parameters[8]));
        }
    }
}

