/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.TimeOperator;
import edu.udo.cs.miningmart.storedProcedures.SimpleSTSP;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import java.sql.SQLException;

public class SignalToSymbolProcessing
extends TimeOperator {
    private static final String INPUTTIMEBA = "InputTimeBA";
    private static final String INPUTVALUEBA = "InputValueBA";
    private static final String OUTPUTTIMESTARTBA = "OutputTimeStartBA";
    private static final String OUTPUTTIMEENDBA = "OutputTimeEndBA";
    private static final String AVERAGEVALUEBA = "AverageValueBA";
    private static final String INCREASEVALUEBA = "IncreaseValueBA";
    private static final String TOLERANCE = "Tolerance";
    private static final String procedureName = "SimpleSTSP";
    private static final String columnSetSuffix = "_CS";

    protected String getColumnSetSuffix() {
        return columnSetSuffix;
    }

    public BaseAttribute getTimeBaIn() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INPUTTIMEBA);
    }

    public BaseAttribute getValueBaIn() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INPUTVALUEBA);
    }

    public BaseAttribute getTimeBaStartOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTTIMESTARTBA);
    }

    public BaseAttribute getTimeBaEndOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTTIMEENDBA);
    }

    public BaseAttribute getAverageValueBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(AVERAGEVALUEBA);
    }

    public BaseAttribute getIncreaseValueBA() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INCREASEVALUEBA);
    }

    public Value getTolerance() throws M4CompilerError {
        return (Value)this.getSingleParameter(TOLERANCE);
    }

    protected void createJavaColumns(Columnset newCS) throws SQLException, M4CompilerError {
        try {
            Column timeColumnForType = this.getTimeBaIn().getColumn(0);
            this.createM4Column(this.getTimeBaStartOut(), newCS, timeColumnForType);
            this.createM4Column(this.getTimeBaEndOut(), newCS, timeColumnForType);
            Column valueColumnForType = this.getValueBaIn().getColumn(0);
            this.createM4Column(this.getAverageValueBA(), newCS, valueColumnForType);
            this.createM4Column(this.getIncreaseValueBA(), newCS, valueColumnForType);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void runStoredProcedure(String newColumnsetName) throws SQLException, M4CompilerError, TimeOperatorException {
        this.valueIsDouble(this.getTolerance(), TOLERANCE);
        this.baseattribHasColumns(this.getTimeBaIn(), INPUTTIMEBA);
        this.baseattribHasColumns(this.getValueBaIn(), INPUTVALUEBA);
        String[] parameters = new String[]{SignalToSymbolProcessing.getQuotedColSetNameforCon(this.getInputConcept()), SignalToSymbolProcessing.getQuotedColNameforInpBA(this.getTimeBaIn()), SignalToSymbolProcessing.getQuotedColNameforInpBA(this.getValueBaIn()), DB.quote(newColumnsetName), SignalToSymbolProcessing.getQuotedColNameforOutBA(this.getTimeBaStartOut()), SignalToSymbolProcessing.getQuotedColNameforOutBA(this.getTimeBaEndOut()), SignalToSymbolProcessing.getQuotedColNameforOutBA(this.getAverageValueBA()), SignalToSymbolProcessing.getQuotedColNameforOutBA(this.getIncreaseValueBA()), this.getTolerance().getValue().trim()};
        if (this.storedProceduresAvailable()) {
            this.executeDbProcedure(procedureName, parameters);
        } else {
            SimpleSTSP.dbSTSP(this.getM4Db(), SignalToSymbolProcessing.unquote(parameters[0]), SignalToSymbolProcessing.unquote(parameters[1]), SignalToSymbolProcessing.unquote(parameters[2]), SignalToSymbolProcessing.unquote(parameters[3]), SignalToSymbolProcessing.unquote(parameters[4]), SignalToSymbolProcessing.unquote(parameters[5]), SignalToSymbolProcessing.unquote(parameters[6]), SignalToSymbolProcessing.unquote(parameters[7]), Double.parseDouble(parameters[8]));
        }
    }
}

