/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.compiler.wrapper.SVM_Wrapper;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.FeatureConstruction;
import java.util.Vector;

public abstract class SVMforDataMining
extends FeatureConstruction {
    private SVM_Wrapper mysvm = null;
    private boolean useDatabaseSVM = false;

    protected abstract SVM_Wrapper constructWrapper(boolean var1) throws M4CompilerError;

    public String generateSQL(Column columnToFill) throws M4CompilerError {
        this.callStatement(columnToFill);
        String fctCall = this.mysvm.getDecisionFunctionName() + "(";
        try {
            for (int i = 0; i < this.getThePredictingAttributes().length; ++i) {
                fctCall = fctCall + this.getThePredictingAttributes()[i].getCurrentColumn().getSQLDefinition() + ", ";
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        fctCall = fctCall.substring(0, fctCall.length() - 2) + ")";
        return fctCall;
    }

    private void callStatement(Column columnToFill) throws M4CompilerError {
        this.useDatabaseSVM = this.getUseDatabaseSVM();
        this.mysvm = this.constructWrapper(this.useDatabaseSVM);
        try {
            Columnset theColumnSet = this.getTheInputConcept().getCurrentColumnSet();
            String fctSchema = theColumnSet.getSchema();
            if (fctSchema.length() == 0) {
                fctSchema = null;
            }
            Vector<Column> theCols = new Vector<Column>();
            for (int i = 0; i < this.getThePredictingAttributes().length; ++i) {
                theCols.add(this.getThePredictingAttributes()[i].getCurrentColumn());
            }
            theCols.trimToSize();
            this.mysvm.callSVM(theColumnSet, columnToFill, this.getTheInputConcept().getId(), this.getC(), this.getKernelType(), this.getEpsilon(), theCols);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("SVM-Wrapper: could not commit DB updates: " + m4e.getMessage());
        }
    }

    protected String getPrefixForDatabaseObjects() throws M4CompilerError {
        try {
            String loopIdentification = "";
            if (this.getHighestLoopNr() > 1) {
                loopIdentification = "L" + this.getCurrentLoopNumber();
            }
            return this.getTheInputConcept().getCurrentColumnSet().getName() + loopIdentification;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected String getDatabaseSchema() throws M4CompilerError {
        try {
            return this.getTheInputConcept().getCurrentColumnSet().getSchema();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public String getC() throws M4CompilerError {
        return ((Value)this.getSingleParameter("C", this.getCurrentLoopNumber())).getValue();
    }

    public BaseAttribute getKey() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheKey", this.getCurrentLoopNumber());
    }

    public String getEpsilon() throws M4CompilerError {
        return ((Value)this.getSingleParameter("Epsilon", this.getCurrentLoopNumber())).getValue();
    }

    public String getKernelType() throws M4CompilerError {
        return ((Value)this.getSingleParameter("KernelType", this.getCurrentLoopNumber())).getValue();
    }

    public String getLossFunctionNeg() throws M4CompilerError {
        return ((Value)this.getSingleParameter("LossFunctionNeg", this.getCurrentLoopNumber())).getValue();
    }

    public String getLossFunctionPos() throws M4CompilerError {
        return ((Value)this.getSingleParameter("LossFunctionPos", this.getCurrentLoopNumber())).getValue();
    }

    public long getSampleSize() throws M4CompilerError {
        long sample;
        Value v = (Value)this.getSingleParameter("SampleSize", this.getCurrentLoopNumber());
        if (v == null) {
            return -1L;
        }
        try {
            sample = Long.parseLong(v.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("SupportVectorMachineForRegression: SampleSize must be an integer! Found: " + v.getValue());
        }
        return sample;
    }

    public BaseAttribute[] getThePredictingAttributes() throws M4CompilerError {
        return (BaseAttribute[])this.getParameter("ThePredictingAttributes", this.getCurrentLoopNumber());
    }

    public boolean getUseDatabaseSVM() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("UseDB_SVM", this.getCurrentLoopNumber());
        if (v == null) {
            return this.useDatabaseSVM;
        }
        String s = v.getValue();
        return s.equalsIgnoreCase("true");
    }
}

