/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.RowSelection;
import java.util.StringTokenizer;

public final class RowSelectionByQuery
extends RowSelection {
    public static final String PARAMETER_LEFT_CONDITION = "TheLeftCondition";
    public static final String PARAMETER_RIGHT_CONDITION = "TheRightCondition";
    public static final String PARAMETER_CONDITION_OP = "TheConditionOperator";

    public String generateConditionForOp() throws M4CompilerError {
        try {
            String sqlCondition = "";
            for (int i = 0; i < this.getNumberOfLoops(); ++i) {
                Value rightCond = this.getTheRightCondition(i);
                String rightExpr = this.ensureQuotation(rightCond, this.getTheConditionOperator(i).trim());
                sqlCondition = sqlCondition + "(" + this.getTheLeftCondition(i).getCurrentColumn().getSQLDefinition() + " " + this.getTheConditionOperator(i) + " " + rightExpr + ") AND ";
            }
            sqlCondition = sqlCondition.substring(0, sqlCondition.length() - 4);
            return sqlCondition;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected BaseAttribute getTheLeftCondition(int loopNr) throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(PARAMETER_LEFT_CONDITION, loopNr);
    }

    protected String getTheConditionOperator(int loopNr) throws M4CompilerError {
        return ((Value)this.getSingleParameter(PARAMETER_CONDITION_OP, loopNr)).getValue();
    }

    protected Value getTheRightCondition(int loopNr) throws M4CompilerError {
        return (Value)this.getSingleParameter(PARAMETER_RIGHT_CONDITION, loopNr);
    }

    private String ensureQuotation(Value rightCond, String operator) {
        if (operator.equalsIgnoreCase("in")) {
            String expr = rightCond.getValue().trim();
            if (expr.startsWith("(")) {
                expr = expr.substring(1);
            }
            if (expr.endsWith(")")) {
                expr = expr.substring(0, expr.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(expr, ", ");
            String ret = "";
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (this.isNumeric(token) || this.isQuoted(token)) {
                    ret = ret + token + ", ";
                    continue;
                }
                ret = ret + DB.quote(token) + ", ";
            }
            ret = "(" + ret.substring(0, ret.length() - 2) + ")";
            return ret;
        }
        if (rightCond.isDouble() || rightCond.isLong()) {
            return rightCond.getValue().trim();
        }
        return DB.quote(rightCond.getValue().trim());
    }

    private boolean isNumeric(String s) {
        if (s == null) {
            return false;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException n) {
            return false;
        }
    }

    private boolean isQuoted(String s) {
        return (s = s.trim()).startsWith("'") && s.endsWith("'");
    }
}

