/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.compiler.wrapper.DB_SVM_RG;
import edu.udo.cs.miningmart.compiler.wrapper.SVM_RG;
import edu.udo.cs.miningmart.compiler.wrapper.SVM_Wrapper;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.MissingValues;
import java.util.Vector;

public class MissingValuesWithRegressionSVM
extends MissingValues {
    private SVM_Wrapper svm;
    private boolean useDatabaseSVM = false;

    public String generateValueForOp(Column columnWithMissingValues) throws M4CompilerError {
        this.callStatement(columnWithMissingValues);
        String fctCall = this.svm.getDecisionFunctionName() + "(";
        try {
            for (int i = 0; i < this.getThePredictingAttributes().length; ++i) {
                fctCall = fctCall + this.getThePredictingAttributes()[i].getCurrentColumn().getSQLDefinition() + ", ";
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        fctCall = fctCall.substring(0, fctCall.length() - 2) + ")";
        return fctCall;
    }

    private void callStatement(Column columnWithMissingValues) throws M4CompilerError {
        Columnset theColumnSet;
        this.svm = null;
        long sample = this.getSampleSize();
        try {
            if (this.useDatabaseSVM) {
                BaseAttribute keyBA = this.getKey();
                String key = null;
                if (keyBA != null) {
                    key = keyBA.getCurrentColumn().getName();
                }
                this.svm = sample == -1L ? new DB_SVM_RG(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getDatabaseSchema(), this.getStep().getId(), key, this.getLossFunctionPos(), this.getLossFunctionNeg()) : new DB_SVM_RG(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getDatabaseSchema(), this.getStep().getId(), key, sample, this.getLossFunctionPos(), this.getLossFunctionNeg());
            } else {
                this.svm = new SVM_RG(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getDatabaseSchema(), this.getStep().getId(), sample, this.getLossFunctionPos(), this.getLossFunctionPos());
            }
        }
        catch (InterruptedException e) {
            this.doPrint(Print.MAX, "Error while constructing SVM: " + e.getMessage());
        }
        catch (Exception e) {
            this.doPrint(Print.MAX, "Error with MissingValuesWithRegressionSVM: " + e.getMessage());
        }
        Vector<Column> theCols = new Vector<Column>();
        try {
            theColumnSet = this.getTheInputConcept().getCurrentColumnSet();
            BaseAttribute[] bas = this.getThePredictingAttributes();
            for (int i = 0; i < bas.length; ++i) {
                theCols.add(bas[i].getCurrentColumn());
            }
            theCols.trimToSize();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
        this.svm.callSVM(theColumnSet, columnWithMissingValues, this.getTheInputConcept().getId(), this.getC(), this.getKernelType(), this.getEpsilon(), theCols);
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: could not commit DB updates: " + m4e.getMessage());
        }
    }

    private String getPrefixForDatabaseObjects() throws M4CompilerError {
        try {
            String loopIdentification = "";
            if (this.getHighestLoopNr() > 1) {
                loopIdentification = "L" + this.getCurrentLoopNumber();
            }
            return this.getTheInputConcept().getCurrentColumnSet().getName() + loopIdentification;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected String getDatabaseSchema() throws M4CompilerError {
        try {
            return this.getTheInputConcept().getCurrentColumnSet().getSchema();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public String getC() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("C", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter C not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public String getEpsilon() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("Epsilon", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter Epsilon not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public String getKernelType() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("KernelType", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter KernelType not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public String getLossFunctionNeg() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("LossFunctionNeg", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter LossFunctionNeg not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public String getLossFunctionPos() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("LossFunctionPos", this.getCurrentLoopNumber());
        if (v == null) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: Parameter LossFunctionPos not found in loop " + this.getCurrentLoopNumber());
        }
        return v.getValue();
    }

    public long getSampleSize() throws M4CompilerError {
        long sample;
        Value v = (Value)this.getSingleParameter("SampleSize", this.getCurrentLoopNumber());
        if (v == null) {
            return -1L;
        }
        try {
            sample = Long.parseLong(v.getValue());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("MissingValuesWithRegressionSVM: SampleSize must be an integer! Found: " + v.getValue());
        }
        return sample;
    }

    public BaseAttribute[] getThePredictingAttributes() throws M4CompilerError {
        return (BaseAttribute[])this.getParameter("ThePredictingAttributes", this.getCurrentLoopNumber());
    }

    public BaseAttribute getKey() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheKey", this.getCurrentLoopNumber());
    }

    public void setToDatabaseSVM() {
        this.useDatabaseSVM = true;
    }

    public void setToStandardSVM() {
        this.useDatabaseSVM = false;
    }
}

