/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.FeatureConstruction;
import java.util.Iterator;
import java.util.Vector;

public class MergeAttributes
extends FeatureConstruction {
    public static final String PARAMETER_MERGE_ATTRIB = "AttributeToMerge";
    public static final String PARAMETER_CLASH_RESOLVE = "ClashResolvation";
    private BaseAttribute mergeAttrib;

    public String generateSQL(Column targetAttributeColumn) throws M4CompilerError {
        String colDef = "(CASE ";
        colDef = colDef + this.getConditionForPrioritisation();
        if (!this.usePriorities()) {
            colDef = colDef + this.getConditionForValueCombi(targetAttributeColumn);
        }
        colDef = colDef + " ELSE " + this.getTheTargetAttribute().getName() + " END)";
        return colDef;
    }

    private String getConditionForPrioritisation() throws M4CompilerError {
        String targetBaName = this.getTheTargetAttribute().getName();
        String mergeBaName = this.getAttributeToMerge().getName();
        String sql = "WHEN " + targetBaName + " IS NULL AND " + mergeBaName + " IS NOT NULL THEN " + mergeBaName + " WHEN " + mergeBaName + " IS NULL THEN " + targetBaName;
        return sql;
    }

    private String getConditionForValueCombi(Column targetCol) throws M4CompilerError {
        String[][] allCombis = this.getValueCombinations(targetCol);
        String targetBaName = this.getTheTargetAttribute().getName();
        String mergeBaName = this.getAttributeToMerge().getName();
        String sql = "";
        for (int i = 0; i < allCombis.length; ++i) {
            sql = sql + " WHEN " + targetBaName + " = '" + allCombis[0][i] + "' AND " + mergeBaName + " = '" + allCombis[1][i] + "' THEN '" + allCombis[2][i] + "'";
        }
        return sql;
    }

    private BaseAttribute getAttributeToMerge() throws M4CompilerError {
        if (this.mergeAttrib == null) {
            this.mergeAttrib = (BaseAttribute)this.getSingleParameter(PARAMETER_MERGE_ATTRIB);
        }
        return this.mergeAttrib;
    }

    private boolean usePriorities() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter(PARAMETER_CLASH_RESOLVE, this.getCurrentLoopNumber());
        if (v == null || v.getValue() == null || v.getValue().equals("")) {
            throw new M4CompilerError("Operator 'MergeAttributes', step '" + this.getStep().getName() + "': could not read parameter '" + PARAMETER_CLASH_RESOLVE + "'!");
        }
        String resolveMethod = v.getValue();
        return resolveMethod.equalsIgnoreCase("priority");
    }

    private String[][] getValueCombinations(Column targetCol) throws M4CompilerError {
        try {
            int j;
            this.getAttributeToMerge();
            int noOfColumns = 3;
            Vector valueLists = new Vector();
            int noOfRows = 1;
            String[] vals = this.getM4Db().getDistinctElementsWithoutNull(targetCol);
            Vector<String> valueList = new Vector<String>();
            for (j = 0; j < vals.length; ++j) {
                valueList.add(vals[j]);
            }
            noOfRows *= vals.length;
            valueLists.add(valueList);
            vals = this.getM4Db().getDistinctElementsWithoutNull(this.mergeAttrib.getCurrentColumn());
            valueList = new Vector();
            for (j = 0; j < vals.length; ++j) {
                valueList.add(vals[j]);
            }
            valueLists.add(valueList);
            Vector allCombis = this.getCombinations(valueLists);
            String[][] ret = new String[noOfColumns][noOfRows *= vals.length];
            int currentRow = 0;
            for (Vector oneCombination : allCombis) {
                Iterator it2 = oneCombination.iterator();
                int currentColumn = 0;
                String combi = "";
                while (it2.hasNext()) {
                    String aValue;
                    ret[currentColumn][currentRow] = aValue = (String)it2.next();
                    combi = combi + aValue + "_";
                    ++currentColumn;
                }
                ret[currentColumn][currentRow] = combi = combi.substring(0, combi.length() - 1);
                ++currentRow;
            }
            return ret;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'MergeAttributes': M4 error when accessing occurring values of attributes to merge: " + m4e.getMessage());
        }
    }

    private Vector getCombinations(Vector listsOfValues) {
        if (listsOfValues == null || listsOfValues.isEmpty()) {
            Vector emptyList = new Vector();
            Vector emptyCombi = new Vector();
            emptyCombi.add(emptyList);
            return emptyCombi;
        }
        Vector firstList = (Vector)listsOfValues.remove(0);
        Vector allCombis = new Vector();
        Vector combisSoFar = this.getCombinations(listsOfValues);
        for (String aValue : firstList) {
            for (Vector aCombi : combisSoFar) {
                aCombi.add(0, aValue);
                allCombis.add(new Vector(aCombi));
                aCombi.remove(0);
            }
        }
        return allCombis;
    }
}

