/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.ForeignKeyLink;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.core.ForeignKey;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.sql.SQLException;

public class MaterializeRelation
extends ExecutableOperator {
    public void createStatement(boolean lazy) throws M4CompilerError {
        try {
            String tableName = this.getTableName();
            this.getM4Db().dropBusinessTable(tableName);
            String sql = "CREATE TABLE " + tableName + " AS ( SELECT * FROM " + this.getCrossTableName() + " )";
            this.executeBusinessSqlWrite(sql);
            Relation rel = this.getRelation();
            sql = this.keyToStatement(tableName, (ForeignKey)rel.getFromKey());
            this.executeBusinessSqlWrite(sql);
            sql = this.keyToStatement(tableName, (ForeignKey)rel.getToKey());
            this.executeBusinessSqlWrite(sql);
            this.getM4Db().addTableToTrash(tableName, this.getSchema(), this.getStep().getId());
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'MaterializeRelation': M4Exception caught during createStatement:\n" + e.getMessage());
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'MaterializeRelation': SQLException caught during createStatement:\n" + e.getMessage());
        }
    }

    private String keyToStatement(String tableName, ForeignKey fk) throws M4Exception {
        ForeignKeyLink fkl = fk.getFirstColumnLink();
        String links = fkl.getForeignKeyColumn().getName();
        String linkedToTab = fkl.getForeignKeyColumn().getColumnset().getSchemaPlusName();
        String linkedToCol = fkl.getForeignKeyColumn().getName();
        return "ALTER TABLE " + tableName + " ADD CONSTRAINT " + tableName + "_FK FOREIGN KEY (" + links + ") REFERENCES " + linkedToTab + "(" + linkedToCol + ")";
    }

    public void compileStatement() {
    }

    public EstimatedStatistics estimateStatistics(Step theStep) throws M4Exception {
        return null;
    }

    public String getTableName() throws M4CompilerError {
        Value value = (Value)this.getSingleParameter("TableName");
        if (value != null && value.getValue().trim().length() > 0) {
            return value.getValue().trim();
        }
        return this.getCrossTableName() + "_T";
    }

    protected Relation getRelation() throws M4CompilerError {
        return (Relation)this.getSingleParameter("TheRelation");
    }

    protected String getSchema() throws M4CompilerError, M4Exception {
        return ((Relation)this.getSingleParameter("TheRelation")).getCrossLinkColumnSet().getSchema();
    }

    protected String getCrossTableName() throws M4CompilerError {
        try {
            Columnset cs = this.getRelation().getCrossLinkColumnSet();
            return cs.getSchemaPlusName();
        }
        catch (M4Exception e) {
            throw new M4CompilerError("MaterializeRelation: Could not read cross-table name. Only n:m relations are supported.");
        }
    }
}

