/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.compiler.wrapper.DB_SVM_CL;
import edu.udo.cs.miningmart.compiler.wrapper.SVM_CL;
import edu.udo.cs.miningmart.compiler.wrapper.SVM_Wrapper;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.FeatureSelection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class FeatureSelectionWithSVM
extends FeatureSelection {
    private SVM_Wrapper mysvm = null;
    private boolean useDatabaseSVM = false;

    protected Collection computeListOfAttributes(Feature[] theSuperset) throws M4CompilerError {
        this.useDatabaseSVM = this.mustUseDatabaseSVM();
        this.prepareSVM();
        Feature[] bestSubset = this.search(theSuperset);
        Vector<Feature> v = new Vector<Feature>();
        for (int i = 0; i < bestSubset.length; ++i) {
            v.add(bestSubset[i]);
        }
        v.trimToSize();
        return v;
    }

    private void prepareSVM() {
        block8: {
            try {
                long sample;
                Value v;
                BaseAttribute keyBA = this.getKey();
                String key = null;
                if (keyBA != null) {
                    key = keyBA.getCurrentColumn().getName();
                }
                if ((v = this.getPositiveTarget()) == null) {
                    throw new M4CompilerError("Operator FeatureSelectionWithSVM: Need parameter 'PositiveTargetValue'!");
                }
                String positiveTargetValue = v.getValue();
                Value sa = this.getSampleSize();
                if (sa == null) {
                    if (!this.useDatabaseSVM) {
                        throw new M4CompilerError("FeatureSelectionWithSVM: parameter 'SampleSize' must be specified if SVM outside database is used!");
                    }
                    this.mysvm = new DB_SVM_CL(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getDatabaseSchema(), this.getStep().getId(), key, positiveTargetValue);
                    break block8;
                }
                try {
                    sample = Long.parseLong(sa.getValue());
                }
                catch (NumberFormatException nfe) {
                    throw new M4CompilerError("FeatureSelectionWithSVM: SampleSize must be an integer! Found: " + v.getValue());
                }
                this.mysvm = this.useDatabaseSVM ? new DB_SVM_CL(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getDatabaseSchema(), this.getStep().getId(), key, sample, positiveTargetValue) : new SVM_CL(this.getM4Db(), this.getM4Db().getCasePrintObject(), this.getPrefixForDatabaseObjects(), this.getDatabaseSchema(), this.getStep().getId(), sample, positiveTargetValue);
            }
            catch (Exception e) {
                this.doPrint(Print.MAX, "Error with SVM for FeatureSelection: " + e.getMessage());
            }
        }
    }

    private String getPrefixForDatabaseObjects() throws M4CompilerError {
        try {
            return this.getInputConcept().getCurrentColumnSet().getName();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected String getDatabaseSchema() throws M4CompilerError {
        try {
            return this.getInputConcept().getCurrentColumnSet().getSchema();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private Feature[] search(Feature[] theSet) throws M4CompilerError {
        Vector best;
        Vector<Feature> all = new Vector<Feature>();
        for (int i = 0; i < theSet.length; ++i) {
            all.add(theSet[i]);
        }
        all.trimToSize();
        if (this.getDirection().getValue().equalsIgnoreCase("forward")) {
            Vector empty = new Vector(0);
            best = this.searchForward(empty, all, -1.0);
        } else {
            best = this.searchBackward(all, -1.0);
        }
        Feature[] bestSubset = new Feature[best.size()];
        String theNames = "";
        for (int i = 0; i < bestSubset.length; ++i) {
            bestSubset[i] = (Feature)best.get(i);
            theNames = theNames + bestSubset[i].getName() + ", ";
        }
        theNames = theNames.substring(0, theNames.length() - 2);
        this.doPrint(Print.OPERATOR, "FSwithSVM: selected the following features: " + theNames);
        return bestSubset;
    }

    private Vector searchBackward(Vector current, double currentPerformance) throws M4CompilerError {
        if (current.size() == 1) {
            return current;
        }
        if (currentPerformance == -1.0) {
            this.doPrint(Print.OPERATOR, "FSwithSVM: evaluating all features...");
            currentPerformance = this.getSVMEstimation(current);
        }
        Vector bestDaughter = current;
        double bestPerformance = -1.0;
        this.doPrint(Print.OPERATOR, "Trying all sets of " + (current.size() - 1) + " features.");
        for (int i = 0; i < current.size(); ++i) {
            Vector daughter = this.removeIndexedFeature(current, i);
            double daughterPerformance = this.getSVMEstimation(daughter);
            if (!(daughterPerformance > bestPerformance)) continue;
            bestPerformance = daughterPerformance;
            bestDaughter = daughter;
        }
        if (bestPerformance >= currentPerformance) {
            return this.searchBackward(bestDaughter, bestPerformance);
        }
        return current;
    }

    private Vector searchForward(Vector current, Vector all, double currentPerformance) throws M4CompilerError {
        if (current.size() == all.size()) {
            return current;
        }
        if (currentPerformance == -1.0 && !current.isEmpty()) {
            currentPerformance = this.getSVMEstimation(current);
        }
        Vector bestDaughter = current;
        double bestPerformance = -1.0;
        this.doPrint(Print.OPERATOR, "FSwithSVM: forward search on level " + current.size() + "...");
        for (int i = 0; i < all.size(); ++i) {
            double daughterPerformance;
            Vector daughter = this.addIndexedFeature(current, all, i);
            if (daughter == null || !((daughterPerformance = this.getSVMEstimation(daughter)) > bestPerformance)) continue;
            bestPerformance = daughterPerformance;
            bestDaughter = daughter;
        }
        if (bestPerformance > currentPerformance) {
            this.doPrint(Print.OPERATOR, "FSwithSVM: best performance on this level was estimated: " + bestPerformance);
            return this.searchForward(bestDaughter, all, bestPerformance);
        }
        this.doPrint(Print.OPERATOR, "FSwithSVM: returned from this level with estimation: " + currentPerformance);
        return current;
    }

    private double getSVMEstimation(Vector theFeatures) throws M4CompilerError {
        try {
            Columnset theColumnSet = this.getInputConcept().getCurrentColumnSet();
            Vector<Column> theCols = new Vector<Column>();
            for (int i = 0; i < theFeatures.size(); ++i) {
                Feature f = (Feature)theFeatures.get(i);
                if (f instanceof BaseAttribute) {
                    BaseAttribute ba = (BaseAttribute)f;
                    theCols.add(ba.getCurrentColumn());
                    continue;
                }
                MultiColumnFeature mcf = (MultiColumnFeature)f;
                Collection theBAs = mcf.getBaseAttributes();
                Iterator it = theBAs.iterator();
                while (it.hasNext()) {
                    theCols.add(((BaseAttribute)it.next()).getCurrentColumn());
                }
            }
            theCols.trimToSize();
            Column theTargetAttributeColumn = this.getTheTargetAttribute().getCurrentColumn();
            this.mysvm.callSVM(theColumnSet, theTargetAttributeColumn, this.getInputConcept().getId(), this.getC().getValue(), this.getKernelType().getValue(), this.getEpsilon().getValue(), theCols);
            return this.mysvm.getXiAlphaEstimation();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    private Vector addIndexedFeature(Vector to, Vector from, int index) {
        Object o = from.get(index);
        if (to.contains(o)) {
            return null;
        }
        Vector v = new Vector();
        for (int i = 0; i < to.size(); ++i) {
            v.add(to.get(i));
        }
        v.add(o);
        v.trimToSize();
        return v;
    }

    private Vector removeIndexedFeature(Vector from, int index) {
        Vector v = new Vector();
        for (int i = 0; i < from.size(); ++i) {
            if (i == index) continue;
            v.add(from.get(i));
        }
        v.trimToSize();
        return v;
    }

    private Value getDirection() throws M4CompilerError {
        return (Value)this.getSingleParameter("SearchDirection");
    }

    private Value getPositiveTarget() throws M4CompilerError {
        return (Value)this.getSingleParameter("PositiveTargetValue");
    }

    private Value getSampleSize() throws M4CompilerError {
        return (Value)this.getSingleParameter("SampleSize");
    }

    private Value getC() throws M4CompilerError {
        return (Value)this.getSingleParameter("C");
    }

    private BaseAttribute getKey() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheKey");
    }

    private BaseAttribute getTheTargetAttribute() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheTargetAttribute");
    }

    private Value getEpsilon() throws M4CompilerError {
        return (Value)this.getSingleParameter("Epsilon");
    }

    private Value getKernelType() throws M4CompilerError {
        return (Value)this.getSingleParameter("KernelType");
    }

    private boolean mustUseDatabaseSVM() throws M4CompilerError {
        Value v = (Value)this.getSingleParameter("UseDB_SVM");
        boolean b = false;
        if (v != null) {
            b = v.getValue().equalsIgnoreCase("true");
        }
        return b;
    }
}

