/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FeatureConstructionWithTFIDF
extends SingleCSOperator {
    private String colNames;
    private String colNamesWithDefs;
    private final String NEW_COLDT_NAME = "NUMBER";
    private final short NEW_COL_DT = (short)12;

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        String inputConcept;
        String columnSetName;
        String key = "";
        String timeStamp = "";
        Feature inF2 = null;
        Feature[] features = this.getTheSelectedAttributes();
        String[] columnNames = new String[features.length];
        try {
            this.makeListsOfColumns();
            columnSetName = this.getNewCSName();
            inputConcept = this.getInputConcept().getCurrentColumnSet().getName();
            for (Feature inF2 : this.getInputConcept().getFeatures()) {
                if (inF2.correspondsTo(this.getTheKey())) {
                    key = ((BaseAttribute)inF2).getCurrentColumn().getName();
                }
                if (inF2.correspondsTo(this.getTheTimeStamp())) {
                    timeStamp = ((BaseAttribute)inF2).getCurrentColumn().getName();
                }
                for (int i = 0; i < features.length; ++i) {
                    BaseAttribute ba = (BaseAttribute)features[i];
                    if (!inF2.correspondsTo(ba)) continue;
                    columnNames[i] = ((BaseAttribute)inF2).getCurrentColumn().getName();
                }
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF.generateSQLDefinition(String):\n" + e.getMessage());
        }
        Hashtable indexes = new Hashtable();
        int total = 0;
        ResultSet ergebnis = null;
        try {
            String query = "SELECT " + this.colNames + " FROM " + inputConcept + " ORDER BY " + key + ", " + timeStamp;
            System.out.println(query);
            ergebnis = this.getM4Db().executeBusinessSqlRead(query);
            while (ergebnis.next()) {
                int i;
                String[] werte;
                int id = ergebnis.getInt(key);
                if (!indexes.containsKey(new Integer(id))) {
                    Vector<String[]> liste = new Vector<String[]>();
                    werte = new String[features.length];
                    for (i = 0; i < features.length; ++i) {
                        try {
                            werte[i] = ergebnis.getString(columnNames[i]);
                            continue;
                        }
                        catch (SQLException e) {
                            throw new M4CompilerError("FeatureConstructionWithTFIDF.generateSQLDefinition(String):\n" + e.getMessage());
                        }
                    }
                    liste.addElement(werte);
                    indexes.put(new Integer(id), liste);
                    continue;
                }
                Vector werteListe = (Vector)indexes.get(new Integer(id));
                werte = new String[features.length];
                for (i = 0; i < features.length; ++i) {
                    try {
                        werte[i] = ergebnis.getString(columnNames[i]);
                        continue;
                    }
                    catch (SQLException e) {
                        throw new M4CompilerError("FeatureConstructionWithTFIDF.generateSQLDefinition(String):\n" + e.getMessage());
                    }
                }
                werteListe.addElement(werte);
            }
            ergebnis.close();
        }
        catch (SQLException sqle) {
            try {
                throw new M4CompilerError("EvaluateAdvantageOFTFIDFTransformation: An error occurred: " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                DB.closeResultSet(ergebnis);
                throw throwable;
            }
        }
        DB.closeResultSet(ergebnis);
        Hashtable<Integer, int[]> tfidf = new Hashtable<Integer, int[]>();
        int[] df = new int[features.length];
        Enumeration e = indexes.keys();
        while (e.hasMoreElements()) {
            Integer index = (Integer)e.nextElement();
            Vector aktuell = (Vector)indexes.get(index);
            int[] frequencies = new int[features.length];
            tfidf.put(index, frequencies);
            if (aktuell.size() <= 1) continue;
            for (int i = 1; i < aktuell.size(); ++i) {
                String[] currentValues = (String[])aktuell.get(i);
                String[] previousValues = (String[])aktuell.get(i - 1);
                for (int j = 0; j < features.length; ++j) {
                    if (currentValues[j] != null) {
                        if (currentValues[j].equals(previousValues[j])) continue;
                        frequencies[j] = frequencies[j] + 1;
                        continue;
                    }
                    if (previousValues[j] == null) continue;
                    frequencies[j] = frequencies[j] + 1;
                }
            }
            for (int k = 0; k < features.length; ++k) {
                if (frequencies[k] <= 0) continue;
                int n = k;
                df[n] = df[n] + 1;
            }
        }
        try {
            this.createTable(columnSetName, this.colNamesWithDefs);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("FeatureConstructionByTFIDF: could not create table: " + sqle.getMessage());
        }
        try {
            total = this.getM4Db().executeBusinessSingleValueSqlReadL("SELECT COUNT(DISTINCT " + key + ") FROM " + inputConcept).intValue();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("FeatureConstructionByTFIDF: An errror occurred: " + sqle.getMessage());
        }
        Enumeration en = tfidf.keys();
        while (en.hasMoreElements()) {
            Integer aktuelleId = (Integer)en.nextElement();
            double[] tfidfValues = new double[features.length];
            int[] frequencyValues = (int[])tfidf.get(aktuelleId);
            String insertValues = "(" + aktuelleId + ", ";
            for (int i = 0; i < frequencyValues.length; ++i) {
                tfidfValues[i] = (double)frequencyValues[i] * Math.log(total / df[i]);
                insertValues = insertValues + tfidfValues[i] + ", ";
            }
            insertValues = insertValues.substring(0, insertValues.length() - 2);
            insertValues = insertValues + ")";
            String updateTable = "INSERT INTO " + columnSetName + " VALUES " + insertValues;
            try {
                this.getM4Db().executeBusinessSqlWrite(updateTable);
            }
            catch (SQLException sqle) {
                throw new M4CompilerError("FeatureConstructionByTFIDF: could not insert values: " + sqle.getMessage());
            }
        }
        try {
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("FeatureConstructionByTFIDF: could not commit to business: " + sqle.getMessage());
        }
        try {
            this.getM4Db().addTableToTrash(this.getNewCSName(), this.getInputConcept().getCurrentColumnSet().getSchema(), this.getStep().getId());
        }
        catch (M4Exception e2) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF.generateSQLDefinition(String):\n" + e2.getMessage());
        }
        try {
            this.getM4Db().commitM4Transactions();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF: could not commit to M4: " + m4e.getMessage());
        }
        return columnSetName;
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return false;
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        edu.udo.cs.miningmart.m4.Column keyColumn = null;
        Feature inF2 = null;
        BaseAttribute outB = null;
        String columnExpr = "";
        try {
            for (Feature inF2 : this.getInputConcept().getFeatures()) {
                if (inF2.correspondsTo(this.getTheKey())) {
                    keyColumn = ((BaseAttribute)inF2).getCurrentColumn().copyColToCS(csForOutputConcept);
                    columnExpr = columnExpr + keyColumn.getSQLDefinition() + ", ";
                }
                Feature[] selectedFeatures = this.getTheSelectedAttributes();
                for (int i = 0; i < selectedFeatures.length; ++i) {
                    BaseAttribute ba = (BaseAttribute)selectedFeatures[i];
                    if (!inF2.correspondsTo(ba)) continue;
                    int iIn = 0;
                    do {
                        outB = (BaseAttribute)this.getOutputConcept().getFeature(iIn);
                    } while (++iIn < this.getOutputConcept().getNumberOfFeatures() && !inF2.correspondsTo(outB));
                    edu.udo.cs.miningmart.m4.Column col = this.createM4Column(outB, csForOutputConcept, ((BaseAttribute)inF2).getCurrentColumn().getName() + "_tfidf");
                    columnExpr = columnExpr + col.getName() + ", ";
                }
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF.generateColumns(Columnset):\n" + e.getMessage());
        }
        if (columnExpr.equals("")) {
            throw new M4CompilerError("ConceptOperator (" + this.getName() + "): No columns for output concept created!");
        }
        columnExpr = columnExpr.substring(0, columnExpr.length() - 2);
        return columnExpr;
    }

    protected edu.udo.cs.miningmart.m4.Column createM4Column(BaseAttribute outputBA, Columnset newCS, String newColumnName) throws M4CompilerError, M4Exception {
        Column newColumn = new Column(this.getM4Db());
        newColumn.setId(0L);
        newColumn.setName(newColumnName);
        newColumn.setColumnset(newCS);
        newColumn.setBaseAttribute(outputBA);
        newColumn.setColumnDataType(12L);
        newColumn.setColumnDataTypeName("NUMBER");
        newColumn.setSQLDefinition(newColumnName);
        outputBA.addColumn(newColumn);
        newCS.addColumn(newColumn);
        return newColumn;
    }

    private void makeListsOfColumns() throws M4CompilerError {
        this.colNames = "";
        this.colNamesWithDefs = "";
        Feature inF2 = null;
        try {
            for (Feature inF2 : this.getInputConcept().getFeatures()) {
                if (inF2.correspondsTo(this.getTheKey())) {
                    this.colNames = this.colNames + ((BaseAttribute)inF2).getCurrentColumn().getSQLDefinition() + ", ";
                    this.colNamesWithDefs = this.colNamesWithDefs + ((BaseAttribute)inF2).getCurrentColumn().getSQLDefinition() + " " + ((BaseAttribute)inF2).getCurrentColumn().getColumnDataTypeName() + ", ";
                }
                Feature[] selectedFeatures = this.getTheSelectedAttributes();
                for (int i = 0; i < selectedFeatures.length; ++i) {
                    BaseAttribute ba = (BaseAttribute)selectedFeatures[i];
                    if (!inF2.correspondsTo(ba)) continue;
                    this.colNames = this.colNames + ((BaseAttribute)inF2).getCurrentColumn().getName() + ", ";
                    this.colNamesWithDefs = this.colNamesWithDefs + ((BaseAttribute)inF2).getCurrentColumn().getName() + "_tfidf " + this.NEW_COLDT_NAME + ", ";
                }
            }
        }
        catch (M4Exception e) {
            throw new M4CompilerError("FeatureConstructionWithTFIDF.generateColumns(Columnset):\n" + e.getMessage());
        }
        this.colNames = this.colNames.substring(0, this.colNames.length() - 2);
        this.colNamesWithDefs = this.colNamesWithDefs.substring(0, this.colNamesWithDefs.length() - 2);
    }

    private void createTable(String tableName, String columnDefs) throws SQLException, M4CompilerError {
        try {
            this.getM4Db().dropBusinessTable(tableName);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
        String cmd = "CREATE TABLE " + tableName + " (" + columnDefs + ")";
        this.getM4Db().executeBusinessSqlWrite(cmd);
    }

    protected Feature[] getTheSelectedAttributes() throws M4CompilerError {
        return (Feature[])this.getParameter("TheSelectedAttributes");
    }

    public BaseAttribute getTheTimeStamp() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheTimeStamp");
    }

    public BaseAttribute getTheKey() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheKey");
    }
}

