/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.ForeignKey;
import edu.udo.cs.miningmart.m4.ForeignKeyLink;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class FeatureConstructionByRelation
extends SingleCSOperator {
    public static final String PARAMETER_AGGREGATION = "AggregationOperator";
    public static final String PARAMETER_RELATION = "TheRelation";
    public static final String PARAMETER_FROMCONCEPT = "TheFromConcept";
    public static final String PARAMETER_TARGET_ATTR = "TheTargetAttribute";
    public static final String PARAMETER_OUTPUT_ATTR = "TheOutputAttribute";
    public static final String AGGREGATION_VALUEOF = "VALUE_OF";
    private boolean isManyToMany;
    private Relation myRelation;
    private Vector myToKeys;
    private String tempViewName = null;

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        String ret = "(select " + selectPart + " from " + this.getFromPart() + " where " + this.getJoinCondition() + ")";
        return ret;
    }

    protected String handleExtraOutputFeature(Feature outF, Columnset csForOutputConcept) throws M4CompilerError {
        try {
            int endLoop;
            if (this.tempViewName == null) {
                this.tempViewName = this.createIntermediateView();
            }
            if ((endLoop = this.getStep().getLoopCount()) == 0) {
                endLoop = 1;
            }
            String sql = null;
            for (int loopnr = 0; loopnr < endLoop; ++loopnr) {
                BaseAttribute outBA = (BaseAttribute)this.getSingleParameter(PARAMETER_OUTPUT_ATTR, loopnr);
                if (!(outF instanceof BaseAttribute) || !((BaseAttribute)outF).equals(outBA)) continue;
                sql = "TMPCOL_" + loopnr;
                Column newCol = (Column)((Object)this.getM4Db().createNewInstance(Column.class));
                newCol.setName(outBA.getName());
                newCol.setSQLDefinition(sql);
                newCol.setBaseAttribute(outBA);
                newCol.setColumnDataTypeName("NUMBER");
                newCol.setColumnset(csForOutputConcept);
            }
            if (sql == null) {
                return "";
            }
            return sql + ", ";
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error accessing target or output attribute: " + m4e.getMessage());
        }
    }

    private String createIntermediateView() throws M4CompilerError {
        String viewName = "CS_" + this.getStep().getId() + "_TMP";
        String sql = "CREATE OR REPLACE VIEW " + viewName + " AS (";
        sql = sql + "SELECT " + this.getPrimKeysOfToConcept() + ", ";
        int endLoop = this.getStep().getLoopCount();
        if (endLoop == 0) {
            endLoop = 1;
        }
        for (int loopnr = 0; loopnr < endLoop; ++loopnr) {
            String op = ((Value)this.getSingleParameter(PARAMETER_AGGREGATION, loopnr)).getValue();
            if (op.equalsIgnoreCase(AGGREGATION_VALUEOF)) {
                op = "MIN";
            }
            sql = sql + op + "(CASE WHEN " + this.getTargetCol(loopnr) + " = " + this.getMostCommonValueOfTargetAttribute(loopnr) + " THEN " + this.getTargetCol(loopnr) + " ELSE NULL END) AS TMPCOL_" + loopnr + ", ";
        }
        sql = sql.substring(0, sql.length() - 2);
        sql = sql + " FROM " + this.getListOfColumnSets() + " WHERE " + this.getCondition() + ")";
        try {
            this.getM4Db().executeBusinessSqlWrite(sql);
            this.getM4Db().addViewToTrash(viewName, this.getM4Db().getBusinessSchemaName(), this.getStep().getId());
            return viewName;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Step '" + this.getStep().getName() + "': SQL error creating an internal temporary view:" + sqle.getMessage());
        }
    }

    private String getJoinCondition() throws M4CompilerError {
        try {
            Concept to = this.getMyRelation().getTheToConcept();
            String toCsName = to.getCurrentColumnSet().getSchemaPlusName();
            String joinCondition = "";
            for (String columnName : this.myToKeys) {
                joinCondition = joinCondition + toCsName + "." + columnName + " = " + this.tempViewName + "." + columnName + " AND ";
            }
            joinCondition = joinCondition.substring(0, joinCondition.length() - 5);
            return joinCondition;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error trying to join columnsets: " + m4e.getMessage());
        }
    }

    private String getFromPart() throws M4CompilerError {
        try {
            String list = "";
            Concept from = this.getMyRelation().getTheToConcept();
            list = list + from.getCurrentColumnSet().getSchemaPlusName() + ", ";
            list = list + this.tempViewName;
            return list;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error trying to join columnsets: " + m4e.getMessage());
        }
    }

    protected Relation getMyRelation() throws M4CompilerError {
        if (this.myRelation == null) {
            this.myRelation = (Relation)this.getSingleParameter(PARAMETER_RELATION);
            if (this.myRelation == null) {
                throw new M4CompilerError("Operator 'FeatureConstructionByRelation', Step '" + this.getStep().getName() + "': no input relation found!");
            }
            this.isManyToMany = this.myRelation.isManyToManyRelation();
        }
        return this.myRelation;
    }

    protected String getCondition() throws M4CompilerError {
        String condition = "";
        try {
            ForeignKey fromFk = this.getMyRelation().getFromKey();
            if (fromFk == null) {
                throw new M4CompilerError("Step '" + this.getStep().getName() + "': the relation given by parameter 'TheRelation' has no keys; please compile the step that creates it first!");
            }
            condition = condition + this.getWhereLink(fromFk);
            if (this.isManyToMany) {
                condition = condition + " AND ";
                ForeignKey toFk = this.getMyRelation().getToKey();
                condition = condition + this.getWhereLink(toFk);
            }
            condition = condition + " GROUP BY " + this.getPrimKeysOfToConcept();
            return condition;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error accessing the relation keys: " + m4e.getMessage());
        }
    }

    private String getPrimKeysOfToConcept() throws M4CompilerError {
        try {
            ForeignKey link;
            String ret = "";
            ForeignKey foreignKey = link = this.isManyToMany ? this.getMyRelation().getToKey() : this.getMyRelation().getFromKey();
            if (link == null) {
                throw new M4CompilerError("Step '" + this.getStep().getName() + "': the relation given by parameter 'TheRelation' has no keys; please compile the step that creates it first!");
            }
            Iterator linkIt = link.getAllColumnLinks().iterator();
            this.myToKeys = new Vector();
            while (linkIt.hasNext()) {
                ForeignKeyLink columnPair = (ForeignKeyLink)linkIt.next();
                Column toColumn = columnPair.getPrimaryKeyColumn();
                ret = ret + toColumn.getSQLPlusLocation() + ", ";
                this.myToKeys.add(toColumn.getSQLDefinition());
            }
            ret = ret.substring(0, ret.length() - 2);
            return ret;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error accessing keys of ToConcept of given relation: " + m4e.getMessage());
        }
    }

    protected String getListOfColumnSets() throws M4CompilerError {
        try {
            String listOfColumnSets = "";
            Concept from = this.getMyRelation().getTheFromConcept();
            listOfColumnSets = listOfColumnSets + from.getCurrentColumnSet().getSchemaPlusName() + ", ";
            if (this.isManyToMany) {
                listOfColumnSets = listOfColumnSets + this.getMyRelation().getCrossLinkColumnSet().getSchemaPlusName() + ", ";
            }
            Concept to = this.getMyRelation().getTheToConcept();
            listOfColumnSets = listOfColumnSets + to.getCurrentColumnSet().getSchemaPlusName();
            return listOfColumnSets;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error accessing the relation: " + m4e.getMessage());
        }
    }

    public String getTypeOfNewColumnSet() {
        return "V";
    }

    protected boolean mustCopyFeature(String nameOfFeature) {
        return true;
    }

    public Concept getInputConcept() throws M4CompilerError {
        try {
            return this.getMyRelation().getTheToConcept();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error accessing the relation's ToConcept: " + m4e.getMessage());
        }
    }

    private String getMostCommonValueOfTargetAttribute(int loopnr) throws M4CompilerError {
        try {
            Concept from = this.getMyRelation().getTheFromConcept();
            String targetCol = this.getTargetCol(loopnr);
            String toCS = null;
            ForeignKey fk = this.getMyRelation().getFromKey();
            toCS = this.isManyToMany ? this.getMyRelation().getCrossLinkColumnSet().getSchemaPlusName() : this.getMyRelation().getTheToConcept().getCurrentColumnSet().getSchemaPlusName();
            String selectCounts = "SELECT " + targetCol + ", COUNT(" + targetCol + ") FROM " + toCS + ", " + from.getCurrentColumnSet().getSchemaPlusName() + " WHERE " + this.getWhereLink(fk) + " GROUP BY " + targetCol;
            String mostFrequentValue = null;
            int highestFrequency = -1;
            ResultSet rs = this.executeBusinessSqlRead(selectCounts);
            while (rs.next()) {
                int freq = rs.getInt(2);
                if (freq <= highestFrequency) continue;
                highestFrequency = freq;
                mostFrequentValue = rs.getString(1);
            }
            if (mostFrequentValue == null) {
                throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': could not determine a frequent value of target attribute!");
            }
            BaseAttribute target = (BaseAttribute)this.getSingleParameter(PARAMETER_TARGET_ATTR, loopnr);
            if (target.getConceptualDataTypeName().equals("NOMINAL")) {
                mostFrequentValue = DB.quote(mostFrequentValue);
            }
            return mostFrequentValue;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error trying to determine most frequent value of target attribute: " + m4e.getMessage());
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': SQL error trying to determine most frequent value of target attribute: " + sqle.getMessage());
        }
    }

    private String getTargetCol(int loopnr) throws M4CompilerError {
        try {
            BaseAttribute target = (BaseAttribute)this.getSingleParameter(PARAMETER_TARGET_ATTR, loopnr);
            String targetCol = target.getCurrentColumn().getSQLPlusLocation();
            return targetCol;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error trying to access target attribute: " + m4e.getMessage());
        }
    }

    private String getWhereLink(ForeignKey fk) throws M4CompilerError {
        String where = "";
        try {
            Collection colLinks = fk.getAllColumnLinks();
            if (colLinks == null) {
                throw new M4CompilerError("Step '" + this.getStep().getName() + "': the relation given by parameter 'TheRelation' has no keys; please compile the step that creates it first!");
            }
            for (ForeignKeyLink myColKey : fk.getAllColumnLinks()) {
                where = where + myColKey.getForeignKeyColumn().getSQLPlusLocation() + " = ";
                where = where + myColKey.getPrimaryKeyColumn().getSQLPlusLocation() + " AND ";
            }
            where = where.substring(0, where.length() - 5);
            return where;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'FeatureConstructionByRelation, Step '" + this.getStep().getName() + "': M4 error trying to access foreign key '" + fk.getName() + "'!");
        }
    }
}

