/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterDeselectedError;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.sql.SQLException;
import java.util.Collection;

public abstract class FeatureConstruction
extends ExecutableOperator {
    private edu.udo.cs.miningmart.m4.Column[] theOutputColumns;
    private String[] generatedSQLDefinitions;
    private int currentLoopNr = 0;
    private boolean targetAttribDeselected = false;

    public void load(Step st) throws M4CompilerError {
        try {
            super.load(st);
        }
        catch (ParameterDeselectedError e) {
            Collection violated = e.getViolatedOpParams();
            for (OpParam op : violated) {
                if (this.handleParameterDeselected(op)) continue;
                throw new M4CompilerError("FeatureConstruction: Parameter " + op.getName() + " is missing / deselected, but is obligatory!");
            }
        }
        this.currentLoopNr = 0;
        this.theOutputColumns = new edu.udo.cs.miningmart.m4.Column[this.getNumberOfLoops()];
        this.generatedSQLDefinitions = new String[this.getNumberOfLoops()];
    }

    private boolean handleParameterDeselected(OpParam op) {
        this.targetAttribDeselected = op.getName().equals("TheTargetAttribute");
        return this.targetAttribDeselected;
    }

    public void execute(boolean lazy) throws UserError, M4CompilerWarning, M4CompilerError, M4Exception, SQLException {
        if (this.targetAttribDeselected) {
            this.print();
        } else {
            super.execute(lazy);
        }
    }

    public void createStatement(boolean lazy) throws SQLException, M4CompilerWarning, M4CompilerError {
        this.currentLoopNr = 0;
        while (this.currentLoopNr < this.getNumberOfLoops()) {
            this.theOutputColumns[this.currentLoopNr] = this.generateColumnForOp();
            this.generatedSQLDefinitions[this.currentLoopNr] = this.theOutputColumns[this.currentLoopNr].getSQLDefinition();
            ++this.currentLoopNr;
        }
    }

    public void compileStatement() throws SQLException, M4CompilerWarning, M4CompilerError {
        for (int i = 0; i < this.getNumberOfLoops(); ++i) {
            long oldDataType = this.theOutputColumns[i].getColumnDataType();
            long newDataType = this.getM4Db().testSQLColumn(this.theOutputColumns[i]);
            if (newDataType != oldDataType) {
                this.doPrint(Print.OPERATOR, "Warning: FeatureConstruction: OutputAttribute Column is of different datatype than TargetAttribute Column.");
                try {
                    this.theOutputColumns[i].setColumnDataTypeName(this.getNameForColumnDataType(newDataType));
                }
                catch (M4Exception e) {
                    throw new M4CompilerError("Error setting column datatype by name (type was: " + newDataType + ")!\n" + e.getMessage());
                }
            }
            this.theOutputColumns[i].setColumnDataType(newDataType);
        }
    }

    public void writeResults() {
    }

    public edu.udo.cs.miningmart.m4.Column generateColumnForOp() throws M4CompilerError, M4CompilerWarning {
        try {
            edu.udo.cs.miningmart.m4.Column theTargetAttributeColumn = this.getTheTargetAttribute().getCurrentColumn();
            if (theTargetAttributeColumn == null) {
                throw new M4CompilerError("Operator '" + this.getName() + "': no column was found for the target attribute! Compilation stopped.");
            }
            BaseAttribute theBA = this.getTheOutputAttribute();
            if (theBA == null) {
                throw new M4CompilerError("Operator '" + this.getName() + "': no output attribute was found! Compilation stopped.");
            }
            String newColSqlDef = this.generateSQL(theTargetAttributeColumn);
            edu.udo.cs.miningmart.m4.Column newCol = (edu.udo.cs.miningmart.m4.Column)((Object)this.getM4Db().createNewInstance(Column.class));
            newCol.setId(0L);
            newCol.setBaseAttribute(theBA);
            newCol.setName(this.getTheOutputAttribute().getName());
            newCol.setColumnset(theTargetAttributeColumn.getColumnset());
            newCol.setColumnDataType(theTargetAttributeColumn.getColumnDataType());
            newCol.setColumnDataTypeName(theTargetAttributeColumn.getColumnDataTypeName());
            newCol.setSQLDefinition(newColSqlDef);
            this.getStep().addToTrash(newCol);
            return newCol;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    public abstract String generateSQL(edu.udo.cs.miningmart.m4.Column var1) throws M4CompilerError, M4CompilerWarning;

    public int getCurrentLoopNumber() {
        return this.currentLoopNr;
    }

    public Concept getTheInputConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheInputConcept");
    }

    public BaseAttribute getTheOutputAttribute() throws M4CompilerError {
        return this.getTheOutputAttribute(this.getCurrentLoopNumber());
    }

    public BaseAttribute getTheTargetAttribute() throws M4CompilerError {
        BaseAttribute target = this.getTheTargetAttribute(this.getCurrentLoopNumber());
        if (target == null) {
            throw new M4CompilerError("Operator '" + this.getName() + "': cannot find target attribute, compilation stopped!");
        }
        return target;
    }

    public BaseAttribute getTheOutputAttribute(int loopNr) throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheOutputAttribute", loopNr);
    }

    public BaseAttribute getTheTargetAttribute(int loopNr) throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheTargetAttribute", loopNr);
    }

    private String getNameForColumnDataType(long type) throws M4CompilerError {
        if (type == 12L) {
            return "NUMBER";
        }
        if (type == 13L) {
            return "STRING";
        }
        if (type == 14L) {
            return "DATE";
        }
        if (type == 15L) {
            return "KEY";
        }
        throw new M4CompilerError("FeatureConstruction: Found unknown column data type number: " + type);
    }
}

