/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.TimeOperator;
import edu.udo.cs.miningmart.storedProcedures.EMF;
import edu.udo.cs.miningmart.storedProcedures.TimeOperatorException;
import java.sql.SQLException;

public class ExponentialMovingFunction
extends TimeOperator {
    private static final String INPUTTIMEBA = "InputTimeBA";
    private static final String INPUTVALUEBA = "InputValueBA";
    private static final String OUTPUTTIMEBA = "OutputTimeBA";
    private static final String OUTPUTVALUEBA = "OutputValueBA";
    private static final String HEADWEIGHT = "HeadWeight";
    private static final String TAILWEIGHT = "TailWeight";
    private static final String DISTANCE = "Distance";
    private static final String procedureName = "EMA";
    private static final String columnSetSuffix = "_CS";

    protected String getColumnSetSuffix() {
        return columnSetSuffix;
    }

    public BaseAttribute getTimeBaIn() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INPUTTIMEBA);
    }

    public BaseAttribute getValueBaIn() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(INPUTVALUEBA);
    }

    public BaseAttribute getTimeBaOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTTIMEBA);
    }

    public BaseAttribute getValueBaOut() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(OUTPUTVALUEBA);
    }

    public Value getHeadWeight() throws M4CompilerError {
        return (Value)this.getSingleParameter(HEADWEIGHT);
    }

    public Value getTailWeight() throws M4CompilerError {
        return (Value)this.getSingleParameter(TAILWEIGHT);
    }

    public Value getDistance() throws M4CompilerError {
        return (Value)this.getSingleParameter(DISTANCE);
    }

    protected void createJavaColumns(Columnset newCS) throws SQLException, M4CompilerError {
        try {
            Column timeColumnForType = this.getTimeBaIn().getColumn(0);
            this.createM4Column(this.getTimeBaOut(), newCS, timeColumnForType);
            Column valueColumnForType = this.getValueBaIn().getColumn(0);
            this.createM4Column(this.getValueBaOut(), newCS, valueColumnForType);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
        }
    }

    protected void runStoredProcedure(String newColumnsetName) throws SQLException, M4CompilerError, TimeOperatorException {
        this.valueIsDouble(this.getHeadWeight(), HEADWEIGHT);
        this.valueIsDouble(this.getTailWeight(), TAILWEIGHT);
        this.valueIsLong(this.getDistance(), DISTANCE);
        this.baseattribHasColumns(this.getTimeBaIn(), INPUTTIMEBA);
        this.baseattribHasColumns(this.getValueBaIn(), INPUTVALUEBA);
        String[] parameters = new String[]{ExponentialMovingFunction.getQuotedColSetNameforCon(this.getInputConcept()), ExponentialMovingFunction.getQuotedColNameforInpBA(this.getTimeBaIn()), ExponentialMovingFunction.getQuotedColNameforInpBA(this.getValueBaIn()), DB.quote(newColumnsetName), ExponentialMovingFunction.getQuotedColNameforOutBA(this.getTimeBaOut()), ExponentialMovingFunction.getQuotedColNameforOutBA(this.getValueBaOut()), this.getHeadWeight().getValue().trim(), this.getTailWeight().getValue().trim(), this.getDistance().getValue().trim()};
        if (this.storedProceduresAvailable()) {
            this.executeDbProcedure(procedureName, parameters);
        } else {
            EMF.dbEMA(this.getM4Db(), ExponentialMovingFunction.unquote(parameters[0]), ExponentialMovingFunction.unquote(parameters[1]), ExponentialMovingFunction.unquote(parameters[2]), ExponentialMovingFunction.unquote(parameters[3]), ExponentialMovingFunction.unquote(parameters[4]), ExponentialMovingFunction.unquote(parameters[5]), Double.parseDouble(parameters[6]), Double.parseDouble(parameters[7]), Integer.parseInt(parameters[8]));
        }
    }
}

