/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EvaluateAdvantageOfTFIDFTransformation
extends ExecutableOperator {
    public void createStatement(boolean lazy) throws SQLException, M4CompilerError {
        ResultSet ergebnis;
        block20: {
            Feature[] features;
            String colNames;
            String timeStamp;
            String key;
            String inputConcept;
            try {
                inputConcept = this.getInputConcept().getCurrentColumnSet().getSQLDefinition();
                key = this.getTheKey().getCurrentColumn().getName();
                timeStamp = this.getTheTimeStamp().getCurrentColumn().getName();
                colNames = this.getTheKey().getCurrentColumn().getSQLDefinition() + ", ";
                features = this.getTheSelectedAttributes();
                for (int i = 0; i < features.length; ++i) {
                    BaseAttribute ba = (BaseAttribute)features[i];
                    Column col = ba.getCurrentColumn();
                    colNames = colNames + col.getName() + ", ";
                }
            }
            catch (M4Exception e) {
                throw new M4CompilerError("M4Exception during EvaluateAdvantageOfTFIDFTransformation.createStatement:\n" + e.getMessage());
            }
            colNames = colNames.substring(0, colNames.length() - 2);
            Hashtable indexes = new Hashtable();
            ergebnis = null;
            try {
                String query = "SELECT " + colNames + " FROM " + inputConcept + " ORDER BY " + key + ", " + timeStamp;
                ergebnis = this.getM4Db().executeBusinessSqlRead(query);
                double maximum_euklidian_length = 0.0;
                double maximum_frequency = 0.0;
                double euklidian_length = 0.0;
                while (ergebnis.next()) {
                    String colName;
                    int i;
                    String[] werte;
                    int id = ergebnis.getInt(key);
                    if (!indexes.containsKey(new Integer(id))) {
                        Vector<String[]> liste = new Vector<String[]>();
                        werte = new String[features.length];
                        for (i = 0; i < features.length; ++i) {
                            try {
                                colName = ((BaseAttribute)features[i]).getCurrentColumn().getName();
                                werte[i] = ergebnis.getString(colName);
                                continue;
                            }
                            catch (M4Exception e) {
                                throw new M4CompilerError("M4Exception during EvaluateAdvantageOfTFIDFTransformation.createStatement:\n" + e.getMessage());
                            }
                        }
                        liste.add(werte);
                        indexes.put(new Integer(id), liste);
                        continue;
                    }
                    Vector werteListe = (Vector)indexes.get(new Integer(id));
                    werte = new String[features.length];
                    for (i = 0; i < features.length; ++i) {
                        try {
                            colName = ((BaseAttribute)features[i]).getCurrentColumn().getName();
                            werte[i] = ergebnis.getString(colName);
                            continue;
                        }
                        catch (M4Exception e) {
                            throw new M4CompilerError("M4Exception during EvaluateAdvantageOfTFIDFTransformation.createStatement:\n" + e.getMessage());
                        }
                    }
                    werteListe.add(werte);
                }
                ergebnis.close();
                Enumeration e = indexes.keys();
                while (e.hasMoreElements()) {
                    Integer index = (Integer)e.nextElement();
                    Vector aktuell = (Vector)indexes.get(index);
                    int[] frequencies = new int[features.length];
                    if (aktuell.size() <= 1) continue;
                    for (int i = 1; i < aktuell.size(); ++i) {
                        String[] currentValues = (String[])aktuell.get(i);
                        String[] previousValues = (String[])aktuell.get(i - 1);
                        for (int j = 0; j < features.length; ++j) {
                            if (currentValues[j].equals(previousValues[j])) continue;
                            int n = j;
                            frequencies[n] = frequencies[n] + 1;
                        }
                    }
                    double sum = 0.0;
                    for (int i = 0; i < features.length; ++i) {
                        sum += Math.pow(frequencies[i], 2.0);
                        if (!((double)frequencies[i] > maximum_frequency)) continue;
                        maximum_frequency = frequencies[i];
                    }
                    euklidian_length = Math.sqrt(sum);
                    if (!(euklidian_length > maximum_euklidian_length)) continue;
                    maximum_euklidian_length = euklidian_length;
                }
                int n = features.length;
                double nm = Math.sqrt(new Integer(n).doubleValue()) * maximum_frequency;
                if (maximum_euklidian_length < nm) {
                    this.doPrint(Print.MAX, "The maximum Euklidian length is: " + maximum_euklidian_length + "\n" + "The maximum frequency is: " + maximum_frequency + "\n" + "As " + maximum_euklidian_length + " is < sqrt(" + n + ") * " + maximum_frequency + " the transformation into TF/IDF features is worth a try!");
                    System.out.println("The maximum Euklidian length is: " + maximum_euklidian_length + "\n" + "The maximum frequency is: " + maximum_frequency + "\n" + "As " + maximum_euklidian_length + " is < sqrt(" + n + ") * " + maximum_frequency + " the transformation into TF/IDF features is worth a try!");
                    break block20;
                }
                this.doPrint(Print.MAX, "The maximum Euklidian length is: " + maximum_euklidian_length + "\n" + "The maximum frequency is: " + maximum_frequency + "\n" + "As " + maximum_euklidian_length + " is > sqrt(" + n + ") * " + maximum_frequency + " the transformation into TF/IDF features has little chances of success!");
                System.out.println("The maximum Euklidian length is: " + maximum_euklidian_length + "\n" + "The maximum frequency is: " + maximum_frequency + "\n" + "As " + maximum_euklidian_length + " is > sqrt(" + n + ") * " + maximum_frequency + " the transformation into TF/IDF features has little chances of success!");
            }
            catch (SQLException sqle) {
                try {
                    throw new M4CompilerError("EvaluateAdvantageOFTFIDFTransformation: an error occurred: " + sqle.getMessage());
                }
                catch (Throwable throwable) {
                    DB.closeResultSet(ergebnis);
                    throw throwable;
                }
            }
        }
        DB.closeResultSet(ergebnis);
    }

    public void compileStatement() throws SQLException, M4CompilerError {
    }

    public void writeResults() throws SQLException, M4CompilerError {
    }

    public Concept getInputConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheInputConcept");
    }

    public BaseAttribute getTheTimeStamp() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheTimeStamp");
    }

    public BaseAttribute getTheKey() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("TheKey");
    }

    protected Feature[] getTheSelectedAttributes() throws M4CompilerError {
        return (Feature[])this.getParameter("TheSelectedAttributes");
    }
}

