/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.FeatureConstruction;

public class DateToNumeric
extends FeatureConstruction {
    private static String[][] dateFormatsMapping = new String[][]{{"Year_YYYY", "YYYY", "year"}, {"Year_YY", "YY", "year"}, {"Month_of_Year", "MM", "month"}, {"Day_of_Month", "DD", "day"}, {"Hour_of_Day", "HH24", "hour"}, {"Minute_of_Hour", "MI", "minute"}, {"Second_of_Minute", "SS", "second"}};

    public String generateSQL(Column targetColumn) throws M4CompilerError {
        String format = this.getOutputFormat();
        String sql = targetColumn.getSQLDefinition();
        short myDbms = this.getM4Db().getBusinessDbms();
        String ret = this.getFormatMapping(format, myDbms);
        if (myDbms == 1) {
            ret = "TO_NUMBER(TO_CHAR(" + sql + ", '" + ret + "'))";
        }
        if (myDbms == 2 || myDbms == 3) {
            ret = "EXTRACT(" + ret + " FROM " + sql + ")";
        }
        return ret;
    }

    private String getFormatMapping(String format, short theDbms) throws M4CompilerError {
        if (format != null) {
            for (int i = 0; i < dateFormatsMapping.length; ++i) {
                if (!format.equalsIgnoreCase(dateFormatsMapping[i][0])) continue;
                if (theDbms == 1) {
                    return dateFormatsMapping[i][1];
                }
                if (theDbms == 2) {
                    return dateFormatsMapping[i][2];
                }
                if (theDbms != 3) continue;
                return dateFormatsMapping[i][2];
            }
        }
        throw new M4CompilerError("Operator 'DateToNumeric': Unsupported entry found in mandatory parameter 'OutputFormat': " + (format == null ? "<null>" : "'" + format + "'"));
    }

    private String getOutputFormat() throws M4CompilerError {
        Value value = (Value)this.getSingleParameter("OutputFormat", this.getCurrentLoopNumber());
        if (value == null) {
            return null;
        }
        return value.getValue();
    }
}

