/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.PrimaryKey;
import edu.udo.cs.miningmart.operator.SingleCSOperator;

public class CreatePrimaryKey
extends SingleCSOperator {
    public String getTypeOfNewColumnSet() {
        return "V";
    }

    protected String generateColumns(Columnset csForOutputConcept) throws M4CompilerError {
        String selectPart = super.generateColumns(csForOutputConcept);
        String columnName = this.getNewKeysColumnName();
        String sqlDef = this.getNewKeysSqlDefinition();
        try {
            edu.udo.cs.miningmart.m4.Column newKey = (edu.udo.cs.miningmart.m4.Column)((Object)this.getM4Db().createNewInstance(Column.class));
            newKey.setName(columnName);
            newKey.setColumnDataTypeName("KEY");
            newKey.setColumnset(csForOutputConcept);
            newKey.setSQLDefinition(columnName);
            this.getPrimaryKey().addColumn(newKey);
            edu.udo.cs.miningmart.m4.PrimaryKey pk = (edu.udo.cs.miningmart.m4.PrimaryKey)((Object)this.getM4Db().createNewInstance(PrimaryKey.class));
            pk.addColumn(newKey);
            pk.setColumnset(csForOutputConcept);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("CreatePrimaryKey.generateColumns: M4Exception when trying to create the PrimaryKey column!\n" + e.getMessage());
        }
        return selectPart + ", " + sqlDef + " AS " + columnName;
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        Concept concept = this.getInputConcept();
        try {
            Columnset cs;
            if (concept == null || (cs = concept.getCurrentColumnSet()) == null) {
                throw new M4CompilerError("Operator 'CreatePrimaryKey': Found no input Concept/Columnset!");
            }
            String sql = "(SELECT " + (this.getAllowDuplicates() ? "" : "DISTINCT ") + selectPart + " FROM " + cs.getSchemaPlusName() + ")";
            return sql;
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'CreatePrimaryKey': M4Exception caught during createStatement:\n" + e.getMessage());
        }
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return true;
    }

    private String getNewKeysColumnName() throws M4CompilerError {
        return this.getPrimaryKey().getName();
    }

    private String getNewKeysSqlDefinition() throws M4CompilerError {
        try {
            if (this.getBusinessDbms() == 3) {
                throw new M4CompilerError("Step '" + this.getStep().getName() + "': operator '" + this.getName() + "' has not yet been implemented for\n" + " MySQL! A possible solution is to create your own AttributeDerivation step instead of this step!");
            }
            if (!this.getInputConcept().getCurrentColumnSet().getType().equals("T") && this.getBusinessDbms() != 1) {
                throw new M4CompilerError("Step '" + this.getStep().getName() + "': operator '" + this.getName() + "' has not yet been implemented for\ninput VIEWS for" + " any other DBMS than Oracle! Please use a Materialisation step before this step!");
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 Exception caught in '" + this.getName() + "': " + m4e.getMessage());
        }
        boolean useDbmsOfBusinessDataSchema = true;
        String sqlDef = this.getM4Db().getUniqueRowIdentifier(useDbmsOfBusinessDataSchema);
        return sqlDef;
    }

    public boolean getAllowDuplicates() throws M4CompilerError {
        String s;
        Value value = (Value)this.getSingleParameter("AllowDuplicates");
        return value != null && (s = value.getValue()) != null && s.equalsIgnoreCase("true");
    }

    public BaseAttribute getPrimaryKey() throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter("PrimaryKey");
    }
}

