/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.ForeignKey;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.CreateManyToManyRelation;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;

public class CreateOneToManyRelation
extends ExecutableOperator {
    public void createStatement(boolean lazy) throws M4CompilerError {
        Step step = this.getStep();
        Relation rel = this.getRelation();
        try {
            Columnset fromCs = this.getFromConcept().getCurrentColumnSet();
            Columnset toCs = this.getToConcept().getCurrentColumnSet();
            Collection keysTarget = this.getM4Db().getPrimaryKeysFromDbSchema(toCs);
            if (keysTarget == null || keysTarget.isEmpty()) {
                Vector keysB = CreateManyToManyRelation.baKeyCollectionToStringCollection(this.getPrimaryKeyToConcept());
                String constraintName = this.getM4Db().getBusinessDbCore().createPrimaryKeyConstraint(toCs.getName(), keysB, null);
                this.getM4Db().addPkConstraintToTrash(toCs.getName(), constraintName, toCs.getSchema(), this.getStep().getId());
            }
            this.createForeignKey(fromCs, this.getForeignKeyFromConcept(), toCs, this.getPrimaryKeyToConcept(), "_FK");
            ForeignKey fk = (ForeignKey)((Object)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.ForeignKey.class));
            fk.setName("FK_" + step.getId());
            fk.setPrimaryKeyColumnset(toCs);
            fk.setForeignKeyColumnset(fromCs);
            CreateManyToManyRelation.fillForeignKey(fk, this.getForeignKeyFromConcept().iterator(), fromCs, this.getPrimaryKeyToConcept().iterator());
            step.addToTrash(fk);
            rel.setFromKey(fk);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'MaterializeRelation': M4Exception caught during createStatement:\n" + e.getMessage());
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'MaterializeRelation': SQLException caught during createStatement:\n" + e.getMessage());
        }
    }

    private void createForeignKey(Columnset fromCs, Collection fromFks, Columnset toCs, Collection toPks, String fkNameSuffix) throws M4Exception, M4CompilerError {
        Vector fromKeyAttribs = CreateManyToManyRelation.baKeyCollectionToStringCollection(fromFks);
        Vector toKeyAttribs = CreateManyToManyRelation.baKeyCollectionToStringCollection(toPks);
        try {
            String tableName = fromCs.getName();
            String constraintName = fromCs.getName() + fkNameSuffix;
            this.getM4Db().getBusinessDbCore().createForeignKeyConstraint(fromCs.getName(), fromKeyAttribs, toCs.getName(), toKeyAttribs, constraintName);
            this.getM4Db().addFkConstraintToTrash(tableName, constraintName, fromCs.getSchema(), this.getStep().getId());
        }
        catch (SQLException e) {
            this.doPrint(Print.WARNING, "Operator CreateOneToManyRealtion failed to create foreign key:\n" + e.getMessage());
        }
    }

    public void compileStatement() {
    }

    protected Concept getFromConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheFromConcept");
    }

    protected Concept getToConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheToConcept");
    }

    protected Relation getRelation() throws M4CompilerError {
        return (Relation)this.getSingleParameter("TheRelation");
    }

    protected Collection getPrimaryKeyToConcept() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("ToConceptKeys");
        return Arrays.asList(keys);
    }

    protected Collection getForeignKeyFromConcept() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("FromConceptKeys");
        return Arrays.asList(keys);
    }
}

