/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.ForeignKey;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class CreateManyToManyRelation
extends ExecutableOperator {
    public void createStatement(boolean lazy) throws M4CompilerError {
        Step step = this.getStep();
        Concept crossConcept = this.getCrossConcept();
        Relation rel = this.getRelation();
        try {
            Collection pksB;
            String nameCrossTable = this.getTableName();
            this.getM4Db().dropBusinessTable(nameCrossTable);
            edu.udo.cs.miningmart.m4.Columnset crossTableCs = this.materializeCrossTable(crossConcept, nameCrossTable);
            edu.udo.cs.miningmart.m4.Columnset targetCsA = this.getFromConcept().getCurrentColumnSet();
            edu.udo.cs.miningmart.m4.Columnset targetCsB = this.getToConcept().getCurrentColumnSet();
            Collection pksA = this.getM4Db().getPrimaryKeysFromDbSchema(targetCsA);
            if (pksA == null || pksA.isEmpty()) {
                Vector keysA = CreateManyToManyRelation.baKeyCollectionToStringCollection(this.getKeysConceptA());
                this.createTargetTablePrimaryKeys(targetCsA, keysA);
            }
            if ((pksB = this.getM4Db().getPrimaryKeysFromDbSchema(targetCsB)) == null || pksB.isEmpty()) {
                Vector keysB = CreateManyToManyRelation.baKeyCollectionToStringCollection(this.getKeysConceptB());
                this.createTargetTablePrimaryKeys(targetCsB, keysB);
            }
            this.createCrossTableForeignKeys(crossTableCs, this.getKeysOfCrossToConceptA(), targetCsA, this.getKeysConceptA(), "_FKA");
            this.createCrossTableForeignKeys(crossTableCs, this.getKeysOfCrossToConceptB(), targetCsB, this.getKeysConceptB(), "_FKB");
            ForeignKey fromFK = (ForeignKey)((Object)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.ForeignKey.class));
            fromFK.setName("FKFR_" + step.getId());
            fromFK.setPrimaryKeyColumnset(targetCsA);
            fromFK.setForeignKeyColumnset(crossTableCs);
            CreateManyToManyRelation.fillForeignKey(fromFK, this.getKeysOfCrossToConceptA().iterator(), crossTableCs, this.getKeysConceptA().iterator());
            ForeignKey toFK = (ForeignKey)((Object)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.ForeignKey.class));
            toFK.setName("FKTO_" + this.getStep().getId());
            toFK.setPrimaryKeyColumnset(targetCsB);
            toFK.setForeignKeyColumnset(crossTableCs);
            CreateManyToManyRelation.fillForeignKey(toFK, this.getKeysOfCrossToConceptB().iterator(), crossTableCs, this.getKeysConceptB().iterator());
            step.addToTrash(toFK);
            step.addToTrash(fromFK);
            rel.setCrossLinkColumnSet(crossTableCs);
            rel.setM2mKeys(fromFK, toFK);
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'MaterializeRelation': M4Exception caught during createStatement:\n" + e.getMessage());
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator 'MaterializeRelation': SQLException caught during createStatement:\n" + e.getMessage());
        }
    }

    private edu.udo.cs.miningmart.m4.Columnset materializeCrossTable(Concept crossConcept, String nameCrossTable) throws M4Exception, M4CompilerError, SQLException {
        edu.udo.cs.miningmart.m4.Columnset ccs = crossConcept.getCurrentColumnSet();
        Vector<Column> copyCols = new Vector<Column>();
        String sqlPrefix = "CREATE TABLE " + nameCrossTable + " AS ( SELECT ";
        String sqlSuffix = " FROM " + ccs.getSchemaPlusName() + " )";
        StringBuffer keySqlDefs = new StringBuffer();
        Vector crossTableBaKeys = new Vector(this.getKeysOfCrossToConceptA());
        crossTableBaKeys.addAll(this.getKeysConceptB());
        Iterator it = crossTableBaKeys.iterator();
        while (it.hasNext()) {
            BaseAttribute ba = (BaseAttribute)it.next();
            Column col = ba.getCurrentColumn();
            copyCols.add(col);
            String sqlDef = col.getSQLDefinition();
            if (sqlDef != null && sqlDef.trim().length() > 0 && !col.getName().equals(sqlDef)) {
                keySqlDefs.append(sqlDef + " ");
            }
            keySqlDefs.append(col.getName() + (it.hasNext() ? ", " : ""));
        }
        String sql = sqlPrefix + keySqlDefs.toString() + sqlSuffix;
        this.executeBusinessSqlWrite(sql);
        this.getM4Db().addTableToTrash(nameCrossTable, ccs.getSchema(), this.getStep().getId());
        edu.udo.cs.miningmart.m4.Columnset outputCs = (edu.udo.cs.miningmart.m4.Columnset)((Object)this.getM4Db().createNewInstance(Columnset.class));
        outputCs.setType("T");
        outputCs.setName(nameCrossTable);
        outputCs.setSchema(ccs.getSchema());
        Step step = this.getStep();
        step.addToTrash(outputCs);
        Iterator it2 = copyCols.iterator();
        while (it2.hasNext()) {
            ((Column)it2.next()).copyColToCS(outputCs);
        }
        for (Column col : outputCs.getColumns()) {
            col.setSQLDefinition(null);
            col.setBaseAttribute(null);
            step.addToTrash(col);
        }
        return outputCs;
    }

    private void createTargetTablePrimaryKeys(edu.udo.cs.miningmart.m4.Columnset cs, Collection pkAttributeNames) throws M4CompilerError, SQLException {
        String constraintName = this.getM4Db().getBusinessDbCore().createPrimaryKeyConstraint(cs.getName(), pkAttributeNames, null);
        this.getM4Db().addPkConstraintToTrash(cs.getName(), constraintName, cs.getSchema(), this.getStep().getId());
    }

    private void createCrossTableForeignKeys(edu.udo.cs.miningmart.m4.Columnset crossCs, Collection crossKeys, edu.udo.cs.miningmart.m4.Columnset targetCs, Collection conPk, String fkNameSuffix) throws M4Exception, M4CompilerError {
        Vector crossKeyAttribs = CreateManyToManyRelation.baKeyCollectionToStringCollection(crossKeys);
        Vector conKeyAttribs = CreateManyToManyRelation.baKeyCollectionToStringCollection(conPk);
        try {
            String tableName = crossCs.getName();
            String constraintName = crossCs.getName() + fkNameSuffix;
            this.getM4Db().getBusinessDbCore().createForeignKeyConstraint(crossCs.getName(), crossKeyAttribs, targetCs.getName(), conKeyAttribs, constraintName);
            this.getM4Db().addFkConstraintToTrash(tableName, constraintName, crossCs.getSchema(), this.getStep().getId());
        }
        catch (SQLException e) {
            throw new M4CompilerError("Operator CreateManyToManyRealtion failed to create cross table foreign key constraint.\n" + e.getMessage());
        }
    }

    static Vector baKeyCollectionToStringCollection(Collection baKeys) throws M4Exception {
        Iterator it = baKeys.iterator();
        Vector<String> nameCollection = new Vector<String>();
        while (it.hasNext()) {
            BaseAttribute keyBa = (BaseAttribute)it.next();
            Column keyCol = keyBa.getCurrentColumn();
            if (keyCol == null || keyCol.getName() == null || keyCol.getName().trim().length() <= 0) continue;
            nameCollection.add(keyCol.getName());
        }
        return nameCollection;
    }

    static void fillForeignKey(ForeignKey fk, Iterator fkKeysIt, edu.udo.cs.miningmart.m4.Columnset crossTableCs, Iterator pkKeysIt) throws M4Exception {
        while (fkKeysIt.hasNext() && pkKeysIt.hasNext()) {
            BaseAttribute fkKey = (BaseAttribute)fkKeysIt.next();
            BaseAttribute pkKey = (BaseAttribute)pkKeysIt.next();
            Column fkColumn = fkKey.getCurrentColumn();
            Column pkColumn = pkKey.getCurrentColumn();
            if (fkColumn == null || pkColumn == null) continue;
            Column crossTableColumn = crossTableCs.getColumn(fkColumn.getName());
            fk.addColumnLink(crossTableColumn, pkColumn);
        }
    }

    public void compileStatement() {
    }

    public Concept getFromConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheFromConcept");
    }

    public Concept getToConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheToConcept");
    }

    public Concept getCrossConcept() throws M4CompilerError {
        return (Concept)this.getSingleParameter("TheCrossTable");
    }

    protected Relation getRelation() throws M4CompilerError {
        return (Relation)this.getSingleParameter("TheRelation");
    }

    public String getTableName() throws M4CompilerError, M4Exception {
        Value value = (Value)this.getSingleParameter("NameForCrossTable");
        if (value != null && value.getValue().trim().length() > 0) {
            return value.getValue().trim();
        }
        edu.udo.cs.miningmart.m4.Columnset cs = this.getCrossConcept().getCurrentColumnSet();
        return (cs == null ? this.getCrossConcept().getName() : cs.getName()) + "_CT";
    }

    public Collection getKeysConceptA() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("FromConceptKeys");
        return Arrays.asList(keys);
    }

    public Collection getKeysConceptB() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("ToConceptKeys");
        return Arrays.asList(keys);
    }

    public Collection getKeysOfCrossToConceptA() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("CrossToFromConceptKeys");
        return Arrays.asList(keys);
    }

    public Collection getKeysOfCrossToConceptB() throws M4CompilerError {
        BaseAttribute[] keys = (BaseAttribute[])this.getParameter("CrossToToConceptKeys");
        return Arrays.asList(keys);
    }
}

