/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.operator.EvaluateResults;
import java.sql.SQLException;

public class ComputeSVMError
extends EvaluateResults {
    public double computeResult(double[] actualvalue, double[] predictedvalue) throws M4CompilerError {
        double lossFunctionNegl;
        double lossFunctionPosl;
        boolean regression;
        Value lossP = this.getLossFunctionPos();
        Value lossN = this.getLossFunctionNeg();
        boolean bl = regression = lossP != null && lossN != null;
        if (regression) {
            lossFunctionPosl = Double.parseDouble(lossP.getValue());
            lossFunctionNegl = Double.parseDouble(lossN.getValue());
        } else {
            lossFunctionNegl = 1.0;
            lossFunctionPosl = 1.0;
        }
        double epsilonl = Double.parseDouble(this.getEpsilon().getValue());
        if (regression) {
            double avgloss = 0.0;
            double loss = 0.0;
            for (int j = 0; j < actualvalue.length; ++j) {
                if (Math.abs(actualvalue[j] - predictedvalue[j]) <= epsilonl) {
                    loss = 0.0;
                } else if (predictedvalue[j] < actualvalue[j] - epsilonl) {
                    loss = lossFunctionNegl * (actualvalue[j] - predictedvalue[j] - epsilonl);
                } else if (predictedvalue[j] > actualvalue[j] + epsilonl) {
                    loss = lossFunctionPosl * (predictedvalue[j] - actualvalue[j] - epsilonl);
                }
                avgloss += loss;
            }
            return avgloss /= (double)actualvalue.length;
        }
        int acc = 0;
        int pos = 0;
        int neg = 0;
        for (int j = 0; j < actualvalue.length; ++j) {
            if (actualvalue[j] == predictedvalue[j]) {
                ++acc;
            }
            if (predictedvalue[j] == 1.0) {
                ++pos;
            }
            if (predictedvalue[j] != -1.0) continue;
            ++neg;
        }
        this.doPrint(Print.OPERATOR, "SVM predicted " + pos + " positives and " + neg + " negatives.");
        return (double)acc / (double)actualvalue.length;
    }

    public void createStatement(boolean lazy) throws SQLException, M4CompilerError {
        boolean regression;
        Value lossP = this.getLossFunctionPos();
        Value lossN = this.getLossFunctionNeg();
        boolean bl = regression = lossP != null && lossN != null;
        if (regression) {
            super.createStatement(lazy);
        } else {
            String predictedColumnName;
            String actualColumnName;
            String inputColumnSetName;
            try {
                Columnset theColumnSet = this.getInputConcept().getCurrentColumnSet();
                inputColumnSetName = theColumnSet.getSchema() + "." + theColumnSet.getName();
                actualColumnName = this.getActualValueAttribute().getCurrentColumn().getSQLDefinition();
                predictedColumnName = this.getPredictedValueAttribute().getCurrentColumn().getSQLDefinition();
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError("M4 interface error in " + this.getName() + ": " + m4e.getMessage());
            }
            String query = "SELECT COUNT(*) FROM " + inputColumnSetName;
            Long countL = this.getM4Db().executeBusinessSingleValueSqlReadL(query);
            if (countL == null || countL == 0L) {
                throw new M4CompilerError("ComputeSVMError: tried to compute accuracy; found 0 rows in TheInputConcept!");
            }
            query = "SELECT COUNT(*) FROM (SELECT A, B FROM (SELECT " + actualColumnName + " A, " + predictedColumnName + " B " + "FROM " + inputColumnSetName + ") WHERE A = B)";
            Long countEqualL = this.getM4Db().executeBusinessSingleValueSqlReadL(query);
            if (countEqualL == null) {
                countEqualL = new Long(0L);
            }
            double acc = (double)countEqualL.longValue() / (double)countL.longValue();
            this.doPrint(Print.OPERATOR, "ComputeSVMError: Computed accuracy comparing '" + actualColumnName + "' with '" + predictedColumnName + "' from '" + inputColumnSetName + "': " + acc);
        }
    }

    public Value getEpsilon() throws M4CompilerError {
        return (Value)this.getSingleParameter("Epsilon");
    }

    public Value getLossFunctionNeg() throws M4CompilerError {
        return (Value)this.getSingleParameter("LossFunctionNeg");
    }

    public Value getLossFunctionPos() throws M4CompilerError {
        return (Value)this.getSingleParameter("LossFunctionPos");
    }
}

