/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4CompilerWarning;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.FeatureConstruction;

public class Binarify
extends FeatureConstruction {
    public static final String PARAMETER_VALUES = "TargetValue";
    public static final String PARAMETER_TARGETATTR = "TheTargetAttribute";
    private boolean checkedValues = false;

    public String generateSQL(Column targetAttributeColumn) throws M4CompilerError, M4CompilerWarning {
        this.checkPresenceOfInputValues();
        Value v = (Value)this.getSingleParameter(PARAMETER_VALUES, this.getCurrentLoopNumber());
        if (v == null || v.getValue() == null || v.getValue().equals("")) {
            throw new M4CompilerError("Binarify, loop nr. " + this.getCurrentLoopNumber() + ": could not read target value!");
        }
        String targetValue = v.getValue();
        try {
            String when = targetAttributeColumn.getSQLPlusLocation() + " = ";
            boolean targetColNominal = targetAttributeColumn.getColumnDataTypeName().equalsIgnoreCase("STRING");
            when = when + (targetColNominal ? DB.quote(targetValue) : targetValue);
            String colDef = "(CASE WHEN " + when + " THEN 1 ELSE 0 END)";
            return colDef;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Binarify: M4Exception caught when accessing target attribute column '" + targetAttributeColumn.getName() + "': " + m4e.getMessage());
        }
    }

    public BaseAttribute getTheTargetAttribute(int loopNr) throws M4CompilerError {
        return (BaseAttribute)this.getSingleParameter(PARAMETER_TARGETATTR);
    }

    private void checkPresenceOfInputValues() throws M4CompilerError {
        if (!this.checkedValues) {
            this.checkedValues = true;
            ParameterObject[] vals = this.getParameterObjectsOfAllLoops(PARAMETER_VALUES);
            if (vals != null) {
                String[] values = new String[vals.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = ((Value)vals[i]).getValue();
                }
                BaseAttribute targetBa = (BaseAttribute)this.getSingleParameter(PARAMETER_TARGETATTR);
                this.giveWarningForChangedInputData(targetBa, values);
            }
        }
    }
}

