/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.operator;

import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.Value;
import edu.udo.cs.miningmart.operator.AttrDerivInterface;
import edu.udo.cs.miningmart.operator.SingleCSOperator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class AttributeDerivation
extends SingleCSOperator {
    private String[] columnNames;
    private String[] columnTypes;
    private int[] columnWidths;
    public static final String PARAM_CLASSNAME = "ClassName";
    public static final String PARAM_OUTPUT_ATTR = "TheOutputAttribute";
    public static final String PARAM_TARGET_ATTR = "TheTargetAttributes";
    public static final String externalMethodName = "deriveAttribute";
    public static final Class[] externalMethodParameters = new Class[]{String[].class, String[].class, String[][].class};

    public String getTypeOfNewColumnSet() {
        return "T";
    }

    public String generateSQLDefinition(String selectPart) throws M4CompilerError {
        Concept concept = this.getInputConcept();
        try {
            Columnset cs;
            if (concept == null || (cs = concept.getCurrentColumnSet()) == null) {
                throw new M4CompilerError("Operator 'AttributeDerivation': Found no input Concept/Columnset!");
            }
            int startLoop = 0;
            int endLoop = this.getStep().getLoopCount();
            if (endLoop > 0) {
                startLoop = 1;
            }
            String[][] inputData = this.getDataFromInputConcept(cs);
            Vector<String[]> allNewValues = new Vector<String[]>();
            for (int loopnr = startLoop; loopnr <= endLoop; ++loopnr) {
                BaseAttribute[] targetBAs = (BaseAttribute[])this.getParameter(PARAM_TARGET_ATTR, loopnr);
                String[] newValuesForThisLoop = this.callExternalMethod(targetBAs, loopnr, inputData);
                allNewValues.add(newValuesForThisLoop);
            }
            String[][] resultData = this.addAttributesToDataSet(inputData, allNewValues);
            String tablename = this.createOutputTable(cs);
            this.fillTable(tablename, resultData);
            return tablename;
        }
        catch (M4Exception e) {
            throw new M4CompilerError("Operator 'AttributeDerivation': M4Exception caught during generateSQLDefinition:\n" + e.getMessage());
        }
    }

    protected boolean mustCopyFeature(String nameOfFeature) throws M4CompilerError {
        return true;
    }

    private String createOutputTable(Columnset inputCs) throws M4CompilerError {
        String tablename = this.getNewCSName();
        int noOfLoops = this.getStep().getLoopCount() > 0 ? this.getStep().getLoopCount() : 1;
        int noOfOriginalColumns = this.columnNames.length;
        String[] allColumnNames = new String[noOfOriginalColumns + noOfLoops];
        String[] allColumnTypes = new String[noOfOriginalColumns + noOfLoops];
        int[] allColumnWidths = new int[noOfOriginalColumns + noOfLoops];
        try {
            for (int i = 0; i < noOfOriginalColumns; ++i) {
                allColumnNames[i] = this.columnNames[i];
                allColumnTypes[i] = inputCs.getColumn(this.columnNames[i]).getColumnDataTypeName();
                allColumnWidths[i] = this.columnWidths[i];
            }
            int startLoop = noOfLoops > 1 ? 1 : 0;
            int endLoop = noOfLoops > 1 ? noOfLoops : 0;
            int counter = 1;
            for (int i = startLoop; i <= endLoop; ++i) {
                BaseAttribute outBa = (BaseAttribute)this.getSingleParameter(PARAM_OUTPUT_ATTR, i);
                BaseAttribute targetBa = (BaseAttribute)this.getSingleParameter(PARAM_TARGET_ATTR, i);
                allColumnNames[noOfOriginalColumns + counter - 1] = outBa.getName();
                allColumnTypes[noOfOriginalColumns + counter - 1] = outBa.getCurrentColumn().getColumnDataTypeName();
                allColumnWidths[noOfOriginalColumns + counter - 1] = 100;
                if (targetBa != null) {
                    int targetIndex = -1;
                    for (int j = 0; j < this.columnNames.length; ++j) {
                        if (!targetBa.getCurrentColumn().getName().equalsIgnoreCase(this.columnNames[j])) continue;
                        targetIndex = j;
                    }
                    if (targetIndex > -1) {
                        allColumnWidths[noOfOriginalColumns + counter - 1] = allColumnWidths[targetIndex];
                    }
                }
                ++counter;
            }
            this.columnTypes = allColumnTypes;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 error preparing creation of output table: " + m4e.getMessage());
        }
        String sql = "CREATE TABLE " + tablename + " (";
        for (int i = 0; i < allColumnTypes.length; ++i) {
            String type = this.getM4Db().getNameOfVarcharDatatype(allColumnWidths[i]);
            if (allColumnTypes[i].equals("NUMBER")) {
                type = this.getM4Db().getNameOfNumericDatatype();
            }
            if (allColumnTypes[i].equals("DATE")) {
                type = this.getM4Db().getNameOfVarcharDatatype(100);
            }
            sql = sql + allColumnNames[i] + " " + type + ", ";
        }
        sql = sql.substring(0, sql.length() - 2) + ")";
        try {
            this.executeBusinessSqlWrite(sql);
            this.getM4Db().commitBusinessTransactions();
            this.getM4Db().addTableToTrash(tablename, inputCs.getSchema(), this.getStep().getId());
        }
        catch (SQLException s) {
            throw new M4CompilerError("SQL error creating output table: " + s.getMessage());
        }
        return this.getNewCSName();
    }

    private String[] callExternalMethod(BaseAttribute[] targetAttribs, int loop, String[][] dataset) throws M4CompilerError {
        String pref = "Operator 'AttributeDerivation' in Step '" + this.getStep().getName() + "': ";
        try {
            Object[] constructorCallParams;
            String classname;
            Class<?> theClassToUse;
            String[] targetColNames = null;
            if (targetAttribs != null) {
                targetColNames = new String[targetAttribs.length];
                for (int i = 0; i < targetColNames.length; ++i) {
                    Column targetCol = targetAttribs[i].getCurrentColumn();
                    targetColNames[i] = targetCol != null ? targetCol.getName() : null;
                }
            }
            if ((theClassToUse = Class.forName(classname = this.getClassName(loop))) == null) {
                throw new M4CompilerError(pref + "Class.forName() returned NULL for class with external method!");
            }
            Class[] constructorParameters = new Class[0];
            Constructor<?> defaultConstr = theClassToUse.getConstructor(constructorParameters);
            Object theObjectOfTheClassToUse = defaultConstr.newInstance(constructorCallParams = new Object[0]);
            if (theObjectOfTheClassToUse == null) {
                throw new M4CompilerError(pref + "could not construct an object of given class!");
            }
            if (!(theObjectOfTheClassToUse instanceof AttrDerivInterface)) {
                throw new M4CompilerError(pref + "the external class must implement the interface 'AttrDerivInterface'!");
            }
            Method theMethod = theClassToUse.getMethod(externalMethodName, externalMethodParameters);
            if (theMethod == null) {
                throw new M4CompilerError(pref + "got NULL for external method!");
            }
            Object[] arguments = new Object[]{this.columnNames, targetColNames, dataset};
            Object result = theMethod.invoke(theObjectOfTheClassToUse, arguments);
            if (!(result instanceof String[])) {
                throw new M4CompilerError(pref + "External method returned wrong result type, expected String[]!");
            }
            return (String[])result;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(pref + "M4 error preparing the call to the external method: " + m4e.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new M4CompilerError(pref + "Class not found with external method: " + cnfe.getMessage());
        }
        catch (NoSuchMethodException nsme) {
            throw new M4CompilerError(pref + "Method not found in external class: " + nsme.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new M4CompilerError(pref + "Illegal access to method in external class: " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            throw new M4CompilerError("Invocation target exception accessing method in external class: " + ite.getMessage());
        }
        catch (InstantiationException ine) {
            throw new M4CompilerError("Instantiation exception using default constructor in external class: " + ine.getMessage());
        }
    }

    private String[][] getDataFromInputConcept(Columnset inputCs) throws M4CompilerError {
        if (inputCs == null) {
            throw new M4CompilerError("Operator 'AttributeDerivation': input columnset not found!");
        }
        try {
            long s = inputCs.getStatisticsAll();
            int size = 0;
            try {
                size = (int)s;
            }
            catch (ClassCastException c) {
                throw new M4CompilerError("Operator 'AttributeDerivation': input data set is too large!");
            }
            String query = inputCs.getCompleteSQLQuery();
            ResultSet rs = this.executeBusinessSqlRead(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int noOfCols = rsmd.getColumnCount();
            this.columnNames = new String[noOfCols];
            this.columnWidths = new int[noOfCols];
            for (int i = 1; i <= noOfCols; ++i) {
                this.columnNames[i - 1] = rsmd.getColumnName(i);
                this.columnWidths[i - 1] = rsmd.getColumnDisplaySize(i);
            }
            String[][] data = new String[noOfCols][size];
            int row = 0;
            while (rs.next()) {
                for (int i = 1; i <= noOfCols; ++i) {
                    data[i - 1][row] = rs.getString(i);
                }
                ++row;
            }
            rs.close();
            return data;
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'AttributeDerivation': M4 error reading input data: " + m4e.getMessage());
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator 'AttributeDerivation': SQL error reading input data: " + sqle.getMessage());
        }
    }

    private void fillTable(String tablename, String[][] dataToFillIn) throws M4CompilerError {
        if (dataToFillIn == null || dataToFillIn.length == 0) {
            throw new M4CompilerError("Operator 'AttributeDerivation': result data set is empty!");
        }
        String prefix = "INSERT INTO " + tablename + " VALUES (";
        try {
            for (int i = 0; i < dataToFillIn[0].length; ++i) {
                String query = prefix;
                for (int j = 0; j < dataToFillIn.length; ++j) {
                    String dataItem = dataToFillIn[j][i];
                    if (this.columnTypes[j].equals("STRING") || this.columnTypes[j].equals("DATE")) {
                        dataItem = "'" + dataItem + "'";
                    }
                    query = query + dataItem + ", ";
                }
                query = query.substring(0, query.length() - 2) + ")";
                this.executeBusinessSqlWrite(query);
            }
            this.getM4Db().commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Operator 'AttributeDerivation': SQL error writing result data: " + sqle.getMessage());
        }
    }

    protected String handleExtraOutputFeature(Feature outF, Columnset csForOutputConcept) throws M4CompilerError {
        try {
            int endLoop = this.getStep().getLoopCount();
            if (endLoop == 0) {
                endLoop = 1;
            }
            String sql = null;
            for (int loopnr = 0; loopnr < endLoop; ++loopnr) {
                BaseAttribute outBA = (BaseAttribute)this.getSingleParameter(PARAM_OUTPUT_ATTR, loopnr);
                if (!(outF instanceof BaseAttribute) || !((BaseAttribute)outF).equals(outBA)) continue;
                sql = outBA.getName();
                Column newCol = (Column)((Object)this.getM4Db().createNewInstance(Column.class));
                newCol.setName(outBA.getName());
                newCol.setSQLDefinition(sql);
                newCol.setBaseAttribute(outBA);
                newCol.setColumnDataTypeName(this.getM4Db().getM4RelTypeForConceptualType(outBA.getConceptualDataTypeName()));
                newCol.setColumnset(csForOutputConcept);
            }
            if (sql == null) {
                return "";
            }
            return sql + ", ";
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Operator 'AttributeDerivation': M4 error: " + m4e.getMessage());
        }
    }

    private String[][] addAttributesToDataSet(String[][] dataset, Vector arraysWithNewValues) throws M4CompilerError {
        if (dataset == null) {
            return null;
        }
        if (arraysWithNewValues == null) {
            return dataset;
        }
        int noOfCols = dataset.length + arraysWithNewValues.size();
        int noOfRows = dataset[0].length;
        String[][] ret = new String[noOfCols][noOfRows];
        for (int i = 0; i < noOfCols; ++i) {
            String[] newValues = null;
            if (i >= dataset.length && dataset[0].length != (newValues = (String[])arraysWithNewValues.get(i - dataset.length)).length) {
                throw new M4CompilerError("Operator 'AttributeDerivation': too few or too many values created!");
            }
            for (int k = 0; k < noOfRows; ++k) {
                ret[i][k] = i < dataset.length ? dataset[i][k] : newValues[k];
            }
        }
        return ret;
    }

    private String getClassName(int loopNr) throws M4CompilerError {
        Value v = (Value)this.getSingleParameter(PARAM_CLASSNAME, loopNr);
        if (v == null) {
            throw new M4CompilerError("Could not find parameter 'ClassName' in loop number " + loopNr + "!");
        }
        return v.getValue();
    }
}

