/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.utils;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.M4Object;
import edu.udo.cs.miningmart.m4.core.M4Data;
import java.sql.ResultSet;
import java.sql.SQLException;

public class M4InfoEntry {
    private final String dbAttribute;
    private final String getter;
    private final String setter;
    private final Class theObjectClass;
    private boolean notNull = false;

    public M4InfoEntry(String dbAttribute, String getter, String setter, Class objectClass) {
        this.dbAttribute = dbAttribute;
        this.getter = getter;
        this.setter = setter;
        this.theObjectClass = objectClass;
    }

    public M4InfoEntry(String dbAttribute, String getter, String setter, Class objectClass, String constraint) {
        this(dbAttribute, getter, setter, objectClass);
        if (constraint == null) {
            return;
        }
        if ("NN".equals(constraint)) {
            this.notNull = true;
        }
    }

    public String getDbAttribute() {
        return this.dbAttribute;
    }

    public String getGetter() {
        return this.getter;
    }

    public String getSetter() {
        return this.setter;
    }

    public Class getTheObjectClass() {
        return this.theObjectClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activateSetter(M4Data m4d, ResultSet rs, DB db) throws SQLException, M4Exception {
        Object object;
        String attributeName = this.getDbAttribute();
        Class type = this.getTheObjectClass();
        if (!M4Object.class.isAssignableFrom(type)) {
            if (type.equals(Long.TYPE)) {
                object = new Long(rs.getLong(attributeName));
            } else if (type.equals(Integer.TYPE)) {
                object = new Integer(rs.getInt(attributeName));
            } else if (type.equals(Short.TYPE)) {
                object = new Short(rs.getShort(attributeName));
            } else if (type.equals(Double.TYPE)) {
                object = new Double(rs.getDouble(attributeName));
            } else if (type.equals(String.class)) {
                object = rs.getString(attributeName);
            } else if (type.equals(Boolean.TYPE)) {
                String s = rs.getString(attributeName).trim().toUpperCase();
                boolean val = s.startsWith("Y") || s.equals("IN") || s.equals("TRUE");
                object = new Boolean(val);
            } else if (type.equals(Long.class)) {
                long num = rs.getLong(attributeName);
                object = rs.wasNull() ? null : new Long(num);
            } else if (type.equals(Integer.class)) {
                int num = rs.getInt(attributeName);
                object = rs.wasNull() ? null : new Integer(num);
            } else {
                if (!type.equals(Double.class)) throw new M4Exception("Found unsupported Class in M4InfoEntry.activateSetter(M4Table, ResultSet, DB): " + m4d.getClass().getName());
                double num = rs.getDouble(attributeName);
                object = rs.wasNull() ? null : new Double(num);
            }
        } else {
            long id = rs.getLong(attributeName);
            object = db.getM4Object(id, type);
        }
        m4d.genericSetter(this.getSetter(), type, object);
    }

    public boolean isNotNull() {
        return this.notNull;
    }
}

