/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.utils;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class CreateConceptsTool {
    private String tableNamesFile;
    private DB m4db;
    private Case myCase;
    private String schema;

    public CreateConceptsTool(DB theDb, String schemaName, Case theCase) {
        this.m4db = theDb;
        this.schema = schemaName;
        this.myCase = theCase;
    }

    public Collection createConcepts(Collection theTableNames) throws M4Exception {
        Vector<Concept> theConcepts = new Vector<Concept>();
        boolean isATable = true;
        if (theTableNames != null) {
            Iterator it = theTableNames.iterator();
            while (it.hasNext()) {
                Concept newConcept = this.createConcept((String)it.next(), isATable);
                theConcepts.add(newConcept);
            }
            theConcepts.trimToSize();
        }
        return theConcepts;
    }

    private Collection getTableNames(String fileName) {
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(fileName));
            String line = lnr.readLine();
            Vector<String> v = new Vector<String>();
            while (line != null) {
                v.add(line.trim());
                line = lnr.readLine();
            }
            v.trimToSize();
            lnr.close();
            return v;
        }
        catch (IOException ioe) {
            System.out.println("CreateConceptsTool: Error accessing file with table names: " + ioe.getMessage());
            System.exit(-1);
            return null;
        }
    }

    private Concept createConcept(String tableName, boolean isTable) throws M4Exception {
        try {
            String query = this.m4db.getSelectStringAllColumnsForDbObject(tableName);
            ResultSet rs = this.m4db.executeBusinessSqlRead(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int noOfColumns = rsmd.getColumnCount();
            String[] theColumnNames = new String[noOfColumns];
            String[] theColumnTypes = new String[noOfColumns];
            String[] theConceptualTypes = new String[noOfColumns];
            for (int i = 1; i <= noOfColumns; ++i) {
                theColumnNames[i - 1] = rsmd.getColumnName(i);
                String dbmsType = rsmd.getColumnTypeName(i);
                theColumnTypes[i - 1] = this.m4db.getM4RelationalDatatypeName(dbmsType, true);
                theConceptualTypes[i - 1] = this.getBaTypeForColumnType(theColumnTypes[i - 1]);
            }
            rs.close();
            Concept newConcept = this.myCase.createConcept(tableName, "DB");
            String csType = isTable ? "T" : "V";
            Columnset newColumnset = newConcept.createColumnset(tableName, this.schema, csType);
            for (int i = 0; i < noOfColumns; ++i) {
                newConcept.createBaseAttribute(theColumnNames[i], theConceptualTypes[i], "DB", "NO_ROLE");
                newColumnset.createColumn(theColumnNames[i], theColumnTypes[i]);
            }
            return newConcept;
        }
        catch (SQLException sqle) {
            throw new M4Exception("CreateConceptsTool: SQL Error reading information about the Columns: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("CreateConceptsTool: DB connection closed: " + dbc.getMessage());
        }
    }

    private String getBaTypeForColumnType(String colType) {
        if (colType.equals("NUMBER")) {
            return "NUMERIC";
        }
        if (colType.equals("STRING")) {
            return "CATEGORIAL";
        }
        if (colType.equals("KEY")) {
            return "CATEGORIAL";
        }
        if (colType.equals("DATE")) {
            return "TIME";
        }
        return null;
    }
}

