/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.core.ParameterObject;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;

public class Value
extends ParameterObject
implements XmlInfo,
edu.udo.cs.miningmart.m4.Value {
    public static final String M4_TABLE_NAME = "value_t";
    public static final String ATTRIB_VALUE_ID = "v_id";
    public static final String ATTRIB_DATATYPE = "v_condtid";
    public static final String ATTRIB_VALUE_NAME = "v_name";
    public static final String ATTRIB_THE_VALUE = "v_value";
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private Long myType;
    private String myValue;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_VALUE_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_VALUE_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_VALUE_NAME, "getName", "setName", String.class), new M4InfoEntry(ATTRIB_DATATYPE, "getTypeL", "setTypeL", Long.class, "NN"), new M4InfoEntry(ATTRIB_THE_VALUE, "getValue", "setRawValue", String.class, "NN")};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("Type", "getType", "setType", Long.TYPE), new M4InfoEntry("Val", "getValue", "setValue", String.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Value() {
        this(null);
    }

    public Value(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(Print.M4_OBJECT, "Value (Id = " + this.myId + ";" + " Type = " + this.myType + ") = " + this.myValue);
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public void setType(long t) {
        this.setDirty();
        this.myType = new Long(t);
    }

    public void setTypeL(Long t) {
        this.setDirty();
        this.myType = t;
    }

    public void setType(String conceptualDatatypeName) throws M4Exception {
        ConceptualDatatypes cd;
        try {
            cd = new ConceptualDatatypes(this.getM4Db());
        }
        catch (DbConnectionClosed c) {
            throw new M4Exception(c.getMessage());
        }
        this.setType(cd.getIdForName(conceptualDatatypeName));
    }

    public String getTypeName() throws M4Exception {
        ConceptualDatatypes cd;
        try {
            cd = new ConceptualDatatypes(this.getM4Db());
        }
        catch (DbConnectionClosed c) {
            throw new M4Exception(c.getMessage());
        }
        return cd.getNameForId(this.getType());
    }

    public long getType() {
        return this.myType == null ? 0L : this.myType;
    }

    public Long getTypeL() {
        return this.myType;
    }

    public void setValue(String v) {
        this.setDirty();
        this.myValue = v;
    }

    public void setRawValue(String value) {
        long t = this.getType();
        if (t == 7L || t == 9L) {
            try {
                value = DB.checkDouble(value);
            }
            catch (M4Exception e) {
                // empty catch block
            }
        }
        this.setValue(value);
    }

    public String getValue() {
        return this.myValue;
    }

    public boolean isLong() {
        String value = this.getValue();
        if (value == null) {
            return false;
        }
        try {
            Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean isDouble() {
        String value = this.getValue();
        if (value == null) {
            return false;
        }
        try {
            Double.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public Long getLong() {
        if (this.isLong()) {
            return Long.valueOf(this.getValue().trim());
        }
        return null;
    }

    public Double getDouble() {
        if (this.isDouble()) {
            return Double.valueOf(this.getValue().trim());
        }
        return null;
    }

    protected boolean hasCoordinates() {
        return false;
    }

    protected void removeAllM4References() throws M4Exception {
        super.removeAllM4References();
        this.removeDocObject();
    }
}

