/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.compiler.CompilerAccessLogic;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterError;
import edu.udo.cs.miningmart.exception.ParameterNotFoundException;
import edu.udo.cs.miningmart.exception.UserError;
import edu.udo.cs.miningmart.exception.XmlException;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Constraint;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.Operator;
import edu.udo.cs.miningmart.m4.ParamDict;
import edu.udo.cs.miningmart.m4.ParameterArray;
import edu.udo.cs.miningmart.m4.ParameterObject;
import edu.udo.cs.miningmart.m4.core.Assertion;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.ConceptualDatatypes;
import edu.udo.cs.miningmart.m4.core.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.core.ForeignKey;
import edu.udo.cs.miningmart.m4.core.GraphicalM4Object;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.core.OpParam;
import edu.udo.cs.miningmart.m4.core.Parameter;
import edu.udo.cs.miningmart.m4.core.Relation;
import edu.udo.cs.miningmart.m4.core.Value;
import edu.udo.cs.miningmart.m4.utils.HasCrossReferences;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.InterM4StepParameter;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.M4Xml;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import edu.udo.cs.miningmart.operator.ConceptOperator;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Step
extends GraphicalM4Object
implements edu.udo.cs.miningmart.m4.Step,
XmlInfo,
HasCrossReferences {
    public static final String M4_TABLE_NAME = "step_t";
    public static final String ATTRIB_STEP_ID = "st_id";
    public static final String ATTRIB_STEP_NAME = "st_name";
    public static final String ATTRIB_CHAIN_ID = "st_chid";
    public static final String ATTRIB_CASE_ID = "st_caid";
    public static final String ATTRIB_OPERATOR_ID = "st_opid";
    public static final String ATTRIB_NUM_OF_LOOPS = "st_loopnr";
    public static final String ATTRIB_STEP_NR = "st_nr";
    public static final String ATTRIB_MULTISTEP_COND = "st_multistepcond";
    public static InterM4Communicator step2par = new InterM4StepParameter();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    public static final String M4_TABLE_NAME_STEPSEQ = "stepsequence_t";
    public static final String ATTRIB_STEPSEQ_DEPENDENCY_ID = "sts_id";
    public static final String ATTRIB_STEPSEQ_FROM_STEP = "sts_stid";
    public static final String ATTRIB_STEPSEQ_TO_STEP = "sts_successorstid";
    public static final String DB_TRASH_TABLENAME = "dbtrash_t";
    public static final String ATTRIB_DBT_OBJTYPE = "ObjType";
    public static final String ATTRIB_DBT_OBJNAME = "ObjName";
    public static final String ATTRIB_DBT_SCHEMA = "SchemaName";
    public static final String ATTRIB_DBT_STEPID = "StepId";
    public static final String DBT_TYPE_FUNCTION = "F";
    public static final String DBT_TYPE_VIEW = "V";
    public static final String DBT_TYPE_TABLE = "T";
    public static final String DBT_TYPE_INDEX = "I";
    public static final String DBT_TYPE_PRIMARY_KEY = "PK";
    public static final String DBT_TYPE_FOREIGN_KEY = "FK";
    public static final String REVSTEP_TABLENAME = "revstep_t";
    public static final String ATTRIB_REV_ID = "rev_id";
    public static final String ATTRIB_REV_ORIGSTEP = "rev_orgstid";
    public static final String ATTRIB_REV_REVSTEP = "rev_revstid";
    private static final String EXPORT_TAG_REVERSING_STEPS = "ReversedByStep";
    private Case myCase;
    private edu.udo.cs.miningmart.m4.core.Chain myChain;
    private long myNr;
    private int loopCount;
    private String multiStepCondition;
    private edu.udo.cs.miningmart.m4.core.Operator myOperator;
    private final HashSet myM4Trash = new HashSet();
    private boolean allM4TrashLoaded = false;
    private final Collection myParameterTuples = new Vector();
    private boolean allParameterTuplesLoaded = false;
    private final Vector dependentSteps = new Vector();
    private boolean allDependentStepsLoaded = false;
    private boolean dependentStepsDirty = false;
    private final Vector myDbTrash = new Vector();
    private boolean dbTrashDirty = false;
    private boolean allDbTrashLoaded = false;
    private static char nameSeparator = (char)95;
    private static String internalNameSeparator = "##";
    private Vector myReversingSteps = null;
    private Step theStepThisStepReverses = null;
    private Concept oldInputConcept = null;
    private Concept replacingConcept = null;
    Map oldNamesOfOutputAttribs = null;
    private Map mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames = null;
    private int bfsLevel = 0;
    public static final String M4_TRASH_TABLE = "m4trash_t";
    public static final String M4_TRASH_ID = "m4id";
    public static final String M4_TRASH_OBJ_TABLE = "m4table";
    public static final String M4_TRASH_STEP_ID = "stepid";
    private boolean isCompiled = false;
    private boolean m4trashDirty = false;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_STEP_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_STEP_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_STEP_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_STEP_NR, "getNumber", "setNumber", Long.TYPE), new M4InfoEntry(ATTRIB_NUM_OF_LOOPS, "getLoopCount", "setLoopCount", Integer.TYPE), new M4InfoEntry(ATTRIB_MULTISTEP_COND, "getMultiStepCondition", "setMultiStepCondition", String.class), new M4InfoEntry(ATTRIB_CASE_ID, "getTheCase", "primitiveSetCase", edu.udo.cs.miningmart.m4.Case.class, "NN"), new M4InfoEntry(ATTRIB_CHAIN_ID, "getTheChain", "primitiveSetChain", Chain.class), new M4InfoEntry(ATTRIB_OPERATOR_ID, "getTheOperator", "setTheOperator", Operator.class, "NN")};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("Number", "getNumber", "setNumber", Long.TYPE), new M4InfoEntry("LoopCount", "getLoopCount", "setLoopCount", Integer.TYPE), new M4InfoEntry("MultiStepCondition", "getMultiStepCondition", "setMultiStepCondition", String.class), new M4InfoEntry("Case", "getTheCase", "setTheCase", edu.udo.cs.miningmart.m4.Case.class), new M4InfoEntry("Chain", "getTheChain", "setTheChain", Chain.class), new M4InfoEntry("Operator", "getTheOperator", "setTheOperator", Operator.class), new M4InfoEntry("Successors", "getSuccessors", "setSuccessors", Collection.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Step(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        edu.udo.cs.miningmart.m4.core.Operator op = null;
        op = (edu.udo.cs.miningmart.m4.core.Operator)this.getTheOperator();
        String opName = op == null ? "<null>" : op.getName();
        this.doPrint(Print.M4_OBJECT, "Step (Id = " + this.myId + ";" + "      Operator = " + opName + ";" + "      Loop Count = " + this.getLoopCount() + ";" + "      Multi Step = " + this.getMultiStepCondition() + ")");
        super.print();
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        if (typeOfObjects.isAssignableFrom(Parameter.class)) {
            return this.getParameterTuples();
        }
        throw new M4Exception("Step.getObjectsInNamespace: unknown type of objects given: " + typeOfObjects.getName());
    }

    public Operator getTheOperator() {
        return this.myOperator;
    }

    public void setTheOperator(Operator theOp) {
        this.setDirty();
        this.myOperator = (edu.udo.cs.miningmart.m4.core.Operator)theOp;
    }

    public Chain getTheChain() {
        return this.myChain;
    }

    public void setTheChain(Chain chain) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Chain.chain2step.checkNameExists(this, chain);
        edu.udo.cs.miningmart.m4.core.Chain.chain2step.updateReferenceTo(this, chain);
    }

    public void primitiveSetChain(Chain chain) {
        this.setDirty();
        this.myChain = (edu.udo.cs.miningmart.m4.core.Chain)chain;
    }

    public long getCaseId() {
        return this.myCase.getId();
    }

    public long getNumber() {
        return this.myNr;
    }

    public void setTheCase(edu.udo.cs.miningmart.m4.Case myCase) throws M4Exception {
        Case.case2step.checkNameExists(this, myCase);
        Case.case2step.updateReferenceTo(this, myCase);
    }

    public void primitiveSetCase(edu.udo.cs.miningmart.m4.Case myCase) {
        this.setDirty();
        this.myCase = (Case)myCase;
    }

    public void setNumber(long nr) {
        this.setDirty();
        this.myNr = nr;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public String getMultiStepCondition() {
        return this.multiStepCondition;
    }

    public void addParameterTuple(edu.udo.cs.miningmart.m4.Parameter par) throws M4Exception {
        step2par.checkNameExists((Parameter)par, this);
        step2par.add(this, (Parameter)par);
    }

    public boolean removeParameterTuple(edu.udo.cs.miningmart.m4.Parameter par) throws M4Exception {
        return step2par.remove(this, (Parameter)par);
    }

    public void removeAllParameterTuples() throws M4Exception {
        step2par.setCollectionTo(this, null);
    }

    public void removeParameter(String parName) throws M4Exception {
        Collection theParamTuples = this.getParameterTuples();
        Vector theCopy = new Vector(theParamTuples);
        for (Parameter par : theCopy) {
            if (par == null || !par.getName().startsWith(parName)) continue;
            this.removeParameterTuple(par);
            par.deleteSoon();
        }
    }

    public void setLoopCount(int lc) throws M4Exception {
        if (this.loopCount > lc) {
            Iterator it = this.getTheOperator().getOpParamsIterator();
            while (it.hasNext()) {
                OpParam myOpPar = (OpParam)it.next();
                if (!myOpPar.isLoopable()) continue;
                for (int loop = lc + 1; loop <= this.loopCount; ++loop) {
                    this.setParameter(myOpPar, new Vector(), loop);
                }
            }
        }
        this.setDirty();
        this.loopCount = lc;
    }

    public void setMultiStepCondition(String msc) {
        this.setDirty();
        this.multiStepCondition = msc;
    }

    public edu.udo.cs.miningmart.m4.Case getTheCase() {
        return this.myCase;
    }

    public edu.udo.cs.miningmart.m4.Step getReversedStep() throws M4Exception {
        Case myCase;
        if (this.theStepThisStepReverses == null && (myCase = (Case)this.getTheCase()) != null) {
            Iterator stepIt = myCase.getStepIterator();
            while (stepIt.hasNext()) {
                Step aStep = (Step)stepIt.next();
                aStep.getDependentReversingSteps();
            }
        }
        return this.theStepThisStepReverses;
    }

    public Collection getParameterTuples() throws M4Exception {
        if (!this.allParameterTuplesLoaded && !this.isNew()) {
            this.allParameterTuplesLoaded = true;
            this.readParameterTuplesFromDB();
        }
        return this.myParameterTuples;
    }

    private Collection getParameterTuples(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        Collection all = this.getParameterTuples();
        Vector<Parameter> ret = new Vector<Parameter>();
        for (Parameter myPar : all) {
            if (!myPar.getName().startsWith(theOpParam.getName())) continue;
            ret.add(myPar);
        }
        return ret;
    }

    private Collection getParameterTuples(edu.udo.cs.miningmart.m4.OpParam theOpParam, int loopNr) throws M4Exception {
        Collection all = this.getParameterTuples();
        Vector<Parameter> ret = new Vector<Parameter>();
        for (Parameter myPar : all) {
            if (!myPar.getName().startsWith(theOpParam.getName()) || myPar.getLoopNr() != loopNr) continue;
            ret.add(myPar);
        }
        return ret;
    }

    public Collection getSuccessors() throws M4Exception {
        if (!this.allDependentStepsLoaded && !this.isNew()) {
            this.allDependentStepsLoaded = true;
            this.readSuccessorsFromDb();
        }
        return this.dependentSteps;
    }

    public void addSuccessor(edu.udo.cs.miningmart.m4.Step step) throws M4Exception {
        if (step != null) {
            this.dependentStepsDirty = true;
            this.setDirty();
            this.primitiveAddSuccessor(step);
        }
    }

    public void primitiveAddSuccessor(edu.udo.cs.miningmart.m4.Step step) throws M4Exception {
        if (step != null) {
            this.getSuccessors().add(step);
        }
    }

    public boolean removeSuccessor(edu.udo.cs.miningmart.m4.Step step) throws M4Exception {
        if (step != null) {
            boolean success = this.getSuccessors().remove(step);
            if (success) {
                this.dependentStepsDirty = true;
                this.setDirty();
            }
            return success;
        }
        return false;
    }

    public boolean removeSuccessor(String name) throws M4Exception {
        if (name != null) {
            Step toRemove = null;
            for (Step st : this.getSuccessors()) {
                if (!st.getName().equals(name)) continue;
                toRemove = st;
            }
            boolean success = this.removeSuccessor(toRemove);
            return success;
        }
        return false;
    }

    public boolean dependencyExists(Chain toChain) throws M4Exception {
        Collection allStepsOfToChain = toChain.getAllSteps();
        if (allStepsOfToChain == null) {
            throw new M4Exception("ToChain '" + toChain.getName() + "': got NULL when asking for all steps!");
        }
        for (Step toStep : allStepsOfToChain) {
            if (!this.getTheCase().containsDependency(this, toStep)) continue;
            return true;
        }
        return false;
    }

    public boolean isRelationallyValid() {
        return true;
    }

    public boolean isSuccessorOf(edu.udo.cs.miningmart.m4.Step previousStep) throws M4Exception {
        if (previousStep == null) {
            return false;
        }
        Collection successorsOfPreviousStep = previousStep.getSuccessors();
        return successorsOfPreviousStep.contains(this);
    }

    public void addPredecessor(edu.udo.cs.miningmart.m4.Step step) throws M4Exception {
        this.getTheCase().addStepDependency(step, this);
    }

    public void addReversingStep(edu.udo.cs.miningmart.m4.Step st) throws M4Exception {
        this.getDependentReversingSteps();
        if (!this.myReversingSteps.contains(st)) {
            if (this.linkExistsToHere((Step)st)) {
                throw new M4Exception("Cannot add step '" + st.getName() + "' as reversing step of '" + this.getName() + "' because the former precedes the latter in the transition graph!");
            }
            this.myReversingSteps.add(st);
            ((Step)st).setReversedStep(this);
        }
    }

    private boolean linkExistsToHere(Step aStep) throws M4Exception {
        for (Step oneStep : this.getTheCase().getDependentStepsFor(aStep)) {
            if (!oneStep.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void setReversedStep(Step reversedStep) {
        this.theStepThisStepReverses = reversedStep;
    }

    public boolean materialisesOutput() throws M4Exception {
        try {
            String outputCsType;
            ExecutableOperator myExecOp = CompilerAccessLogic.getExecutableOperator(this.getTheOperator());
            return myExecOp instanceof ConceptOperator && (outputCsType = ((ConceptOperator)myExecOp).getTypeOfNewColumnSet(0)).equals(DBT_TYPE_TABLE);
        }
        catch (M4CompilerError mce) {
            throw new M4Exception("Step '" + this.getName() + "': could not determine executable operator: " + mce.getMessage());
        }
    }

    public boolean hasOnlyInputConceptsOfTypeDB() throws M4Exception {
        for (Concept inputConcept : this.getAllInputConcepts()) {
            if (inputConcept.getType().equals("DB")) continue;
            return false;
        }
        return true;
    }

    public int getMaximumNumberOfStepsSinceLastMaterialisation() throws M4Exception {
        Collection directPredecessors = this.getAllPredecessors();
        if (directPredecessors.isEmpty()) {
            return 0;
        }
        Iterator predStepIt = directPredecessors.iterator();
        boolean allPredsMaterialise = true;
        while (predStepIt.hasNext()) {
            Step predecessor = (Step)predStepIt.next();
            if (predecessor.materialisesOutput()) continue;
            allPredsMaterialise = false;
        }
        if (allPredsMaterialise) {
            return 0;
        }
        predStepIt = directPredecessors.iterator();
        int maximum = 0;
        while (predStepIt.hasNext()) {
            Step predecessor = (Step)predStepIt.next();
            int predValue = predecessor.getMaximumNumberOfStepsSinceLastMaterialisation();
            if (predValue <= maximum) continue;
            maximum = predValue;
        }
        return maximum + 1;
    }

    public boolean createsConceptualOutput() throws M4Exception {
        return !this.getTheOperator().getAllOutputOperatorParameters().isEmpty();
    }

    public boolean isLastStepProducingConceptualOutput() throws M4Exception {
        Collection succ = this.getSuccessors();
        if (succ.isEmpty() && this.createsConceptualOutput()) {
            return true;
        }
        for (Step successorStep : succ) {
            if (!successorStep.createsConceptualOutput() && successorStep.getSuccessors().isEmpty()) continue;
            return false;
        }
        return this.createsConceptualOutput();
    }

    public Collection getSuccessorsUntilOutputConceptIsCreated() throws M4Exception {
        if (this.getOutputConcept() != null) {
            return new Vector();
        }
        Collection myInputs = this.getAllInputConcepts();
        Vector ret = new Vector();
        this.getSuccessorsUntilOutputConceptIsCreated(myInputs, ret);
        return ret;
    }

    private void getSuccessorsUntilOutputConceptIsCreated(Collection theInputs, Collection theSuccessors) throws M4Exception {
        theSuccessors.add(this);
        if (this.getOutputConcept() != null) {
            return;
        }
        for (Step successor : new Vector(this.getSuccessors())) {
            successor.getSuccessorsUntilOutputConceptIsCreated(theInputs, theSuccessors);
        }
    }

    public boolean usesAggregation() throws M4Exception {
        Collection c = new Vector();
        OpParam groupByOpParam = (OpParam)this.getTheOperator().getOpParam("TheGroupByAttributes");
        if (groupByOpParam != null) {
            c = this.getParameterTuples(groupByOpParam);
            groupByOpParam = (OpParam)this.getTheOperator().getOpParam("GroupBy");
            if (groupByOpParam != null) {
                c.addAll(this.getParameterTuples(groupByOpParam));
            }
        }
        return !c.isEmpty();
    }

    public void deleteSoon() throws M4Exception {
        this.deleteOutputs();
        super.deleteSoon();
    }

    protected void deleteLocal() throws M4Exception {
        super.deleteLocal();
        this.deleteDbTrash();
        this.writeDbTrashToDb();
        this.deleteM4Trash();
        this.writeM4TrashToDb();
        String sql = "DELETE FROM stepsequence_t WHERE sts_stid = " + this.getId();
        this.executeM4SqlWrite(sql);
        sql = "DELETE FROM stepsequence_t WHERE sts_successorstid = " + this.getId();
        this.executeM4SqlWrite(sql);
        if (this.reversingStepsTableExistsInM4()) {
            sql = "DELETE FROM revstep_t WHERE rev_revstid = " + this.getId();
            this.executeM4SqlWrite(sql);
            sql = "DELETE FROM revstep_t WHERE rev_orgstid = " + this.getId();
            this.executeM4SqlWrite(sql);
        }
    }

    private void readParameterTuplesFromDB() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(Parameter.class).iterator();
        while (it.hasNext()) {
            this.addParameterTuple((Parameter)it.next());
        }
    }

    public ParamDict readParametersFromDB(boolean paramsMustExist) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParamDict pd = new edu.udo.cs.miningmart.m4.core.ParamDict();
        Iterator it = this.getTheOperator().getOpParamsIterator();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.ParameterArray obj;
            int i;
            int loops;
            OpParam op = (OpParam)it.next();
            if (op.getMinArg() == 0) {
                try {
                    edu.udo.cs.miningmart.m4.core.ParameterArray withoutLoop = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.loadParam(op, 0);
                    if (withoutLoop.size() > 0 || this.getLoopCount() <= 0) {
                        pd.put(op.getName(), withoutLoop);
                        continue;
                    }
                    loops = this.getLoopCount() + 1;
                    for (i = 1; i < loops; ++i) {
                        obj = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.loadParam(op, i);
                        pd.put(op.getName(), i, obj);
                    }
                    continue;
                }
                catch (ParameterNotFoundException e) {
                    throw new M4Exception("Internal compiler error.'ParameterNotFound' exception was thrown for an optional parameter:\n" + e.getMessage());
                }
            }
            try {
                pd.put(op.getName(), this.loadParam(op, 0));
            }
            catch (ParameterNotFoundException e) {
                if (this.getLoopCount() > 0) {
                    loops = this.getLoopCount() + 1;
                    try {
                        for (i = 1; i < loops; ++i) {
                            obj = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.loadParam(op, i);
                            pd.put(op.getName(), i, obj);
                        }
                        continue;
                    }
                    catch (ParameterNotFoundException pnfe) {
                        if (!paramsMustExist) continue;
                        throw pnfe;
                    }
                }
                if (!paramsMustExist) continue;
                throw e;
            }
        }
        return pd;
    }

    private ParameterArray loadParam(edu.udo.cs.miningmart.m4.OpParam op, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterArray ret = null;
        try {
            if (op.getMaxArg() == 1) {
                Parameter obj = (Parameter)this.loadSingleParam(op, loopNr);
                if (obj != null) {
                    ret = new edu.udo.cs.miningmart.m4.core.ParameterArray(obj.getParObjectType());
                    ret.addParameter(obj);
                }
            } else {
                ret = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.loadParamArray(op, loopNr);
            }
        }
        catch (ParameterError e) {
            // empty catch block
        }
        if (ret == null) {
            if (op.getMinArg() > 0) {
                this.throwParameterLoadException(loopNr, op.getName() + " not found.");
            } else {
                ret = new edu.udo.cs.miningmart.m4.core.ParameterArray(op.getType());
            }
        } else {
            if (ret.size() < op.getMinArg()) {
                this.throwParameterLoadException(loopNr, op.getName() + " should be an Array of at least " + op.getMinArg() + " entries, but has only " + ret.size() + " elements!");
            }
            if (op.getMaxArg() >= 0 && ret.size() > op.getMaxArg()) {
                this.throwParameterLoadException(loopNr, op.getName() + " should be an Array of at most " + op.getMinArg() + " entries, but has " + ret.size() + " elements!");
            }
        }
        return ret;
    }

    private void throwParameterLoadException(int loopNr, String restOfMessage) throws M4Exception {
        String message = "Could not load parameters for operator " + this.getTheOperator().getName() + " in step " + this.getId();
        if (loopNr > 0) {
            message = message + ", loop nr." + loopNr;
        }
        message = message + " !\nParameter " + restOfMessage;
        throw new ParameterNotFoundException(message);
    }

    private edu.udo.cs.miningmart.m4.Parameter loadSingleParam(edu.udo.cs.miningmart.m4.OpParam op, int loopNr) throws M4Exception {
        Parameter theSingleParam = null;
        if (this.myParameterTuples != null) {
            for (Parameter myParam : this.myParameterTuples) {
                if (!myParam.getName().startsWith(op.getName())) continue;
                if (theSingleParam == null) {
                    theSingleParam = myParam;
                    continue;
                }
                throw new M4Exception("Step.loadSingleParam(): found more than one Parameter '" + op.getName() + "' in Step '" + this.getName());
            }
        }
        if (theSingleParam != null) {
            return theSingleParam;
        }
        String query = this.createLoadParamQuery(op, loopNr);
        Long parId = this.executeM4SingleValueSqlReadL(query);
        if (parId == null) {
            return null;
        }
        DB db = this.getM4Db();
        return (Parameter)db.getM4Object(parId, Parameter.class);
    }

    private ParameterArray loadParamArray(edu.udo.cs.miningmart.m4.OpParam op, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterArray parameterArray;
        edu.udo.cs.miningmart.m4.core.ParameterArray ret = null;
        if (this.myParameterTuples != null) {
            ret = new edu.udo.cs.miningmart.m4.core.ParameterArray(op.getType());
            for (Parameter myParam : this.myParameterTuples) {
                if (!myParam.getName().startsWith(op.getName())) continue;
                ret.addParameter(myParam);
            }
        }
        if (ret != null && ret.size() != 0) {
            return ret;
        }
        ResultSet rs = null;
        try {
            String query = this.createLoadParamQuery(op, loopNr);
            rs = this.executeM4SqlRead(query);
            DB db = this.getM4Db();
            ret = new edu.udo.cs.miningmart.m4.core.ParameterArray(op.getType());
            while (rs.next()) {
                Long parId = new Long(rs.getLong(1));
                Parameter p = (Parameter)db.getM4Object(parId, Parameter.class);
                ret.addParameter(p);
            }
            parameterArray = ret;
        }
        catch (SQLException sqle) {
            try {
                throw new M4Exception("SQL error when loading ParameterArray for Step " + this.getId() + ": " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        return parameterArray;
    }

    private String createLoadParamQuery(edu.udo.cs.miningmart.m4.OpParam op, int loopNr) {
        String parName = op.getName();
        String LoopCondition = loopNr == 0 ? "(par_stloopnr IS NULL OR par_stloopnr = 0)" : "par_stloopnr = " + loopNr;
        String query = "SELECT par_id FROM parameter_t WHERE par_stid = " + this.getId() + " AND " + LoopCondition + " AND " + DB.attribPrefix("par_name", parName) + " = " + DB.quote(parName) + " ORDER BY " + "par_nr";
        return query;
    }

    private void readSuccessorsFromDb() throws M4Exception {
        String query = "SELECT sts_successorstid FROM stepsequence_t WHERE sts_stid = " + this.getId();
        ResultSet rs = null;
        try {
            rs = this.executeM4SqlRead(query);
            DB db = this.getM4Db();
            while (rs.next()) {
                long successorId = rs.getLong(1);
                if (rs.wasNull()) continue;
                Step step = (Step)db.getM4Object(successorId, Step.class);
                if (!this.dependentSteps.contains(step)) {
                    this.primitiveAddSuccessor(step);
                    continue;
                }
                throw new M4Exception("Step.readSuccessorsFromDb(): Found double entry for Step " + this.getId() + " and Successor Step " + step.getId() + "!");
            }
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error when reading step sequence for case with Id " + this.getId() + ": " + sqle.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    public Collection getCrossReferences() throws M4Exception {
        Collection ret = this.getSuccessors();
        return ret;
    }

    protected boolean hasCoordinates() {
        return true;
    }

    protected void storeLocal() throws M4Exception {
        super.storeLocal();
        if (this.dependentStepsDirty) {
            String sql = "DELETE FROM stepsequence_t WHERE sts_stid = " + this.getId();
            this.executeM4SqlWrite(sql);
            Iterator it = this.getSuccessors().iterator();
            String prefix = "INSERT INTO stepsequence_t ( sts_id, sts_stid, sts_successorstid ) VALUES ( ";
            while (it.hasNext()) {
                Step successor = (Step)it.next();
                String sql2 = prefix + this.getNextM4SequenceValue() + ", " + this.getId() + ", " + successor.getId() + " )";
                this.executeM4SqlWrite(sql2);
            }
        }
        this.writeM4TrashToDb();
        this.writeDbTrashToDb();
        this.writeThisStepAsReversedStepToDb();
    }

    protected void setSuccessors(Collection newSuccessors) throws M4Exception {
        Iterator it = new Vector(this.getSuccessors()).iterator();
        while (it.hasNext()) {
            this.removeSuccessor((Step)it.next());
        }
        if (newSuccessors == null || newSuccessors.isEmpty()) {
            return;
        }
        edu.udo.cs.miningmart.m4.Case theCase = this.getTheCase();
        if (theCase != null) {
            it = newSuccessors.iterator();
            while (it.hasNext()) {
                theCase.addStepDependency(this, (Step)it.next());
            }
        } else {
            this.getSuccessors().addAll(newSuccessors);
        }
    }

    protected void removeAllM4References() throws M4Exception {
        this.deleteM4Trash();
        this.deleteDbTrash();
        this.removeAllSuccessorsDuringDelete();
        this.removeAllParametersDuringDelete();
        this.setTheCase(null);
        this.setTheChain(null);
        this.setTheOperator(null);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getParameterTuples());
        return ret;
    }

    private void removeAllSuccessorsDuringDelete() throws M4Exception {
        Collection suc = this.getSuccessors();
        if (suc != null && suc.size() > 0) {
            suc.clear();
            this.dependentStepsDirty = true;
        }
    }

    private void removeAllParametersDuringDelete() throws M4Exception {
        Collection col = this.getParameterTuples();
        if (col != null && !col.isEmpty()) {
            Iterator it = new Vector(col).iterator();
            while (it.hasNext()) {
                this.removeParameterTuple((Parameter)it.next());
            }
        }
    }

    public Collection getM4Trash() throws M4Exception {
        if (!this.allM4TrashLoaded && !this.isNew()) {
            this.allM4TrashLoaded = true;
            try {
                this.readM4TrashFromDb();
            }
            catch (SQLException e) {
                throw new M4Exception("SQLException caught when trying to read M4Trash information from DB:\n" + e.getMessage());
            }
        }
        return this.myM4Trash;
    }

    public void addToTrash(edu.udo.cs.miningmart.m4.M4Data m4data) throws M4Exception {
        if (m4data != null) {
            this.getM4Trash().add(m4data);
        }
        this.setM4TrashDirty();
    }

    public void deleteM4Trash() throws M4Exception {
        Iterator it = this.getM4Trash().iterator();
        try {
            while (it.hasNext()) {
                ((M4Data)it.next()).deleteSoon();
                it.remove();
            }
        }
        catch (ClassCastException cce) {
            System.out.println("CCException in Step " + this.getName() + ": " + cce.getMessage());
            throw cce;
        }
        this.isCompiled = false;
        this.setM4TrashDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readM4TrashFromDb() throws M4Exception, SQLException {
        String sql = "SELECT m4id, m4table FROM m4trash_t WHERE stepid = " + this.getId();
        DB db = this.getM4Db();
        ResultSet rs = null;
        try {
            rs = this.executeM4SqlRead(sql);
            while (rs.next()) {
                Class objClass;
                long objId = rs.getLong(M4_TRASH_ID);
                String table = rs.getString(M4_TRASH_OBJ_TABLE);
                if (table.equalsIgnoreCase("column_t")) {
                    objClass = Column.class;
                } else if (table.equalsIgnoreCase("columnset_t")) {
                    objClass = Columnset.class;
                } else if (table.equalsIgnoreCase("keyhead_t")) {
                    objClass = ForeignKey.class;
                } else {
                    if (table.equals(" ")) {
                        this.isCompiled = true;
                        continue;
                    }
                    throw new M4Exception("Step.readM4TrashFromDb(): Found unsupported M4 table " + table + " in attribute " + M4_TRASH_OBJ_TABLE + " of table " + M4_TRASH_TABLE + "!");
                }
                try {
                    M4Data obj = (M4Data)db.getM4Object(objId, objClass);
                    if (obj == null) continue;
                    this.getM4Trash().add(obj);
                }
                catch (ParameterNotFoundException e) {
                    super.doPrint(Print.COMPILER_STEP_CONTROL, "Garbage Collection for Step " + this.getId() + "did not find object with ID " + objId + " from table " + table + "!");
                }
            }
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    private void setDbTrashDirty() {
        if (!this.dbTrashDirty) {
            this.dbTrashDirty = true;
            this.setDirty();
        }
    }

    public void addDatabaseObjectToTrash(String objectName, String schemaName, String objectType) throws M4Exception {
        String[] trashEntry = this.createDbTrashArray(objectName, schemaName, objectType);
        this.getDbTrash().add(trashEntry);
        this.setDbTrashDirty();
    }

    public void deleteDbTrash() throws M4Exception {
        Iterator it = this.getDbTrash().iterator();
        Vector<Object> vector = new Vector<Object>();
        Vector<String[]> pkList = new Vector<String[]>();
        Vector<String[]> other = new Vector<String[]>();
        Vector<String[]> intermediateViews = new Vector<String[]>();
        while (it.hasNext()) {
            String[] trashArray = (String[])it.next();
            String objectType = trashArray[2];
            if (objectType.equalsIgnoreCase(DBT_TYPE_FOREIGN_KEY)) {
                vector.add(trashArray);
                continue;
            }
            if (objectType.equalsIgnoreCase(DBT_TYPE_PRIMARY_KEY)) {
                pkList.add(trashArray);
                continue;
            }
            if (objectType.equalsIgnoreCase(DBT_TYPE_VIEW)) {
                if (trashArray[0].endsWith("_V")) {
                    intermediateViews.add(trashArray);
                    continue;
                }
                other.add(trashArray);
                continue;
            }
            other.add(trashArray);
        }
        vector.addAll(pkList);
        vector.addAll(other);
        vector.addAll(intermediateViews);
        for (String[] stringArray : vector) {
            String objectName = stringArray[0];
            String schemaName = stringArray[1];
            String objectType = stringArray[2];
            String query = null;
            boolean tableOrView = false;
            if (objectType.equalsIgnoreCase(DBT_TYPE_TABLE)) {
                query = "DROP TABLE ";
                tableOrView = true;
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_VIEW)) {
                query = "DROP VIEW ";
                tableOrView = true;
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_FUNCTION)) {
                query = "DROP FUNCTION ";
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_INDEX)) {
                query = "DROP INDEX ";
            } else if (objectType.equalsIgnoreCase(DBT_TYPE_PRIMARY_KEY) || objectType.equalsIgnoreCase(DBT_TYPE_FOREIGN_KEY)) {
                int dotIndex = objectName.indexOf(46);
                if (dotIndex < 1) {
                    throw new M4Exception("Step.deleteDbTrash: Found invalid constraint primary key or foreign key constraint:\n" + objectType + "'!");
                }
                String table = objectName.substring(0, dotIndex);
                objectName = objectName.substring(dotIndex + 1, objectName.length());
                query = "ALTER TABLE " + (schemaName == null ? "" : schemaName + ".") + table + " DROP CONSTRAINT ";
                schemaName = null;
            } else {
                throw new M4Exception("Step.deleteDbTrash: Unknown object type '" + objectType + "'!");
            }
            if (schemaName != null) {
                query = query + schemaName + ".";
            }
            query = query + objectName;
            try {
                if (tableOrView && (this.getM4Db().getBusinessDbms() == 2 || this.getM4Db().getBusinessDbms() == 3)) {
                    query = query + " CASCADE";
                }
                this.executeBusinessSqlWrite(query);
            }
            catch (M4Exception sqle) {
                this.doPrint(Print.MAX, "WARNING: Error when attempting to remove a database object according to DBTrash_T: " + sqle.getMessage());
                try {
                    this.getM4Db().commitBusinessTransactions();
                }
                catch (DbConnectionClosed dbc) {
                    throw new M4Exception("Closed Db connection during trash deletion:\n" + dbc.getMessage());
                }
                catch (SQLException se) {
                    throw new M4Exception("Error trying to commit transactions during trash deletion:\n" + se.getMessage());
                }
            }
            catch (DbConnectionClosed dbc) {
                throw new M4Exception("Closed Db connection during trash deletion:\n" + dbc.getMessage());
            }
            this.getDbTrash().remove(stringArray);
            this.setDbTrashDirty();
        }
    }

    private Collection getDbTrash() throws M4Exception {
        if (!this.allDbTrashLoaded && !this.isNew()) {
            this.allDbTrashLoaded = true;
            this.readDbTrashFromDb();
        }
        return this.myDbTrash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDbTrashFromDb() throws M4Exception {
        String sql = "SELECT ObjName, SchemaName, ObjType FROM dbtrash_t WHERE StepId = " + this.getId();
        ResultSet rs = null;
        try {
            rs = this.executeM4SqlRead(sql);
            while (rs.next()) {
                String[] trashEntry = this.createDbTrashArray(rs.getString(ATTRIB_DBT_OBJNAME), rs.getString(ATTRIB_DBT_SCHEMA), rs.getString(ATTRIB_DBT_OBJTYPE));
                this.myDbTrash.add(trashEntry);
            }
        }
        catch (SQLException e) {
            this.doPrint(Print.MAX, "WARNING: Error when attempting to read a database object from dbtrash_t for step " + this.getId() + ":\n" + e.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    private void writeDbTrashToDb() throws M4Exception {
        if (this.dbTrashDirty) {
            String query = "DELETE FROM dbtrash_t WHERE StepId = " + this.getId();
            this.executeM4SqlWrite(query);
            String attributes = "ObjType, ObjName, SchemaName, StepId";
            for (String[] trashArray : this.getDbTrash()) {
                String objectName = trashArray[0];
                String schemaName = trashArray[1];
                String objectType = trashArray[2];
                schemaName = schemaName == null || schemaName.equals("") ? "NULL" : DB.quote(schemaName);
                query = "INSERT INTO dbtrash_t (ObjType, ObjName, SchemaName, StepId) VALUES (" + DB.quote(objectType) + ", " + DB.quote(objectName) + ", " + schemaName + ", " + this.getId() + ")";
                this.executeM4SqlWrite(query);
            }
        }
        this.dbTrashDirty = false;
    }

    private String[] createDbTrashArray(String objectName, String schemaName, String objectType) throws M4Exception {
        if (!(objectType.equals(DBT_TYPE_FUNCTION) || objectType.equals(DBT_TYPE_INDEX) || objectType.equals(DBT_TYPE_TABLE) || objectType.equals(DBT_TYPE_VIEW) || objectType.equals(DBT_TYPE_PRIMARY_KEY) || objectType.equals(DBT_TYPE_FOREIGN_KEY))) {
            throw new M4Exception("Error adding a database object to trash: Unknown type: " + objectType + "!");
        }
        if (schemaName != null && schemaName.length() == 0) {
            schemaName = null;
        }
        String[] trashEntry = new String[]{objectName, schemaName, objectType};
        return trashEntry;
    }

    public boolean isCompiled() throws M4Exception {
        this.getM4Trash();
        return this.isCompiled;
    }

    public void setCompiled() throws M4Exception {
        this.getM4Trash();
        this.isCompiled = true;
        this.setM4TrashDirty();
    }

    private void setM4TrashDirty() {
        this.m4trashDirty = true;
        this.setDirty();
    }

    private void writeM4TrashToDb() throws M4Exception {
        if (this.m4trashDirty) {
            this.m4trashDirty = false;
            String delSql = "DELETE FROM m4trash_t WHERE stepid = " + this.getId();
            this.executeM4SqlWrite(delSql);
            String sqlPre = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( ";
            String sqlPost = ", " + this.getId() + " )";
            for (M4Data m4data : this.getM4Trash()) {
                if (m4data.isWaitingForDelete()) continue;
                long objId = m4data.getId();
                String table = m4data.getM4TableName();
                String sql = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( " + objId + ", " + DB.quote(table) + sqlPost;
                this.executeM4SqlWrite(sql);
            }
            if (this.isCompiled()) {
                String sql = "INSERT INTO m4trash_t ( m4id, m4table, stepid ) VALUES ( 0, ' '" + sqlPost;
                this.executeM4SqlWrite(sql);
            }
        }
    }

    public edu.udo.cs.miningmart.m4.Step getPredecessor() throws M4Exception {
        Iterator it = this.getTheCase().getReverseIterator();
        boolean currentStepFound = false;
        while (it.hasNext()) {
            Step step = (Step)it.next();
            if (this.equals(step)) {
                currentStepFound = true;
                continue;
            }
            if (!currentStepFound || !this.getTheCase().containsDependency(step, this)) continue;
            return step;
        }
        return null;
    }

    public Collection getAllPredecessors() throws M4Exception {
        if (this.getTheCase() == null) {
            return null;
        }
        Iterator it = this.getTheCase().getReverseIterator();
        boolean currentStepFound = false;
        Vector<Step> thePredecessors = new Vector<Step>();
        while (it.hasNext()) {
            Step step = (Step)it.next();
            if (this.equals(step)) {
                currentStepFound = true;
                continue;
            }
            if (!currentStepFound || !this.getTheCase().containsDependency(step, this)) continue;
            thePredecessors.add(step);
        }
        return thePredecessors;
    }

    public Collection getDependentReversingSteps() throws M4Exception {
        if (this.myReversingSteps == null) {
            this.readReversingStepsFromDb();
        }
        return this.myReversingSteps;
    }

    private void readReversingStepsFromDb() throws M4Exception {
        this.myReversingSteps = new Vector();
        try {
            if (!this.reversingStepsTableExistsInM4()) {
                return;
            }
            String query = "SELECT rev_id, rev_revstid FROM revstep_t WHERE rev_orgstid = " + this.getId();
            ResultSet rs = this.executeM4SqlRead(query);
            while (rs.next()) {
                long revStepId = rs.getLong(ATTRIB_REV_REVSTEP);
                Step revStep = (Step)this.getM4Db().getM4Object(revStepId, Step.class);
                this.myReversingSteps.add(revStep);
                revStep.theStepThisStepReverses = this;
            }
            rs.close();
        }
        catch (SQLException se) {
            throw new M4Exception("Step '" + this.getName() + "': SQL error reading reversing steps from DB: " + se.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Step '" + this.getName() + "': M4 error reading reversing steps from DB: " + m4e.getMessage());
        }
    }

    private void writeThisStepAsReversedStepToDb() throws M4Exception {
        if (this.getDependentReversingSteps().isEmpty()) {
            return;
        }
        try {
            if (!this.reversingStepsTableExistsInM4()) {
                return;
            }
            long reversedStepId = this.getId();
            for (Step reversingStep : this.myReversingSteps) {
                long reversingStepId = reversingStep.getId();
                String query = "SELECT rev_orgstid FROM revstep_t WHERE rev_revstid = " + reversingStepId + " AND " + ATTRIB_REV_ORIGSTEP + " = " + reversedStepId;
                ResultSet rs = this.executeM4SqlRead(query);
                if (rs.next()) {
                    query = "UPDATE revstep_t SET rev_orgstid = " + reversedStepId + " WHERE " + ATTRIB_REV_REVSTEP + " = " + reversingStepId;
                } else {
                    long newId = this.getM4Db().getNextM4SequenceValue();
                    query = "INSERT INTO revstep_t (rev_id, rev_orgstid, rev_revstid) VALUES (" + newId + ", " + reversedStepId + ", " + reversingStepId + ")";
                }
                this.executeM4SqlWrite(query);
            }
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Step '" + this.getName() + "': DB connection closed when writing reversing step to DB: " + d.getMessage());
        }
        catch (SQLException se) {
            throw new M4Exception("Step '" + this.getName() + "': SQL error writing reversing step to DB: " + se.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Step '" + this.getName() + "': M4 error writing reversing step to DB: " + m4e.getMessage());
        }
    }

    private boolean reversingStepsTableExistsInM4() throws M4Exception {
        return this.getM4Db().tableExistsInM4(REVSTEP_TABLENAME);
    }

    public Collection exportLocal(Writer out, Collection dependent) throws M4Exception, IOException {
        Collection theStepsThatReverseThisStep = this.getDependentReversingSteps();
        if (theStepsThatReverseThisStep == null || theStepsThatReverseThisStep.isEmpty()) {
            return null;
        }
        Vector<String> ret = new Vector<String>();
        for (Step revStep : theStepsThatReverseThisStep) {
            long xmlIdOfReversedStep = M4Xml.export(revStep, out, dependent);
            String xmlIdentification = M4Xml.putInXmlTags(xmlIdOfReversedStep + "", "XmlId");
            String xmlDescription = M4Xml.putInXmlTags(xmlIdentification, EXPORT_TAG_REVERSING_STEPS);
            ret.add(xmlDescription);
        }
        return ret;
    }

    public void importLocal(String tag, String embedded) throws XmlException, M4Exception {
        if (tag.equals(EXPORT_TAG_REVERSING_STEPS)) {
            if (!this.reversingStepsTableExistsInM4()) {
                return;
            }
            String[] tags = M4Xml.stripOuterTag(embedded);
            if (tags == null) {
                return;
            }
            String xmlTag = tags[0];
            if (!xmlTag.equals("XmlId")) {
                throw new M4Exception("Error importing steps that reverse step '" + this.getName() + "': found wrong tag in Step.importLocal()!");
            }
            String xmlId = tags[1];
            Object o = M4Xml.createObjectFromXml(xmlTag, xmlId);
            if (!(o instanceof Step)) {
                throw new M4Exception("Error importing steps that reverse step '" + this.getName() + "': found wrong object type in Step.importLocal()!");
            }
            Step reversingStep = (Step)o;
            this.addReversingStep(reversingStep);
        }
    }

    public boolean belongsToChainOrSubChain(Chain theChain2) throws M4Exception {
        if (theChain2 == null) {
            return true;
        }
        if (this.getTheChain().equals(theChain2)) {
            return true;
        }
        for (Chain theChain2 : theChain2.getDirectSubChains()) {
            if (!this.belongsToChainOrSubChain(theChain2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPredecessorOutsideChain() throws M4Exception {
        Iterator predIt = this.getAllPredecessors().iterator();
        edu.udo.cs.miningmart.m4.core.Chain myChain = (edu.udo.cs.miningmart.m4.core.Chain)this.getTheChain();
        while (predIt.hasNext()) {
            Step aStep = (Step)predIt.next();
            if (aStep.belongsToChainOrSubChain(myChain)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSuccessorOutsideChain() throws M4Exception {
        Iterator succIt = this.getSuccessors().iterator();
        edu.udo.cs.miningmart.m4.core.Chain myChain = (edu.udo.cs.miningmart.m4.core.Chain)this.getTheChain();
        while (succIt.hasNext()) {
            Step aStep = (Step)succIt.next();
            if (aStep.belongsToChainOrSubChain(myChain)) continue;
            return true;
        }
        return false;
    }

    public void removePredecessor() throws M4Exception {
        Step fromStep = (Step)this.getPredecessor();
        this.getTheCase().removeStepDependency(fromStep, this);
    }

    public edu.udo.cs.miningmart.m4.Parameter getParameterTuple(String name, int loopNr) throws M4Exception {
        Iterator it;
        Collection col = this.getParameterTuples();
        if (name != null && col != null && (it = col.iterator()) != null) {
            while (it.hasNext()) {
                Parameter par = (Parameter)it.next();
                if (par == null || !par.getName().startsWith(name) || par.getLoopNr() != loopNr) continue;
                return par;
            }
        }
        return null;
    }

    public ParameterObject getSingleParameterObject(String parameterName) {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] pos = this.getParameter(parameterName, 0);
        if (pos == null || pos.length == 0) {
            return null;
        }
        return pos[0];
    }

    private ParameterArray getParameterArray(edu.udo.cs.miningmart.m4.OpParam theOperatorParameter, int loopNumber) throws M4Exception {
        Collection allParamTuples = this.getParameterTuples();
        Iterator tupleIt = allParamTuples.iterator();
        edu.udo.cs.miningmart.m4.core.ParameterArray thePA = new edu.udo.cs.miningmart.m4.core.ParameterArray(theOperatorParameter.getType());
        while (tupleIt.hasNext()) {
            Parameter myParam = (Parameter)tupleIt.next();
            if (!this.parameterNamesMatch(theOperatorParameter.getName(), myParam) || myParam.getLoopNr() != loopNumber) continue;
            thePA.addParameter(myParam);
        }
        if (thePA.size() == 0) {
            return null;
        }
        return thePA;
    }

    private boolean parameterNamesMatch(String name, Parameter param) {
        String parName = param.getName();
        if (parName.startsWith(name)) {
            String suffix = parName.substring(name.length());
            if (suffix.length() == 0) {
                return true;
            }
            try {
                Integer.parseInt(suffix);
                return true;
            }
            catch (NumberFormatException n) {
                return false;
            }
        }
        return false;
    }

    public edu.udo.cs.miningmart.m4.Parameter createParameterTuple(String name, ParameterObject object, long number, int loopNumber, String ioType) throws M4Exception {
        if (this.getTheOperator().getOpParam(this.getParameterNameWithoutSuffix(name)) == null) {
            throw new M4Exception("Step.createParameter(...): name '" + name + "' is not an allowed parameter of operator '" + this.getTheOperator().getName() + "'!");
        }
        Parameter par = (Parameter)this.getM4Db().createNewInstance(Parameter.class);
        par.setParameterName(name);
        par.setParamNr(number);
        par.setInputParam(ioType);
        par.setTheStep(this);
        par.setTheParameterObject(object);
        par.setTheOperator(this.getTheOperator());
        par.setLoopNr(loopNumber);
        return par;
    }

    public edu.udo.cs.miningmart.m4.Parameter createValueParameterTuple(String value, String datatype, String name, long number, int loopNumber, String type) throws M4Exception {
        Value newVal = (Value)this.getM4Db().createNewInstance(Value.class);
        newVal.setName(name);
        newVal.setType(datatype);
        newVal.setValue(value);
        return this.createParameterTuple(name, newVal, number, loopNumber, type);
    }

    public edu.udo.cs.miningmart.m4.Step copy(edu.udo.cs.miningmart.m4.Case newCase, Chain newChain) throws M4Exception {
        Step theCopy = new Step(this.getM4Db());
        try {
            theCopy.setTheCase(newCase);
            theCopy.setTheChain(newChain);
            theCopy.setLoopCount(this.getLoopCount());
            theCopy.setMultiStepCondition(this.getMultiStepCondition());
            String nameOfCopy = newChain.getValidName(this.getName(), Step.class);
            theCopy.setName(nameOfCopy);
            theCopy.setNumber(this.getNumber());
            theCopy.setTheOperator(this.getTheOperator());
            theCopy.setNumber(this.getNumber());
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Could not create copy of Step " + this.getId() + ": " + m4e.getMessage());
        }
        return theCopy;
    }

    public Collection getParameter(edu.udo.cs.miningmart.m4.OpParam theOpParam, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] parObjArray = this.getParameter(theOpParam.getName(), loopNr);
        if (parObjArray == null) {
            return null;
        }
        Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> vec = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
        for (int i = 0; i < parObjArray.length; ++i) {
            vec.add(parObjArray[i]);
        }
        return vec;
    }

    public Map setParameter(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theParameterObjects, int loopNr) throws M4Exception {
        if (theParameterObjects == null) {
            throw new M4Exception("Step.setParameter() was called with >null< Collection 'theParameterObjects'!");
        }
        if (theOpParam.isValueParameter()) {
            Vector<Value> newValueObjects = new Vector<Value>();
            for (edu.udo.cs.miningmart.m4.core.ParameterObject parameterObject : theParameterObjects) {
                if (!(parameterObject instanceof Value)) {
                    throw new M4Exception("Step.setParameter() was called with a Value OpParam but non-Value parameter objects!");
                }
                Value v = (Value)this.getM4Db().createNewInstance(Value.class);
                v.setDocumentation(parameterObject.getDocumentation());
                v.setType(((Value)parameterObject).getTypeName());
                v.setValue(((Value)parameterObject).getValue());
                v.setName(parameterObject.getName());
                newValueObjects.add(v);
            }
            theParameterObjects = newValueObjects;
        }
        String parameterName = theOpParam.getName();
        ParameterArray paOld = null;
        HashMap hashMap = new HashMap();
        paOld = this.getParameterArray(theOpParam, loopNr);
        boolean needsSuffix = theOpParam.isArray() || theOpParam.isLoopable() || loopNr > 0 || paOld != null && paOld.size() > 1 || theParameterObjects.size() > 1;
        String inputOutputString = theOpParam.getInput();
        M4Object oldParameterObject = null;
        edu.udo.cs.miningmart.m4.core.ParameterObject newParameterObject = null;
        if (paOld == null) {
            if (!theParameterObjects.isEmpty()) {
                Iterator it = theParameterObjects.iterator();
                while (it.hasNext()) {
                    edu.udo.cs.miningmart.m4.core.ParameterObject parObj;
                    newParameterObject = parObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)it.next();
                    long freeParNum = this.getFreeParameterNumber();
                    int freeSuffixNum = this.getFreeParameterSuffix(theOpParam);
                    this.createParameterTuple(needsSuffix ? parameterName + freeSuffixNum : parameterName, parObj, freeParNum, loopNr, inputOutputString);
                }
            }
        } else {
            Parameter oldPar;
            int index;
            Object[] copyOfOldParams = paOld.getParameters().toArray();
            Object[] copyOfParObjs = theParameterObjects.toArray();
            for (index = 0; index < copyOfOldParams.length && index < copyOfParObjs.length; ++index) {
                oldPar = (Parameter)copyOfOldParams[index];
                oldParameterObject = (edu.udo.cs.miningmart.m4.core.ParameterObject)oldPar.getTheParameterObject();
                edu.udo.cs.miningmart.m4.core.ParameterObject newParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)copyOfParObjs[index];
                if (!theOpParam.isInput()) {
                    if (!this.checkOccurrence((Object)oldParameterObject, copyOfParObjs)) {
                        this.handleOldOutput(oldPar, hashMap, newParObj);
                        this.giveValidOutputObjectName(newParObj, newParObj.getName());
                    }
                } else {
                    this.handleOutputCreatedByOldInput(theOpParam, oldPar);
                }
                newParameterObject = newParObj;
                oldPar.setTheParameterObject(newParObj);
            }
            while (index < copyOfOldParams.length) {
                oldPar = (Parameter)copyOfOldParams[index];
                oldParameterObject = (edu.udo.cs.miningmart.m4.core.ParameterObject)oldPar.getTheParameterObject();
                if (!theOpParam.isInput()) {
                    this.handleOldOutput(oldPar, hashMap, null);
                }
                this.removeParameterTuple(oldPar);
                oldPar.deleteSoon();
                ++index;
            }
            while (index < copyOfParObjs.length) {
                edu.udo.cs.miningmart.m4.core.ParameterObject newParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)copyOfParObjs[index];
                long freeParameterNumber = this.getFreeParameterNumber();
                int freeSuffixNum = this.getFreeParameterSuffix(theOpParam);
                this.createParameterTuple(needsSuffix ? parameterName + freeSuffixNum : parameterName, newParObj, freeParameterNumber, loopNr, inputOutputString);
                ++index;
            }
        }
        if (oldParameterObject != null && theOpParam.isInput() && theOpParam.isConceptParameter() && !oldParameterObject.equals(newParameterObject)) {
            if (!(oldParameterObject instanceof Concept) || newParameterObject != null && !(newParameterObject instanceof Concept)) {
                throw new M4Exception("Step.setParameter(): found something that is not a concept as (old) parameter object of a concept parameter!");
            }
            this.oldInputConcept = (Concept)oldParameterObject;
            this.replacingConcept = (Concept)newParameterObject;
        }
        return hashMap;
    }

    private void handleOldOutput(edu.udo.cs.miningmart.m4.Parameter oldOutput, Map mapParametersToOldNames, ParameterObject newObject) throws M4Exception {
        if (oldOutput == null || mapParametersToOldNames == null) {
            return;
        }
        if (mapParametersToOldNames.get(oldOutput) != null) {
            return;
        }
        edu.udo.cs.miningmart.m4.core.ParameterObject oldParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)oldOutput.getTheParameterObject();
        if (oldParObj == null) {
            return;
        }
        if (oldParObj instanceof edu.udo.cs.miningmart.m4.core.Feature) {
            edu.udo.cs.miningmart.m4.core.Feature outF = (edu.udo.cs.miningmart.m4.core.Feature)oldParObj;
            Collection inputParamsUsingOutF = this.getInputParametersUsingFeature(outF);
            String newName = newObject != null ? newObject.getName() : null;
            this.createMapOfInputParamsToNames(inputParamsUsingOutF, mapParametersToOldNames, oldParObj.getName(), newName);
            oldParObj.deleteSoon();
        }
    }

    private void handleOutputCreatedByOldInput(edu.udo.cs.miningmart.m4.OpParam inputOpParam, Parameter oldPar) throws M4Exception {
        Collection constraints = inputOpParam.getApplicableConstraints();
        for (edu.udo.cs.miningmart.m4.core.Constraint inputConstraint : constraints) {
            Collection names;
            edu.udo.cs.miningmart.m4.core.BaseAttribute inputBA;
            Map namesMap;
            if (!(oldPar.getTheParameterObject() instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute) || (namesMap = this.getMapOfNamesToNamesWithSuffixes(inputConstraint, new String[]{(inputBA = (edu.udo.cs.miningmart.m4.core.BaseAttribute)oldPar.getTheParameterObject()).getName()})) == null || (names = (Collection)namesMap.get(inputBA.getName())) == null) continue;
            this.deleteFeaturesFromConcept(names, (Concept)this.getOutputConcept());
        }
    }

    private void deleteFeaturesFromConcept(Collection namesOfFeatures, Concept theConcept) throws M4Exception {
        if (namesOfFeatures == null || namesOfFeatures.isEmpty() || theConcept == null) {
            return;
        }
        Collection bas = theConcept.getAllBaseAttributes();
        for (edu.udo.cs.miningmart.m4.core.BaseAttribute ba : bas) {
            if (!namesOfFeatures.contains(ba.getName())) continue;
            theConcept.removeBaseAttribute(ba.getName());
        }
    }

    private void giveValidOutputObjectName(edu.udo.cs.miningmart.m4.core.ParameterObject newOutputObject, String newName) throws M4Exception {
        if (newOutputObject instanceof Concept) {
            String validName = ((Case)this.getTheCase()).getValidName(newName, Concept.class, newOutputObject);
            newOutputObject.setName(validName);
            return;
        }
        if (newOutputObject instanceof edu.udo.cs.miningmart.m4.core.Feature) {
            Collection allOutputNames = this.getAllNamesOfOutputAttribsOfDependentSteps();
            String validName = this.getUniqueName(newName, allOutputNames);
            newOutputObject.setName(validName);
        }
    }

    private Collection getAllNamesOfOutputAttribsOfDependentSteps() throws M4Exception {
        Vector ret = new Vector();
        for (Step succStep : this.getSuccessors()) {
            succStep.getNamesOfOutputAttribs(ret);
        }
        return ret;
    }

    private void getNamesOfOutputAttribs(Collection namesSoFar) throws M4Exception {
        if (this.getTheOperator() == null) {
            return;
        }
        Collection outOpParams = this.getTheOperator().getAllOutputOperatorParameters();
        for (OpParam anOpPar : outOpParams) {
            if (!anOpPar.isBaseAttribParameter() && !anOpPar.isFeatureParameter()) continue;
            Collection attribs = this.getParameterObjects(anOpPar.getName());
            for (edu.udo.cs.miningmart.m4.core.Feature f : attribs) {
                if (namesSoFar.contains(f.getName())) continue;
                namesSoFar.add(f.getName());
            }
        }
        for (Step succStep : this.getSuccessors()) {
            succStep.getNamesOfOutputAttribs(namesSoFar);
        }
    }

    private Collection getInputParametersUsingFeature(edu.udo.cs.miningmart.m4.core.Feature theFeature) throws M4Exception {
        if (theFeature == null) {
            return new Vector();
        }
        Collection paramsUsingFeatureDirectly = this.getInputParametersFor(theFeature);
        for (Step successor : this.getSuccessors()) {
            Collection copiesOfTheFeature = successor.getCorrespondingOutputFeatures(theFeature.getConcept(), theFeature);
            if (copiesOfTheFeature == null) continue;
            for (edu.udo.cs.miningmart.m4.core.Feature copyOfTheFeature : copiesOfTheFeature) {
                Collection additionalParams = successor.getInputParametersUsingFeature(copyOfTheFeature);
                for (Parameter aPar : additionalParams) {
                    if (paramsUsingFeatureDirectly.contains(aPar)) continue;
                    paramsUsingFeatureDirectly.add(aPar);
                }
            }
        }
        return paramsUsingFeatureDirectly;
    }

    private Collection getInputParametersFor(edu.udo.cs.miningmart.m4.core.Feature f) throws M4Exception {
        Collection paramsUsingFeatureDirectly = f.getParameterReferences();
        Vector<Parameter> ret = new Vector<Parameter>();
        for (Parameter onePar : paramsUsingFeatureDirectly) {
            if (!onePar.isInputParam()) continue;
            ret.add(onePar);
        }
        return ret;
    }

    private void createMapOfInputParamsToNames(Collection inputParams, Map mapParametersToNames, String oldName, String newName) throws M4Exception {
        if (oldName == null) {
            return;
        }
        for (Parameter aPar : inputParams) {
            if (aPar == null || aPar.getTheStep() == null || aPar.getTheStep().equals(this) || !aPar.isInputParam() || aPar.getTheParameterObject() == null) continue;
            String oldNameWithLoop = this.addLoopNumberToName(oldName, aPar.getLoopNr());
            String newNameWithLoop = newName != null ? this.addLoopNumberToName(newName, aPar.getLoopNr()) : null;
            String[] pairOfOldAndNewName = new String[]{oldNameWithLoop, newNameWithLoop};
            mapParametersToNames.put(aPar, pairOfOldAndNewName);
        }
    }

    private boolean checkOccurrence(Object anObject, Object[] anArray) {
        for (int i = 0; i < anArray.length; ++i) {
            if (!anArray[i].equals(anObject)) continue;
            return true;
        }
        return false;
    }

    private boolean checkOccurrence(Object anObject, Collection aColl) {
        if (aColl != null) {
            for (Object myObj : aColl) {
                if (!anObject.equals(myObj)) continue;
                return true;
            }
        }
        return false;
    }

    private int getHighestLoopNr(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        Iterator parIt = this.getParameterTuples(theOpParam).iterator();
        int highestLoopNr = 0;
        while (parIt.hasNext()) {
            Parameter myPar = (Parameter)parIt.next();
            if (myPar.getLoopNr() <= highestLoopNr) continue;
            highestLoopNr = myPar.getLoopNr();
        }
        return highestLoopNr;
    }

    private long getFreeParameterNumber() throws M4Exception {
        Collection theTuples = this.getParameterTuples();
        boolean found = false;
        long candidateNumber = 0L;
        while (!found) {
            Iterator it = theTuples.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                Parameter myPar = (Parameter)it.next();
                long number = myPar.getParamNr();
                if (number != candidateNumber) continue;
                ++candidateNumber;
                changed = true;
            }
            if (changed) continue;
            found = true;
        }
        return candidateNumber;
    }

    private int getFreeParameterSuffix(edu.udo.cs.miningmart.m4.OpParam anOpPar) throws M4Exception {
        Collection theTuples = this.getParameterTuples(anOpPar);
        boolean found = false;
        int candidateSuffix = 0;
        while (!found) {
            Iterator it = theTuples.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                Parameter myPar = (Parameter)it.next();
                int suffix = this.getParameterNameSuffix(myPar);
                if (suffix != candidateSuffix) continue;
                ++candidateSuffix;
                changed = true;
            }
            if (changed) continue;
            found = true;
        }
        return candidateSuffix;
    }

    private int getParameterNameSuffix(Parameter aPar) {
        String parName = aPar.getName();
        int pos = parName.length() - 1;
        while (Character.isDigit(parName.charAt(pos))) {
            --pos;
        }
        if (pos == parName.length() - 1) {
            return -1;
        }
        return Integer.parseInt(parName.substring(pos + 1));
    }

    private String getParameterNameWithoutSuffix(String parName) {
        int pos = parName.length() - 1;
        while (Character.isDigit(parName.charAt(pos))) {
            --pos;
        }
        if (pos == -1) {
            return null;
        }
        return parName.substring(0, pos + 1);
    }

    private void deleteOutputs() throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Operator op = (edu.udo.cs.miningmart.m4.core.Operator)this.getTheOperator();
        if (op != null) {
            Iterator outputOpParIt = op.getAllOutputOperatorParameters().iterator();
            int loops = this.getLoopCount();
            if (loops == 0) {
                loops = 1;
            }
            boolean thisStepHadAnOutputConcept = false;
            while (outputOpParIt.hasNext()) {
                OpParam outOpPar = (OpParam)outputOpParIt.next();
                int startLoop = outOpPar.isLoopable() && loops > 1 ? 1 : 0;
                int endLoop = loops;
                for (int loopNr = startLoop; loopNr <= endLoop; ++loopNr) {
                    Collection parObjs = this.getParameter(outOpPar, loopNr);
                    if (parObjs == null) continue;
                    for (edu.udo.cs.miningmart.m4.core.ParameterObject myParObj : parObjs) {
                        myParObj.deleteSoon();
                    }
                }
                if (!outOpPar.isConceptParameter()) continue;
                thisStepHadAnOutputConcept = true;
            }
            if (!thisStepHadAnOutputConcept) {
                this.propagateOutputChanges();
            }
        }
    }

    public void handleOldInput() throws M4Exception {
        if (this.oldInputConcept == null || this.replacingConcept == null) {
            return;
        }
        this.makeInputConceptChanges(this.oldInputConcept, this.replacingConcept);
        this.oldInputConcept = null;
        this.replacingConcept = null;
    }

    private void makeInputConceptChanges(edu.udo.cs.miningmart.m4.Concept oldInputConcept, edu.udo.cs.miningmart.m4.Concept newInputConcept) throws M4Exception {
        Collection successorsWithSameOldInputConcept;
        if (oldInputConcept != null && newInputConcept != null && this.getTheOperator() != null && (successorsWithSameOldInputConcept = this.getSuccessorsUntilOutputConceptIsCreated()) != null && !successorsWithSameOldInputConcept.isEmpty()) {
            String message = "Some successor steps use the previous input concept '" + oldInputConcept.getName() + "':\n";
            for (Step mySuccessor : successorsWithSameOldInputConcept) {
                if (mySuccessor.equals(this)) continue;
                message = message + " - " + mySuccessor.getName() + "\n";
            }
            int answer = JOptionPane.showConfirmDialog(null, message = message + "Should it be replaced by the new concept '" + newInputConcept.getName() + "' in those steps, too?", "Replace concepts?", 0);
            if (answer == 0) {
                for (Step mySuccessor : successorsWithSameOldInputConcept) {
                    mySuccessor.changeInputConcept(oldInputConcept, newInputConcept);
                    for (OpParam outOpPar : mySuccessor.getTheOperator().getAllOutputOperatorParameters()) {
                        if (!outOpPar.isBaseAttribParameter() && !outOpPar.isFeatureParameter()) continue;
                        Collection coll = this.getParameterTuples(outOpPar);
                        for (Parameter myPar : coll) {
                            edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)myPar.getTheParameterObject();
                            if (!oldInputConcept.hasFeature((edu.udo.cs.miningmart.m4.core.Feature)myParObj)) continue;
                            oldInputConcept.removeFeature((edu.udo.cs.miningmart.m4.core.Feature)myParObj);
                        }
                    }
                }
            }
        }
    }

    public boolean checkInputParameterEntries() throws M4Exception {
        Collection allConstraints;
        String errorMsg = null;
        int numLoops = this.getLoopCount();
        Collection opParams = this.getTheOperator().getOpParams();
        Iterator it = opParams.iterator();
        while (it.hasNext()) {
            OpParam opPar = (OpParam)it.next();
            if (!opPar.isInput()) continue;
            String parName = opPar.getName();
            if (numLoops > 0 && opPar.isLoopable()) {
                for (int i = 1; i <= numLoops; ++i) {
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray = this.getParameter(parName, i);
                    if (pArray == null) {
                        throw new M4Exception("Step '" + this.getName() + "', Parameter '" + parName + "', Loop " + i + ": no parameter object(s) found!");
                    }
                    errorMsg = this.checkSingleLoopOpParam(opPar, pArray);
                    if (errorMsg == null) continue;
                    errorMsg = errorMsg + " (loop: " + i + ") ";
                }
                continue;
            }
            errorMsg = this.checkSingleLoopOpParam(opPar, this.getParameter(parName, 0));
        }
        if (errorMsg == null) {
            allConstraints = this.getTheOperator().getConstraints();
            HashMap<String, Vector<edu.udo.cs.miningmart.m4.core.Constraint>> datatypeConstraints = new HashMap<String, Vector<edu.udo.cs.miningmart.m4.core.Constraint>>();
            if (allConstraints != null && (it = allConstraints.iterator()) != null) {
                while (it.hasNext() && errorMsg == null) {
                    edu.udo.cs.miningmart.m4.core.Constraint constraint = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
                    if (constraint.getType().equals("TYPE")) {
                        Vector<edu.udo.cs.miningmart.m4.core.Constraint> listOfConstraints = (Vector<edu.udo.cs.miningmart.m4.core.Constraint>)datatypeConstraints.get(constraint.getObj1());
                        if (listOfConstraints == null) {
                            listOfConstraints = new Vector<edu.udo.cs.miningmart.m4.core.Constraint>();
                            datatypeConstraints.put(constraint.getObj1(), listOfConstraints);
                        }
                        listOfConstraints.add(constraint);
                        continue;
                    }
                    errorMsg = this.checkInputTypeConstraint(constraint);
                }
            }
            if (errorMsg == null) {
                for (Map.Entry myEntry : datatypeConstraints.entrySet()) {
                    OpParam obj1OpPar;
                    int loopNum;
                    Vector listOfConstraints = (Vector)myEntry.getValue();
                    if (listOfConstraints.size() == 1) {
                        errorMsg = this.checkInputTypeConstraint((edu.udo.cs.miningmart.m4.core.Constraint)listOfConstraints.get(0));
                        if (errorMsg == null) continue;
                        break;
                    }
                    String obj1 = (String)myEntry.getKey();
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray = this.getParameter(obj1, loopNum = (obj1OpPar = (OpParam)this.getTheOperator().getOpParam(obj1)).isLoopable() && this.getLoopCount() > 0 ? 1 : 0);
                    if (pArray == null || pArray.length == 0 || pArray[0] == null) {
                        if (obj1OpPar.isOptional()) break;
                        throw new UserError("Constraint TYPE violated. No object(s) for mandatory parameter '" + obj1 + "' found!");
                    }
                    boolean oneConstraintFulfilledByEachObject = true;
                    for (int i = 0; i < pArray.length; ++i) {
                        Iterator constrIt = listOfConstraints.iterator();
                        boolean oneConstraintFulfilledByCurrentObject = false;
                        while (constrIt.hasNext()) {
                            edu.udo.cs.miningmart.m4.core.Constraint myConstr = (edu.udo.cs.miningmart.m4.core.Constraint)constrIt.next();
                            String localErrorMsg = this.checkDatatypeConstraint(pArray[i], myConstr.getObj2());
                            if (localErrorMsg == null) {
                                oneConstraintFulfilledByCurrentObject = true;
                                continue;
                            }
                            errorMsg = localErrorMsg;
                        }
                        if (oneConstraintFulfilledByCurrentObject) continue;
                        oneConstraintFulfilledByEachObject = false;
                    }
                    if (!oneConstraintFulfilledByEachObject) continue;
                    errorMsg = null;
                }
            }
        }
        if (errorMsg != null && this.getTheOperator().getName().equals("MultiRelationalFeatureConstruction")) {
            allConstraints = this.getTheOperator().getConstraints();
            Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> inputConcepts = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
            Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> attribsInInputConcept = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
            if (allConstraints != null && (it = allConstraints.iterator()) != null) {
                while (it.hasNext()) {
                    int i;
                    edu.udo.cs.miningmart.m4.core.Constraint constraint = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
                    if (!constraint.getType().equals("IN")) continue;
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] concepts = this.getParameter(constraint.getObj2(), 0);
                    edu.udo.cs.miningmart.m4.core.ParameterObject[] attribs = this.getParameter(constraint.getObj1(), 0);
                    if (concepts == null) continue;
                    for (i = 0; i < attribs.length; ++i) {
                        attribsInInputConcept.add(attribs[i]);
                    }
                    for (i = 0; i < concepts.length; ++i) {
                        inputConcepts.add(concepts[i]);
                    }
                }
            }
            Iterator attrIt = attribsInInputConcept.iterator();
            errorMsg = null;
            while (attrIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute myBA = (edu.udo.cs.miningmart.m4.core.BaseAttribute)attrIt.next();
                Iterator concIt = inputConcepts.iterator();
                boolean found = false;
                while (concIt.hasNext()) {
                    Concept myCon = (Concept)concIt.next();
                    if (myCon.getBaseAttribute(myBA.getName()) == null) continue;
                    found = true;
                }
                if (found) continue;
                errorMsg = "Step '" + this.getName() + "': BaseAttribute '" + myBA.getName() + "' does not belong to any of the input concepts!";
            }
        }
        if (errorMsg == null) {
            return true;
        }
        throw new UserError(errorMsg + " in step '" + this.getName() + "' (Id " + this.getId() + ")");
    }

    public boolean checkOutputParameterEntries() throws M4Exception, UserError {
        Collection out = this.getTheOperator().getAllOutputOperatorParameters();
        String pref = "Step '" + this.getName() + "'";
        String errorPrefix = "";
        if (out == null || out.isEmpty()) {
            return true;
        }
        for (OpParam outputOpParam : out) {
            String errPref = pref + ", output parameter '" + outputOpParam.getName() + "'";
            if (outputOpParam.isOptional()) continue;
            int startloop = 0;
            int endloop = 0;
            if (outputOpParam.isLoopable() && this.getLoopCount() > 0) {
                startloop = 1;
                endloop = this.getLoopCount();
            }
            for (int loop = startloop; loop <= endloop; ++loop) {
                errorPrefix = startloop > 0 ? errPref + ", loop " + loop + ": " : errPref + ": ";
                Collection itsTuples = this.getParameterTuples(outputOpParam, loop);
                if (itsTuples == null || itsTuples.isEmpty()) {
                    throw new UserError(errorPrefix + "no entries found, but parameter is not optional!");
                }
                if (outputOpParam.getMinArg() > itsTuples.size()) {
                    throw new UserError(errorPrefix + "at least " + outputOpParam.getMinArg() + " entries are needed!");
                }
                if (outputOpParam.getMaxArg() > -1 && itsTuples.size() > outputOpParam.getMaxArg()) {
                    throw new UserError(errorPrefix + "at most " + outputOpParam.getMinArg() + " entries are possible!");
                }
                for (Parameter myPar : itsTuples) {
                    if (myPar == null) {
                        throw new UserError(errorPrefix + "found NULL parameter!");
                    }
                    edu.udo.cs.miningmart.m4.core.ParameterObject po = (edu.udo.cs.miningmart.m4.core.ParameterObject)myPar.getTheParameterObject();
                    if (po == null) {
                        throw new UserError(errorPrefix + "found no parameter object!");
                    }
                    if (outputOpParam.isBaseAttribParameter() && !(po instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) {
                        throw new UserError(errorPrefix + "expected a BaseAttribute as parameter object!");
                    }
                    if (outputOpParam.isConceptParameter() && !(po instanceof Concept)) {
                        throw new UserError(errorPrefix + "expected a Concept as parameter object!");
                    }
                    if (!outputOpParam.isFeatureParameter() || po instanceof edu.udo.cs.miningmart.m4.core.Feature) continue;
                    throw new UserError(errorPrefix + "expected a Feature as parameter object!");
                }
            }
        }
        return true;
    }

    private String checkSingleLoopOpParam(OpParam opParam, edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray) {
        if (opParam.getMinArg() > 0 && pArray == null) {
            return "Step '" + this.getName() + "': non-optional parameter '" + opParam.getName() + "' is missing!";
        }
        if (pArray == null) {
            return null;
        }
        if (pArray.length < opParam.getMinArg()) {
            return "Non-optional parameter '" + opParam.getName() + "': Found " + pArray.length + " entries, but expect at least " + opParam.getMinArg();
        }
        if (opParam.getMaxArg() > 0 && pArray.length > opParam.getMaxArg()) {
            return "Parameter '" + opParam.getName() + "': Found " + pArray.length + " entries, but expect at most " + opParam.getMaxArg();
        }
        short parType = opParam.getType();
        for (int i = 0; i < pArray.length; ++i) {
            edu.udo.cs.miningmart.m4.core.ParameterObject pObj = pArray[i];
            if (pObj == null) {
                return "Parameter '" + opParam.getName() + "': Found null entry at index " + i;
            }
            String expected = null;
            if (parType == 1 && !(pObj instanceof Concept)) {
                expected = "Concept";
            } else if (parType == 3 && !(pObj instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) {
                expected = "BaseAttribute";
            } else if (parType == 4 && !(pObj instanceof MultiColumnFeature)) {
                expected = "MultiColumnFeature";
            } else if (parType == 5 && !(pObj instanceof edu.udo.cs.miningmart.m4.core.Feature)) {
                expected = "Feature";
            } else if (parType == 0 && !(pObj instanceof Value)) {
                expected = "Value";
            } else if (parType == 2 && !(pObj instanceof Relation)) {
                expected = "Relation";
            }
            if (expected == null) continue;
            return "Parameter '" + opParam.getName() + "' at index " + i + ": Expected was a " + expected + ", but found an object of incompatible class " + pObj.getClass().getName();
        }
        return null;
    }

    private String checkInputTypeConstraint(edu.udo.cs.miningmart.m4.core.Constraint constraint) throws M4Exception {
        String type = constraint.getType();
        String obj1 = constraint.getObj1();
        String obj2 = constraint.getObj2();
        OpParam oneOpPar = (OpParam)this.getTheOperator().getOpParam(obj1);
        OpParam secondOpPar = null;
        if (!oneOpPar.isInput()) {
            return null;
        }
        if (obj2 != null && (secondOpPar = (OpParam)this.getTheOperator().getOpParam(obj2)) != null && !secondOpPar.isInput()) {
            return null;
        }
        int loopNum = 0;
        int lastLoop = this.getLoopCount() + 1;
        if (oneOpPar.isLoopable() && this.getLoopCount() > 0) {
            loopNum = 1;
        }
        if (!oneOpPar.isLoopable()) {
            lastLoop = 0;
        }
        String errMessg = null;
        do {
            edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray;
            if ((pArray = this.getParameter(obj1, loopNum)) == null || pArray.length == 0 || pArray[0] == null) {
                if (oneOpPar.isOptional()) {
                    return null;
                }
                throw new UserError("Constraint " + type + " violated. No object(s) for mandatory parameter '" + obj1 + "' found!");
            }
            if (type.equals("ONE_OF")) {
                errMessg = this.checkOneOfConstraint(pArray, obj2);
                continue;
            }
            if (type.equals("IN")) {
                if (secondOpPar == null) {
                    throw new M4Exception("Step '" + this.getName() + "': IN Constraint found whose object 2 is not a parameter!");
                }
                int loopNumberForSecondParameter = secondOpPar.isLoopable() ? loopNum : 0;
                edu.udo.cs.miningmart.m4.core.ParameterObject[] obj2ParArray = this.getParameter(obj2, loopNumberForSecondParameter);
                errMessg = this.checkContainedInConstraint(pArray, obj2ParArray, loopNum);
                continue;
            }
            if (type.equals("TYPE")) {
                int loopNumberForSecondParameter;
                edu.udo.cs.miningmart.m4.core.ParameterObject[] obj2ParArray;
                String theType = obj2;
                if (secondOpPar != null && (obj2ParArray = this.getParameter(obj2, loopNumberForSecondParameter = secondOpPar.isLoopable() ? loopNum : 0)) != null && obj2ParArray.length > 0) {
                    theType = ((Value)obj2ParArray[0]).getValue();
                }
                errMessg = this.checkDatatypeConstraint(pArray, theType);
                continue;
            }
            if (type.equals("GE")) {
                errMessg = this.checkComparisonConstraint(pArray, obj2, loopNum, true, true);
                continue;
            }
            if (type.equals("GT")) {
                errMessg = this.checkComparisonConstraint(pArray, obj2, loopNum, false, true);
                continue;
            }
            if (type.equals("LE")) {
                errMessg = this.checkComparisonConstraint(pArray, obj2, loopNum, true, false);
                continue;
            }
            if (type.equals("LT")) {
                errMessg = this.checkComparisonConstraint(pArray, obj2, loopNum, false, false);
                continue;
            }
            if (type.equals("SAME_TYPE")) {
                errMessg = this.checkSameDataTypeConstraint(pArray, obj2, loopNum);
                continue;
            }
            if (type.equals("SAME_FEAT")) {
                errMessg = this.checkSameFeatureConstraint(pArray, obj2, loopNum);
                continue;
            }
            if (type.equals("SUM")) {
                errMessg = this.checkSumsToOne(pArray);
                continue;
            }
            if (type.equals("COORD")) {
                errMessg = this.checkArrayCoordination(pArray, obj1, obj2, loopNum);
                continue;
            }
            if (!type.equals("NO_COMMON")) continue;
            errMessg = this.checkNoCommonFeaturesExceptRenamedFeatures(pArray);
        } while (++loopNum < lastLoop && errMessg == null);
        return errMessg;
    }

    private String checkNoCommonFeaturesExceptRenamedFeatures(edu.udo.cs.miningmart.m4.core.ParameterObject[] theConcepts) throws M4Exception {
        int level;
        String errorMessage;
        if (theConcepts == null || theConcepts.length < 2) {
            return null;
        }
        edu.udo.cs.miningmart.m4.core.Constraint theRenameConstraint = this.getRenamingConstraint();
        edu.udo.cs.miningmart.m4.core.Constraint theMatchConstraint = this.getMatchingConstraint();
        String inputParamName = null;
        String outputParamName = null;
        Collection listOfRenamedOrMatchedFeatures = null;
        if (theRenameConstraint != null) {
            String error = this.checkNoDoublesInOutputNames(theRenameConstraint);
            if (error != null) {
                return error;
            }
            inputParamName = theRenameConstraint.getObj1();
            outputParamName = theRenameConstraint.getObj2();
            listOfRenamedOrMatchedFeatures = this.getListOfRenamedAndMatchedFeatures(theRenameConstraint, theMatchConstraint);
        }
        if ((errorMessage = this.checkNoCommonFeaturesPairwise(level = 0, theConcepts, listOfRenamedOrMatchedFeatures)) != null) {
            errorMessage = errorMessage + "\nPlease use the Parameters '" + inputParamName + "' and '" + outputParamName + "' to map the names to different output names!";
            return errorMessage;
        }
        return null;
    }

    private String checkNoCommonFeaturesPairwise(int currentLevel, edu.udo.cs.miningmart.m4.core.ParameterObject[] theConcepts, Collection allowedFeatures) throws M4Exception {
        if (currentLevel < 0 || currentLevel >= theConcepts.length) {
            return null;
        }
        if (!(theConcepts[currentLevel] instanceof Concept)) {
            throw new M4Exception("Step '" + this.getName() + "': found non-Concept as object of a concept parameter!");
        }
        Concept currentConcept = (Concept)theConcepts[currentLevel];
        for (int nextLevel = currentLevel + 1; nextLevel < theConcepts.length; ++nextLevel) {
            if (!(theConcepts[nextLevel] instanceof Concept)) {
                throw new M4Exception("Step '" + this.getName() + "': found non-Concept as object of a concept parameter!");
            }
            Concept nextConcept = (Concept)theConcepts[nextLevel];
            for (edu.udo.cs.miningmart.m4.core.BaseAttribute currBa : currentConcept.getAllBaseAttributes()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute nextBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)nextConcept.getBaseAttribute(currBa.getName());
                if (nextBa == null || allowedFeatures != null && this.checkOccurrence((Object)currBa, allowedFeatures) && this.checkOccurrence((Object)nextBa, allowedFeatures)) continue;
                return "A feature named '" + currBa.getName() + "' occurs in the input concepts '" + currentConcept.getName() + "' and '" + nextConcept.getName() + "'!";
            }
            String message = this.checkNoCommonFeaturesPairwise(currentLevel + 1, theConcepts, allowedFeatures);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private String checkNoDoublesInOutputNames(edu.udo.cs.miningmart.m4.core.Constraint theRenameConstraint) throws M4Exception {
        if (theRenameConstraint == null) {
            return null;
        }
        Vector<String> outputMappedFeatures = new Vector<String>();
        OpParam outOpPar = (OpParam)this.getTheOperator().getOpParam(theRenameConstraint.getObj2());
        int startLoop = 1;
        int endLoop = this.getHighestLoopNr(outOpPar);
        if (endLoop > 0) {
            for (int loop = startLoop; loop <= endLoop; ++loop) {
                edu.udo.cs.miningmart.m4.core.ParameterObject outObj;
                Parameter outParam = (Parameter)this.getParameterTuple(outOpPar.getName(), loop);
                if (outParam == null || (outObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)outParam.getTheParameterObject()) == null || !(outObj instanceof edu.udo.cs.miningmart.m4.core.Feature)) continue;
                outputMappedFeatures.add(outObj.getName());
            }
        }
        int noOfElems = outputMappedFeatures.size();
        for (int i = 0; i < noOfElems; ++i) {
            String oneName = (String)outputMappedFeatures.remove(0);
            for (String s : outputMappedFeatures) {
                if (!s.equalsIgnoreCase(oneName)) continue;
                return "The name '" + oneName + "' occurs more than once in Parameter '" + outOpPar.getName() + "' (ignoring case)!";
            }
        }
        return null;
    }

    private Collection getListOfRenamedAndMatchedFeatures(edu.udo.cs.miningmart.m4.core.Constraint theRenameConstraint, edu.udo.cs.miningmart.m4.core.Constraint theMatchConstraint) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] pos;
        OpParam matchOpParam;
        if (theRenameConstraint == null && theMatchConstraint == null) {
            return null;
        }
        Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> listOfFeatures = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
        Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> outputMappedFeatures = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
        OpParam inOpPar = (OpParam)this.getTheOperator().getOpParam(theRenameConstraint.getObj1());
        OpParam outOpPar = (OpParam)this.getTheOperator().getOpParam(theRenameConstraint.getObj2());
        int startLoop = 1;
        int endLoop = this.getHighestLoopNr(inOpPar);
        if (endLoop > 0) {
            for (int loop = startLoop; loop <= endLoop; ++loop) {
                edu.udo.cs.miningmart.m4.core.ParameterObject outObj;
                edu.udo.cs.miningmart.m4.core.ParameterObject inObj;
                Parameter inParam = (Parameter)this.getParameterTuple(inOpPar.getName(), loop);
                Parameter outParam = (Parameter)this.getParameterTuple(outOpPar.getName(), loop);
                if (inParam != null && (inObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)inParam.getTheParameterObject()) != null && inObj instanceof edu.udo.cs.miningmart.m4.core.Feature) {
                    listOfFeatures.add(inObj);
                }
                if (outParam == null || (outObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)outParam.getTheParameterObject()) == null || !(outObj instanceof edu.udo.cs.miningmart.m4.core.Feature)) continue;
                outputMappedFeatures.add(outObj);
            }
        }
        if ((matchOpParam = (OpParam)this.getTheOperator().getOpParam(theMatchConstraint.getObj1())) != null && (pos = this.getParameter(matchOpParam.getName(), 0)) != null) {
            for (int i = 0; i < pos.length; ++i) {
                if (!(pos[i] instanceof edu.udo.cs.miningmart.m4.core.Feature)) continue;
                listOfFeatures.add(pos[i]);
            }
        }
        return listOfFeatures;
    }

    private edu.udo.cs.miningmart.m4.core.Constraint getRenamingConstraint() throws M4Exception {
        if (this.getTheOperator() == null) {
            return null;
        }
        Collection theConstraints = this.getTheOperator().getConstraints();
        if (theConstraints != null) {
            for (edu.udo.cs.miningmart.m4.core.Constraint constr : theConstraints) {
                if (!constr.getType().equals("RENAME_OUT")) continue;
                return constr;
            }
        }
        return null;
    }

    private edu.udo.cs.miningmart.m4.core.Constraint getMatchingConstraint() throws M4Exception {
        if (this.getTheOperator() == null) {
            return null;
        }
        Collection theConstraints = this.getTheOperator().getConstraints();
        if (theConstraints != null) {
            for (edu.udo.cs.miningmart.m4.core.Constraint constr : theConstraints) {
                if (!constr.getType().equals("MATCHBYCON")) continue;
                return constr;
            }
        }
        return null;
    }

    private String checkOneOfConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2) {
        if (obj2 == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(obj2);
        Vector<Object> alternatives = new Vector<Object>();
        while (st.hasMoreElements()) {
            alternatives.add(st.nextElement());
        }
        for (int i = 0; i < pArray.length; ++i) {
            if (pArray[i] instanceof Value) {
                String value = ((Value)pArray[i]).getValue();
                if (alternatives.contains(value)) continue;
                return "'ONE OF'-Constraint violated: value " + value + " not found in list of alternatives (" + alternatives.toString() + ").";
            }
            return "'ONE OF'-Constraint found for parameter of different type than Value.";
        }
        return null;
    }

    private String checkContainedInConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, edu.udo.cs.miningmart.m4.core.ParameterObject[] obj2, int loopNum) throws M4Exception {
        int i;
        for (i = 0; i < obj2.length; ++i) {
            if (obj2[i] instanceof Concept) continue;
            return "Constraint 'IN' expects a Concept as its second parameter. Found an object of class " + obj2[i].getClass().getName() + " instead!";
        }
        if (pArray[0] instanceof edu.udo.cs.miningmart.m4.core.Feature) {
            for (i = 0; i < pArray.length; ++i) {
                if (pArray[i] instanceof edu.udo.cs.miningmart.m4.core.Feature) {
                    if (this.findFeatureInConcepts((edu.udo.cs.miningmart.m4.core.Feature)pArray[i], obj2)) continue;
                    return "'IN'-constraint violated for feature '" + ((edu.udo.cs.miningmart.m4.core.Feature)pArray[i]).getName() + "', it does not belong to the input concept(s) in loop number " + loopNum + "!";
                }
                return "Found unsupported object of class " + pArray[i].getClass().getName() + " in first parameter of 'IN' constraint!";
            }
        } else if (pArray[0] instanceof Concept) {
            for (edu.udo.cs.miningmart.m4.core.Feature f : ((Concept)pArray[0]).getFeatures()) {
                if (this.findFeatureInConcepts(f, obj2)) continue;
                return "'IN'-constraint violated for feature '" + f.getName() + "' of concept '" + pArray[0].getName() + "'!";
            }
        } else {
            return "Found unsupported object of class " + pArray[0].getClass().getName() + " in first parameter of 'IN' constraint!";
        }
        return null;
    }

    private boolean findFeatureInConcepts(edu.udo.cs.miningmart.m4.core.Feature f, edu.udo.cs.miningmart.m4.core.ParameterObject[] concepts) throws M4Exception {
        for (int i = 0; i < concepts.length; ++i) {
            Concept myCon = (Concept)concepts[i];
            for (edu.udo.cs.miningmart.m4.core.Feature myF : myCon.getFeatures()) {
                if (!myF.equals(f)) continue;
                return true;
            }
        }
        return false;
    }

    private String checkSameFeatureConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2, int loopNum) throws M4Exception {
        Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> otherConcepts = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
        for (int i = 0; i < pArray.length; ++i) {
            if (!(pArray[i] instanceof Concept)) {
                return "Constraint 'SAME_FEAT' expects a single or an array of Concept(s) as its first parameter. Found an object of class " + pArray[i].getClass().getName() + " instead!";
            }
            otherConcepts.add(pArray[i]);
        }
        edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray2 = this.getParameter(obj2, loopNum);
        if (pArray2 == null || pArray2.length == 0) {
            return null;
        }
        if (!(pArray2[0] instanceof Concept)) {
            return "Constraint 'SAME_FEAT' expects a Concept as its second parameter. Found an object of class " + pArray[0].getClass().getName() + " instead!";
        }
        Concept inConcept = (Concept)pArray2[0];
        Vector<String> inputFeatureNames = new Vector<String>();
        for (edu.udo.cs.miningmart.m4.core.Feature feature : inConcept.getFeatures()) {
            if (!this.isVisible(feature)) continue;
            inputFeatureNames.add(feature.getName());
        }
        for (Concept concept : otherConcepts) {
            Iterator feaIt = concept.getFeatures().iterator();
            Vector ifn = (Vector)inputFeatureNames.clone();
            while (feaIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature fea = (edu.udo.cs.miningmart.m4.core.Feature)feaIt.next();
                if (this.isVisible(fea) && !ifn.contains(fea.getName())) {
                    return "Constraint 'SAME_FEAT' violated. Concept '" + concept.getName() + "' contains additional feature '" + fea.getName() + "'!";
                }
                ifn.remove(fea.getName());
            }
            if (ifn.isEmpty()) continue;
            String additional = (String)ifn.firstElement();
            return "Constraint 'SAME_FEAT' violated. Concept '" + inConcept.getName() + "' contains feature '" + additional + "', which is not part of concept '" + concept.getName() + "'!";
        }
        return null;
    }

    private String checkDatatypeConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2) throws M4Exception {
        for (int i = 0; i < pArray.length; ++i) {
            edu.udo.cs.miningmart.m4.core.ParameterObject current = pArray[i];
            String error = this.checkDatatypeConstraint(current, obj2);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private String checkDatatypeConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject theObject, String obj2) throws M4Exception {
        String datatype = null;
        if (theObject instanceof Value) {
            datatype = ((Value)theObject).getTypeName();
        } else if (theObject instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute) {
            datatype = ((edu.udo.cs.miningmart.m4.core.BaseAttribute)theObject).getConceptualDataTypeName();
        } else {
            return "Found unsupported object of class " + theObject.getClass().getName() + " in first parameter of 'TYPE' constraint!";
        }
        if (!ConceptualDatatypes.checkDatatypeCompatibility(obj2, datatype)) {
            return "'TYPE' constraint violated. BaseAttribute or Value '" + theObject.getName() + "' is of type " + datatype + ", but the type must be " + obj2 + "!";
        }
        return null;
    }

    private String checkComparisonConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2, int loopNr, boolean orEqual, boolean greater) throws M4Exception {
        String constrType = null;
        constrType = greater ? (orEqual ? "GE" : "GT") : (orEqual ? "LE" : "LT");
        OpParam secondObjOpPar = (OpParam)this.getTheOperator().getOpParam(obj2);
        Double obj2D = null;
        if (secondObjOpPar == null) {
            if (obj2 != null) {
                try {
                    obj2D = new Double(obj2);
                }
                catch (NumberFormatException e) {}
            }
        } else {
            Iterator it = this.getParameter(secondObjOpPar, loopNr).iterator();
            edu.udo.cs.miningmart.m4.core.ParameterObject po = (edu.udo.cs.miningmart.m4.core.ParameterObject)it.next();
            if (!(po instanceof Value)) {
                throw new M4Exception("Step '" + this.getName() + "', Constraint " + constrType + ": Second constraint object is neither a number nor a Value parameter!");
            }
            obj2D = ((Value)po).getDouble();
        }
        if (obj2D == null) {
            return "Second argument of " + constrType + "constraint invalid: " + obj2;
        }
        double obj2d = obj2D;
        for (int i = 0; i < pArray.length; ++i) {
            edu.udo.cs.miningmart.m4.core.ParameterObject current = pArray[i];
            if (!(current instanceof Value)) {
                return "Found unsupported object of class " + current.getClass().getName() + " in first parameter of " + constrType + " constraint!";
            }
            String valueS = ((Value)current).getValue();
            Double value = null;
            if (valueS != null) {
                try {
                    value = new Double(valueS);
                }
                catch (NumberFormatException e) {
                    return "Found unsupported Value object for 'GE' or 'GT' constraint:The constraint implies a numeric value, but the value found is '" + valueS + "'!";
                }
            }
            if (!(greater ? value < obj2d || !orEqual && value <= obj2d : value > obj2d || !orEqual && value >= obj2d)) continue;
            return "Constraint " + constrType + " violated: Found parameter value " + value + "!";
        }
        return null;
    }

    private String checkSumsToOne(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray) {
        double sum = 0.0;
        String constraint = "'SUM'";
        for (int i = 0; i < pArray.length; ++i) {
            edu.udo.cs.miningmart.m4.core.ParameterObject current = pArray[i];
            if (!(current instanceof Value)) {
                return "Found unsupported object of class " + current.getClass().getName() + " in first parameter of " + constraint + " constraint!";
            }
            String valueS = ((Value)current).getValue();
            Double value = null;
            if (valueS != null) {
                try {
                    value = new Double(valueS);
                }
                catch (NumberFormatException e) {
                    return "Found unsupported Value object for " + constraint + " constraint:" + "The constraint implies a numeric value, but the value found is '" + valueS + "'!";
                }
            }
            sum += value.doubleValue();
        }
        if (sum != 1.0) {
            return "Constraint " + constraint + " violated. Sum is " + sum + " rather than 1.0 !";
        }
        return null;
    }

    private String checkArrayCoordination(edu.udo.cs.miningmart.m4.core.ParameterObject[] theArray, String nameOf1stArray, String nameOf2ndArray, int loopNum) {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray2 = this.getParameter(nameOf2ndArray, loopNum);
        if (theArray != null && pArray2 != null && theArray.length != pArray2.length) {
            return "Constraint 'COORD' (Array coordination) is violated for parameters '" + nameOf1stArray + "' and '" + nameOf2ndArray + "' (number of entries not equal), ";
        }
        return null;
    }

    private String checkSameDataTypeConstraint(edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray, String obj2, int loopNum) {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] pArray2 = this.getParameter(obj2, loopNum);
        if (pArray2 == null || pArray2.length == 0 || pArray2[0] == null) {
            return "Second argument of 'SAME_TYPE' constraint missing!";
        }
        if (!(pArray[0] instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) {
            return "First argument of 'SAME_TYPE' constraint should be a BaseAttribute. Found an object of class " + pArray[0].getClass().getName() + " instead!";
        }
        if (!(pArray2[0] instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) {
            return "Second argument of 'SAME_TYPE' constraint should be a BaseAttribute. Found an object of class " + pArray2[0].getClass().getName() + " instead!";
        }
        edu.udo.cs.miningmart.m4.core.BaseAttribute firstBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)pArray[0];
        edu.udo.cs.miningmart.m4.core.BaseAttribute secondBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)pArray2[0];
        if (firstBa.getConceptualDataType() != secondBa.getConceptualDataType()) {
            return "Constraint 'SAME_TYPE' violated for BaseAttributes '" + firstBa.getName() + "' and '" + secondBa.getName() + "'!";
        }
        return null;
    }

    private edu.udo.cs.miningmart.m4.core.ParameterObject[] getParameter(String name, int loopNr) {
        try {
            ParameterArray p = this.getParameterDictionary(false).get(name, loopNr);
            if (p == null) {
                return null;
            }
            return (edu.udo.cs.miningmart.m4.core.ParameterObject[])p.getParameterObjectArray();
        }
        catch (M4Exception e) {
            this.doPrint(Print.MAX, "Warning: Exception caught when trying to fetch parameters for Step " + this.getId());
            this.doPrint(e);
            return null;
        }
    }

    private Collection getParameterObjects(String name) throws M4Exception {
        Collection c = this.getParameterTuples();
        if (c != null) {
            Iterator it = c.iterator();
            Vector<ParameterObject> ret = new Vector<ParameterObject>();
            while (it.hasNext()) {
                Parameter aPar = (Parameter)it.next();
                if (!this.parameterNamesMatch(name, aPar)) continue;
                ret.add(aPar.getTheParameterObject());
            }
            return ret;
        }
        return null;
    }

    public Collection getPossibleConceptsForParam(edu.udo.cs.miningmart.m4.OpParam opParam) throws M4Exception {
        Collection c = this.getOpParamsToSelectFeatureParamObjectsFrom(opParam);
        if (c == null) {
            return null;
        }
        Vector<edu.udo.cs.miningmart.m4.Concept> theConcepts = new Vector<edu.udo.cs.miningmart.m4.Concept>();
        for (OpParam anOpPar : c) {
            if (anOpPar.isConceptParameter()) {
                theConcepts.addAll(this.getParameterObjects(anOpPar.getName()));
            }
            if (!anOpPar.isRelationParameter()) continue;
            Relation rel = (Relation)this.getSingleParameterObject(anOpPar.getName());
            boolean takeFromConcept = false;
            boolean takeToConcept = false;
            Collection constrs = anOpPar.getApplicableConstraints();
            if (constrs == null || constrs.isEmpty()) continue;
            for (edu.udo.cs.miningmart.m4.core.Constraint myRelConstraint : constrs) {
                if (myRelConstraint.getType().equals("IN_RELFROM")) {
                    takeFromConcept = true;
                    continue;
                }
                if (!myRelConstraint.getType().equals("IN_RELTO")) continue;
                takeToConcept = true;
            }
            if (takeFromConcept) {
                theConcepts.add(rel.getTheFromConcept());
            }
            if (!takeToConcept) continue;
            theConcepts.add(rel.getTheToConcept());
        }
        return theConcepts;
    }

    public boolean isAttribToTakeFromFromConcept(edu.udo.cs.miningmart.m4.OpParam theAttribOpParam, edu.udo.cs.miningmart.m4.OpParam theRelationOpParam) throws M4Exception {
        Collection constrs = theAttribOpParam.getApplicableConstraints();
        if (constrs == null || constrs.isEmpty()) {
            return false;
        }
        for (edu.udo.cs.miningmart.m4.core.Constraint aConstr : constrs) {
            if (!aConstr.getType().equals("IN_RELFROM") || !aConstr.getObj2().equalsIgnoreCase(theRelationOpParam.getName()) && !aConstr.getObj1().equalsIgnoreCase(theRelationOpParam.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAttribToTakeFromToConcept(edu.udo.cs.miningmart.m4.OpParam theAttribOpParam, edu.udo.cs.miningmart.m4.OpParam theRelationOpParam) throws M4Exception {
        Collection constrs = theAttribOpParam.getApplicableConstraints();
        if (constrs == null || constrs.isEmpty()) {
            return false;
        }
        for (edu.udo.cs.miningmart.m4.core.Constraint aConstr : constrs) {
            if (!aConstr.getType().equals("IN_RELTO") || !aConstr.getObj2().equalsIgnoreCase(theRelationOpParam.getName()) && !aConstr.getObj1().equalsIgnoreCase(theRelationOpParam.getName())) continue;
            return true;
        }
        return false;
    }

    public Collection getOpParamsToSelectFeatureParamObjectsFrom(edu.udo.cs.miningmart.m4.OpParam opParam) throws M4Exception {
        if (opParam == null) {
            return null;
        }
        Class typeOfParameter = Parameter.getClassForParameterType(opParam.getType());
        if (!edu.udo.cs.miningmart.m4.core.Feature.class.isAssignableFrom(typeOfParameter)) {
            throw new M4Exception("Step.getPossibleConceptsForParam: Expected a Feature parameter, but found an object of class " + typeOfParameter.getName());
        }
        String opParamName = opParam.getName();
        Iterator it = this.getTheOperator().getConstraints().iterator();
        Vector<OpParam> inputConOpParams = new Vector<OpParam>();
        OpParam outputOpParam = null;
        OpParam relationOpParam = null;
        while (it.hasNext()) {
            OpParam obj2OpPar;
            String obj2;
            edu.udo.cs.miningmart.m4.core.Constraint constraint = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
            if (constraint.getType().equals("IN") && constraint.getObj1().equalsIgnoreCase(opParamName) && (obj2 = constraint.getObj2()) != null && obj2.length() > 0) {
                obj2OpPar = (OpParam)this.getTheOperator().getOpParam(obj2);
                if (obj2OpPar.isInput() && obj2OpPar.isConceptParameter()) {
                    inputConOpParams.add(obj2OpPar);
                }
                if (!obj2OpPar.isInput() && obj2OpPar.isConceptParameter()) {
                    outputOpParam = obj2OpPar;
                }
            }
            if (!constraint.getType().equals("IN_RELFROM") && !constraint.getType().equals("IN_RELTO") || !constraint.getObj1().equalsIgnoreCase(opParamName) || (obj2 = constraint.getObj2()) == null || obj2.length() <= 0 || !(obj2OpPar = (OpParam)this.getTheOperator().getOpParam(obj2)).isInput() || !obj2OpPar.isRelationParameter()) continue;
            relationOpParam = obj2OpPar;
        }
        if (relationOpParam != null) {
            Vector<OpParam> v = new Vector<OpParam>();
            v.add(relationOpParam);
            return v;
        }
        if (outputOpParam != null && inputConOpParams.isEmpty()) {
            return null;
        }
        if (outputOpParam != null && !inputConOpParams.isEmpty()) {
            return inputConOpParams;
        }
        if (!inputConOpParams.isEmpty() && this.getOutputConcept() == null) {
            if (opParam.isInput()) {
                return inputConOpParams;
            }
            return null;
        }
        if (!inputConOpParams.isEmpty() && this.getOutputConcept() != null) {
            return inputConOpParams;
        }
        return null;
    }

    public Collection getPossibleInputConcepts() throws M4Exception {
        Vector<Concept> ret = new Vector<Concept>();
        for (Concept myCon : this.getTheCase().getConcepts()) {
            if (!myCon.getType().equals("DB")) continue;
            ret.add(myCon);
        }
        this.addOutputConceptsOfPredecessors(ret);
        ret.trimToSize();
        return ret;
    }

    private void addOutputConceptsOfPredecessors(Collection outCons) throws M4Exception {
        for (Step myPredStep : this.getAllPredecessors()) {
            Concept anOutCon = (Concept)myPredStep.getOutputConcept();
            if (anOutCon != null && !outCons.contains(anOutCon)) {
                outCons.add(anOutCon);
            }
            myPredStep.addOutputConceptsOfPredecessors(outCons);
        }
    }

    public boolean isContainedInInputConcept(edu.udo.cs.miningmart.m4.OpParam outputFeature) throws M4Exception {
        if (outputFeature.isInput()) {
            throw new M4Exception("Step.isContainedInInputConcept: can only be called with an output parameter!");
        }
        boolean isContained = false;
        Collection applicableConstraints = outputFeature.getApplicableConstraints();
        for (edu.udo.cs.miningmart.m4.core.Constraint aConstr : applicableConstraints) {
            if (!aConstr.getType().equalsIgnoreCase("IN")) continue;
            String containedIn = aConstr.getObj2();
            Parameter conceptPar = (Parameter)this.getParameterTuple(containedIn, 0);
            if (!conceptPar.getParObjectType().equalsIgnoreCase(Parameter.typeStringForTypeConst((short)1))) {
                throw new M4Exception("Step '" + this.getName() + "': found IN constraint for output BA without a Concept in object 2!");
            }
            if (!conceptPar.isInputParam()) continue;
            isContained = true;
        }
        return isContained;
    }

    public ParamDict getParameterDictionary(boolean expectingAllParamsToExist) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParamDict pd = new edu.udo.cs.miningmart.m4.core.ParamDict();
        Iterator it = this.getTheOperator().getOpParamsIterator();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.ParameterArray obj;
            int loops;
            edu.udo.cs.miningmart.m4.core.ParameterArray additionalParArr;
            int loopNr;
            OpParam op = (OpParam)it.next();
            String paramMissingMsg = "Parameter '" + op.getName() + "' missing in Step '" + this.getName() + "'!";
            if (op.getMinArg() == 0) {
                try {
                    edu.udo.cs.miningmart.m4.core.ParameterArray withoutLoop = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, 0);
                    if (withoutLoop != null && (withoutLoop.size() > 0 || this.getLoopCount() <= 0)) {
                        pd.put(op.getName(), withoutLoop);
                        continue;
                    }
                    if (op.isCoordinated()) {
                        loopNr = 1;
                        edu.udo.cs.miningmart.m4.core.ParameterArray myPar = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, loopNr);
                        if (myPar == null) continue;
                        additionalParArr = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, ++loopNr);
                        while (additionalParArr != null) {
                            for (Parameter aParam : additionalParArr.getParameters()) {
                                myPar.addParameter(aParam);
                            }
                            additionalParArr = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, ++loopNr);
                        }
                        pd.put(op.getName(), 0, myPar);
                        continue;
                    }
                    loops = this.getLoopCount() + 1;
                    for (int i = 1; i < loops; ++i) {
                        obj = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, i);
                        if (obj == null) continue;
                        pd.put(op.getName(), i, obj);
                    }
                    continue;
                }
                catch (ParameterNotFoundException e) {
                    throw new M4Exception("Internal error.'ParameterNotFound' exception was thrown for an optional parameter:\n" + e.getMessage());
                }
            }
            try {
                edu.udo.cs.miningmart.m4.core.ParameterArray obj2 = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, 0);
                if (obj2 == null) {
                    throw new ParameterNotFoundException(paramMissingMsg);
                }
                pd.put(op.getName(), obj2);
            }
            catch (ParameterNotFoundException e) {
                if (op.isCoordinated()) {
                    loopNr = 1;
                    edu.udo.cs.miningmart.m4.core.ParameterArray myPar = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, loopNr);
                    if (myPar == null) {
                        if (!expectingAllParamsToExist) continue;
                        throw new ParameterNotFoundException(paramMissingMsg);
                    }
                    additionalParArr = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, ++loopNr);
                    while (additionalParArr != null) {
                        for (Parameter aParam : additionalParArr.getParameters()) {
                            myPar.addParameter(aParam);
                        }
                        additionalParArr = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, ++loopNr);
                    }
                    pd.put(op.getName(), 0, myPar);
                    continue;
                }
                if (this.getLoopCount() > 0) {
                    loops = this.getLoopCount() + 1;
                    for (int i = 1; i < loops; ++i) {
                        try {
                            obj = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(op, i);
                            if (obj == null) {
                                throw new ParameterNotFoundException(paramMissingMsg);
                            }
                            pd.put(op.getName(), i, obj);
                            continue;
                        }
                        catch (ParameterNotFoundException pnfe) {
                            if (!expectingAllParamsToExist) continue;
                            throw pnfe;
                        }
                    }
                    continue;
                }
                if (!expectingAllParamsToExist) continue;
                throw e;
            }
        }
        return pd;
    }

    public boolean isVisible(Feature theFeature) throws M4Exception {
        edu.udo.cs.miningmart.m4.Parameter featureOutputParam;
        if (this.getTheCase() == null) {
            return false;
        }
        if (theFeature instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute) {
            if (((edu.udo.cs.miningmart.m4.core.BaseAttribute)theFeature).isDBAttrib()) {
                return true;
            }
        } else {
            boolean allBAsAreDB = true;
            MultiColumnFeature mcf = (MultiColumnFeature)theFeature;
            Iterator it = mcf.getBaseAttributes().iterator();
            if (!it.hasNext()) {
                throw new M4Exception("Step.isVisible(Feature): found MCF '" + mcf.getName() + "'without BAs!");
            }
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)it.next();
                if (ba.isDBAttrib()) continue;
                allBAsAreDB = false;
            }
            if (allBAsAreDB) {
                return true;
            }
        }
        if ((featureOutputParam = theFeature.getParameterWhereThisIsOutputFeature()) == null) {
            return true;
        }
        if (this.getParameterTuples().contains(featureOutputParam)) {
            return true;
        }
        Collection predSteps = this.getTheCase().getStepsToCompileBefore(this, true);
        if (predSteps == null) {
            throw new M4Exception("Step.isVisible(Feature): got <null> Collection when asking for predecessors!");
        }
        for (Step myPrecedingStep : predSteps) {
            if (!myPrecedingStep.getParameterTuples().contains(featureOutputParam)) continue;
            return true;
        }
        return false;
    }

    public Collection getCorrespondingOutputFeatures(edu.udo.cs.miningmart.m4.Concept theInputConcept, Feature theFeature) throws M4Exception {
        Concept outputConcept = (Concept)this.getOutputConcept();
        if (outputConcept == null) {
            Vector<Feature> ret = new Vector<Feature>();
            ret.add(theFeature);
            return ret;
        }
        edu.udo.cs.miningmart.m4.core.Feature directCorrespondence = (edu.udo.cs.miningmart.m4.core.Feature)outputConcept.getFeature(theFeature.getName());
        if (directCorrespondence != null) {
            Vector<edu.udo.cs.miningmart.m4.core.Feature> ret = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
            ret.add(directCorrespondence);
            return ret;
        }
        for (edu.udo.cs.miningmart.m4.core.Constraint theConstraint : this.getTheOperator().getConstraints()) {
            OpParam inputOpParam;
            if (theConstraint.getType().equals("CREATE_BY") || theConstraint.getType().equals("CR_SUFFIX")) {
                inputOpParam = (OpParam)this.getTheOperator().getOpParam(theConstraint.getObj1());
                Collection inputAttribsOfThisParam = this.getParameterObjects(inputOpParam.getName());
                Iterator inputAttrIt = inputAttribsOfThisParam.iterator();
                String[] inputBaNames = new String[inputAttribsOfThisParam.size()];
                int i = 0;
                boolean constraintApplies = false;
                while (inputAttrIt.hasNext()) {
                    edu.udo.cs.miningmart.m4.core.BaseAttribute in = (edu.udo.cs.miningmart.m4.core.BaseAttribute)inputAttrIt.next();
                    inputBaNames[i] = in.getName();
                    if (in.correspondsTo(theFeature)) {
                        constraintApplies = true;
                    }
                    ++i;
                }
                if (constraintApplies) {
                    Map mapInputFeaturesToOutputFeatureNames = this.getMapOfNamesToNamesWithSuffixes(theConstraint, inputBaNames);
                    Vector correspondingOutputFeatureNames = (Vector)mapInputFeaturesToOutputFeatureNames.get(theFeature.getName());
                    Vector<edu.udo.cs.miningmart.m4.core.Feature> outputFeatures = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
                    for (String outName : correspondingOutputFeatureNames) {
                        edu.udo.cs.miningmart.m4.core.Feature f = (edu.udo.cs.miningmart.m4.core.Feature)outputConcept.getFeature(outName);
                        if (f == null) continue;
                        outputFeatures.add(f);
                    }
                    return outputFeatures;
                }
            }
            if (!theConstraint.getType().equalsIgnoreCase("RENAME_OUT")) continue;
            inputOpParam = (OpParam)this.getTheOperator().getOpParam(theConstraint.getObj1());
            OpParam outputOpParam = (OpParam)this.getTheOperator().getOpParam(theConstraint.getObj2());
            edu.udo.cs.miningmart.m4.core.ParameterArray paIn = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(inputOpParam, 0);
            edu.udo.cs.miningmart.m4.core.ParameterArray paOut = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(outputOpParam, 0);
            edu.udo.cs.miningmart.m4.core.ParameterObject[] inputFeatures = (edu.udo.cs.miningmart.m4.core.ParameterObject[])paIn.getParameterObjectArray();
            edu.udo.cs.miningmart.m4.core.ParameterObject[] outputFeatures = (edu.udo.cs.miningmart.m4.core.ParameterObject[])paOut.getParameterObjectArray();
            Vector<edu.udo.cs.miningmart.m4.core.ParameterObject> ret = new Vector<edu.udo.cs.miningmart.m4.core.ParameterObject>();
            for (int i = 0; i < inputFeatures.length; ++i) {
                if (!((edu.udo.cs.miningmart.m4.core.Feature)inputFeatures[i]).correspondsTo(theFeature)) continue;
                ret.add(outputFeatures[i]);
            }
            return ret;
        }
        return new Vector();
    }

    public String checkFeatureRemoval(edu.udo.cs.miningmart.m4.Concept theInputConcept, Feature theFeature) throws M4Exception {
        if (!this.checkOccurrence((Object)theInputConcept, this.getAllInputConcepts())) {
            throw new M4Exception("Step '" + this.getName() + "', method checkFeatureRemoval: got unknown input concept!");
        }
        if (!theInputConcept.hasFeature(theFeature)) {
            throw new M4Exception("Step '" + this.getName() + "', method checkFeatureRemoval: got unknown input Feature!");
        }
        Collection myParameters = this.getParameterTuples();
        for (Parameter myPar : myParameters) {
            edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)myPar.getTheParameterObject();
            if (!(myParObj instanceof edu.udo.cs.miningmart.m4.core.Feature) || !theInputConcept.hasFeature((edu.udo.cs.miningmart.m4.core.Feature)myParObj) || !myParObj.getName().equalsIgnoreCase(theFeature.getName())) continue;
            OpParam theParamInfo = this.findOpParamForParam(myPar);
            if (theParamInfo == null) {
                throw new M4Exception("Step '" + this.getName() + "', method checkFeatureRemoval: found no OpParam for Parameter '" + myPar.getName() + "'!");
            }
            if (theParamInfo.isOptional()) {
                return null;
            }
            if (theParamInfo.isArray()) {
                edu.udo.cs.miningmart.m4.core.ParameterArray pa = (edu.udo.cs.miningmart.m4.core.ParameterArray)this.getParameterArray(theParamInfo, myPar.getLoopNr());
                if (pa.getParameterObjectArray().length > 1) {
                    return null;
                }
                return "The list of entries in the obligatory parameter '" + theParamInfo.getName() + "' in loop number " + myPar.getLoopNr() + " of Step '" + this.getName() + "' would be empty!";
            }
            return "The obligatory parameter '" + theParamInfo.getName() + "' in loop number " + myPar.getLoopNr() + " of Step '" + this.getName() + "' would be deleted!";
        }
        return null;
    }

    private OpParam findOpParamForParam(Parameter myParameter) throws M4Exception {
        Collection allOpParams = this.getTheOperator().getOpParams();
        if (allOpParams != null) {
            for (OpParam myOpPar : allOpParams) {
                if (!this.parameterNamesMatch(myOpPar.getName(), myParameter)) continue;
                return myOpPar;
            }
        }
        return null;
    }

    public boolean usesLoopsForCoordination() throws M4Exception {
        Iterator it = this.getTheOperator().getOpParamsIterator();
        while (it.hasNext()) {
            OpParam anOpPar = (OpParam)it.next();
            if (!anOpPar.isCoordinated()) continue;
            return true;
        }
        return false;
    }

    public void createOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames) throws M4Exception {
        boolean create = true;
        if (theNames == null || theNames.isEmpty()) {
            return;
        }
        this.workOnOutput(theOpParam, theNames, create);
    }

    public void propagateOutputChanges() throws M4Exception {
        if (this.getTheCase() == null) {
            return;
        }
        Iterator stepsIt = this.getTheCase().getStepIterator();
        while (stepsIt.hasNext()) {
            Step oneStep = (Step)stepsIt.next();
            oneStep.bfsLevel = 0;
        }
        Vector<Step> myQueue = new Vector<Step>();
        this.bfsLevel = 1;
        Step nextStep = this;
        int currentBfsLevel = 1;
        boolean noStepOfThisLevelHasChangedItsOutput = true;
        Collection stepsToBeUpdated = this.getTheCase().getDependentStepsFor(this);
        while (nextStep != null) {
            if (this != nextStep && !this.havePredecessorsBeenVisited(nextStep, myQueue, stepsToBeUpdated)) {
                nextStep.bfsLevel = 0;
                nextStep = myQueue.isEmpty() ? null : (Step)myQueue.remove(0);
                continue;
            }
            int nextBfsLevel = nextStep.bfsLevel;
            if (nextBfsLevel > currentBfsLevel) {
                currentBfsLevel = nextBfsLevel;
                if (noStepOfThisLevelHasChangedItsOutput && (this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames == null || this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames.isEmpty())) {
                    return;
                }
                noStepOfThisLevelHasChangedItsOutput = true;
            }
            if (this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames != null) {
                nextStep.recreateInputParametersForThisStep(this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames);
            }
            if (nextStep.equals(this) || nextStep.adaptOutputToChangedInput()) {
                noStepOfThisLevelHasChangedItsOutput = false;
            }
            Vector successors = new Vector(nextStep.getSuccessors());
            successors.addAll(nextStep.getSuccessorsUntilOutputConceptIsCreated());
            if (successors != null && !successors.isEmpty()) {
                for (Step succ : successors) {
                    if (succ.bfsLevel != 0 || myQueue.contains(succ)) continue;
                    succ.bfsLevel = nextBfsLevel + 1;
                    myQueue.add(succ);
                }
            }
            nextStep = myQueue.isEmpty() ? null : (Step)myQueue.remove(0);
        }
        this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames = null;
    }

    private boolean havePredecessorsBeenVisited(Step currentStep, Vector theSearchQueue, Collection relevantSteps) throws M4Exception {
        Collection preds = currentStep.getAllPredecessors();
        if (preds != null && !preds.isEmpty()) {
            for (Step predecessor : preds) {
                if (!relevantSteps.contains(predecessor)) continue;
                if (predecessor.bfsLevel == 0) {
                    return false;
                }
                if (!theSearchQueue.contains(predecessor)) continue;
                return false;
            }
        }
        return true;
    }

    private void workOnOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames, boolean create) throws M4Exception {
        if (theOpParam != null && theOpParam.isInput()) {
            throw new M4Exception("Step.create/updateOutput: got an input operator parameter!");
        }
        if (theOpParam != null && theNames != null && create) {
            this.deleteParameters(theOpParam);
        }
        Collection applicableConstraints = this.getApplicableOutputConstraints(theOpParam);
        Vector<edu.udo.cs.miningmart.m4.OpParam> outputFeatureOpParams = null;
        if (!create && this.oldNamesOfOutputAttribs == null) {
            outputFeatureOpParams = this.getOutputFeatureOpParams();
            this.oldNamesOfOutputAttribs = this.storeNamesOfOpParams(outputFeatureOpParams);
        }
        Map mapChangedInputsToOldNames = null;
        Map secondMapChangedInputsToOldNames = null;
        if (theOpParam == null || theOpParam.isRelationParameter()) {
            this.checkWorkOnOutputRelation(theOpParam, theNames, create);
        }
        if (theOpParam == null || theOpParam.isConceptParameter()) {
            String theName = create ? this.extractSingleName(theNames) : null;
            mapChangedInputsToOldNames = this.workOnOutputConcept(theName, create);
        }
        if (theOpParam == null || theOpParam.isBaseAttribParameter() || theOpParam.isFeatureParameter()) {
            int startLoopNr = this.getStartOrEndLoopNumber(theOpParam, theNames, true);
            int endLoopNr = this.getStartOrEndLoopNumber(theOpParam, theNames, false);
            for (int loopNr = startLoopNr; loopNr <= endLoopNr; ++loopNr) {
                if (create) {
                    Collection namesForLoop = this.getNamesForThisLoop(theOpParam, theNames, startLoopNr, loopNr);
                    secondMapChangedInputsToOldNames = this.workOnOutputBAs(applicableConstraints, theOpParam, namesForLoop, loopNr, create);
                    continue;
                }
                if (theOpParam != null) {
                    outputFeatureOpParams = new Vector<edu.udo.cs.miningmart.m4.OpParam>();
                    outputFeatureOpParams.add(theOpParam);
                }
                secondMapChangedInputsToOldNames = this.updateOutputFeatures(outputFeatureOpParams, this.oldNamesOfOutputAttribs, startLoopNr, loopNr);
            }
            this.oldNamesOfOutputAttribs = null;
        }
        if (mapChangedInputsToOldNames == null) {
            this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames = secondMapChangedInputsToOldNames;
        } else if (secondMapChangedInputsToOldNames == null) {
            this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames = mapChangedInputsToOldNames;
        } else {
            for (Map.Entry myEntry : secondMapChangedInputsToOldNames.entrySet()) {
                mapChangedInputsToOldNames.put(myEntry.getKey(), myEntry.getValue());
            }
            this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames = mapChangedInputsToOldNames;
        }
    }

    private Map updateOutputFeatures(Collection featureOpParams, Map mapFromOpParamsToOldNames, int startLoopNr, int currentLoopNumber) throws M4Exception {
        if (mapFromOpParamsToOldNames == null || featureOpParams == null) {
            return null;
        }
        Iterator it = featureOpParams.iterator();
        Map mapChangedInputParamsOfFollowingStepsToOldNames = null;
        while (it.hasNext()) {
            OpParam myOutputFeatureOpPar = (OpParam)it.next();
            Collection applicableConstraints = this.getApplicableOutputConstraints(myOutputFeatureOpPar);
            Collection names = (Collection)mapFromOpParamsToOldNames.get(myOutputFeatureOpPar);
            if (!myOutputFeatureOpPar.isCoordinated()) {
                Collection namesForThisLoop = this.removeLoopsFromNames(names, currentLoopNumber);
                mapChangedInputParamsOfFollowingStepsToOldNames = this.workOnOutputBAs(applicableConstraints, myOutputFeatureOpPar, namesForThisLoop, currentLoopNumber, false);
                continue;
            }
            int newStartLoopNr = 1;
            int newEndLoopNr = names != null ? names.size() : this.getHighestLoopNr(myOutputFeatureOpPar);
            for (int loop = newStartLoopNr; loop <= newEndLoopNr; ++loop) {
                Collection namesForThisLoop = this.removeLoopsFromNames(names, loop);
                mapChangedInputParamsOfFollowingStepsToOldNames = this.workOnOutputBAs(applicableConstraints, myOutputFeatureOpPar, namesForThisLoop, loop, false);
            }
        }
        return mapChangedInputParamsOfFollowingStepsToOldNames;
    }

    private Collection removeLoopsFromNames(Collection theNames, int loopNr) {
        if (theNames == null) {
            return null;
        }
        Vector<String> ret = new Vector<String>();
        for (String aName : theNames) {
            String suffix;
            if (!aName.endsWith(suffix = internalNameSeparator + loopNr)) continue;
            int endIndex = aName.length() - suffix.length();
            String originalName = aName.substring(0, endIndex);
            ret.add(originalName);
        }
        return ret;
    }

    private String addLoopNumberToName(String name, int loopNr) {
        return name + internalNameSeparator + loopNr;
    }

    private String getNameWithoutLoopNumber(String nameWithLoop) {
        if (nameWithLoop == null) {
            return null;
        }
        int index = nameWithLoop.indexOf(internalNameSeparator);
        if (index > -1) {
            String prefix = nameWithLoop.substring(0, index);
            return prefix;
        }
        return nameWithLoop;
    }

    private int getLoopNumberWithoutName(String nameWithLoop) {
        if (nameWithLoop == null) {
            return -1;
        }
        int index = nameWithLoop.indexOf(internalNameSeparator);
        if (index > -1) {
            String suffix = nameWithLoop.substring(index + internalNameSeparator.length());
            int loop = -1;
            try {
                loop = Integer.parseInt(suffix);
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
            return loop;
        }
        return -1;
    }

    public boolean adaptOutputToChangedInput() throws M4Exception {
        Map outputOpParamsToInfos = this.storeCurrentOutput();
        this.workOnOutput(null, null, false);
        return this.compareOutputs(outputOpParamsToInfos);
    }

    private boolean compareOutputs(Map outputOpParamsToParamObjects) throws M4Exception {
        if (outputOpParamsToParamObjects == null) {
            return false;
        }
        Map currentMap = this.storeCurrentOutput();
        for (OpParam outputOpParam : currentMap.keySet()) {
            Collection current = (Collection)currentMap.get(outputOpParam);
            Collection previous = (Collection)outputOpParamsToParamObjects.get(outputOpParam);
            if (current.size() != previous.size()) {
                return true;
            }
            Iterator currentIt = current.iterator();
            boolean differenceFound = false;
            while (currentIt.hasNext() && !differenceFound) {
                Object currentInfoObj = currentIt.next();
                if (currentInfoObj instanceof ConceptualAttributeInfo && !((ConceptualAttributeInfo)currentInfoObj).hasMatchIn(previous)) {
                    differenceFound = true;
                }
                if (!(currentInfoObj instanceof ConceptualConceptInfo) || ((ConceptualConceptInfo)currentInfoObj).hasMatchIn(previous)) continue;
                differenceFound = true;
            }
            if (!differenceFound) continue;
            return true;
        }
        return false;
    }

    private Map storeCurrentOutput() throws M4Exception {
        if (this.getTheOperator() == null) {
            return null;
        }
        Iterator outOpParamsIt = this.getTheOperator().getAllOutputOperatorParameters().iterator();
        HashMap theMap = new HashMap();
        while (outOpParamsIt.hasNext()) {
            OpParam outputOpPar = (OpParam)outOpParamsIt.next();
            Iterator paramsIt = this.getParameterTuples(outputOpPar).iterator();
            Vector<Object> infoObjects = new Vector<Object>();
            while (paramsIt.hasNext()) {
                Parameter myParam = (Parameter)paramsIt.next();
                edu.udo.cs.miningmart.m4.core.ParameterObject theObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)myParam.getTheParameterObject();
                if (theObj instanceof Concept) {
                    infoObjects.add(new ConceptualConceptInfo((Concept)theObj));
                }
                if (!(theObj instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) continue;
                infoObjects.add(new ConceptualAttributeInfo((edu.udo.cs.miningmart.m4.core.BaseAttribute)theObj));
            }
            theMap.put(outputOpPar, infoObjects);
        }
        return theMap;
    }

    private int getStartOrEndLoopNumber(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames, boolean start) throws M4Exception {
        int startLoopNr = 0;
        int endLoopNr = 0;
        if (this.getLoopCount() > 0) {
            startLoopNr = 1;
            endLoopNr = this.getLoopCount();
        }
        if (theOpParam != null && theOpParam.isCoordinated()) {
            startLoopNr = 1;
            endLoopNr = theNames != null ? theNames.size() : this.getHighestLoopNr(theOpParam);
        }
        return start ? startLoopNr : endLoopNr;
    }

    private void checkWorkOnOutputRelation(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames, boolean create) throws M4Exception {
        if (this.getTheOperator() == null) {
            return;
        }
        OpParam relationOpParam = null;
        if (theOpParam == null) {
            for (OpParam anOpPar : this.getTheOperator().getAllOutputOperatorParameters()) {
                if (!anOpPar.isRelationParameter()) continue;
                relationOpParam = anOpPar;
            }
        } else {
            relationOpParam = (OpParam)theOpParam;
        }
        if (relationOpParam != null) {
            String theName = null;
            if (create) {
                theName = this.extractSingleName(theNames);
            }
            this.workOnOutputRelation(relationOpParam, theName, create);
        }
    }

    private String extractSingleName(Collection theNames) throws M4Exception {
        if (theNames == null || theNames.size() != 1) {
            throw new M4Exception("Step '" + this.getName() + "': found 0 or several names for output parameter, but need exactly one!");
        }
        String theName = null;
        try {
            theName = (String)theNames.iterator().next();
        }
        catch (ClassCastException cce) {
            Collection c = (Collection)theNames.iterator().next();
            theName = (String)c.iterator().next();
        }
        return theName;
    }

    private void deleteParameters(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        int startLoop;
        int endLoop = this.getHighestLoopNr(theOpParam);
        for (int l = startLoop = theOpParam.isCoordinated() || theOpParam.isLoopable() && this.getLoopCount() > 0 ? 1 : 0; l <= endLoop; ++l) {
            Collection c = this.getParameter(theOpParam, l);
            if (c == null) continue;
            for (edu.udo.cs.miningmart.m4.core.ParameterObject myParObj : c) {
                myParObj.deleteSoon();
            }
            this.setParameter(theOpParam, new Vector(), l);
        }
    }

    private Collection getApplicableOutputConstraints(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        if (this.getTheOperator() == null) {
            return null;
        }
        Collection applicableConstraints = new Vector();
        if (theOpParam != null) {
            applicableConstraints = theOpParam.getApplicableConstraints();
            if (!(!applicableConstraints.isEmpty() || this.getTheOperator().getName().equals("SpecifiedStatistics") || this.getTheOperator().getName().equals("SegmentationStratified") || this.getTheOperator().getName().equals("Unsegment") || this.getTheOperator().getName().equals("CreateOneToManyRelation") || this.getTheOperator().getName().equals("CreateManyToManyRelation") || this.getTheOperator().getName().equals("ReversePivotize"))) {
                throw new M4Exception("Step '" + this.getName() + "': the operator does not specify the output parameters (missing constraints on output parameters)!");
            }
        } else {
            for (OpParam anOutputOpPar : this.getTheOperator().getAllOutputOperatorParameters()) {
                if (!anOutputOpPar.isConceptParameter()) continue;
                applicableConstraints.addAll(anOutputOpPar.getApplicableConstraints());
            }
        }
        return applicableConstraints;
    }

    private void workOnOutputRelation(edu.udo.cs.miningmart.m4.OpParam theOpParam, String theName, boolean create) throws M4Exception {
        Relation rel = null;
        boolean isManyToMany = false;
        if (create) {
            isManyToMany = this.createOutputRelationWithoutKeys(theOpParam, theName);
        }
        if ((rel = (Relation)this.getSingleParameterObject(theOpParam.getName())) != null) {
            this.adjustKeysOfRelation(theOpParam, rel, isManyToMany);
        }
    }

    private boolean createOutputRelationWithoutKeys(edu.udo.cs.miningmart.m4.OpParam theOpParam, String theName) throws M4Exception {
        Relation rel = (Relation)this.getM4Db().createNewInstance(Relation.class);
        rel.setName(theName);
        Vector<Relation> v = new Vector<Relation>();
        v.add(rel);
        this.setParameter(theOpParam, v, 0);
        Concept fromConcept = null;
        Concept toConcept = null;
        Columnset crossLinkCs = null;
        boolean isManyToMany = false;
        String fromConceptName = null;
        String toConceptName = null;
        String crossConceptName = null;
        Collection constrColl = theOpParam.getApplicableConstraints();
        if (constrColl != null) {
            for (edu.udo.cs.miningmart.m4.core.Constraint myConstraint : constrColl) {
                if (myConstraint.getType().equals("TOCON")) {
                    toConceptName = myConstraint.getObj2();
                }
                if (myConstraint.getType().equals("FROMCON")) {
                    fromConceptName = myConstraint.getObj2();
                }
                if (!myConstraint.getType().equals("CROSSCON")) continue;
                crossConceptName = myConstraint.getObj2();
            }
        }
        if (fromConceptName == null || toConceptName == null) {
            throw new M4Exception("Step '" + this.getName() + "': could not determine the FROM or TO concept parameter name for creating the relation!");
        }
        fromConcept = (Concept)this.getSingleParameterObject(fromConceptName);
        toConcept = (Concept)this.getSingleParameterObject(toConceptName);
        Concept crossConcept = (Concept)this.getSingleParameterObject(crossConceptName);
        if (crossConcept != null) {
            isManyToMany = true;
            crossLinkCs = (Columnset)crossConcept.getCurrentColumnSet();
        }
        if (fromConcept == null || toConcept == null) {
            throw new M4Exception("Step '" + this.getName() + "': could not determine FromConcept and/or ToConcept for output relation!");
        }
        rel.setTheFromConcept(fromConcept);
        rel.setTheToConcept(toConcept);
        if (crossLinkCs != null) {
            rel.setCrossLinkColumnSet(crossLinkCs);
        }
        return isManyToMany;
    }

    private void adjustKeysOfRelation(edu.udo.cs.miningmart.m4.OpParam theOpParam, Relation rel, boolean isManyToMany) throws M4Exception {
        ForeignKey oldFrom = (ForeignKey)rel.getFromKey();
        if (oldFrom != null) {
            oldFrom.deleteSoon();
        }
        rel.removeFromKey();
        ForeignKey oldTo = (ForeignKey)rel.getToKey();
        if (oldTo != null) {
            oldTo.deleteSoon();
        }
        rel.removeToKey();
        Collection fromConceptKeyAttribs = null;
        Collection toConceptKeyAttribs = null;
        Collection crossConceptToFromAttribs = null;
        Collection crossConceptToToAttribs = null;
        String fromConceptKeyName = null;
        String toConceptKeyName = null;
        String crossConceptFromKeyName = null;
        String crossConceptToKeyName = null;
        Collection constrColl = theOpParam.getApplicableConstraints();
        if (constrColl != null) {
            for (edu.udo.cs.miningmart.m4.core.Constraint myConstraint : constrColl) {
                if (myConstraint.getType().equals("FROMKEY")) {
                    fromConceptKeyName = myConstraint.getObj2();
                }
                if (myConstraint.getType().equals("TOKEY")) {
                    toConceptKeyName = myConstraint.getObj2();
                }
                if (myConstraint.getType().equals("CR_FROMKEY")) {
                    crossConceptFromKeyName = myConstraint.getObj2();
                }
                if (!myConstraint.getType().equals("CR_TOKEY")) continue;
                crossConceptToKeyName = myConstraint.getObj2();
            }
        }
        if (fromConceptKeyName == null || toConceptKeyName == null) {
            throw new M4Exception("Step '" + this.getName() + "': could not determine the FROM or TO KEY parameter name for creating the relation!");
        }
        fromConceptKeyAttribs = this.getParameterObjects(fromConceptKeyName);
        toConceptKeyAttribs = this.getParameterObjects(toConceptKeyName);
        if (isManyToMany) {
            crossConceptToFromAttribs = this.getParameterObjects(crossConceptFromKeyName);
            crossConceptToToAttribs = this.getParameterObjects(crossConceptToKeyName);
        }
        if (!isManyToMany) {
            ForeignKey theForeignKey = (ForeignKey)this.getM4Db().createNewInstance(ForeignKey.class);
            theForeignKey.setForeignKeyColumnset(rel.getTheFromConcept().getCurrentColumnSet());
            theForeignKey.setPrimaryKeyColumnset(rel.getTheToConcept().getCurrentColumnSet());
            theForeignKey.createColumnLinksFromAttribs(fromConceptKeyAttribs, toConceptKeyAttribs);
            theForeignKey.setName(rel.getName() + "_FK");
            rel.setFromKey(theForeignKey);
            rel.setToKey(null);
            rel.setCrossLinkColumnSet(null);
        } else {
            ForeignKey linkCrossToFromConcept = (ForeignKey)this.getM4Db().createNewInstance(ForeignKey.class);
            ForeignKey linkCrossToToConcept = (ForeignKey)this.getM4Db().createNewInstance(ForeignKey.class);
            String crossTableName = rel.getCrossLinkColumnSet().getName();
            linkCrossToFromConcept.setName(crossTableName + "_" + rel.getTheFromConcept().getName() + "_FK");
            linkCrossToToConcept.setName(crossTableName + "_" + rel.getTheToConcept().getName() + "_FK");
            linkCrossToFromConcept.setPrimaryKeyColumnset(rel.getTheFromConcept().getCurrentColumnSet());
            linkCrossToFromConcept.setForeignKeyColumnset(rel.getCrossLinkColumnSet());
            linkCrossToToConcept.setPrimaryKeyColumnset(rel.getTheToConcept().getCurrentColumnSet());
            linkCrossToToConcept.setForeignKeyColumnset(rel.getCrossLinkColumnSet());
            linkCrossToFromConcept.createColumnLinksFromAttribs(crossConceptToFromAttribs, fromConceptKeyAttribs);
            linkCrossToToConcept.createColumnLinksFromAttribs(crossConceptToToAttribs, toConceptKeyAttribs);
            rel.setFromKey(linkCrossToFromConcept);
            rel.setToKey(linkCrossToToConcept);
        }
    }

    private Collection getOutputFeatureOpParams() throws M4Exception {
        if (this.getTheOperator() == null) {
            return null;
        }
        Iterator it = this.getTheOperator().getAllOutputOperatorParameters().iterator();
        Vector<OpParam> ret = new Vector<OpParam>();
        while (it.hasNext()) {
            OpParam outputOpPar = (OpParam)it.next();
            if (!outputOpPar.isBaseAttribParameter() && !outputOpPar.isFeatureParameter()) continue;
            ret.add(outputOpPar);
        }
        return ret;
    }

    private Collection getNamesForThisLoop(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames, int startLoopNr, int loopNr) throws M4Exception {
        if (theOpParam != null && (theOpParam.isLoopable() || theOpParam.isCoordinated())) {
            Iterator it = theNames.iterator();
            int counter = startLoopNr;
            while (it.hasNext()) {
                Collection namesForOneLoop = (Collection)it.next();
                if (counter == loopNr) {
                    return namesForOneLoop;
                }
                ++counter;
            }
            throw new M4Exception("Step.create/updateOutput: method getNamesForThisLoop could not find the names for loop number " + loopNr + "!");
        }
        return theNames;
    }

    private HashMap storeNamesOfOpParams(Collection opParams) throws M4Exception {
        if (opParams == null) {
            return null;
        }
        Iterator it = opParams.iterator();
        HashMap theMap = new HashMap();
        while (it.hasNext()) {
            OpParam outputOpPar = (OpParam)it.next();
            Vector<String> theNames = new Vector<String>();
            Collection params = this.getParameterTuples(outputOpPar);
            for (Parameter myPar : params) {
                edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)myPar.getTheParameterObject();
                if (myParObj == null) continue;
                String nameToStore = this.addLoopNumberToName(myParObj.getName(), myPar.getLoopNr());
                theNames.add(nameToStore);
            }
            theMap.put(outputOpPar, theNames);
        }
        return theMap;
    }

    private Map workOnOutputConcept(String theName, boolean create) throws M4Exception {
        if (this.getTheOperator() == null) {
            return null;
        }
        OpParam theOutputConceptOpParam = this.getOutputConceptOpParamForThisStep();
        if (theOutputConceptOpParam == null) {
            return null;
        }
        if (create) {
            this.createEmptyOutputConceptForThisStep(theName, theOutputConceptOpParam);
        }
        Concept outputConcept = this.checkConceptExists(theOutputConceptOpParam);
        Collection featuresForOutputConcept = this.getInputFeaturesForOutputConceptByConstraints();
        featuresForOutputConcept = this.checkExistenceOfInputFeatures(featuresForOutputConcept);
        Map oldInputParameterNames = null;
        if (featuresForOutputConcept != null && !featuresForOutputConcept.isEmpty()) {
            oldInputParameterNames = this.copyFeaturesIntoConcept(featuresForOutputConcept, outputConcept);
        }
        this.checkForMatchingOutputAttribs(outputConcept);
        this.checkForOutputAttribsToCreateFromInput(outputConcept);
        if (create) {
            this.createSemanticLinksAccordingToAssertions();
        }
        return oldInputParameterNames;
    }

    private void recreateInputParametersForThisStep(Map parametersToOldNames) throws M4Exception {
        Vector allInputParametersThatWereDeleted = new Vector(parametersToOldNames.keySet());
        for (Parameter inputParam : allInputParametersThatWereDeleted) {
            OpParam inputOpParam;
            if (inputParam.getTheStep() == null || !inputParam.getTheStep().equals(this)) continue;
            String[] pairOfNames = (String[])parametersToOldNames.get(inputParam);
            parametersToOldNames.remove(inputParam);
            if (inputParam == null || inputParam.getTheParameterObject() != null || (inputOpParam = (OpParam)this.getTheOperator().getOpParam(this.getParameterNameWithoutSuffix(inputParam.getName()))) == null) continue;
            String oldParamName = this.getNameWithoutLoopNumber(pairOfNames[0]);
            String newParamName = pairOfNames[1] != null ? this.getNameWithoutLoopNumber(pairOfNames[1]) : null;
            int oldLoopNumber = this.getLoopNumberWithoutName(pairOfNames[0]);
            if (oldLoopNumber == -1) {
                throw new M4Exception("Unrecognised loop number in Step.recreateInputParameters!");
            }
            if (inputOpParam.isConceptParameter()) {
                Collection possibleInputs = this.getPossibleConceptsForParam(inputOpParam);
                for (Concept myCandidate : possibleInputs) {
                    if (!myCandidate.getName().equals(oldParamName) && !myCandidate.getName().equals(newParamName)) continue;
                    inputParam.setTheParameterObject(myCandidate);
                }
            }
            if (!inputOpParam.isBaseAttribParameter() && !inputOpParam.isFeatureParameter()) continue;
            Collection allMyInputs = this.getAllInputConcepts();
            for (Concept inputConcept : allMyInputs) {
                for (edu.udo.cs.miningmart.m4.core.BaseAttribute myInBA : inputConcept.getAllBaseAttributes()) {
                    if (!myInBA.getName().equals(oldParamName) && !myInBA.getName().equals(newParamName) || !this.checkFulfillsInInputConceptConstraint(inputOpParam, myInBA)) continue;
                    inputParam.setTheParameterObject(myInBA);
                }
            }
        }
    }

    private boolean checkFulfillsInInputConceptConstraint(OpParam inputOpParamOfThisStep, edu.udo.cs.miningmart.m4.core.BaseAttribute theParamObject) throws M4Exception {
        for (edu.udo.cs.miningmart.m4.core.Constraint myConstr : inputOpParamOfThisStep.getApplicableConstraints()) {
            OpParam otherOpPar;
            if (!myConstr.getType().equals("IN")) continue;
            String otherOpParName = myConstr.getObj1();
            if (otherOpParName.equalsIgnoreCase(inputOpParamOfThisStep.getName())) {
                otherOpParName = myConstr.getObj2();
            }
            if (!(otherOpPar = (OpParam)this.getTheOperator().getOpParam(otherOpParName)).isInput() || !otherOpPar.isConceptParameter()) continue;
            for (Concept oneInputConcept : this.getParameterObjects(otherOpPar.getName())) {
                if (!oneInputConcept.hasFeature(theParamObject)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection getInputFeaturesForOutputConceptByConstraints() throws M4Exception {
        Iterator theConstraintsIt = this.getTheOperator().getConstraints().iterator();
        Vector ret = new Vector();
        boolean exceptionsDone = false;
        while (theConstraintsIt.hasNext()) {
            Collection theInputFeaturesForOutputConcept;
            edu.udo.cs.miningmart.m4.core.Constraint aConstr = (edu.udo.cs.miningmart.m4.core.Constraint)theConstraintsIt.next();
            if (this.outputConceptIsCopyOfInput(aConstr)) {
                String nameOfSecondConstraintObject = aConstr.getObj2();
                OpParam inputConcOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfSecondConstraintObject);
                Concept inputConcept = this.checkConceptExists(inputConcOpPar);
                if (inputConcept == null) {
                    throw new M4Exception("Step '" + this.getName() + "': could not find input concept for copying its features to the output concept!");
                }
                ret.addAll(inputConcept.getFeatures());
            }
            if (this.outputConceptHasSubsetOfInputConceptFeatures(aConstr)) {
                return new Vector();
            }
            OpParam inputOpPar = null;
            inputOpPar = (OpParam)this.addFeaturesFromInputParameter(aConstr);
            if (inputOpPar != null && inputOpPar != null && (theInputFeaturesForOutputConcept = this.getParameter(inputOpPar, 0)) != null) {
                ret.addAll(theInputFeaturesForOutputConcept);
            }
            if (this.copyFeaturesToOutputWithException(aConstr) && !exceptionsDone) {
                Iterator inputConceptsIt = this.getAllInputConcepts().iterator();
                Vector allFeatures = new Vector();
                while (inputConceptsIt.hasNext()) {
                    Concept anInConc = (Concept)inputConceptsIt.next();
                    allFeatures.addAll(anInConc.getAllBaseAttributes());
                }
                ret.addAll(this.removeExceptions(allFeatures));
                exceptionsDone = true;
            }
            Concept relatedConcept = null;
            relatedConcept = this.getRelatedConceptWithFeaturesToCopy(aConstr);
            if (relatedConcept == null) continue;
            ret.addAll(relatedConcept.getAllBaseAttributes());
        }
        return ret;
    }

    private Concept getRelatedConceptWithFeaturesToCopy(edu.udo.cs.miningmart.m4.core.Constraint theConstraint) throws M4Exception {
        boolean takeFeaturesFromFromConcept = false;
        takeFeaturesFromFromConcept = theConstraint.getType().equalsIgnoreCase("FEAT_RFR");
        if (takeFeaturesFromFromConcept || theConstraint.getType().equalsIgnoreCase("FEAT_RTO")) {
            String relParamName = theConstraint.getObj1();
            OpParam relOpPar = (OpParam)this.getTheOperator().getOpParam(relParamName);
            Collection rels = this.getParameter(relOpPar, 0);
            Iterator relIt = rels.iterator();
            Relation inputRel = null;
            if (relIt.hasNext()) {
                inputRel = (Relation)relIt.next();
            }
            if (inputRel == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find input relation for a constraint that specifies that output features come from a related concept!");
            }
            Concept theConcept = (Concept)(takeFeaturesFromFromConcept ? inputRel.getTheFromConcept() : inputRel.getTheToConcept());
            if (theConcept == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find the related concept, for a constraint that specifies that output features come from a related concept!");
            }
            return theConcept;
        }
        return null;
    }

    private void checkForMatchingOutputAttribs(Concept theOutputConcept) throws M4Exception {
        for (edu.udo.cs.miningmart.m4.core.Constraint matchingConstraint : this.getTheOperator().getConstraints()) {
            String parName;
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] matchingAttribs;
            if (!matchingConstraint.getType().equals("MATCHBYCON") || (matchingAttribs = (edu.udo.cs.miningmart.m4.core.BaseAttribute[])this.getParameter(parName = matchingConstraint.getObj1(), 0)) == null) continue;
            Concept oneConcept = null;
            Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> allMatchAttribsOfOneConcept = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
            for (int i = 0; i < matchingAttribs.length; ++i) {
                if (oneConcept == null) {
                    oneConcept = (Concept)matchingAttribs[i].getConcept();
                    allMatchAttribsOfOneConcept.add(matchingAttribs[i]);
                    continue;
                }
                if (!oneConcept.equals(matchingAttribs[i].getConcept())) continue;
                allMatchAttribsOfOneConcept.add(matchingAttribs[i]);
            }
            if (oneConcept == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not find concept(s) for attribs from parameter '" + parName + "', which are to be matched!");
            }
            for (edu.udo.cs.miningmart.m4.core.BaseAttribute newBa : allMatchAttribsOfOneConcept) {
                this.updateOrCreateBaInConcept(theOutputConcept, newBa);
            }
        }
    }

    private void checkForOutputAttribsToCreateFromInput(Concept theOutputConcept) throws M4Exception {
        for (edu.udo.cs.miningmart.m4.core.Constraint createConstraint : this.getTheOperator().getConstraints()) {
            String parName;
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] templateAttribs;
            if (!createConstraint.getType().equals("CREATE_BY") && !createConstraint.getType().equals("CR_SUFFIX") || (templateAttribs = (edu.udo.cs.miningmart.m4.core.BaseAttribute[])this.getParameter(parName = createConstraint.getObj1(), 0)) == null || templateAttribs.length == 0) continue;
            for (int i = 0; i < templateAttribs.length; ++i) {
                Map mapToCorrespondingNames;
                String oldName = this.getTheCase().getOldNameOfChangedFeature(templateAttribs[i].getName());
                if (oldName == null || (mapToCorrespondingNames = this.getMapOfNamesToNamesWithSuffixes(createConstraint, new String[]{oldName})) == null) continue;
                Collection correspondingNames = (Collection)mapToCorrespondingNames.get(oldName);
                if (correspondingNames == null) {
                    return;
                }
                this.deleteFeaturesFromConcept(correspondingNames, theOutputConcept);
            }
            String[] namesOfNewAttribs = this.getNamesBySuffixes(createConstraint, templateAttribs);
            String typeOfNewAttribs = this.getTypeOfCreatedOutputAttribs(parName);
            if (typeOfNewAttribs == null) {
                typeOfNewAttribs = templateAttribs[0].getConceptualDataTypeName();
            }
            if (typeOfNewAttribs == null) {
                throw new M4Exception("Step '" + this.getName() + "': could not determine type of some created output attributes!");
            }
            String[] types = new String[namesOfNewAttribs.length];
            for (int i = 0; i < namesOfNewAttribs.length; ++i) {
                types[i] = typeOfNewAttribs;
            }
            String roleOfNewAttribs = templateAttribs[0].getRoleName();
            String[] roles = new String[namesOfNewAttribs.length];
            for (int i = 0; i < namesOfNewAttribs.length; ++i) {
                roles[i] = roleOfNewAttribs;
            }
            this.createBAsInConcept(namesOfNewAttribs, types, roles, theOutputConcept);
        }
    }

    private String getTypeOfCreatedOutputAttribs(String nameOfConstrainedParameter) throws M4Exception {
        String type = null;
        for (edu.udo.cs.miningmart.m4.core.Constraint aConstraint : this.getTheOperator().getConstraints()) {
            if (!aConstraint.getObj1().equalsIgnoreCase(nameOfConstrainedParameter) || !aConstraint.getType().equals("OUT_TYPE")) continue;
            String parName = aConstraint.getObj2();
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] templates = (edu.udo.cs.miningmart.m4.core.BaseAttribute[])this.getParameter(parName, 0);
            if (templates != null && templates.length > 0) {
                type = templates[0].getConceptualDataTypeName();
                continue;
            }
            type = parName;
        }
        return type;
    }

    private Map getMapOfNamesToNamesWithSuffixes(edu.udo.cs.miningmart.m4.core.Constraint theCreateConstraint, String[] templateBaNames) throws M4Exception {
        HashMap theMap = new HashMap();
        if (theCreateConstraint.getType().equals("CR_SUFFIX")) {
            String suffix = theCreateConstraint.getObj2();
            for (int i = 0; i < templateBaNames.length; ++i) {
                Vector<String> theNames = new Vector<String>();
                theNames.add(templateBaNames[i] + nameSeparator + suffix);
                theNames.trimToSize();
                theMap.put(templateBaNames[i], theNames);
            }
            return theMap;
        }
        if (theCreateConstraint.getType().equals("CREATE_BY")) {
            String secondParamName = theCreateConstraint.getObj2();
            Value[] theValues = (Value[])this.getParameter(secondParamName, 0);
            String firstParamName = theCreateConstraint.getObj1();
            OpParam baOpParam = (OpParam)this.getTheOperator().getOpParam(firstParamName);
            if (baOpParam.isArray()) {
                if (theValues.length != templateBaNames.length) {
                    throw new M4Exception("Step '" + this.getName() + "': there must be as many values for parameter '" + secondParamName + "' as for the corresponding grouped parameter!");
                }
                for (int i = 0; i < templateBaNames.length; ++i) {
                    String valueList = theValues[i].getValue();
                    Vector<String> theNames = new Vector<String>();
                    StringTokenizer st = new StringTokenizer(valueList, ",");
                    while (st.hasMoreTokens()) {
                        String value = st.nextToken().trim();
                        value.replace(' ', nameSeparator);
                        theNames.add(templateBaNames[i] + nameSeparator + value);
                    }
                    theNames.trimToSize();
                    theMap.put(templateBaNames[i], theNames);
                }
            } else {
                OpParam valueOpParam = (OpParam)this.getTheOperator().getOpParam(secondParamName);
                if (theValues.length == 1 && valueOpParam.isValueParameter()) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(theValues[0].getValue());
                    }
                    catch (NumberFormatException nfe) {
                        n = -1;
                    }
                    if (n > 0) {
                        String namePrefix = templateBaNames[0];
                        Vector<String> theNames = new Vector<String>();
                        for (int i = 1; i <= n; ++i) {
                            theNames.add(namePrefix + nameSeparator + i);
                        }
                        theNames.trimToSize();
                        theMap.put(templateBaNames[0], theNames);
                        return theMap;
                    }
                }
                String namePrefix = templateBaNames[0];
                int recursionLevel = 0;
                Vector theNames = new Vector();
                this.recurseThroughValueLists(theNames, namePrefix, theValues, recursionLevel);
                theNames.trimToSize();
                theMap.put(templateBaNames[0], theNames);
            }
        }
        return theMap;
    }

    private String[] getNamesBySuffixes(edu.udo.cs.miningmart.m4.core.Constraint theCreateConstraint, edu.udo.cs.miningmart.m4.core.BaseAttribute[] templateBAs) throws M4Exception {
        String[] templateNames = new String[templateBAs.length];
        for (int i = 0; i < templateNames.length; ++i) {
            templateNames[i] = templateBAs[i].getName();
        }
        Map theMap = this.getMapOfNamesToNamesWithSuffixes(theCreateConstraint, templateNames);
        if (theMap == null) {
            return null;
        }
        Vector allOutputNames = new Vector();
        for (Vector theOutNames : theMap.values()) {
            allOutputNames.addAll(theOutNames);
        }
        String[] ret = new String[allOutputNames.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)allOutputNames.get(i);
        }
        return ret;
    }

    private void recurseThroughValueLists(Vector namesToCreate, String namePrefix, Value[] valueLists, int level) {
        if (level < valueLists.length) {
            String oneValueList = valueLists[level].getValue();
            StringTokenizer st = new StringTokenizer(oneValueList, ", ");
            while (st.hasMoreTokens()) {
                String value = st.nextToken();
                String newPrefix = namePrefix + nameSeparator + value;
                this.recurseThroughValueLists(namesToCreate, newPrefix, valueLists, level + 1);
            }
        } else {
            namesToCreate.add(namePrefix);
        }
    }

    private Collection removeExceptions(Collection features) throws M4Exception {
        Iterator it = this.getTheOperator().getConstraints().iterator();
        Vector ret = new Vector(features);
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Constraint constr = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
            if (!this.copyFeaturesToOutputWithException(constr)) continue;
            String paramName = constr.getObj1();
            OpParam opPar = (OpParam)this.getTheOperator().getOpParam(paramName);
            for (Parameter myParam : this.getParameterTuples(opPar)) {
                ret.remove(myParam.getTheParameterObject());
            }
        }
        return ret;
    }

    private boolean outputConceptIsCopyOfInput(edu.udo.cs.miningmart.m4.core.Constraint theConstraint) {
        return theConstraint.getType().equalsIgnoreCase("SAME_FEAT") && theConstraint.getObj1().equalsIgnoreCase("TheOutputConcept") && theConstraint.getObj2().equalsIgnoreCase("TheInputConcept");
    }

    private boolean outputConceptHasSubsetOfInputConceptFeatures(edu.udo.cs.miningmart.m4.core.Constraint theConstraint) {
        return theConstraint.getType().equalsIgnoreCase("IN") && theConstraint.getObj1().equalsIgnoreCase("TheOutputConcept") && theConstraint.getObj2().equalsIgnoreCase("TheInputConcept");
    }

    private edu.udo.cs.miningmart.m4.OpParam addFeaturesFromInputParameter(edu.udo.cs.miningmart.m4.core.Constraint theConstraint) throws M4Exception {
        if (theConstraint.getType().equalsIgnoreCase("IN") && theConstraint.getObj2().equalsIgnoreCase("TheOutputConcept")) {
            String parName = theConstraint.getObj1();
            OpParam opPar = (OpParam)this.getTheOperator().getOpParam(parName);
            if (opPar != null && opPar.isInput() && (opPar.isFeatureParameter() || opPar.isBaseAttribParameter())) {
                return opPar;
            }
        }
        return null;
    }

    private boolean copyFeaturesToOutputWithException(edu.udo.cs.miningmart.m4.core.Constraint theConstraint) {
        return theConstraint.getType().equalsIgnoreCase("ALL_EXCEPT") && theConstraint.getObj2().equalsIgnoreCase("TheOutputConcept");
    }

    private void createSemanticLinksAccordingToAssertions() throws M4Exception {
        for (Assertion myAss : this.getTheOperator().getAssertions()) {
            boolean isFrom;
            if (myAss.getAssertionType().equals("PROJ")) {
                String fromConceptParName = myAss.getObj2();
                String toConceptParName = myAss.getObj1();
                edu.udo.cs.miningmart.m4.core.ParameterObject[] fromConcepts = this.getParameter(fromConceptParName, 0);
                edu.udo.cs.miningmart.m4.core.ParameterObject[] toConcepts = this.getParameter(toConceptParName, 0);
                for (int i = 0; i < fromConcepts.length; ++i) {
                    for (int j = 0; j < toConcepts.length; ++j) {
                        String projName = null;
                        ((Concept)fromConcepts[i]).createProjectionToConcept((Concept)toConcepts[j], projName);
                    }
                }
            }
            if ((isFrom = myAss.getAssertionType().equals("PROJ_RFROM")) || myAss.getAssertionType().equals("PROJ_RELTO")) {
                Relation rel = this.getRelationFromAssertion(myAss);
                if (rel == null) {
                    throw new M4Exception("Step '" + this.getName() + "': could not find relation for assertion of type '" + (isFrom ? "PROJ_RFROM" : "PROJ_RELTO") + "'!");
                }
                Concept from = this.getConceptFromAssertion(myAss);
                if (from == null) {
                    throw new M4Exception("Step '" + this.getName() + "': could not find concept for assertion of type '" + (isFrom ? "PROJ_RFROM" : "PROJ_RELTO") + "'!");
                }
                Concept to = (Concept)(isFrom ? rel.getTheFromConcept() : rel.getTheToConcept());
                String projName = null;
                from.createProjectionToConcept(to, projName);
            }
            if (!myAss.getAssertionType().equals("SUBSET")) continue;
            String subConceptParName = myAss.getObj1();
            String superConceptParName = myAss.getObj2();
            edu.udo.cs.miningmart.m4.core.ParameterObject[] subConcepts = this.getParameter(subConceptParName, 0);
            edu.udo.cs.miningmart.m4.core.ParameterObject[] superConcepts = this.getParameter(superConceptParName, 0);
            for (int i = 0; i < subConcepts.length; ++i) {
                for (int j = 0; j < superConcepts.length; ++j) {
                    ((Concept)subConcepts[i]).addSuperConcept((Concept)superConcepts[j]);
                }
            }
        }
        this.createOneToManyRelationByAssertion();
    }

    private void createOneToManyRelationByAssertion() throws M4Exception {
        edu.udo.cs.miningmart.m4.core.BaseAttribute[][] allKeys = (edu.udo.cs.miningmart.m4.core.BaseAttribute[][])this.getKeysOfRelationshipAssertion();
        if (allKeys != null) {
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] manyKeys = allKeys[0];
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] oneKeys = allKeys[1];
            if (oneKeys != null && manyKeys != null && oneKeys.length > 0 && manyKeys.length > 0) {
                Concept fromConcept = (Concept)manyKeys[0].getConcept();
                Concept toConcept = (Concept)oneKeys[0].getConcept();
                String nameForRel = fromConcept.getName() + "_" + toConcept.getName() + "_REL";
                Relation rel = (Relation)fromConcept.getRelationshipToConcept(toConcept);
                if (rel == null) {
                    Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> mk = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
                    Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> ok = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
                    for (int i = 0; i < oneKeys.length; ++i) {
                        mk.add(manyKeys[i]);
                        ok.add(oneKeys[i]);
                    }
                    this.getTheCase().createOneToManyRelation(nameForRel, mk, ok);
                }
            }
        }
    }

    private Relation getRelationFromAssertion(Assertion ass) throws M4Exception {
        String obj = ass.getObj1();
        OpParam opPar = (OpParam)this.getTheOperator().getOpParam(obj);
        if (!opPar.isRelationParameter()) {
            obj = ass.getObj2();
            opPar = (OpParam)this.getTheOperator().getOpParam(obj);
            if (!opPar.isRelationParameter()) {
                return null;
            }
        }
        return (Relation)this.getSingleParameterObject(opPar.getName());
    }

    private Concept getConceptFromAssertion(Assertion ass) throws M4Exception {
        String obj = ass.getObj1();
        OpParam opPar = (OpParam)this.getTheOperator().getOpParam(obj);
        if (!opPar.isConceptParameter()) {
            obj = ass.getObj2();
            opPar = (OpParam)this.getTheOperator().getOpParam(obj);
            if (!opPar.isConceptParameter()) {
                return null;
            }
        }
        return (Concept)this.getSingleParameterObject(opPar.getName());
    }

    private OpParam getOutputConceptOpParamForThisStep() throws M4Exception {
        try {
            Collection allOutOpParams = this.getTheOperator().getAllOutputOperatorParameters();
            Vector<OpParam> outConceptOpParams = new Vector<OpParam>();
            if (allOutOpParams != null) {
                for (OpParam outOpParam : allOutOpParams) {
                    if (!outOpParam.isConceptParameter()) continue;
                    outConceptOpParams.add(outOpParam);
                }
            }
            if (outConceptOpParams.isEmpty()) {
                return null;
            }
            if (outConceptOpParams.size() > 1) {
                throw new M4Exception("Found more than on output concept OpParam!");
            }
            return (OpParam)outConceptOpParams.iterator().next();
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Step '" + this.getName() + "': M4 error trying to access output concept OpParam: " + m4e.getMessage());
        }
    }

    public BaseAttribute[][] getKeysOfRelationshipAssertion() throws M4Exception {
        Iterator assIt = this.getTheOperator().getAssertions().iterator();
        Concept manyConcept = null;
        Concept oneConcept = null;
        edu.udo.cs.miningmart.m4.core.BaseAttribute[] manyKeys = null;
        edu.udo.cs.miningmart.m4.core.BaseAttribute[] oneKeys = null;
        while (assIt.hasNext()) {
            String oneKeysParName;
            edu.udo.cs.miningmart.m4.core.ParameterObject[] ones;
            String manyKeysParName;
            edu.udo.cs.miningmart.m4.core.ParameterObject[] manys;
            Assertion myAss = (Assertion)assIt.next();
            boolean manyToOne = false;
            manyToOne = myAss.getAssertionType().equals("REL_N_1");
            if (manyToOne || myAss.getAssertionType().equals("REL_1_N")) {
                String manyConceptParName = manyToOne ? myAss.getObj1() : myAss.getObj2();
                String oneConceptParName = manyToOne ? myAss.getObj2() : myAss.getObj1();
                edu.udo.cs.miningmart.m4.core.ParameterObject[] manyConcepts = this.getParameter(manyConceptParName, 0);
                edu.udo.cs.miningmart.m4.core.ParameterObject[] oneConcepts = this.getParameter(oneConceptParName, 0);
                if (manyConcepts != null && manyConcepts.length > 0) {
                    manyConcept = (Concept)manyConcepts[0];
                }
                if (oneConcepts != null && oneConcepts.length > 0) {
                    oneConcept = (Concept)oneConcepts[0];
                }
            }
            if (myAss.getAssertionType().equals("REL_N_K") && (manys = this.getParameter(manyKeysParName = myAss.getObj1(), 0)) != null && manys.length > 0) {
                manyKeys = new edu.udo.cs.miningmart.m4.core.BaseAttribute[manys.length];
                for (int i = 0; i < manys.length; ++i) {
                    manyKeys[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)manys[i];
                }
            }
            if (!myAss.getAssertionType().equals("REL_1_K") || (ones = this.getParameter(oneKeysParName = myAss.getObj1(), 0)) == null || ones.length <= 0) continue;
            oneKeys = new edu.udo.cs.miningmart.m4.core.BaseAttribute[ones.length];
            for (int i = 0; i < ones.length; ++i) {
                oneKeys[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)ones[i];
            }
        }
        if (manyConcept != null && oneConcept != null && manyKeys != null && oneKeys != null) {
            if (this.attribsBelongToConcept(manyKeys, oneConcept)) {
                manyKeys = this.getCorrespondingAttribs(manyKeys, manyConcept);
            }
            if (this.attribsBelongToConcept(oneKeys, manyConcept)) {
                oneKeys = this.getCorrespondingAttribs(oneKeys, oneConcept);
            }
            if (manyKeys == null || oneKeys == null || manyKeys.length != oneKeys.length) {
                throw new M4Exception("Step '" + this.getName() + "': found nonmatching number of keys for relationship between input and output!");
            }
            BaseAttribute[][] ret = new edu.udo.cs.miningmart.m4.core.BaseAttribute[][]{manyKeys, oneKeys};
            return ret;
        }
        return null;
    }

    private edu.udo.cs.miningmart.m4.core.BaseAttribute[] getCorrespondingAttribs(edu.udo.cs.miningmart.m4.core.BaseAttribute[] theAttribs, Concept theConcept) throws M4Exception {
        if (this.attribsBelongToConcept(theAttribs, theConcept)) {
            return theAttribs;
        }
        if (theAttribs != null) {
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] correspondents = new edu.udo.cs.miningmart.m4.core.BaseAttribute[theAttribs.length];
            for (int i = 0; i < theAttribs.length; ++i) {
                correspondents[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)theConcept.getBaseAttribute(theAttribs[i].getName());
                if (correspondents[i] != null) continue;
                return null;
            }
            return correspondents;
        }
        return null;
    }

    private edu.udo.cs.miningmart.m4.core.BaseAttribute[] getAllCorrespondingAttribs(edu.udo.cs.miningmart.m4.core.BaseAttribute[] theAttribs, Concept theConcept) throws M4Exception {
        if (this.attribsBelongToConcept(theAttribs, theConcept)) {
            return theAttribs;
        }
        if (theAttribs != null) {
            edu.udo.cs.miningmart.m4.core.BaseAttribute[] correspondents = new edu.udo.cs.miningmart.m4.core.BaseAttribute[theAttribs.length];
            for (int i = 0; i < theAttribs.length; ++i) {
                correspondents[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)theConcept.getBaseAttribute(theAttribs[i].getName());
            }
            return correspondents;
        }
        return null;
    }

    private boolean attribsBelongToConcept(edu.udo.cs.miningmart.m4.core.BaseAttribute[] theAttribs, Concept theConcept) throws M4Exception {
        if (theAttribs != null && theConcept != null) {
            for (int i = 0; i < theAttribs.length; ++i) {
                if (theAttribs[i].getConcept().equals(theConcept)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Concept checkConceptExists(OpParam theConceptOpParam) throws M4Exception {
        Concept con = null;
        try {
            Parameter theConcPar = (Parameter)this.getParameterTuple(theConceptOpParam.getName(), 0);
            if (theConcPar == null) {
                throw new M4Exception("Step '" + this.getName() + "': no Parameter for '" + theConceptOpParam.getName() + "' has been created!");
            }
            con = (Concept)theConcPar.getTheParameterObject();
        }
        catch (ClassCastException cce) {
            throw new M4Exception("Step '" + this.getName() + "': found something different from a concept as parameter object of '" + theConceptOpParam.getName() + "'!");
        }
        if (con == null) {
            throw new M4Exception("Step '" + this.getName() + "': failed to reach concept '" + theConceptOpParam.getName() + "'!");
        }
        return con;
    }

    private Collection checkExistenceOfInputFeatures(Collection theInputFeatures) throws M4Exception {
        Vector<edu.udo.cs.miningmart.m4.core.Feature> ret = new Vector<edu.udo.cs.miningmart.m4.core.Feature>();
        if (theInputFeatures != null) {
            Iterator it = theInputFeatures.iterator();
            Collection incons = this.getAllInputConcepts();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature myF = (edu.udo.cs.miningmart.m4.core.Feature)it.next();
                Concept theConcept = (Concept)myF.getConcept();
                if (theConcept == null || !incons.contains(theConcept)) continue;
                ret.add(myF);
            }
        }
        return ret;
    }

    private Map copyFeaturesIntoConcept(Collection theFeatures, edu.udo.cs.miningmart.m4.Concept theConcept) throws M4Exception {
        Collection theFeats = theConcept.getFeatures();
        edu.udo.cs.miningmart.m4.core.Feature[] toDelete = new edu.udo.cs.miningmart.m4.core.Feature[theFeats.size()];
        Iterator outputFeatureIt = theFeats.iterator();
        int i = 0;
        HashMap<Parameter, String[]> mapFromParametersToTheirOldNames = new HashMap<Parameter, String[]>();
        while (outputFeatureIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Feature outF = (edu.udo.cs.miningmart.m4.core.Feature)outputFeatureIt.next();
            Iterator inputFeatureIt = theFeatures.iterator();
            boolean hasCorrespondentInInputConcept = false;
            boolean isUsedAsOutputParameterByDifferentStep = false;
            boolean isRenamed = false;
            while (inputFeatureIt.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Feature inF = (edu.udo.cs.miningmart.m4.core.Feature)inputFeatureIt.next();
                if (!this.isVisible(inF) || !inF.correspondsTo(outF)) continue;
                hasCorrespondentInInputConcept = true;
            }
            isRenamed = this.getTheCase().getNewNameOfChangedFeature(outF.getName()) != null;
            for (Parameter aPar : outF.getParameterReferences()) {
                if (aPar == null || aPar.getTheStep() == null || aPar.getTheStep().equals(this)) continue;
                if (!aPar.isInputParam()) {
                    isUsedAsOutputParameterByDifferentStep = true;
                    continue;
                }
                if (isRenamed || aPar.getTheParameterObject() == null) continue;
                String nameWithLoop = this.addLoopNumberToName(aPar.getTheParameterObject().getName(), aPar.getLoopNr());
                String[] pairOfOldAndNewNames = new String[]{nameWithLoop, null};
                mapFromParametersToTheirOldNames.put(aPar, pairOfOldAndNewNames);
            }
            toDelete[i] = hasCorrespondentInInputConcept || isRenamed || isUsedAsOutputParameterByDifferentStep ? null : outF;
            ++i;
        }
        for (i = 0; i < toDelete.length; ++i) {
            if (toDelete[i] == null) continue;
            toDelete[i].deleteSoon();
        }
        for (edu.udo.cs.miningmart.m4.core.Feature myF : theFeatures) {
            if (!this.isVisible(myF)) continue;
            if (myF instanceof MultiColumnFeature) {
                for (edu.udo.cs.miningmart.m4.core.BaseAttribute ba : ((MultiColumnFeature)myF).getBaseAttributes()) {
                    this.updateOrCreateBaInConcept(theConcept, ba);
                }
                continue;
            }
            edu.udo.cs.miningmart.m4.core.BaseAttribute ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)myF;
            this.updateOrCreateBaInConcept(theConcept, ba);
        }
        return mapFromParametersToTheirOldNames;
    }

    private void updateOrCreateBaInConcept(edu.udo.cs.miningmart.m4.Concept theConcept, BaseAttribute templateBa) throws M4Exception {
        Iterator baIt = theConcept.getAllBaseAttributes().iterator();
        boolean wasUpdated = false;
        while (baIt.hasNext()) {
            String newName;
            edu.udo.cs.miningmart.m4.core.BaseAttribute myBA = (edu.udo.cs.miningmart.m4.core.BaseAttribute)baIt.next();
            if (myBA.correspondsTo(templateBa)) {
                myBA.setConceptualDataTypeName(templateBa.getConceptualDataTypeName());
                myBA.setRole(templateBa.getRole());
                wasUpdated = true;
            }
            if ((newName = this.getTheCase().getNewNameOfChangedFeature(myBA.getName())) == null) continue;
            myBA.setName(newName);
            wasUpdated = true;
        }
        if (!wasUpdated) {
            if (theConcept.getBaseAttribute(templateBa.getName()) != null) {
                throw new M4Exception("Step '" + this.getName() + "': attempt to add a double BaseAttribute to the output concept!");
            }
            theConcept.createBaseAttribute(templateBa.getName(), templateBa.getConceptualDataTypeName(), "MINING", templateBa.getRoleName());
        }
    }

    private void createEmptyOutputConceptForThisStep(String theName, edu.udo.cs.miningmart.m4.OpParam theOutputConceptOpParam) throws M4Exception {
        Concept existingConcept = null;
        edu.udo.cs.miningmart.m4.Parameter existingParameter = null;
        try {
            existingParameter = (Parameter)this.getParameterTuple(theOutputConceptOpParam.getName(), 0);
            if (existingParameter != null) {
                existingConcept = (Concept)existingParameter.getTheParameterObject();
            }
        }
        catch (ClassCastException cce) {
            throw new M4Exception("Step '" + this.getName() + "': Parameter object for output concept was not a concept!");
        }
        if (existingConcept != null) {
            throw new M4Exception("Step '" + this.getName() + "': createOutput was called with output concept, but it exists already!");
        }
        if (theName.equals("")) {
            throw new UserError("Step '" + this.getName() + "': empty output object name!");
        }
        Concept conceptWithGivenName = (Concept)this.getTheCase().getConcept(theName);
        Concept newOutputConcept = null;
        if (conceptWithGivenName != null) {
            conceptWithGivenName.removeAllFeatures();
            newOutputConcept = conceptWithGivenName;
        } else {
            newOutputConcept = (Concept)this.getTheCase().createConcept(theName, "MINING");
        }
        if (existingParameter == null) {
            existingParameter = this.createParameterTuple(theOutputConceptOpParam.getName(), newOutputConcept, this.getFreeParameterNumber(), 0, "OUT");
        } else {
            existingParameter.setTheParameterObject(newOutputConcept);
        }
    }

    private Map workOnOutputBAs(Collection theConstraints, edu.udo.cs.miningmart.m4.OpParam theOutputOpParam, Collection theNames, int loopNr, boolean create) throws M4Exception {
        if (theConstraints == null || this.getTheOperator() == null) {
            return null;
        }
        String type = null;
        String role = null;
        edu.udo.cs.miningmart.m4.core.Constraint inOutputConceptConstraint = null;
        edu.udo.cs.miningmart.m4.core.Constraint inInputConceptConstraint = null;
        Concept outputConcept = null;
        Concept inputConcept = null;
        for (edu.udo.cs.miningmart.m4.core.Constraint aConstr : theConstraints) {
            if (aConstr.getType().equalsIgnoreCase("TYPE")) {
                Value v;
                type = aConstr.getObj2();
                OpParam valueOpPar = (OpParam)this.getTheOperator().getOpParam(type);
                if (valueOpPar != null && valueOpPar.isValueParameter() && (v = (Value)this.getParameterArray(valueOpPar, loopNr).getParameterObjectArray()[0]) != null) {
                    type = v.getValue();
                }
            }
            if (aConstr.getType().equalsIgnoreCase("SAME_TYPE")) {
                String[] result = this.getTypeAndRoleFromCorrespondingBA(aConstr, loopNr);
                type = result[0];
                role = result[1];
            }
            if (aConstr.getType().equalsIgnoreCase("RENAME_OUT")) {
                this.addRenamedFeaturesToOutput(aConstr, theNames, loopNr);
            }
            if (!aConstr.getType().equalsIgnoreCase("IN")) continue;
            String whatIsContained = aConstr.getObj1();
            OpParam containedOpPar = (OpParam)this.getTheOperator().getOpParam(whatIsContained);
            if (containedOpPar == null) {
                throw new M4Exception("Step '" + this.getName() + "': found IN constraint whose object 1 is not a parameter!");
            }
            if (!containedOpPar.isBaseAttribParameter() && !containedOpPar.isFeatureParameter() || containedOpPar.isInput()) continue;
            String containedIn = aConstr.getObj2();
            OpParam containedInOpPar = (OpParam)this.getTheOperator().getOpParam(containedIn);
            if (containedInOpPar == null) {
                throw new M4Exception("Step '" + this.getName() + "': found IN constraint whose object 2 is not a parameter!");
            }
            if (!containedInOpPar.isConceptParameter()) {
                throw new M4Exception("Step '" + this.getName() + "': found IN constraint for output BA without a Concept in object 2!");
            }
            Parameter conceptPar = (Parameter)this.getParameterTuple(containedInOpPar.getName(), 0);
            if (conceptPar == null) {
                return null;
            }
            Concept conceptFromInConstraint = (Concept)conceptPar.getTheParameterObject();
            if (!conceptPar.isInputParam()) {
                if (conceptFromInConstraint == null) {
                    throw new M4Exception("Step '" + this.getName() + "': method workOnOutput was called with an output BA " + "that belongs to an output concept; " + "please create that concept first!");
                }
                inOutputConceptConstraint = aConstr;
                outputConcept = conceptFromInConstraint;
                continue;
            }
            inInputConceptConstraint = aConstr;
            inputConcept = conceptFromInConstraint;
            if (inputConcept != null) continue;
            return null;
        }
        if (role == null) {
            role = this.determineRoleByAssertions(theOutputOpParam, loopNr);
        }
        Map mapInputParamsToOldNames = this.handleBaConstraints(inInputConceptConstraint, inOutputConceptConstraint, theNames, (OpParam)theOutputOpParam, type, role, inputConcept, outputConcept, create, loopNr);
        this.createOneToManyRelationByAssertion();
        return mapInputParamsToOldNames;
    }

    private Map handleBaConstraints(edu.udo.cs.miningmart.m4.core.Constraint inInputConceptConstraint, edu.udo.cs.miningmart.m4.core.Constraint inOutputConceptConstraint, Collection theNames, OpParam theOutputOpParam, String type, String roleName, Concept inputConcept, Concept outputConcept, boolean create, int loopNr) throws M4Exception {
        if (inInputConceptConstraint == null && inOutputConceptConstraint == null) {
            return null;
        }
        String[] typesOfInputBAs = new String[theNames.size()];
        Collection baseAttribsOfThisOutputParam = null;
        if (inOutputConceptConstraint == null) {
            String[] theTypes = new String[theNames.size()];
            String[] namesArray = new String[theNames.size()];
            String[] roles = new String[theNames.size()];
            if (type == null) {
                type = "NOMINAL";
            }
            if (roleName == null) {
                roleName = "NO_ROLE";
            }
            Iterator namesIt = theNames.iterator();
            int j = 0;
            while (namesIt.hasNext()) {
                namesArray[j] = (String)namesIt.next();
                theTypes[j] = type;
                roles[j] = roleName;
                ++j;
            }
            baseAttribsOfThisOutputParam = this.createBAsInConcept(namesArray, theTypes, roles, inputConcept);
        } else {
            Iterator theNamesIt = theNames.iterator();
            Vector<String> namesOfBAsForOutput = new Vector<String>();
            Vector<String> typesOfBAsForOutput = new Vector<String>();
            Vector<String> rolesOfBAsForOutput = new Vector<String>();
            while (theNamesIt.hasNext()) {
                String oneNewName = (String)theNamesIt.next();
                if (oneNewName.equals("")) {
                    throw new UserError("Step '" + this.getName() + "': empty output object name!");
                }
                if (inInputConceptConstraint != null) {
                    edu.udo.cs.miningmart.m4.core.Feature inF = (edu.udo.cs.miningmart.m4.core.Feature)inputConcept.getFeature(oneNewName);
                    if (inF == null || !this.isVisible(inF) || !(inF instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) continue;
                    typesOfBAsForOutput.add(((edu.udo.cs.miningmart.m4.core.BaseAttribute)inF).getConceptualDataTypeName());
                    rolesOfBAsForOutput.add(((edu.udo.cs.miningmart.m4.core.BaseAttribute)inF).getRoleName());
                    namesOfBAsForOutput.add(oneNewName);
                    continue;
                }
                boolean done = this.handleUnsegment(typesOfBAsForOutput, namesOfBAsForOutput, rolesOfBAsForOutput, oneNewName);
                if (done) continue;
                typesOfBAsForOutput.add(type);
                rolesOfBAsForOutput.add(roleName);
                namesOfBAsForOutput.add(oneNewName);
            }
            String[] outNames = new String[namesOfBAsForOutput.size()];
            typesOfInputBAs = new String[typesOfBAsForOutput.size()];
            String[] roles = new String[rolesOfBAsForOutput.size()];
            Iterator namesIt = namesOfBAsForOutput.iterator();
            Iterator typesIt = typesOfBAsForOutput.iterator();
            Iterator rolesIt = rolesOfBAsForOutput.iterator();
            int i = 0;
            while (namesIt.hasNext()) {
                outNames[i] = (String)namesIt.next();
                typesOfInputBAs[i] = (String)typesIt.next();
                roles[i] = (String)rolesIt.next();
                ++i;
            }
            baseAttribsOfThisOutputParam = this.createBAsInConcept(outNames, typesOfInputBAs, roles, outputConcept);
        }
        if (baseAttribsOfThisOutputParam != null) {
            Map oldInputParamObjectNames = this.setParameter(theOutputOpParam, baseAttribsOfThisOutputParam, loopNr);
            return oldInputParamObjectNames;
        }
        return null;
    }

    private boolean handleUnsegment(Collection types, Collection names, Collection roles, String nameOfOutputAttrib) throws M4Exception {
        if (this.getTheOperator().getName().equals("Unsegment")) {
            if (nameOfOutputAttrib.equals("(Random)")) {
                return true;
            }
            for (Step predecessor : this.getTheCase().getStepsToCompileBefore(this, true)) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute origAttrib;
                Parameter originalAttribParam;
                if (!predecessor.getTheOperator().getName().equals("SegmentationStratified") || (originalAttribParam = (Parameter)predecessor.getParameterTuple("TheAttribute", 0)) == null || (origAttrib = (edu.udo.cs.miningmart.m4.core.BaseAttribute)originalAttribParam.getTheParameterObject()) == null) continue;
                String type = origAttrib.getConceptualDataTypeName();
                types.add(type);
                names.add(nameOfOutputAttrib);
                roles.add(origAttrib.getRoleName());
                return true;
            }
        }
        return false;
    }

    private String determineRoleByAssertions(edu.udo.cs.miningmart.m4.OpParam theOutputOpParam, int loopNr) throws M4Exception {
        Collection assertions = this.getTheOperator().getAssertions();
        assertions = this.getRelevantAssertions(theOutputOpParam.getName(), assertions);
        for (Assertion ass : assertions) {
            edu.udo.cs.miningmart.m4.core.BaseAttribute correspondingAttrib;
            if (!ass.getAssertionType().equalsIgnoreCase("MV_FROM")) continue;
            String otherParamOfAssertion = ass.getObj1();
            if (ass.getObj1().equalsIgnoreCase(theOutputOpParam.getName())) {
                otherParamOfAssertion = ass.getObj2();
            }
            if ((correspondingAttrib = this.getAssociatedAttribute(theOutputOpParam.getName(), otherParamOfAssertion, loopNr)) == null) continue;
            return correspondingAttrib.getRoleName();
        }
        return "NO_ROLE";
    }

    private void addRenamedFeaturesToOutput(edu.udo.cs.miningmart.m4.core.Constraint theRenameConstraint, Collection newNames, int loopNr) throws M4Exception {
        if (!theRenameConstraint.getType().equalsIgnoreCase("RENAME_OUT")) {
            return;
        }
        String inputParamName = theRenameConstraint.getObj1();
        String outputParamName = theRenameConstraint.getObj2();
        OpParam outOpPar = (OpParam)this.getTheOperator().getOpParam(outputParamName);
        OpParam inOpPar = (OpParam)this.getTheOperator().getOpParam(inputParamName);
        Collection sourceFeatureParams = this.getParameterTuples(inOpPar, loopNr);
        if (sourceFeatureParams.size() != newNames.size()) {
            throw new M4Exception("Step '" + this.getName() + "': error matching parameters for a RENAME constraint!");
        }
        edu.udo.cs.miningmart.m4.core.BaseAttribute[] sourceBAs = new edu.udo.cs.miningmart.m4.core.BaseAttribute[sourceFeatureParams.size()];
        Iterator it = sourceFeatureParams.iterator();
        int i = 0;
        while (it.hasNext()) {
            Parameter aPar = (Parameter)it.next();
            sourceBAs[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)aPar.getTheParameterObject();
            ++i;
        }
        String[] namesForOutBAs = new String[newNames.size()];
        it = newNames.iterator();
        String[] typesForOutBAs = new String[namesForOutBAs.length];
        String[] rolesForOutBAs = new String[namesForOutBAs.length];
        for (i = 0; i < namesForOutBAs.length; ++i) {
            namesForOutBAs[i] = (String)it.next();
            typesForOutBAs[i] = sourceBAs[i].getConceptualDataTypeName();
            rolesForOutBAs[i] = sourceBAs[i].getRoleName();
        }
        Concept outputConcept = (Concept)this.getOutputConcept();
        for (int j = 0; j < namesForOutBAs.length; ++j) {
            for (edu.udo.cs.miningmart.m4.core.BaseAttribute ba : outputConcept.getAllBaseAttributes()) {
                if (!ba.getName().equalsIgnoreCase(namesForOutBAs[j])) continue;
                throw new M4Exception("Step '" + this.getName() + "': cannot create features of output concept because output parameter\n'" + outputParamName + "' contains the name '" + namesForOutBAs[j] + "', which either occurs more than once (ignoring case)\nin this parameter, or it already occurs as another input feature!");
            }
        }
        Collection outputBAs = this.createBAsInConcept(namesForOutBAs, typesForOutBAs, rolesForOutBAs, outputConcept);
        this.setParameter(outOpPar, outputBAs, loopNr);
    }

    private Collection createBAsInConcept(String[] theNames, String[] types, String[] roleNames, edu.udo.cs.miningmart.m4.Concept theConcept) throws M4Exception {
        Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> ret = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
        if (types.length != theNames.length) {
            throw new M4Exception("Step '" + this.getName() + "': could not find suitable datatype(s) for new output BA(s)!");
        }
        for (int i = 0; i < theNames.length; ++i) {
            String oneNewName = theNames[i];
            if (oneNewName == null) continue;
            String datatype = types[i] == null ? "NOMINAL" : types[i];
            String role = roleNames[i] == null ? "NO_ROLE" : roleNames[i];
            edu.udo.cs.miningmart.m4.core.BaseAttribute oldBa = (edu.udo.cs.miningmart.m4.core.BaseAttribute)theConcept.getBaseAttribute(oneNewName);
            if (oldBa != null) {
                oldBa.setConceptualDataTypeName(datatype);
                oldBa.setRoleName(role);
                ret.add(oldBa);
                continue;
            }
            if (oneNewName.equals("")) {
                throw new UserError("Step '" + this.getName() + "': empty output object name!");
            }
            edu.udo.cs.miningmart.m4.core.BaseAttribute ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)theConcept.createBaseAttribute(oneNewName, datatype, "MINING", role);
            ret.add(ba);
        }
        return ret;
    }

    private String[] getTypeAndRoleFromCorrespondingBA(Constraint aConstr, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.BaseAttribute theTarget;
        String nameOfParamWithSameType = aConstr.getObj2();
        String nameOfConstrainedParam = aConstr.getObj1();
        if (nameOfParamWithSameType == null) {
            throw new M4Exception("Step '" + this.getName() + "': a SAME_TYPE constraint was found without second object!");
        }
        OpParam targetOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfParamWithSameType);
        if (targetOpPar == null) {
            throw new M4Exception("Step '" + this.getName() + "': a same-type constraint was found that does not use a parameter of this step!");
        }
        if (!targetOpPar.isInput()) {
            nameOfParamWithSameType = aConstr.getObj1();
            nameOfConstrainedParam = aConstr.getObj2();
            targetOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfParamWithSameType);
            if (targetOpPar == null || !targetOpPar.isInput()) {
                throw new M4Exception("Step '" + this.getName() + "': a same-type constraint was found that does not use an input parameter of this step!");
            }
        }
        if ((theTarget = this.getAssociatedAttribute(nameOfConstrainedParam, nameOfParamWithSameType, loopNr)) == null) {
            return new String[]{"NOMINAL", "NO_ROLE"};
        }
        return new String[]{theTarget.getConceptualDataTypeName(), theTarget.getRoleName()};
    }

    private edu.udo.cs.miningmart.m4.core.BaseAttribute getAssociatedAttribute(String nameOfParameterOfGivenAttrib, String nameOfParameterOfAssociatedAttrib, int loopNr) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.ParameterObject[] targets;
        OpParam constrainedOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfParameterOfGivenAttrib);
        OpParam targetOpPar = (OpParam)this.getTheOperator().getOpParam(nameOfParameterOfAssociatedAttrib);
        if (constrainedOpPar.isCoordinated() && !targetOpPar.isCoordinated()) {
            loopNr = 0;
        }
        if (targetOpPar.isCoordinated() && !constrainedOpPar.isCoordinated()) {
            loopNr = 1;
        }
        if ((targets = this.getParameter(nameOfParameterOfAssociatedAttrib, loopNr)) == null || targets.length == 0) {
            this.doPrint(Print.MAX, "WARNING: Step '" + this.getName() + "': no parameter '" + nameOfParameterOfAssociatedAttrib + "' found, though this name is used in a constraint!");
            return null;
        }
        edu.udo.cs.miningmart.m4.core.BaseAttribute theTarget = null;
        try {
            theTarget = (edu.udo.cs.miningmart.m4.core.BaseAttribute)targets[0];
        }
        catch (ClassCastException cce) {
            throw new M4Exception("Step '" + this.getName() + "': a same-type constraint or assertion was found that does not use the name of a BA parameter!");
        }
        if (theTarget == null) {
            throw new M4Exception("Step '" + this.getName() + "': could not find a parameter called '" + nameOfParameterOfAssociatedAttrib + "', though it was specified in a same-type constraint!");
        }
        if (!this.isVisible(theTarget)) {
            throw new M4Exception("Step '" + this.getName() + "': The target attribute '" + theTarget.getName() + "' is not visible here!");
        }
        return theTarget;
    }

    public void renameOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam, Collection theNames) throws M4Exception {
        int endLoopNr;
        int startLoopNr;
        if (theOpParam.isInput()) {
            return;
        }
        Collection flatNames = theNames;
        if (theOpParam.isCoordinated() || theOpParam.isLoopable()) {
            flatNames = this.flattenCollections(theNames);
        }
        Iterator namesIt = flatNames.iterator();
        if (theOpParam.isLoopable() && this.getLoopCount() > 0 || theOpParam.isCoordinated()) {
            startLoopNr = 1;
            endLoopNr = this.getHighestLoopNr(theOpParam);
        } else {
            endLoopNr = 0;
            startLoopNr = 0;
        }
        if (namesIt.hasNext()) {
            for (int loopNr = startLoopNr; loopNr <= endLoopNr; ++loopNr) {
                Parameter thePar = (Parameter)this.getParameterTuple(theOpParam.getName(), loopNr);
                if (thePar == null) {
                    this.createOutput(theOpParam, theNames);
                    return;
                }
                edu.udo.cs.miningmart.m4.core.ParameterObject myParObj = (edu.udo.cs.miningmart.m4.core.ParameterObject)thePar.getTheParameterObject();
                String oldName = myParObj.getName();
                String newName = (String)namesIt.next();
                if (myParObj instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute) {
                    Collection inputParamsUsingAttr = this.getInputParametersUsingFeature((edu.udo.cs.miningmart.m4.core.Feature)myParObj);
                    this.giveValidOutputObjectName(myParObj, newName);
                    this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames = new HashMap();
                    this.createMapOfInputParamsToNames(inputParamsUsingAttr, this.mapFromInputParametersOfFollowingStepsToTheirOldParameterObjectNames, oldName, newName);
                    continue;
                }
                this.giveValidOutputObjectName(myParObj, newName);
            }
        }
    }

    private Collection flattenCollections(Collection coll) throws M4Exception {
        if (coll == null) {
            throw new M4Exception("Step '" + this.getName() + "' (method flattenCollections): got >null< instead of names for output objects!");
        }
        Iterator it1 = coll.iterator();
        Vector ret = new Vector();
        while (it1.hasNext()) {
            Collection innerColl = (Collection)it1.next();
            if (innerColl == null) {
                throw new M4Exception("Step '" + this.getName() + "' (method flattenCollections): got >null< instead of names for output objects (inner collection)!");
            }
            Iterator it2 = innerColl.iterator();
            while (it2.hasNext()) {
                ret.add(it2.next());
            }
        }
        return ret;
    }

    public Collection getInputConceptsThatAreParameters() throws M4Exception {
        Collection theInputOpParams = this.getTheOperator().getAllInputOperatorParameters();
        Iterator it = theInputOpParams.iterator();
        Vector theInputConcepts = new Vector();
        while (it.hasNext()) {
            Collection inputObjects;
            OpParam myOpPar = (OpParam)it.next();
            if (!myOpPar.isConceptParameter() || (inputObjects = this.getParameter(myOpPar, 0)) == null) continue;
            theInputConcepts.addAll(inputObjects);
        }
        return theInputConcepts;
    }

    public Collection getAllInputConcepts() throws M4Exception {
        Collection directInputs = this.getInputConceptsThatAreParameters();
        for (Relation inRel : this.getAllInputRelations()) {
            Concept from = (Concept)inRel.getTheFromConcept();
            Concept to = (Concept)inRel.getTheToConcept();
            if (!directInputs.contains(from)) {
                directInputs.add(from);
            }
            if (to == null || directInputs.contains(to)) continue;
            directInputs.add(to);
        }
        return directInputs;
    }

    public Collection getAllInputRelations() throws M4Exception {
        Collection theInputOpParams = this.getTheOperator().getAllInputOperatorParameters();
        Iterator it = theInputOpParams.iterator();
        Vector<ParameterObject> theInputRels = new Vector<ParameterObject>();
        while (it.hasNext()) {
            OpParam myOpPar = (OpParam)it.next();
            if (!myOpPar.isRelationParameter()) continue;
            Collection relPars = this.getParameterTuples(myOpPar);
            for (Parameter myPar : relPars) {
                theInputRels.add(myPar.getTheParameterObject());
            }
        }
        return theInputRels;
    }

    public edu.udo.cs.miningmart.m4.Concept getOutputConcept() throws M4Exception {
        if (this.getTheOperator() == null) {
            return null;
        }
        Collection theOutputOpParams = this.getTheOperator().getAllOutputOperatorParameters();
        for (OpParam myOpPar : theOutputOpParams) {
            if (!myOpPar.isConceptParameter()) continue;
            int loopNr = 0;
            Collection outputConcepts = this.getParameter(myOpPar, loopNr);
            if (outputConcepts == null) {
                return null;
            }
            if (outputConcepts.size() > 1) {
                throw new M4Exception("Step '" + this.getName() + "': found more than one output concept (Parameter '" + myOpPar.getName() + "'!");
            }
            if (outputConcepts.isEmpty()) continue;
            return (Concept)outputConcepts.iterator().next();
        }
        return null;
    }

    public void changeInputConcept(edu.udo.cs.miningmart.m4.Concept oldConcept, edu.udo.cs.miningmart.m4.Concept newConcept) throws M4Exception {
        if (oldConcept == null || newConcept == null) {
            return;
        }
        if (this.getTheOperator() == null) {
            return;
        }
        Collection inOpPars = this.getTheOperator().getAllInputOperatorParameters();
        if (inOpPars != null) {
            Iterator inOpParIt = inOpPars.iterator();
            Parameter paramToBeChanged = null;
            OpParam opParamToBeChanged = null;
            while (inOpParIt.hasNext()) {
                Collection allInputConceptParams;
                OpParam anInputOpPar = (OpParam)inOpParIt.next();
                if (!anInputOpPar.isConceptParameter() || (allInputConceptParams = this.getParameterTuples(anInputOpPar)) == null) continue;
                for (Parameter myInConPar : allInputConceptParams) {
                    if (!myInConPar.getTheParameterObject().equals(oldConcept)) continue;
                    paramToBeChanged = myInConPar;
                    opParamToBeChanged = anInputOpPar;
                }
            }
            if (paramToBeChanged == null || opParamToBeChanged == null) {
                return;
            }
            paramToBeChanged.setTheParameterObject(newConcept);
            Collection constrs = opParamToBeChanged.getApplicableConstraints();
            if (constrs != null) {
                for (edu.udo.cs.miningmart.m4.core.Constraint myConstr : constrs) {
                    if (!myConstr.getType().equals("IN")) continue;
                    String otherOpParOfThisConstraint = null;
                    otherOpParOfThisConstraint = myConstr.getObj1().equalsIgnoreCase(opParamToBeChanged.getName()) ? myConstr.getObj2() : myConstr.getObj1();
                    OpParam otherOpPar = (OpParam)this.getTheOperator().getOpParam(otherOpParOfThisConstraint);
                    if (otherOpPar == null || !otherOpPar.isInput() || !otherOpPar.isBaseAttribParameter() && !otherOpPar.isFeatureParameter()) continue;
                    for (Parameter inputFParam : this.getParameterTuples(otherOpPar)) {
                        edu.udo.cs.miningmart.m4.core.Feature newFeature;
                        edu.udo.cs.miningmart.m4.core.Feature oldFeature;
                        edu.udo.cs.miningmart.m4.core.ParameterObject po = (edu.udo.cs.miningmart.m4.core.ParameterObject)inputFParam.getTheParameterObject();
                        if (!(po instanceof edu.udo.cs.miningmart.m4.core.Feature) || !(oldFeature = (edu.udo.cs.miningmart.m4.core.Feature)po).getConcept().equals(oldConcept) || (newFeature = (edu.udo.cs.miningmart.m4.core.Feature)newConcept.getFeature(po.getName())) == null) continue;
                        inputFParam.setTheParameterObject(newFeature);
                    }
                }
            }
        }
    }

    public Collection getResultingDataModel() throws M4Exception {
        Vector<Concept> inputDataModelOfCase = new Vector<Concept>(this.getTheCase().getInputDataModel());
        Vector conceptsToBeReplaced = new Vector();
        HashSet visitedSteps = new HashSet();
        Concept replacingConcept = this.getReplacingConcept(this, conceptsToBeReplaced, visitedSteps);
        if (replacingConcept != null) {
            inputDataModelOfCase.removeAll(conceptsToBeReplaced);
            inputDataModelOfCase.add(replacingConcept);
        }
        return inputDataModelOfCase;
    }

    private Concept getReplacingConcept(Step current, Collection conceptsToBeReplaced, Collection visitedSteps) throws M4Exception {
        if (current == null) {
            return null;
        }
        visitedSteps.add(current);
        Concept ret = null;
        Collection preds = current.getAllPredecessors();
        if (preds != null && !preds.isEmpty()) {
            Iterator it = preds.iterator();
            Vector<Concept> outputConceptsOfIncomingSteps = new Vector<Concept>();
            while (it.hasNext()) {
                Step next = (Step)it.next();
                if (visitedSteps.contains(next)) continue;
                ret = this.getReplacingConcept(next, conceptsToBeReplaced, visitedSteps);
                outputConceptsOfIncomingSteps.add(ret);
            }
            Collection inCons = current.getAllInputConcepts();
            for (Concept anInputConcept : inCons) {
                if (!anInputConcept.getType().equals("DB") || outputConceptsOfIncomingSteps.contains(anInputConcept)) continue;
                conceptsToBeReplaced.add(anInputConcept);
            }
        } else {
            for (Concept inCon : current.getAllInputConcepts()) {
                if (conceptsToBeReplaced.contains(inCon)) continue;
                conceptsToBeReplaced.add(inCon);
            }
        }
        if (current.getOutputConcept() != null) {
            ret = (Concept)current.getOutputConcept();
        }
        return ret;
    }

    public void updateOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        boolean create = false;
        this.workOnOutput(theOpParam, null, create);
    }

    public boolean inputChangeCanAffectOutput(edu.udo.cs.miningmart.m4.OpParam theOpParam) throws M4Exception {
        if (!theOpParam.isInput()) {
            return false;
        }
        if (theOpParam.isConceptParameter()) {
            return true;
        }
        for (edu.udo.cs.miningmart.m4.core.Constraint myConstr : theOpParam.getApplicableConstraints()) {
            OpParam otherOpPar;
            if (myConstr.getType().equals("CREATE_BY") || myConstr.getType().equals("CR_SUFFIX")) {
                return true;
            }
            String otherParameter = myConstr.getObj1();
            if (otherParameter.equalsIgnoreCase(theOpParam.getName())) {
                otherParameter = myConstr.getObj2();
            }
            if ((otherOpPar = (OpParam)this.getTheOperator().getOpParam(otherParameter)) == null || otherOpPar.isInput()) continue;
            return true;
        }
        return false;
    }

    public edu.udo.cs.miningmart.m4.EstimatedStatistics estimateStatisticsForOutputConcept() throws M4Exception {
        Concept outputConcept = (Concept)this.getOutputConcept();
        if (outputConcept == null) {
            return null;
        }
        if (outputConcept.getType() == "DB") {
            throw new M4Exception("Error in step '" + this.getName() + "': output concept of this step is of type DB!");
        }
        EstimatedStatistics outputEstimations = new EstimatedStatistics(outputConcept);
        Collection inputConcepts = this.getAllInputConcepts();
        if (inputConcepts.size() == 1) {
            Concept inputConcept = (Concept)inputConcepts.iterator().next();
            EstimatedStatistics inputEstimations = (EstimatedStatistics)inputConcept.getEstimatedStatistics(this);
            this.copyEstimationsForMatchingAttribs(inputEstimations, outputEstimations);
            this.applyEstimationsOneInput(inputEstimations, outputEstimations);
        } else {
            outputEstimations = this.mergeEstimations(inputConcepts, outputConcept);
        }
        outputEstimations.readAvailableStatisticsFromDb();
        return outputEstimations;
    }

    private EstimatedStatistics mergeEstimations(Collection inputConcepts, Concept outputConcept) throws M4Exception {
        if (inputConcepts == null) {
            return null;
        }
        if (inputConcepts.size() > 1) {
            edu.udo.cs.miningmart.m4.EstimatedStatistics[] allESs = new EstimatedStatistics[inputConcepts.size()];
            Iterator it = inputConcepts.iterator();
            int i = 0;
            while (it.hasNext()) {
                Concept myInputConcept = (Concept)it.next();
                allESs[i] = (EstimatedStatistics)myInputConcept.getEstimatedStatistics(this);
                ++i;
            }
            EstimatedStatistics outputES = new EstimatedStatistics(outputConcept);
            Collection assertions = this.getTheOperator().getAssertions();
            Assertion[] sortedAssertions = this.sortAssertions(assertions);
            for (i = 0; i < sortedAssertions.length; ++i) {
                sortedAssertions[i].applyEstimationSeveralInputs(this, allESs, outputES);
            }
            return outputES;
        }
        return null;
    }

    private void copyEstimationsForMatchingAttribs(EstimatedStatistics inputEstimations, EstimatedStatistics outputEstimations) throws M4Exception {
        outputEstimations.setNumberOfRows(inputEstimations.getNumberOfRows());
        Concept outputConcept = (Concept)outputEstimations.getConcept();
        Concept inputConcept = (Concept)inputEstimations.getConcept();
        Collection allOutAttribs = outputConcept.getAllBaseAttributes();
        edu.udo.cs.miningmart.m4.core.BaseAttribute[] outAttribs = this.getBaseAttribArray(allOutAttribs);
        edu.udo.cs.miningmart.m4.core.BaseAttribute[] inAttribs = this.getAllCorrespondingAttribs(outAttribs, inputConcept);
        for (int i = 0; i < inAttribs.length && i < outAttribs.length; ++i) {
            if (inAttribs[i] == null) continue;
            outputEstimations.setBiggestValue(outAttribs[i].getName(), inputEstimations.getBiggestValue(inAttribs[i].getName()));
            outputEstimations.setLowestValue(outAttribs[i].getName(), inputEstimations.getLowestValue(inAttribs[i].getName()));
            outputEstimations.setNumberOfMissingValues(outAttribs[i].getName(), inputEstimations.getNumberOfMissingValues(inAttribs[i].getName()));
            Vector valueList = inputEstimations.getValueList(inAttribs[i].getName());
            outputEstimations.setValueList(outAttribs[i].getName(), valueList);
            for (String value : valueList) {
                outputEstimations.setNumberOfOccurrences(outAttribs[i].getName(), value, inputEstimations.getNumberOfOccurrences(inAttribs[i].getName(), value));
            }
        }
    }

    private edu.udo.cs.miningmart.m4.core.BaseAttribute[] getBaseAttribArray(Collection baseAttribCollection) {
        if (baseAttribCollection == null || baseAttribCollection.isEmpty()) {
            return null;
        }
        edu.udo.cs.miningmart.m4.core.BaseAttribute[] ret = new edu.udo.cs.miningmart.m4.core.BaseAttribute[baseAttribCollection.size()];
        Iterator it = baseAttribCollection.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = (edu.udo.cs.miningmart.m4.core.BaseAttribute)it.next();
            ++i;
        }
        return ret;
    }

    private void applyEstimationsOneInput(EstimatedStatistics inputEstimations, EstimatedStatistics outputEstimations) throws M4Exception {
        Collection assertions = this.getTheOperator().getAssertions();
        Assertion[] sortedAssertions = this.sortAssertions(assertions);
        for (int i = 0; i < sortedAssertions.length; ++i) {
            sortedAssertions[i].applyEstimationOneInput(this, inputEstimations, outputEstimations);
        }
    }

    public void estimateStatisticsForOutputAttrib(edu.udo.cs.miningmart.m4.EstimatedStatistics currentOutputEstimations, BaseAttribute outputAttribute) throws M4Exception {
        Collection outOpParamsOfThisStep = this.getTheOperator().getAllOutputOperatorParameters();
        boolean found = false;
        String nameOfOutputAttribsParameter = null;
        block0: for (OpParam outOpPar : outOpParamsOfThisStep) {
            for (Parameter myPar : this.getParameterTuples(outOpPar)) {
                if (!outputAttribute.equals(myPar.getTheParameterObject())) continue;
                found = true;
                nameOfOutputAttribsParameter = this.getParameterNameWithoutSuffix(myPar.getName());
                continue block0;
            }
        }
        if (found) {
            Collection assertions = this.getTheOperator().getAssertions();
            assertions = this.getRelevantAssertions(nameOfOutputAttribsParameter, assertions);
            Assertion[] sortedAssertions = this.sortAssertions(assertions);
            for (int i = 0; i < sortedAssertions.length; ++i) {
                sortedAssertions[i].applyEstimationOneInput(this, currentOutputEstimations, currentOutputEstimations);
            }
        }
    }

    private Collection getRelevantAssertions(String paramName, Collection givenAssertions) {
        if (givenAssertions == null) {
            return null;
        }
        Iterator it = givenAssertions.iterator();
        Vector<Assertion> ret = new Vector<Assertion>();
        while (it.hasNext()) {
            Assertion anAssertion = (Assertion)it.next();
            if (!anAssertion.getObj1().equalsIgnoreCase(paramName) && (anAssertion.getObj2() == null || !anAssertion.getObj2().equalsIgnoreCase(paramName))) continue;
            ret.add(anAssertion);
        }
        return ret;
    }

    private Assertion[] sortAssertions(Collection unsortedAssertions) {
        if (unsortedAssertions == null) {
            return null;
        }
        Assertion[] ret = new Assertion[unsortedAssertions.size()];
        Iterator it = unsortedAssertions.iterator();
        Vector<Assertion> vlAssertions = new Vector<Assertion>();
        Vector<Assertion> vfAssertions = new Vector<Assertion>();
        Vector<Assertion> otherAssertions = new Vector<Assertion>();
        while (it.hasNext()) {
            Assertion myAssertion = (Assertion)it.next();
            if (myAssertion.isValueListAssertion()) {
                if (myAssertion.getAssertionType().equals("VL_ADD") || myAssertion.getAssertionType().equals("VL_BY_SYM")) {
                    vlAssertions.add(vlAssertions.size(), myAssertion);
                    continue;
                }
                vlAssertions.add(0, myAssertion);
                continue;
            }
            if (myAssertion.isValueFrequencyAssertion()) {
                vfAssertions.add(myAssertion);
                continue;
            }
            otherAssertions.add(myAssertion);
        }
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i < vlAssertions.size() ? (Assertion)vlAssertions.get(i) : (i < vlAssertions.size() + vfAssertions.size() ? (Assertion)vfAssertions.get(i - vlAssertions.size()) : (Assertion)otherAssertions.get(i - vlAssertions.size() - vfAssertions.size()));
        }
        return ret;
    }

    private class ConceptualConceptInfo {
        String name;
        Vector attribInfos;

        ConceptualConceptInfo(Concept theConcept) throws M4Exception {
            if (theConcept == null) {
                throw new M4Exception("Step.ConceptualConceptInfo, constructor: got NULL concept!");
            }
            this.name = theConcept.getName();
            Iterator it = theConcept.getAllBaseAttributes().iterator();
            this.attribInfos = new Vector();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.BaseAttribute ba = (edu.udo.cs.miningmart.m4.core.BaseAttribute)it.next();
                this.attribInfos.add(new ConceptualAttributeInfo(ba));
            }
        }

        boolean hasMatchIn(Collection otherInfos) {
            for (ConceptualConceptInfo info : otherInfos) {
                if (!this.name.equals(info.name)) continue;
                Iterator attrInfoIt = this.attribInfos.iterator();
                boolean allAttribsMatch = true;
                while (attrInfoIt.hasNext()) {
                    ConceptualAttributeInfo ai = (ConceptualAttributeInfo)attrInfoIt.next();
                    if (ai.hasMatchIn(info.attribInfos)) continue;
                    allAttribsMatch = false;
                }
                if (allAttribsMatch) {
                    for (ConceptualAttributeInfo ai : info.attribInfos) {
                        if (ai.hasMatchIn(this.attribInfos)) continue;
                        allAttribsMatch = false;
                    }
                }
                if (!allAttribsMatch) continue;
                return true;
            }
            return false;
        }
    }

    private class ConceptualAttributeInfo {
        String name;
        String conceptualDataType;
        String role;

        ConceptualAttributeInfo(edu.udo.cs.miningmart.m4.core.BaseAttribute theAttribute) throws M4Exception {
            if (theAttribute == null) {
                throw new M4Exception("Step.ConceptualAttributeInfo, constructor: got NULL attribute!");
            }
            this.name = theAttribute.getName();
            this.conceptualDataType = theAttribute.getConceptualDataTypeName();
            this.role = theAttribute.getRoleName();
        }

        boolean hasMatchIn(Collection otherAttribInfos) {
            for (ConceptualAttributeInfo otherInfo : otherAttribInfos) {
                if (!this.name.equals(otherInfo.name) || !this.conceptualDataType.equalsIgnoreCase(otherInfo.conceptualDataType) || !this.role.equalsIgnoreCase(otherInfo.role)) continue;
                return true;
            }
            return false;
        }
    }
}

