/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class Roles
implements edu.udo.cs.miningmart.m4.Roles {
    public static final String M4_TABLE_NAME = "roles_t";
    public static final String ATTRIB_ROLE_ID = "role_id";
    public static final String ATTRIB_ROLE_NAME = "role_name";
    private HashMap idToName = new HashMap();
    private HashMap nameToId = new HashMap();

    public Roles(DB db) throws M4Exception, DbConnectionClosed {
        String query = "SELECT role_id, role_name FROM roles_t";
        ResultSet rs = null;
        try {
            rs = db.executeM4SqlRead(query);
            while (rs.next()) {
                Integer id = new Integer(rs.getInt(ATTRIB_ROLE_ID));
                if (rs.wasNull()) continue;
                String name = rs.getString(ATTRIB_ROLE_NAME);
                this.idToName.put(id, name);
                this.nameToId.put(name, id);
            }
        }
        catch (SQLException e) {
            throw new M4Exception("SQLException when trying to read the roles:\n" + e.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    public long getIdForName(String name) {
        Integer id = (Integer)this.nameToId.get(name);
        if (id != null) {
            return id.longValue();
        }
        return 0L;
    }

    public String getNameForId(long id) {
        Integer idI = new Integer((int)id);
        return (String)this.idToName.get(idI);
    }
}

