/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.ForeignKey;
import edu.udo.cs.miningmart.m4.ForeignKeyLink;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Concept;
import edu.udo.cs.miningmart.m4.core.Parameter;
import edu.udo.cs.miningmart.m4.core.ParameterObject;
import edu.udo.cs.miningmart.m4.utils.InterM4ObjectToObject;
import edu.udo.cs.miningmart.m4.utils.InterM4RelationToColumnset;
import edu.udo.cs.miningmart.m4.utils.InterM4RelationToFromKey;
import edu.udo.cs.miningmart.m4.utils.InterM4RelationToToKey;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Relation
extends ParameterObject
implements XmlInfo,
edu.udo.cs.miningmart.m4.Relation {
    public static final String M4_TABLE_NAME = "relation_t";
    public static final String ATTRIB_REL_ID = "rel_id";
    public static final String ATTRIB_REL_NAME = "rel_name";
    public static final String ATTRIB_FROM_CONCEPT = "rel_fromconid";
    public static final String ATTRIB_TO_CONCEPT = "rel_toconid";
    public static final String ATTRIB_FROM_KEY = "rel_fromkid";
    public static final String ATTRIB_TO_KEY = "rel_tokid";
    public static final String ATTRIB_COLUMNSET = "rel_csid";
    static InterM4ObjectToObject rel2cs = new InterM4RelationToColumnset();
    static InterM4ObjectToObject rel2fromKey = new InterM4RelationToFromKey();
    static InterM4ObjectToObject rel2toKey = new InterM4RelationToToKey();
    private Concept fromConcept;
    private Concept toConcept;
    private edu.udo.cs.miningmart.m4.core.ForeignKey fromKey;
    private edu.udo.cs.miningmart.m4.core.ForeignKey toKey;
    private edu.udo.cs.miningmart.m4.core.Columnset myColumnSet;
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_REL_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_REL_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_REL_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_COLUMNSET, "getCrossLinkColumnSet", "primitiveSetColumnset", Columnset.class), new M4InfoEntry(ATTRIB_FROM_CONCEPT, "getTheFromConcept", "primitiveSetFromConcept", edu.udo.cs.miningmart.m4.Concept.class), new M4InfoEntry(ATTRIB_FROM_KEY, "getFromKey", "primitiveSetFromKey", ForeignKey.class), new M4InfoEntry(ATTRIB_TO_CONCEPT, "getTheToConcept", "primitiveSetToConcept", edu.udo.cs.miningmart.m4.Concept.class), new M4InfoEntry(ATTRIB_TO_KEY, "getToKey", "primitiveSetToKey", ForeignKey.class)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("CrossColumnSet", "getCrossLinkColumnSet", "setCrossLinkColumnSet", Columnset.class), new M4InfoEntry("FromConcept", "getTheFromConcept", "setTheFromConcept", edu.udo.cs.miningmart.m4.Concept.class), new M4InfoEntry("ToConcept", "getTheToConcept", "setTheToConcept", edu.udo.cs.miningmart.m4.Concept.class), new M4InfoEntry("FromKey", "getFromKey", "setFromKey", ForeignKey.class), new M4InfoEntry("ToKey", "getToKey", "setToKey", ForeignKey.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Relation(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(Print.M4_OBJECT, "Relation " + this.myName + "(Id = " + this.myId + ")" + " between " + this.fromConcept.getName() + " and " + this.toConcept.getName());
        super.print();
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.ForeignKey.class)) {
            Vector<edu.udo.cs.miningmart.m4.core.ForeignKey> c = new Vector<edu.udo.cs.miningmart.m4.core.ForeignKey>();
            edu.udo.cs.miningmart.m4.core.ForeignKey fk = (edu.udo.cs.miningmart.m4.core.ForeignKey)this.getFromKey();
            if (fk != null) {
                c.add(fk);
            }
            if ((fk = (edu.udo.cs.miningmart.m4.core.ForeignKey)this.getToKey()) != null) {
                c.add(fk);
            }
            return c;
        }
        throw new M4Exception("Relation.getObjectsInNamespace: unknown type of objects given: " + typeOfObjects.getName());
    }

    public void setTheToConcept(edu.udo.cs.miningmart.m4.Concept c) throws M4Exception {
        Concept.con2ToRel.checkNameExists(this, c);
        Concept.con2ToRel.updateReferenceTo(this, c);
    }

    public edu.udo.cs.miningmart.m4.Concept getTheToConcept() {
        return this.toConcept;
    }

    public void setTheFromConcept(edu.udo.cs.miningmart.m4.Concept c) throws M4Exception {
        Concept.con2FromRel.checkNameExists(this, c);
        Concept.con2FromRel.updateReferenceTo(this, c);
    }

    public edu.udo.cs.miningmart.m4.Concept getTheFromConcept() {
        return this.fromConcept;
    }

    public void setToKey(ForeignKey newToKey) throws M4Exception {
        rel2toKey.removeReferences(this, this.toKey);
        rel2toKey.setReciprocalReferences(this, (edu.udo.cs.miningmart.m4.core.ForeignKey)newToKey);
    }

    public void primitiveSetToKey(ForeignKey fk) {
        this.setDirty();
        this.toKey = (edu.udo.cs.miningmart.m4.core.ForeignKey)fk;
    }

    public ForeignKey getToKey() {
        return this.toKey;
    }

    public void setFromKey(ForeignKey newFromKey) throws M4Exception {
        rel2fromKey.removeReferences(this, this.fromKey);
        rel2fromKey.setReciprocalReferences(this, (edu.udo.cs.miningmart.m4.core.ForeignKey)newFromKey);
    }

    public void primitiveSetFromKey(ForeignKey fk) {
        this.setDirty();
        this.fromKey = (edu.udo.cs.miningmart.m4.core.ForeignKey)fk;
    }

    public ForeignKey getFromKey() {
        return this.fromKey;
    }

    public Columnset getCrossLinkColumnSet() {
        return this.myColumnSet;
    }

    public void setCrossLinkColumnSet(Columnset cs) throws M4Exception {
        rel2cs.removeReferences(this, this.myColumnSet);
        rel2cs.setReciprocalReferences(this, (edu.udo.cs.miningmart.m4.core.Columnset)cs);
    }

    public void changeCrossTable(String newCrossTableName) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset cs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().getColumnsetFromCase(newCrossTableName, this.getTheFromConcept().getTheCase());
        if (cs == null) {
            cs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().createColumnsetFromTable(newCrossTableName);
        }
        this.setCrossLinkColumnSet(cs);
    }

    public void changeAllKeys(Collection fromConceptAttribs, Collection toConceptAttribs, Collection crossToFromKeyNames, Collection crossToToKeyNames) throws M4Exception {
        if (fromConceptAttribs.size() != crossToFromKeyNames.size()) {
            throw new M4Exception("Relation.changeAllKeys: number of key attributes must be equal in FromConcept and cross table!");
        }
        if (toConceptAttribs.size() != crossToToKeyNames.size()) {
            throw new M4Exception("Relation.changeAllKeys: number of key attributes must be equal in ToConcept and cross table!");
        }
        if (this.getFromKey() == null) {
            this.setFromKey((edu.udo.cs.miningmart.m4.core.ForeignKey)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.ForeignKey.class));
        }
        if (this.getToKey() == null) {
            this.setToKey((edu.udo.cs.miningmart.m4.core.ForeignKey)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.ForeignKey.class));
        }
        this.changeKey(this.getFromKey(), fromConceptAttribs, crossToFromKeyNames);
        this.changeKey(this.getToKey(), toConceptAttribs, crossToToKeyNames);
    }

    private void changeKey(ForeignKey whichKey, Collection primaryKeyAttribs, Collection foreignKeyNames) throws M4Exception {
        Collection presentLinks = whichKey.getAllColumnLinks();
        Iterator presentIt = null;
        if (presentLinks != null) {
            presentIt = presentLinks.iterator();
        }
        Iterator toIt = primaryKeyAttribs.iterator();
        Iterator fromIt = foreignKeyNames.iterator();
        while (presentIt != null && presentIt.hasNext() && fromIt.hasNext() && toIt.hasNext()) {
            ForeignKeyLink fkl = (ForeignKeyLink)presentIt.next();
            BaseAttribute toAttrib = (BaseAttribute)toIt.next();
            String fromName = (String)fromIt.next();
            Column fromCol = (Column)this.getCrossLinkColumnSet().getColumn(fromName);
            Column toCol = (Column)toAttrib.getCurrentColumn();
            fkl.setForeignKeyColumn(fromCol);
            fkl.setPrimaryKeyColumn(toCol);
            whichKey.setForeignKeyColumnset(fromCol.getColumnset());
            whichKey.setPrimaryKeyColumnset(toCol.getColumnset());
        }
        while (fromIt.hasNext() && toIt.hasNext()) {
            BaseAttribute toAttrib = (BaseAttribute)toIt.next();
            String fromName = (String)fromIt.next();
            Column fromCol = (Column)this.getCrossLinkColumnSet().getColumn(fromName);
            Column toCol = (Column)toAttrib.getCurrentColumn();
            whichKey.addColumnLink(fromCol, toCol);
        }
    }

    public void changeFromAndToKeys(Collection fromConceptAttribs, Collection toConceptAttribs) throws M4Exception {
        if (this.isManyToManyRelation()) {
            throw new M4Exception("Relation.changeFromAndToKeys: this method must only be called for one-to-many relations!");
        }
        if (fromConceptAttribs.size() != toConceptAttribs.size()) {
            throw new M4Exception("Relation.changeFromAndToKeys: number of key attributes must be equal in both concepts!");
        }
        edu.udo.cs.miningmart.m4.core.ForeignKey fk = (edu.udo.cs.miningmart.m4.core.ForeignKey)this.getFromKey();
        Collection presentLinks = fk != null ? fk.getAllColumnLinks() : new Vector();
        Iterator presentIt = null;
        if (presentLinks != null) {
            presentIt = presentLinks.iterator();
        }
        Iterator fromIt = fromConceptAttribs.iterator();
        Iterator toIt = toConceptAttribs.iterator();
        while (presentIt != null && presentIt.hasNext() && fromIt.hasNext() && toIt.hasNext()) {
            ForeignKeyLink fkl = (ForeignKeyLink)presentIt.next();
            BaseAttribute fromAttrib = (BaseAttribute)fromIt.next();
            BaseAttribute toAttrib = (BaseAttribute)toIt.next();
            Column fromCol = (Column)fromAttrib.getCurrentColumn();
            Column toCol = (Column)toAttrib.getCurrentColumn();
            fkl.setForeignKeyColumn(fromCol);
            fkl.setPrimaryKeyColumn(toCol);
        }
        if (fk == null && fromIt.hasNext() && toIt.hasNext()) {
            edu.udo.cs.miningmart.m4.core.ForeignKey theForeignKey = (edu.udo.cs.miningmart.m4.core.ForeignKey)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.ForeignKey.class);
            theForeignKey.setName(this.getName() + "_FK");
            this.setFromKey(theForeignKey);
            fk = theForeignKey;
        }
        while (fromIt.hasNext() && toIt.hasNext()) {
            BaseAttribute fromAttrib = (BaseAttribute)fromIt.next();
            BaseAttribute toAttrib = (BaseAttribute)toIt.next();
            Column fromCol = (Column)fromAttrib.getCurrentColumn();
            Column toCol = (Column)toAttrib.getCurrentColumn();
            fk.addColumnLink(fromCol, toCol);
        }
    }

    public void removeCrossLinkColumnset() throws M4Exception {
        this.setCrossLinkColumnSet(null);
    }

    public Columnset createCrossLinkColumnset(String name, String schema, String type) throws M4Exception {
        if (name == null || schema == null || type == null) {
            throw new M4Exception("ConceptImpl.createColumnSet: got <null> as a parameter!");
        }
        edu.udo.cs.miningmart.m4.core.Columnset newCS = new edu.udo.cs.miningmart.m4.core.Columnset(this.getM4Db());
        try {
            newCS.setType(type);
            newCS.setName(name);
            newCS.setSchema(schema);
            this.setCrossLinkColumnSet(newCS);
        }
        catch (M4Exception se) {
            throw new M4Exception("Could not create/connect new Columnset '" + name + " to Concept " + this.getId() + ": " + se.getMessage());
        }
        newCS.createColumnsFromDbObject(name);
        return newCS;
    }

    public boolean isOneToManyRelation() {
        return this.getToKey() == null;
    }

    public boolean isManyToManyRelation() {
        return this.getToKey() != null;
    }

    public Columnset getResultOfJoin() throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset cross = (edu.udo.cs.miningmart.m4.core.Columnset)this.getCrossLinkColumnSet();
        String selectPart = "SELECT ";
        String fromPart = " FROM ";
        String wherePart = " WHERE ";
        edu.udo.cs.miningmart.m4.core.Columnset fromCs = null;
        edu.udo.cs.miningmart.m4.core.Columnset toCs = null;
        edu.udo.cs.miningmart.m4.core.Columnset joinedCs = (edu.udo.cs.miningmart.m4.core.Columnset)this.getM4Db().createNewInstance(edu.udo.cs.miningmart.m4.core.Columnset.class);
        if (cross == null) {
            edu.udo.cs.miningmart.m4.core.ForeignKey link = (edu.udo.cs.miningmart.m4.core.ForeignKey)this.getFromKey();
            fromCs = (edu.udo.cs.miningmart.m4.core.Columnset)link.getForeignKeyColumnset();
            toCs = (edu.udo.cs.miningmart.m4.core.Columnset)link.getPrimaryKeyColumnset();
            fromPart = fromPart + fromCs.getSQLDefinition() + " T1, " + toCs.getSQLDefinition() + " T2 ";
            for (Column myCol : toCs.getColumns()) {
                selectPart = selectPart + myCol.getName() + ", ";
                Column foreignKeyCol = (Column)link.getForeignForPrimaryColumn(myCol);
                if (foreignKeyCol != null) {
                    wherePart = wherePart + " T1." + myCol.getName() + " = T2." + foreignKeyCol.getName() + " AND";
                }
                myCol.copyColToCS(joinedCs);
            }
            for (Column myCol : fromCs.getColumns()) {
                if (link.isColumnContainedInForeignColumns(myCol)) continue;
                selectPart = selectPart + myCol.getName() + ", ";
                myCol.copyColToCS(joinedCs);
            }
            selectPart = selectPart.substring(0, selectPart.length() - 2);
            wherePart = wherePart.substring(0, wherePart.length() - 4);
        } else {
            Column foreignKeyCol;
            edu.udo.cs.miningmart.m4.core.ForeignKey firstLink = (edu.udo.cs.miningmart.m4.core.ForeignKey)this.getFromKey();
            edu.udo.cs.miningmart.m4.core.ForeignKey secondLink = (edu.udo.cs.miningmart.m4.core.ForeignKey)this.getToKey();
            fromCs = (edu.udo.cs.miningmart.m4.core.Columnset)firstLink.getPrimaryKeyColumnset();
            toCs = (edu.udo.cs.miningmart.m4.core.Columnset)secondLink.getPrimaryKeyColumnset();
            if (!cross.equals(firstLink.getForeignKeyColumnset()) || !cross.equals(secondLink.getForeignKeyColumnset())) {
                throw new M4Exception("Relation '" + this.getName() + "', getJoinedColumnset(): invalid key meta data!");
            }
            fromPart = fromPart + fromCs.getSQLDefinition() + " T1, " + toCs.getSQLDefinition() + " T2, " + cross.getSQLDefinition() + " K ";
            for (Column myCol : fromCs.getColumns()) {
                selectPart = selectPart + myCol.getName() + ", ";
                foreignKeyCol = (Column)firstLink.getForeignForPrimaryColumn(myCol);
                if (foreignKeyCol != null) {
                    wherePart = wherePart + " T1." + myCol.getName() + " = K." + foreignKeyCol.getName() + " AND";
                }
                myCol.copyColToCS(joinedCs);
            }
            for (Column myCol : toCs.getColumns()) {
                selectPart = selectPart + myCol.getName() + ", ";
                foreignKeyCol = (Column)secondLink.getForeignForPrimaryColumn(myCol);
                if (foreignKeyCol != null) {
                    wherePart = wherePart + " T1." + myCol.getName() + " = K." + foreignKeyCol.getName() + " AND";
                }
                myCol.copyColToCS(joinedCs);
            }
            selectPart = selectPart.substring(0, selectPart.length() - 2);
            wherePart = wherePart.substring(0, wherePart.length() - 4);
        }
        String sqlDef = "(" + selectPart + fromPart + wherePart + ")";
        joinedCs.setName("Joined" + fromCs.getName() + toCs.getName());
        joinedCs.setType("V");
        joinedCs.setSchema(fromCs.getSchema());
        joinedCs.setSQLDefinition(sqlDef);
        return joinedCs;
    }

    public void setM2mKeys(ForeignKey fromFK, ForeignKey toFK) throws M4Exception {
        if (fromFK == null || toFK == null) {
            return;
        }
        this.setFromKey(fromFK);
        this.setToKey(toFK);
    }

    public void primitiveSetColumnset(Columnset cs) {
        this.setDirty();
        this.myColumnSet = (edu.udo.cs.miningmart.m4.core.Columnset)cs;
    }

    public void primitiveSetFromConcept(edu.udo.cs.miningmart.m4.Concept c) {
        this.setDirty();
        this.fromConcept = (Concept)c;
    }

    public void primitiveSetToConcept(edu.udo.cs.miningmart.m4.Concept c) {
        this.setDirty();
        this.toConcept = (Concept)c;
    }

    protected void removeAllM4References() throws M4Exception {
        super.removeAllM4References();
        this.setTheFromConcept(null);
        this.setTheToConcept(null);
        this.setCrossLinkColumnSet(null);
        this.setFromKey(null);
        this.setToKey(null);
        this.removeDocObject();
    }

    public void deleteSoon() throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset cross = (edu.udo.cs.miningmart.m4.core.Columnset)this.getCrossLinkColumnSet();
        if (cross != null && cross.getTheConcept() == null) {
            cross.deleteSoon();
        }
        super.deleteSoon();
    }

    protected boolean hasCoordinates() {
        return true;
    }

    public boolean isRelationallyValid() {
        if (this.getTheFromConcept() == null || this.getTheToConcept() == null) {
            return false;
        }
        if (!this.getTheFromConcept().getType().equals("DB") || !this.getTheToConcept().getType().equals("DB")) {
            return false;
        }
        return this.getFromKey() != null;
    }

    public edu.udo.cs.miningmart.m4.Relation copy(edu.udo.cs.miningmart.m4.Concept fromConcept, edu.udo.cs.miningmart.m4.Concept toConcept) throws M4Exception {
        Relation theCopy = (Relation)fromConcept.createFromConceptRelation(this.getName(), toConcept);
        try {
            theCopy.setCrossLinkColumnSet(this.getCrossLinkColumnSet());
            theCopy.setFromKey(this.getFromKey());
            theCopy.setToKey(this.getToKey());
            theCopy.setSuperRelation(this.getSuperRelation());
            theCopy.setDocumentation(this.getDocumentation());
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Could not create copy of Relationship " + this.getId() + ": " + m4e.getMessage());
        }
        return theCopy;
    }

    public Collection getStepsWhereThisIsInputRelation() throws M4Exception {
        Collection params = this.getParameterReferences();
        Vector<Step> steps = new Vector<Step>();
        if (params != null) {
            for (Parameter p : params) {
                if (p == null || !p.getParameterType().equals("IN")) continue;
                steps.add(p.getTheStep());
            }
        }
        return steps;
    }

    public void removeFromKey() throws M4Exception {
        this.setFromKey(null);
    }

    public void removeToKey() throws M4Exception {
        this.setToKey(null);
    }

    public Collection getSubRelations() {
        return new Vector();
    }

    public edu.udo.cs.miningmart.m4.Relation getSuperRelation() {
        return null;
    }

    public void setSuperRelation(edu.udo.cs.miningmart.m4.Relation superRelationship) throws M4Exception {
    }

    public void removeSuperRelation() throws M4Exception {
    }

    public void addSubRelationship(edu.udo.cs.miningmart.m4.Relation relationship) throws M4Exception {
    }

    public edu.udo.cs.miningmart.m4.Relation getSubRelation(String name) {
        return null;
    }

    public Collection getAllSubRelationships() {
        return new Vector();
    }

    public void removeSubRelationship(String name) throws M4Exception {
    }

    public void removeAllSubRelationships() throws M4Exception {
    }
}

