/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.exception.ParameterError;
import edu.udo.cs.miningmart.m4.Parameter;
import edu.udo.cs.miningmart.m4.core.ParameterObject;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ParameterArray
implements Serializable,
edu.udo.cs.miningmart.m4.ParameterArray {
    private final short parameterType;
    private final Vector parametersV = new Vector();
    private ParameterObject[] parameterObjectArray;

    public ParameterArray(short parameterType) throws ParameterError {
        edu.udo.cs.miningmart.m4.core.Parameter.typeStringForTypeConst(parameterType);
        this.parameterType = parameterType;
    }

    public ParameterArray(String parameterType) throws ParameterError {
        this.parameterType = edu.udo.cs.miningmart.m4.core.Parameter.typeConstForTypeString(parameterType);
    }

    public void addParameter(Parameter par) throws M4Exception {
        edu.udo.cs.miningmart.m4.ParameterObject parObj = null;
        if (par == null || (parObj = par.getTheParameterObject()) == null) {
            return;
        }
        Class thisParClass = edu.udo.cs.miningmart.m4.core.Parameter.getClassForParameterType(this.getParameterType());
        if (!thisParClass.isInstance(parObj)) {
            throw new ParameterError("ParameterArray.addParameter:\nTried to add an incompatible ParameterObjectof type " + par.getParObjectType() + " to an array of type " + this.getParameterTypeS());
        }
        this.parameterObjectArray = null;
        this.parametersV.add(par);
    }

    public boolean removeParameter(Parameter par) throws M4Exception {
        boolean ret = this.parametersV.remove(par);
        if (ret) {
            this.parameterObjectArray = null;
        }
        return ret;
    }

    public boolean hasParameter(Parameter par) throws M4Exception {
        return par != null && this.getParameters() != null && this.getParameters().contains(par);
    }

    public short getParameterType() {
        return this.parameterType;
    }

    public String getParameterTypeS() {
        try {
            return edu.udo.cs.miningmart.m4.core.Parameter.typeStringForTypeConst(this.getParameterType());
        }
        catch (M4Exception e) {
            return null;
        }
    }

    public int size() {
        return this.getParameters().size();
    }

    public Collection getParameters() {
        return this.parametersV;
    }

    public edu.udo.cs.miningmart.m4.ParameterObject[] getParameterObjectArray() throws M4Exception {
        if (this.parameterObjectArray == null) {
            Class<ParameterObject> classForArray;
            try {
                classForArray = edu.udo.cs.miningmart.m4.core.Parameter.getClassForParameterType(this.getParameterType());
            }
            catch (M4Exception e) {
                classForArray = ParameterObject.class;
            }
            ParameterObject[] parObjArr = (ParameterObject[])Array.newInstance(classForArray, this.size());
            Iterator it = this.getParameters().iterator();
            int i = 0;
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.Parameter par = (edu.udo.cs.miningmart.m4.core.Parameter)it.next();
                if (par != null) {
                    parObjArr[i] = par.getTheParameterObject();
                }
                ++i;
            }
            this.parameterObjectArray = parObjArr;
        }
        return this.parameterObjectArray;
    }
}

