/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.ParameterArray;
import java.io.Serializable;
import java.util.HashMap;

public class ParamDict
implements Serializable,
edu.udo.cs.miningmart.m4.ParamDict {
    private final HashMap entries = new HashMap();
    private static final String LOOPNR_DELIMITER = " #";

    public void put(String paramName, ParameterArray theParameter) throws M4Exception {
        this.put(paramName, 0, theParameter);
    }

    public void put(String paramName, int loopNr, ParameterArray theParameter) throws M4Exception {
        if (theParameter == null) {
            throw new M4Exception("Operator.autoLoad() mechanism, internal class ParamDict:\nError - Operator tried to insert null into parameter dictionary!");
        }
        if (this.containsKey(paramName, loopNr)) {
            throw new M4Exception("Could not store parameter in autoLoad() of class Operator: Already loaded!");
        }
        this.store(paramName, loopNr, theParameter);
    }

    public void replace(String paramName, int loopNr, ParameterArray theParameter) throws M4Exception {
        if (loopNr > 0 || this.isLooped(paramName)) {
            ++loopNr;
        }
        if (!this.remove(paramName, loopNr)) {
            throw new M4Exception("Could not replace parameter " + paramName + ", loopNr: " + loopNr + " in autoLoad() of class Operator:\nOld parameter value not found!");
        }
        this.store(paramName, loopNr, theParameter);
    }

    public boolean containsKey(String paramName) {
        return this.containsKey(paramName, 0) || this.containsKey(paramName, 1);
    }

    public boolean containsKey(String paramName, int loopNr) {
        return this.entries.containsKey(paramName + LOOPNR_DELIMITER + loopNr);
    }

    public boolean containsParamArray(ParameterArray paramArray) {
        return this.entries.values().contains(paramArray);
    }

    public boolean removeParamArray(ParameterArray paramArray) {
        return this.entries.values().remove(paramArray);
    }

    public ParameterArray get(String paramName) throws M4Exception {
        return this.get(paramName, 0);
    }

    public ParameterArray get(String paramName, int loopNr) {
        String key = paramName + LOOPNR_DELIMITER + loopNr;
        return (ParameterArray)this.entries.get(key);
    }

    public boolean isLooped(String paramName) {
        return this.containsKey(paramName, 1) && !this.containsKey(paramName, 0);
    }

    private void store(String paramName, int loopNr, ParameterArray theParameter) {
        String key = paramName + LOOPNR_DELIMITER + loopNr;
        this.entries.put(key, theParameter);
    }

    private boolean remove(String paramName, int loopNr) {
        String key = paramName + LOOPNR_DELIMITER + loopNr;
        return this.entries.remove(key) != null;
    }
}

