/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Assertion;
import edu.udo.cs.miningmart.m4.Constraint;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.core.Condition;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.InterM4OperatorAssertion;
import edu.udo.cs.miningmart.m4.utils.InterM4OperatorCondition;
import edu.udo.cs.miningmart.m4.utils.InterM4OperatorConstraint;
import edu.udo.cs.miningmart.m4.utils.InterM4OperatorOpParam;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class Operator
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Operator {
    public static final String M4_TABLE_NAME = "operator_t";
    public static final String ATTRIB_OPERATOR_ID = "op_id";
    public static final String ATTRIB_OPERATOR_NAME = "OP_NAME";
    public static final String ATTRIB_OPERATOR_IS_MANUAL = "OP_MANUAL";
    public static final String ATTRIB_OPERATOR_IS_LOOPABLE = "OP_LOOP";
    public static final String ATTRIB_OPERATOR_IS_MULTISTEPABLE = "OP_MULTI";
    public static final String ATTRIB_OPERATOR_REALIZED = "OP_REALIZE";
    static final InterM4Communicator op2oppar = new InterM4OperatorOpParam();
    static final InterM4Communicator op2assert = new InterM4OperatorAssertion();
    static final InterM4Communicator op2cond = new InterM4OperatorCondition();
    static final InterM4Communicator op2constr = new InterM4OperatorConstraint();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    protected boolean loopable;
    protected boolean stepable;
    protected boolean manual;
    protected String realize;
    private final Vector myOpParams = new Vector();
    private final Vector myAssertions = new Vector();
    private final Vector myConditions = new Vector();
    private final Vector myConstraints = new Vector();
    private boolean allOpParamsLoaded = false;
    private boolean allAssertionsLoaded = false;
    private boolean allConditionsLoaded = false;
    private boolean allConstraintsLoaded = false;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_OPERATOR_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_OPERATOR_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_OPERATOR_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_OPERATOR_REALIZED, "getRealize", "setRealize", String.class), new M4InfoEntry(ATTRIB_OPERATOR_IS_MANUAL, "getManual", "setManual", String.class), new M4InfoEntry(ATTRIB_OPERATOR_IS_LOOPABLE, "getLoopable", "setLoopable", String.class), new M4InfoEntry(ATTRIB_OPERATOR_IS_MULTISTEPABLE, "getStepable", "setStepable", String.class)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("isManual", "getManual", "setManual", String.class), new M4InfoEntry("isLoopable", "getLoopable", "setLoopable", String.class), new M4InfoEntry("isMultiStepable", "getStepable", "setStepable", String.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Operator(DB db) {
        super(db);
    }

    public Iterator getOpParamsIterator() throws M4Exception {
        Collection col = this.getOpParams();
        Iterator it = col == null ? null : col.iterator();
        return it;
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    public void setRealize(String r) {
        this.setDirty();
        this.realize = r;
    }

    public String getRealize() {
        return this.realize;
    }

    public void setLoopable(boolean l) {
        this.setDirty();
        this.loopable = l;
    }

    public void setLoopable(String loopable) {
        this.setLoopable("YES".equals(loopable));
    }

    public boolean isLoopable() {
        return this.loopable;
    }

    public String getLoopable() {
        return this.isLoopable() ? "YES" : "NO";
    }

    public void setManual(boolean m) {
        this.setDirty();
        this.manual = m;
    }

    public void setManual(String manual) {
        this.setManual("YES".equals(manual));
    }

    public boolean isManual() {
        return this.manual;
    }

    public String getManual() {
        return this.isManual() ? "YES" : "NO";
    }

    public void setStepable(boolean s) {
        this.setDirty();
        this.stepable = s;
    }

    public void setStepable(String stepable) {
        this.setStepable("YES".equals(stepable));
    }

    public boolean isStepable() {
        return this.stepable;
    }

    public String getStepable() {
        return this.isStepable() ? "YES" : "NO";
    }

    public Collection getOpParams() throws M4Exception {
        if (!this.allOpParamsLoaded && !this.isNew()) {
            this.allOpParamsLoaded = true;
            this.readOpParamsForOp();
        }
        return this.myOpParams;
    }

    public void addOpParam(OpParam opParam) throws M4Exception {
        op2oppar.checkNameExists((edu.udo.cs.miningmart.m4.core.OpParam)opParam, this);
        op2oppar.add(this, (edu.udo.cs.miningmart.m4.core.OpParam)opParam);
    }

    public boolean removeOpParam(OpParam opParam) throws M4Exception {
        return op2oppar.remove(this, (edu.udo.cs.miningmart.m4.core.OpParam)opParam);
    }

    public Collection getAssertions() throws M4Exception {
        if (!this.allAssertionsLoaded && !this.isNew()) {
            this.allAssertionsLoaded = true;
            this.readAssertionsFromDB();
        }
        return this.myAssertions;
    }

    public Collection getConditions() throws M4Exception {
        if (!this.allConditionsLoaded && !this.isNew()) {
            this.allConditionsLoaded = true;
            this.readConditionsFromDB();
        }
        return this.myConditions;
    }

    public Collection getConstraints() throws M4Exception {
        if (!this.allConstraintsLoaded && !this.isNew()) {
            this.allConstraintsLoaded = true;
            this.readConstraintsFromDB();
        }
        return this.myConstraints;
    }

    public void addAssertion(Assertion assertion) throws M4Exception {
        op2assert.add(this, (edu.udo.cs.miningmart.m4.core.Assertion)assertion);
    }

    public void addCondition(edu.udo.cs.miningmart.m4.Condition condition) throws M4Exception {
        op2cond.add(this, (Condition)condition);
    }

    public void addConstraint(Constraint constraint) throws M4Exception {
        op2constr.add(this, (edu.udo.cs.miningmart.m4.core.Constraint)constraint);
    }

    public boolean removeAssertion(Assertion assertion) throws M4Exception {
        return op2assert.remove(this, (edu.udo.cs.miningmart.m4.core.Assertion)assertion);
    }

    public boolean removeCondition(edu.udo.cs.miningmart.m4.Condition condition) throws M4Exception {
        return op2cond.remove(this, (Condition)condition);
    }

    public boolean removeConstraint(Constraint constraint) throws M4Exception {
        return op2constr.remove(this, (edu.udo.cs.miningmart.m4.core.Constraint)constraint);
    }

    public Assertion createAssertion(String type, String object1, String object2, String text) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Assertion assertion = new edu.udo.cs.miningmart.m4.core.Assertion(this.getM4Db());
        assertion.setAssertionType(type);
        assertion.setObj1(object1);
        assertion.setObj2(object2);
        assertion.setDocumentation(text);
        try {
            this.addAssertion(assertion);
        }
        catch (M4Exception e) {
            throw new M4Exception("Could not add new assertion (" + type + ", " + object1 + ", " + object2 + ", " + text + ") to operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
        return assertion;
    }

    public Constraint createConstraint(String type, String object1, String object2, String text) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Constraint constraint = new edu.udo.cs.miningmart.m4.core.Constraint(this.getM4Db());
        constraint.setType(type);
        constraint.setObj1(object1);
        constraint.setObj2(object2);
        constraint.setDocumentation(text);
        try {
            this.addConstraint(constraint);
        }
        catch (M4Exception e) {
            throw new M4Exception("Could not add new constraint (" + type + ", " + object1 + ", " + object2 + ", " + text + ") to operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
        return constraint;
    }

    public edu.udo.cs.miningmart.m4.Condition createCondition(String type, String object1, String object2, String text) throws M4Exception {
        Condition condition = new Condition(this.getM4Db());
        condition.setType(type);
        condition.setObj1(object1);
        condition.setObj2(object2);
        condition.setDocumentation(text);
        try {
            this.addCondition(condition);
        }
        catch (M4Exception e) {
            throw new M4Exception("Could not add new condition (" + type + ", " + object1 + ", " + object2 + ", " + text + ") to operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
        return condition;
    }

    public OpParam createOperatorParameter(String name, int minNrOfArgs, int maxNrOfArgs, String ioType, String parameterType, String text) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.OpParam opParam = new edu.udo.cs.miningmart.m4.core.OpParam(this.getM4Db());
        opParam.setName(name);
        opParam.setMinArg(minNrOfArgs);
        opParam.setMaxArg(maxNrOfArgs);
        opParam.setInput(ioType);
        opParam.setType(parameterType);
        opParam.setDocumentation(text);
        try {
            this.addOpParam(opParam);
        }
        catch (M4Exception e) {
            throw new M4Exception("Could not add new OperatorParameter (" + name + ", " + minNrOfArgs + ", " + maxNrOfArgs + ", " + ioType + ", " + parameterType + ", " + text + ") to operator with ID " + this.getId() + ":\n" + e.getMessage());
        }
        return opParam;
    }

    public edu.udo.cs.miningmart.m4.core.OpParam getOperatorParameter(String name) throws M4Exception {
        Iterator it = null;
        it = this.getOpParamsIterator();
        if (it != null && name != null) {
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.OpParam opParam = (edu.udo.cs.miningmart.m4.core.OpParam)it.next();
                if (opParam == null || !name.equals(opParam.getName())) continue;
                return opParam;
            }
        }
        return null;
    }

    public void removeOperatorParameter(String name) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.OpParam opParam = this.getOperatorParameter(name);
        if (opParam != null) {
            this.removeOpParam(opParam);
        }
    }

    public void removeAllOperatorParameters() throws M4Exception {
        Collection col = this.getAllOperatorParameters();
        if (col == null) {
            return;
        }
        for (edu.udo.cs.miningmart.m4.core.OpParam opPar : col) {
            this.removeOpParam(opPar);
        }
    }

    public void removeOperatorParameterByType(String type) throws M4Exception {
        Collection col = this.getOperatorParametersByType(type);
        if (col == null) {
            return;
        }
        for (edu.udo.cs.miningmart.m4.core.OpParam opPar : col) {
            this.removeOpParam(opPar);
        }
    }

    public Collection getAllOperatorParameters() throws M4Exception {
        return this.getOpParams();
    }

    public Collection getOperatorParametersByType(String type) throws M4Exception {
        Iterator it = null;
        it = this.getOpParamsIterator();
        if (it != null && type != null) {
            Vector<edu.udo.cs.miningmart.m4.core.OpParam> results = new Vector<edu.udo.cs.miningmart.m4.core.OpParam>();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.OpParam opParam = (edu.udo.cs.miningmart.m4.core.OpParam)it.next();
                if (opParam == null || !type.equals(opParam.getTypeS())) continue;
                results.add(opParam);
            }
            return results;
        }
        return null;
    }

    public Collection getAllInputOperatorParameters() throws M4Exception {
        Iterator it = null;
        it = this.getOpParamsIterator();
        if (it != null) {
            Vector<edu.udo.cs.miningmart.m4.core.OpParam> results = new Vector<edu.udo.cs.miningmart.m4.core.OpParam>();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.OpParam opParam = (edu.udo.cs.miningmart.m4.core.OpParam)it.next();
                if (opParam == null || !opParam.isInput()) continue;
                results.add(opParam);
            }
            return results;
        }
        return null;
    }

    public Collection getAllOutputOperatorParameters() throws M4Exception {
        Iterator it = null;
        it = this.getOpParamsIterator();
        if (it != null) {
            Vector<edu.udo.cs.miningmart.m4.core.OpParam> results = new Vector<edu.udo.cs.miningmart.m4.core.OpParam>();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.OpParam opParam = (edu.udo.cs.miningmart.m4.core.OpParam)it.next();
                if (opParam == null || opParam.isInput()) continue;
                results.add(opParam);
            }
            return results;
        }
        return null;
    }

    public OpParam getOpParam(String name) throws M4Exception {
        Iterator it = null;
        it = this.getOpParamsIterator();
        if (it != null) {
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.OpParam opParam = (edu.udo.cs.miningmart.m4.core.OpParam)it.next();
                if (opParam == null || !opParam.getName().equals(name)) continue;
                return opParam;
            }
        }
        return null;
    }

    public Collection getCoordinatedParameterArrays() throws M4Exception {
        HashMap theCollections = new HashMap();
        for (edu.udo.cs.miningmart.m4.core.Constraint myConstr : this.getConstraintsOfType("COORD")) {
            String name1 = myConstr.getObj1();
            String name2 = myConstr.getObj2();
            if (name1 == null || name2 == null) {
                throw new M4Exception("Operator.getCoordinatedParameterArrays(): Found a Constraint of type COORD that is underspecified!");
            }
            HashSet<edu.udo.cs.miningmart.m4.core.OpParam> theGroup = (HashSet<edu.udo.cs.miningmart.m4.core.OpParam>)theCollections.get(name1);
            if (theGroup == null) {
                theGroup = (HashSet)theCollections.get(name2);
            } else {
                HashSet secondGroup = (HashSet)theCollections.get(name2);
                if (secondGroup != null) {
                    theGroup.addAll(secondGroup);
                }
            }
            if (theGroup == null) {
                theGroup = new HashSet<edu.udo.cs.miningmart.m4.core.OpParam>();
            }
            theCollections.put(name1, theGroup);
            theCollections.put(name2, theGroup);
            edu.udo.cs.miningmart.m4.core.OpParam par1 = this.getOperatorParameter(name1);
            edu.udo.cs.miningmart.m4.core.OpParam par2 = this.getOperatorParameter(name2);
            if (par1 == null) {
                throw new M4Exception("Operator.getCoordinatedParameterArrays: could not find OpParam object with name '" + name1 + "'!");
            }
            if (par2 == null) {
                throw new M4Exception("Operator.getCoordinatedParameterArrays: could not find OpParam object with name '" + name2 + "'!");
            }
            theGroup.add(par1);
            theGroup.add(par2);
        }
        Vector<HashSet> ret = new Vector<HashSet>();
        for (Map.Entry myEntry : theCollections.entrySet()) {
            HashSet myGroup = (HashSet)myEntry.getValue();
            if (ret.contains(myGroup)) continue;
            ret.add(myGroup);
        }
        return ret;
    }

    private Collection getConstraintsOfType(String type) throws M4Exception {
        Iterator it = this.getConstraints().iterator();
        Vector<edu.udo.cs.miningmart.m4.core.Constraint> result = new Vector<edu.udo.cs.miningmart.m4.core.Constraint>();
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Constraint myConstr = (edu.udo.cs.miningmart.m4.core.Constraint)it.next();
            if (!myConstr.getType().equalsIgnoreCase(type)) continue;
            result.add(myConstr);
        }
        return result;
    }

    private void readOpParamsForOp() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.OpParam.class).iterator();
        while (it.hasNext()) {
            this.addOpParam((OpParam)it.next());
        }
    }

    private void readAssertionsFromDB() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Assertion.class).iterator();
        while (it.hasNext()) {
            this.addAssertion((Assertion)it.next());
        }
    }

    private void readConditionsFromDB() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(Condition.class).iterator();
        while (it.hasNext()) {
            this.addCondition((edu.udo.cs.miningmart.m4.Condition)it.next());
        }
    }

    private void readConstraintsFromDB() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Constraint.class).iterator();
        while (it.hasNext()) {
            this.addConstraint((Constraint)it.next());
        }
    }

    public void print() {
        this.doPrint(Print.M4_OBJECT, "Operator " + this.getName() + " (ID: " + this.getId() + "): {");
        this.doPrint(Print.M4_OBJECT, (this.isManual() ? "" : "not") + " manual,");
        this.doPrint(Print.M4_OBJECT, (this.isLoopable() ? "" : "not") + " loopable,");
        this.doPrint(Print.M4_OBJECT, (this.isStepable() ? "" : "not") + " multistep-able\n}");
        try {
            Iterator it = this.getOpParamsIterator();
            while (it.hasNext()) {
                edu.udo.cs.miningmart.m4.core.OpParam op = (edu.udo.cs.miningmart.m4.core.OpParam)it.next();
                op.print();
            }
        }
        catch (M4Exception e) {
            this.doPrint(Print.MAX, "Warning: Exception when printing operator " + this.getId() + ":");
            this.doPrint(e);
        }
    }

    protected void removeAllM4References() throws M4Exception {
        Vector empty = new Vector();
        op2assert.setCollectionTo(this, empty);
        op2cond.setCollectionTo(this, empty);
        op2constr.setCollectionTo(this, empty);
        op2oppar.setCollectionTo(this, empty);
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getOpParams());
        ret.addAll(this.getAssertions());
        ret.addAll(this.getConditions());
        ret.addAll(this.getConstraints());
        return ret;
    }
}

