/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.core.KeyMember;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.InterM4KeyKeymember;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class Key
extends M4Data
implements XmlInfo,
edu.udo.cs.miningmart.m4.Key {
    private boolean allMembersLoaded = false;
    public static final String M4_TABLE_NAME = "keyhead_t";
    public static final String ATTRIB_HEAD_ID = "kh_id";
    public static final String ATTRIB_HEAD_NAME = "kh_name";
    public static final String ATTRIB_HEAD_PK_CS = "kh_pkcsid";
    public static final String ATTRIB_HEAD_FK_CS = "kh_fkcsid";
    static final InterM4Communicator key2member = new InterM4KeyKeymember();
    private Vector theKeyMembers = new Vector();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_HEAD_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_HEAD_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_HEAD_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_HEAD_PK_CS, "getPrimaryKeyColumnset", "primitiveSetPrimaryKeyColumnset", Columnset.class), new M4InfoEntry(ATTRIB_HEAD_FK_CS, "getForeignKeyColumnset", "primitiveSetForeignKeyColumnset", Columnset.class)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("PrimaryKeyColumnset", "getPrimaryKeyColumnset", "setPrimaryKeyColumnset", Columnset.class), new M4InfoEntry("ForeignKeyColumnset", "getForeignKeyColumnset", "setForeignKeyColumnset", Columnset.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Key(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(Print.M4_OBJECT, "Key " + this.myName + ": Id = " + this.myId + ";");
    }

    public abstract void setPrimaryKeyColumnset(Columnset var1) throws M4Exception;

    public abstract void setForeignKeyColumnset(Columnset var1) throws M4Exception;

    public abstract void primitiveSetPrimaryKeyColumnset(Columnset var1) throws M4Exception;

    public abstract void primitiveSetForeignKeyColumnset(Columnset var1) throws M4Exception;

    public abstract Columnset getPrimaryKeyColumnset() throws M4Exception;

    public abstract Columnset getForeignKeyColumnset() throws M4Exception;

    protected void addMember(KeyMember newMember) throws M4Exception {
        key2member.checkNameExists(newMember, this);
        key2member.add(this, newMember);
        newMember.setThePosition(this.theKeyMembers.size());
    }

    protected void removeMemberByPrimaryColumnName(String name) throws M4Exception {
        if (this.getMembers().isEmpty()) {
            return;
        }
        Iterator it = this.getMembers().iterator();
        KeyMember theMemberToBeRemoved = null;
        while (it.hasNext()) {
            KeyMember km = (KeyMember)it.next();
            if (!km.getPrimaryKeyColumn().getName().equals(name)) continue;
            theMemberToBeRemoved = km;
        }
        key2member.remove(this, theMemberToBeRemoved);
        this.setPositions();
    }

    protected void removeMemberByForeignColumnName(String name) throws M4Exception {
        if (this.getMembers().isEmpty()) {
            return;
        }
        Iterator it = this.getMembers().iterator();
        KeyMember theMemberToBeRemoved = null;
        while (it.hasNext()) {
            KeyMember km = (KeyMember)it.next();
            if (!km.getForeignKeyColumn().getName().equals(name)) continue;
            theMemberToBeRemoved = km;
        }
        key2member.remove(this, theMemberToBeRemoved);
        this.setPositions();
    }

    public Collection getMembers() throws M4Exception {
        if (!this.allMembersLoaded && !this.isNew()) {
            this.allMembersLoaded = true;
            this.readKeyMembersFromDb();
        }
        return this.theKeyMembers;
    }

    protected void removeMembers() {
        this.theKeyMembers = new Vector();
    }

    protected void setMembers(Collection newMembers) throws M4Exception {
        key2member.setCollectionTo(this, newMembers);
        this.setPositions();
    }

    public void deleteSoon() throws M4Exception {
        Collection kms = this.getMembers();
        if (kms != null && !kms.isEmpty()) {
            for (KeyMember km : new Vector(kms)) {
                km.deleteSoon();
            }
        }
        super.deleteSoon();
    }

    private void readKeyMembersFromDb() throws M4Exception {
        this.setMembers(this.getObjectsReferencingMe(KeyMember.class));
    }

    private void setPositions() throws M4Exception {
        Iterator it = this.getMembers().iterator();
        int i = 1;
        while (it.hasNext()) {
            ((KeyMember)it.next()).setThePosition(i);
            ++i;
        }
    }

    protected void removeAllM4References() throws M4Exception {
        this.setMembers(new Vector());
        this.removeDocObject();
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getMembers());
        return ret;
    }

    public abstract void removeColumn(String var1) throws M4Exception;

    public void removeAllColumns() throws M4Exception {
        this.removeMembers();
    }
}

