/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.ForeignKeyLink;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.m4.core.Feature;
import edu.udo.cs.miningmart.m4.core.Key;
import edu.udo.cs.miningmart.m4.core.KeyMember;
import java.util.Collection;
import java.util.Iterator;

public class ForeignKey
extends Key
implements edu.udo.cs.miningmart.m4.ForeignKey {
    private Columnset primaryKeyCS;
    private Columnset foreignKeyCS;
    private edu.udo.cs.miningmart.m4.core.Relation myRelation;
    private boolean myRelationLoaded = false;

    public ForeignKey(DB m4Db) {
        super(m4Db);
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        return null;
    }

    protected Column getColumn(KeyMember km) {
        return (Column)km.getForeignKeyColumn();
    }

    private void setRelation(Relation relationship) throws M4Exception {
        boolean thisIsAFromKey = true;
        this.setRelation(relationship, thisIsAFromKey);
    }

    public void addColumnLink(edu.udo.cs.miningmart.m4.Column fkColumn, edu.udo.cs.miningmart.m4.Column pkColumn) throws M4Exception {
        try {
            KeyMember km = (KeyMember)this.getM4Db().createNewInstance(KeyMember.class);
            km.setForeignKeyColumn(null);
            km.setPrimaryKeyColumn(pkColumn);
            km.setForeignKeyColumn(fkColumn);
            this.addMember(km);
        }
        catch (M4Exception m4e) {
            throw new M4Exception("ForeignKey.addColumnLink: Error adding Columns " + ((Column)fkColumn).getId() + " (foreign key column) and " + ((Column)pkColumn).getId() + " (primary key column) to Foreign Key " + this.getId() + ": " + m4e.getMessage());
        }
    }

    public void createColumnLinksFromAttribs(Collection fromAttribs, Collection toAttribs) throws M4Exception {
        Iterator fromKeyIt = fromAttribs.iterator();
        Iterator toKeyIt = toAttribs.iterator();
        while (fromKeyIt.hasNext()) {
            Feature fromFeature = (Feature)fromKeyIt.next();
            Feature toFeature = (Feature)toKeyIt.next();
            if (fromFeature instanceof BaseAttribute && toFeature instanceof BaseAttribute) {
                Column fromCol = (Column)((BaseAttribute)fromFeature).getCurrentColumn();
                Column toCol = (Column)((BaseAttribute)toFeature).getCurrentColumn();
                this.addColumnLink(fromCol, toCol);
                continue;
            }
            throw new M4Exception("ForeignKey.createColumnLinksFromAttribs: MultiColumnFeatures are not allowed as Key attributes yet!");
        }
    }

    public boolean isColumnContainedInForeignColumns(edu.udo.cs.miningmart.m4.Column theColumn) throws M4Exception {
        for (ForeignKeyLink myColumnLink : this.getAllColumnLinks()) {
            if (!myColumnLink.getForeignKeyColumn().equals(theColumn)) continue;
            return true;
        }
        return false;
    }

    public boolean isColumnContainedInPrimaryColumns(edu.udo.cs.miningmart.m4.Column theColumn) throws M4Exception {
        for (ForeignKeyLink myColumnLink : this.getAllColumnLinks()) {
            if (!myColumnLink.getPrimaryKeyColumn().equals(theColumn)) continue;
            return true;
        }
        return false;
    }

    public edu.udo.cs.miningmart.m4.Column getPrimaryForForeignColumn(edu.udo.cs.miningmart.m4.Column theForeignKeyColumn) throws M4Exception {
        for (ForeignKeyLink myColumnLink : this.getAllColumnLinks()) {
            if (!myColumnLink.getForeignKeyColumn().equals(theForeignKeyColumn)) continue;
            return myColumnLink.getPrimaryKeyColumn();
        }
        return null;
    }

    public edu.udo.cs.miningmart.m4.Column getForeignForPrimaryColumn(edu.udo.cs.miningmart.m4.Column thePrimaryKeyColumn) throws M4Exception {
        for (ForeignKeyLink myColumnLink : this.getAllColumnLinks()) {
            if (!myColumnLink.getPrimaryKeyColumn().equals(thePrimaryKeyColumn)) continue;
            return myColumnLink.getForeignKeyColumn();
        }
        return null;
    }

    public edu.udo.cs.miningmart.m4.ForeignKey copy(edu.udo.cs.miningmart.m4.Columnset newColumnSet) throws M4Exception {
        ForeignKey theCopy = new ForeignKey(this.getM4Db());
        try {
            theCopy.setForeignKeyColumnset(this.getForeignKeyColumnset());
            theCopy.setPrimaryKeyColumnset(this.getPrimaryKeyColumnset());
            Case myContainer = (Case)this.getForeignKeyColumnset().getTheConcept().getTheCase();
            String nameOfCopy = myContainer.getValidName(this.getName(), ForeignKey.class);
            theCopy.setName(nameOfCopy);
            theCopy.setMembers(this.getMembers());
            theCopy.setRelation(this.getRelation());
        }
        catch (M4Exception se) {
            throw new M4Exception("Could not copy ForeignKey " + this.getId() + " to Columnset '" + newColumnSet.getName() + "': " + se.getMessage());
        }
        return theCopy;
    }

    public edu.udo.cs.miningmart.m4.Columnset getPrimaryKeyColumnset() throws M4Exception {
        return this.primaryKeyCS;
    }

    public void setPrimaryKeyColumnset(edu.udo.cs.miningmart.m4.Columnset cs) throws M4Exception {
        Columnset.csAsPk2FKey.updateReferenceTo(this, cs);
    }

    public void removePrimaryKeyColumnset() throws M4Exception {
        Columnset.csAsPk2FKey.remove(this.primaryKeyCS, this);
    }

    public void primitiveSetPrimaryKeyColumnset(edu.udo.cs.miningmart.m4.Columnset cs) {
        this.setDirty();
        this.primaryKeyCS = (Columnset)cs;
    }

    public edu.udo.cs.miningmart.m4.Columnset getForeignKeyColumnset() throws M4Exception {
        return this.foreignKeyCS;
    }

    public void setForeignKeyColumnset(edu.udo.cs.miningmart.m4.Columnset cs) throws M4Exception {
        Columnset.csAsFk2Fkey.updateReferenceTo(this, cs);
    }

    public void removeForeignKeyColumnset() throws M4Exception {
        Columnset.csAsFk2Fkey.remove(this.foreignKeyCS, this);
    }

    public void primitiveSetForeignKeyColumnset(edu.udo.cs.miningmart.m4.Columnset cs) {
        this.setDirty();
        this.foreignKeyCS = (Columnset)cs;
    }

    public void removeColumn(String name) throws M4Exception {
        this.removeColumnLink(name);
    }

    public void removeColumnLink(String name) throws M4Exception {
        this.removeMemberByForeignColumnName(name);
    }

    public void removeAllColumnLinks() throws M4Exception {
        this.removeAllColumns();
    }

    public Relation getRelation() throws M4Exception {
        if (!this.myRelationLoaded && !this.isNew()) {
            this.myRelationLoaded = true;
            Collection rels = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Relation.class, "rel_fromkid");
            edu.udo.cs.miningmart.m4.core.Relation rel = null;
            if (rels != null && !rels.isEmpty()) {
                rel = (edu.udo.cs.miningmart.m4.core.Relation)rels.iterator().next();
            }
            if (rel != null) {
                edu.udo.cs.miningmart.m4.core.Relation.rel2fromKey.setReciprocalReferences(rel, this);
            } else {
                rels = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Relation.class, "rel_tokid");
                if (rels != null && !rels.isEmpty()) {
                    rel = (edu.udo.cs.miningmart.m4.core.Relation)rels.iterator().next();
                }
                if (rel != null) {
                    edu.udo.cs.miningmart.m4.core.Relation.rel2toKey.setReciprocalReferences(rel, this);
                }
            }
            this.myRelation = rel;
        }
        return this.myRelation;
    }

    public void setRelation(Relation rel, boolean isFrom) throws M4Exception {
        if (isFrom) {
            edu.udo.cs.miningmart.m4.core.Relation.rel2fromKey.setReciprocalReferences((edu.udo.cs.miningmart.m4.core.Relation)rel, this);
        } else {
            edu.udo.cs.miningmart.m4.core.Relation.rel2toKey.setReciprocalReferences((edu.udo.cs.miningmart.m4.core.Relation)rel, this);
        }
    }

    public Collection getAllColumnLinks() throws M4Exception {
        return this.getMembers();
    }

    public ForeignKeyLink getFirstColumnLink() throws M4Exception {
        Iterator it = this.getMembers().iterator();
        if (it.hasNext()) {
            return (KeyMember)it.next();
        }
        return null;
    }

    public void setRelationPrimitive(edu.udo.cs.miningmart.m4.core.Relation r) {
        this.myRelation = r;
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        Columnset cs = (Columnset)this.getPrimaryKeyColumnset();
        if (cs != null) {
            ret.add(cs);
        }
        if ((cs = (Columnset)this.getForeignKeyColumnset()) != null) {
            ret.add(cs);
        }
        return ret;
    }

    protected void deleteLocal() throws M4Exception {
        super.deleteLocal();
        Relation rel = this.getRelation();
        if (rel != null) {
            if (rel.getFromKey() == this) {
                rel.setFromKey(null);
            }
            if (rel.getToKey() == this) {
                rel.setToKey(null);
            }
        }
    }
}

