/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.core.BaseAttribute;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.ColumnStatistics1;
import edu.udo.cs.miningmart.m4.core.ColumnStatistics2;
import edu.udo.cs.miningmart.m4.core.Columnset;
import edu.udo.cs.miningmart.m4.core.Concept;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class EstimatedStatistics
implements edu.udo.cs.miningmart.m4.EstimatedStatistics {
    private Concept myConcept;
    private long numberOfRows;
    private Map attributesToInfos;

    public EstimatedStatistics(edu.udo.cs.miningmart.m4.Concept theConcept) throws M4Exception {
        this.myConcept = (Concept)theConcept;
        this.numberOfRows = Integer.MIN_VALUE;
        if (theConcept == null) {
            throw new M4Exception("Constructor of EstimatedStatistics: got NULL concept!");
        }
        this.initiateValueLists(theConcept);
        Columnset theCs = (Columnset)theConcept.getCurrentColumnSet();
        if (theCs != null && theConcept.getType().equals("DB")) {
            theCs.updateStatistics();
            this.takePrecomputedStatistics(theCs);
        }
    }

    public edu.udo.cs.miningmart.m4.Concept getConcept() {
        return this.myConcept;
    }

    public Vector getValueList(String nameOfAttribute) {
        if (nameOfAttribute == null) {
            return null;
        }
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        Vector<String> theValues = new Vector<String>();
        Vector valInfos = ai.getValues();
        for (ValueInfo vi : valInfos) {
            theValues.add(vi.getTheValue());
        }
        return theValues;
    }

    public void setValueList(String nameOfAttribute, Vector theValues) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        if (theValues != null && ai != null) {
            Vector<ValueInfo> theValueInfos = new Vector<ValueInfo>();
            for (String myValue : theValues) {
                ValueInfo vi = new ValueInfo();
                vi.setTheValue(myValue);
                theValueInfos.add(vi);
            }
            ai.setValues(theValueInfos);
        }
    }

    private AttributeInfo getAttribInfo(String nameOfAttribute) {
        return (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
    }

    public void copyValueList(String nameOfDestinationAttribute, edu.udo.cs.miningmart.m4.EstimatedStatistics from, String nameOfSourceAttribute) {
        AttributeInfo toAi = (AttributeInfo)this.attributesToInfos.get(nameOfDestinationAttribute);
        EstimatedStatistics coreFrom = (EstimatedStatistics)from;
        AttributeInfo fromAi = coreFrom.getAttribInfo(nameOfSourceAttribute);
        Iterator it = fromAi.getValues().iterator();
        Vector<ValueInfo> copyOfList = new Vector<ValueInfo>();
        while (it.hasNext()) {
            ValueInfo vi = (ValueInfo)it.next();
            copyOfList.add(vi.copy());
        }
        toAi.setValues(copyOfList);
    }

    public void removeValue(String value, String nameOfAttribute) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        if (ai == null) {
            return;
        }
        Vector valInfos = ai.getValues();
        ValueInfo toRemove = null;
        for (ValueInfo vi : valInfos) {
            if (!vi.getTheValue().equals(value)) continue;
            toRemove = vi;
        }
        if (toRemove != null) {
            ai.getValues().remove(toRemove);
        }
    }

    public int getNumberOfMissingValues(String nameOfAttribute) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        return ai.getNumberOfMissingValues();
    }

    public void setNumberOfMissingValues(String nameOfAttribute, int number) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        if (ai != null) {
            ai.setNumberOfMissingValues(number);
        }
    }

    public double getBiggestValue(String nameOfAttribute) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        return ai.getMaximum();
    }

    public void setBiggestValue(String nameOfAttribute, double value) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        if (ai != null) {
            ai.setMaximum(value);
        }
    }

    public void setLowestValue(String nameOfAttribute, double value) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        if (ai != null) {
            ai.setMinimum(value);
        }
    }

    public double getLowestValue(String nameOfAttribute) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        return ai.getMinimum();
    }

    public boolean readAvailableStatisticsFromDb() throws M4Exception {
        if (this.getConcept().getType().equals("DB")) {
            return false;
        }
        Columnset myCs = (Columnset)this.getConcept().getCurrentColumnSet();
        if (myCs == null) {
            return false;
        }
        if (myCs.statisticsExist()) {
            this.takePrecomputedStatistics(myCs);
            return true;
        }
        return false;
    }

    private void takePrecomputedStatistics(Columnset theCs) throws M4Exception {
        this.numberOfRows = theCs.getStatisticsAll();
        for (BaseAttribute myBa : this.getConcept().getAllBaseAttributes()) {
            Column myCol = (Column)myBa.getCurrentColumn();
            if (myCol == null) continue;
            AttributeInfo theAttrInfo = (AttributeInfo)this.attributesToInfos.get(myBa.getName());
            if (theAttrInfo == null) {
                throw new M4Exception("EstimatedStatistics, constructor: found unknown (?) BaseAttribute '" + myBa.getName() + "'!");
            }
            Collection colStats1 = myCol.getBasicColStats();
            if (colStats1 != null && !colStats1.isEmpty()) {
                Iterator csIt = colStats1.iterator();
                boolean moreThanOne = false;
                while (csIt.hasNext() && !moreThanOne) {
                    String min;
                    String max;
                    moreThanOne = true;
                    ColumnStatistics1 colstat1 = (ColumnStatistics1)csIt.next();
                    Integer noOfMiss = colstat1.getNrOfMissingValuesI();
                    if (noOfMiss != null) {
                        theAttrInfo.setNumberOfMissingValues(noOfMiss);
                    }
                    if ((max = colstat1.getMaximum()) != null) {
                        try {
                            double m = Double.parseDouble(max);
                            theAttrInfo.setMaximum(m);
                        }
                        catch (NumberFormatException nfe) {
                            theAttrInfo.setMaximum(Double.NaN);
                        }
                    }
                    if ((min = colstat1.getMinimum()) == null) continue;
                    try {
                        double m = Double.parseDouble(min);
                        theAttrInfo.setMinimum(m);
                    }
                    catch (NumberFormatException nfe) {
                        theAttrInfo.setMinimum(Double.NaN);
                    }
                }
            }
            Vector someValues = theAttrInfo.getValues();
            Collection colStats2 = myCol.getDistributionStatistics();
            if (colStats2 == null || colStats2.isEmpty()) continue;
            someValues.clear();
            Iterator csIt = colStats2.iterator();
            while (csIt.hasNext()) {
                int count;
                ValueInfo valInfo = new ValueInfo();
                someValues.add(valInfo);
                ColumnStatistics2 colstat2 = (ColumnStatistics2)csIt.next();
                String value = colstat2.getDistributionValue();
                if (value != null) {
                    valInfo.setTheValue(value);
                }
                if ((count = colstat2.getDistributionCount()) != Integer.MIN_VALUE && count > 0) {
                    valInfo.setNumberOfOccurrences(count);
                }
                if (count != 0) continue;
                System.out.println("Warning: value '" + value + "' in column '" + myCol.getName() + "' occurs 0 times, it's not used in estimated statistics!");
                someValues.remove(valInfo);
            }
        }
    }

    private void initiateValueLists(edu.udo.cs.miningmart.m4.Concept theConcept) throws M4Exception {
        this.attributesToInfos = new HashMap();
        Collection bas = theConcept.getAllBaseAttributes();
        if (bas != null && !bas.isEmpty()) {
            for (BaseAttribute ba : bas) {
                this.attributesToInfos.put(ba.getName(), new AttributeInfo());
            }
        }
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public void setNumberOfOccurrences(String nameOfAttribute, String value, int number) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        if (ai != null) {
            Vector valInfos = ai.getValues();
            ValueInfo toRemove = null;
            for (ValueInfo vi : valInfos) {
                if (!vi.getTheValue().equals(value)) continue;
                if (number == 0) {
                    toRemove = vi;
                    continue;
                }
                vi.setNumberOfOccurrences(number);
            }
            if (toRemove != null) {
                ai.getValues().remove(toRemove);
            }
        }
    }

    public int getNumberOfOccurrences(String nameOfAttribute, String value) {
        Vector valInfos;
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        if (ai != null && (valInfos = ai.getValues()) != null) {
            for (ValueInfo vi : valInfos) {
                if (!vi.getTheValue().equals(value)) continue;
                return vi.getNumberOfOccurrences();
            }
        }
        return 0;
    }

    public edu.udo.cs.miningmart.m4.EstimatedStatistics copy(edu.udo.cs.miningmart.m4.Concept toConcept) throws M4Exception {
        EstimatedStatistics copy = new EstimatedStatistics(toConcept);
        copy.setNumberOfRows(this.getNumberOfRows());
        for (Map.Entry myEntry : this.attributesToInfos.entrySet()) {
            String nameOfAttrib = (String)myEntry.getKey();
            AttributeInfo ai = (AttributeInfo)myEntry.getValue();
            copy.addAttribInfo(nameOfAttrib, ai.copy());
        }
        return copy;
    }

    public void addValueInformation(String nameOfAttribute, String value, int noOfOccurrences) {
        AttributeInfo ai = (AttributeInfo)this.attributesToInfos.get(nameOfAttribute);
        if (ai != null) {
            ai.addValueInfo(value, noOfOccurrences);
            double dVal = this.getNumeric(value);
            if (!this.doublesAreEqual(dVal, Double.NaN)) {
                if (!this.doublesAreEqual(this.getBiggestValue(nameOfAttribute), Double.NaN)) {
                    this.setBiggestValue(nameOfAttribute, Math.max(dVal, this.getBiggestValue(nameOfAttribute)));
                }
                if (!this.doublesAreEqual(this.getLowestValue(nameOfAttribute), Double.NaN)) {
                    this.setLowestValue(nameOfAttribute, Math.min(dVal, this.getLowestValue(nameOfAttribute)));
                }
            }
        }
    }

    private boolean doublesAreEqual(double a, double b) {
        Double aA = new Double(a);
        Double bB = new Double(b);
        return aA.compareTo(bB) == 0;
    }

    private double getNumeric(String value) {
        try {
            double d = Double.parseDouble(value);
            return d;
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    private void addAttribInfo(String nameOfAttribute, AttributeInfo ai) {
        if (this.attributesToInfos == null) {
            this.attributesToInfos = new HashMap();
        }
        if (ai != null && nameOfAttribute != null) {
            this.attributesToInfos.put(nameOfAttribute, ai);
        }
    }

    public void addAttribute(String nameOfAttribute) {
        if (this.attributesToInfos == null) {
            this.attributesToInfos = new HashMap();
        }
        this.attributesToInfos.put(nameOfAttribute, new AttributeInfo());
    }

    private class ValueInfo {
        private String theValue = "<unknown>";
        private int numberOfOccurrences = Integer.MIN_VALUE;

        public int getNumberOfOccurrences() {
            return this.numberOfOccurrences;
        }

        public void setNumberOfOccurrences(int numberOfOccurrences) {
            this.numberOfOccurrences = numberOfOccurrences;
        }

        public String getTheValue() {
            return this.theValue;
        }

        public void setTheValue(String theValue) {
            theValue = theValue.trim();
            try {
                Double.parseDouble(theValue);
                while (theValue.indexOf(".") > -1 && theValue.endsWith("0")) {
                    theValue = theValue.substring(0, theValue.length() - 1);
                }
                if (theValue.endsWith(".")) {
                    theValue = theValue.substring(0, theValue.length() - 1);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.theValue = theValue;
        }

        public ValueInfo copy() {
            ValueInfo copy = new ValueInfo();
            copy.setNumberOfOccurrences(this.getNumberOfOccurrences());
            copy.setTheValue(this.getTheValue());
            return copy;
        }
    }

    private class AttributeInfo {
        private double minimum;
        private double maximum = Double.NaN;
        private int numberOfMissingValues;
        private Vector values;

        public AttributeInfo() {
            this.minimum = Double.NaN;
            this.numberOfMissingValues = Integer.MIN_VALUE;
            this.values = new Vector();
        }

        public double getMaximum() {
            return this.maximum;
        }

        public void setMaximum(double maximum) {
            this.maximum = maximum;
        }

        public double getMinimum() {
            return this.minimum;
        }

        public void setMinimum(double minimum) {
            this.minimum = minimum;
        }

        public int getNumberOfMissingValues() {
            return this.numberOfMissingValues;
        }

        public void setNumberOfMissingValues(int numberOfMissingValues) {
            this.numberOfMissingValues = numberOfMissingValues;
        }

        public Vector getValues() {
            return this.values;
        }

        public void setValues(Vector values) {
            this.values = values;
        }

        public void setValueInfo(String value, int noOfOccurrences) {
            Iterator it = this.values.iterator();
            ValueInfo toRemove = null;
            while (it.hasNext()) {
                ValueInfo vi = (ValueInfo)it.next();
                if (!vi.getTheValue().equals(value)) continue;
                if (noOfOccurrences > 0) {
                    vi.setNumberOfOccurrences(noOfOccurrences);
                    continue;
                }
                if (noOfOccurrences != 0) continue;
                toRemove = vi;
            }
            if (toRemove != null) {
                this.values.remove(toRemove);
            }
        }

        public void addValueInfo(String value, int noOfOccurrences) {
            ValueInfo vi2;
            for (ValueInfo vi2 : this.values) {
                if (!vi2.getTheValue().equals(value)) continue;
                vi2.setNumberOfOccurrences(noOfOccurrences);
                return;
            }
            vi2 = new ValueInfo();
            vi2.setTheValue(value);
            vi2.setNumberOfOccurrences(noOfOccurrences);
            this.values.add(vi2);
        }

        public AttributeInfo copy() {
            AttributeInfo copy = new AttributeInfo();
            copy.setMaximum(this.getMaximum());
            copy.setMinimum(this.getMinimum());
            copy.setNumberOfMissingValues(this.getNumberOfMissingValues());
            Vector<ValueInfo> copyOfValues = new Vector<ValueInfo>();
            for (ValueInfo vi : this.getValues()) {
                ValueInfo copyVi = vi.copy();
                copyOfValues.add(copyVi);
            }
            copy.setValues(copyOfValues);
            return copy;
        }
    }
}

