/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Object;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.GraphicalM4Object;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.awt.Point;
import java.io.Serializable;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;

public class Coordinates
extends M4Data
implements Serializable,
XmlInfo {
    public static String TAG_MAIN = "Coordinates";
    private edu.udo.cs.miningmart.m4.GraphicalM4Object theObject;
    private Point theLocation;
    private static final Class[] objectTypes = new Class[]{Chain.class, Relation.class, Concept.class, Step.class};
    private static final String[] objectDB_Names = new String[]{"CH", "REL", "CON", "ST"};
    public static final String M4_TABLE_NAME = "hci_coord_t";
    public static final String ATTRIB_OBJECT_ID = "obj_id";
    public static final String ATTRIB_OBJECT_NAME = "obj_name";
    public static final String ATTRIB_OBJECT_TYPE = "obj_type";
    public static final String ATTRIB_CONTEXT_ID = "context_id";
    public static final String ATTRIB_CONTEXT_NAME = "context_name";
    public static final String ATTRIB_CONTEXT_TYPE = "context_type";
    public static final String ATTRIB_X_COORD = "x";
    public static final String ATTRIB_Y_COORD = "y";
    private static M4Info xmlInfo = null;
    public static M4Info m4Info = null;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public Collection getDependentObjects() {
        return new Vector();
    }

    public String getXmlVersion() {
        return "M4-XML V0.5";
    }

    public String getXmlIdTag() {
        return "XmlId";
    }

    public String getObjectTag() {
        return TAG_MAIN;
    }

    public String getIdAttributeName() {
        return ATTRIB_CONTEXT_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_CONTEXT_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_OBJECT_ID, "getMyM4Object", "primitiveSetMyM4Object", edu.udo.cs.miningmart.m4.GraphicalM4Object.class, "NN"), new M4InfoEntry(ATTRIB_OBJECT_NAME, "getName", "setName", String.class), new M4InfoEntry(ATTRIB_OBJECT_TYPE, "getType", "setType", String.class), new M4InfoEntry(ATTRIB_X_COORD, "getX", "setX", Integer.TYPE), new M4InfoEntry(ATTRIB_Y_COORD, "getY", "setY", Integer.TYPE)};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("M4Object", "getMyM4Object", "setMyM4Object", edu.udo.cs.miningmart.m4.GraphicalM4Object.class), new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("X_Coord", "getX", "setX", Integer.TYPE), new M4InfoEntry("Y_Coord", "getY", "setY", Integer.TYPE)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Coordinates(DB db) {
        super(db);
    }

    public edu.udo.cs.miningmart.m4.GraphicalM4Object getMyM4Object() {
        return this.theObject;
    }

    public String getName() {
        if (this.getMyM4Object() != null) {
            return this.getMyM4Object().getName();
        }
        return null;
    }

    public void setName(String name) {
    }

    public void setType(String type) {
    }

    public String getType() throws M4Exception {
        if (this.getMyM4Object() != null) {
            return this.checkObjectType(this.getMyM4Object());
        }
        return null;
    }

    public Collection getObjectsInNamespace(Class namespace) {
        return new Vector();
    }

    public void setMyM4Object(edu.udo.cs.miningmart.m4.GraphicalM4Object theM4Object) throws M4Exception {
        GraphicalM4Object.graph2coord.setReciprocalReferences((GraphicalM4Object)theM4Object, this);
    }

    public void primitiveSetMyM4Object(edu.udo.cs.miningmart.m4.GraphicalM4Object m4Object) {
        this.setDirty();
        this.theObject = m4Object;
    }

    public Point getLocation() throws M4Exception {
        if (this.theLocation == null) {
            this.readFromDb();
            if (this.theLocation == null) {
                this.theLocation = new Point();
                this.theLocation.setLocation(1, 1);
            }
        }
        return this.theLocation;
    }

    public void setLocation(Point theLocation) {
        this.setDirty();
        this.theLocation = theLocation;
    }

    public void setX(int x_coord) {
        if (this.theLocation == null) {
            this.theLocation = new Point();
        }
        this.theLocation.setLocation(x_coord, this.theLocation.y);
    }

    public void setY(int y_coord) {
        if (this.theLocation == null) {
            this.theLocation = new Point();
        }
        this.theLocation.setLocation(this.theLocation.x, y_coord);
    }

    public int getX() {
        if (this.theLocation == null) {
            return -1;
        }
        return this.theLocation.x;
    }

    public int getY() {
        if (this.theLocation == null) {
            return -1;
        }
        return this.theLocation.y;
    }

    public Collection exportLocal(Writer out, Collection dependent) {
        return null;
    }

    public void importLocal(String tag, String embedded) {
    }

    public void doPrint(Level verbosity, String message) {
        Print p = this.getPrintObject();
        if (p != null) {
            p.doPrint(verbosity, message);
        } else if (verbosity == Print.MAX) {
            System.err.println("Coordinates: " + message);
        }
    }

    public void doPrint(Exception ex) {
        this.doPrint(Print.MAX, ex.getMessage());
    }

    private Print getPrintObject() {
        if (this.getM4Db() != null) {
            return this.getM4Db().getCasePrintObject();
        }
        edu.udo.cs.miningmart.m4.GraphicalM4Object gm4o = this.getMyM4Object();
        if (gm4o != null) {
            return gm4o.getCasePrintObject();
        }
        return null;
    }

    public void delete() throws M4Exception {
        String query = "DELETE FROM hci_coord_t WHERE ";
        query = this.getMyM4Object() == null ? query + this.getIdAttributeName() + " = " + this.getId() : query + "obj_id = " + this.getMyM4Object().getId();
        try {
            this.getM4Db().executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception(this.createErrorMsgPrefix() + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception(this.createErrorMsgPrefix() + d.getMessage());
        }
    }

    private String createErrorMsgPrefix() {
        return "SQL Error when deleting coordinates of M4 object (Id: " + this.getMyM4Object().getId() + ", Name: " + this.getMyM4Object().getName() + "): ";
    }

    public void store() throws M4Exception {
        this.delete();
        if (this.getMyM4Object() == null) {
            return;
        }
        if (this.getId() == 0L) {
            return;
        }
        String query = "INSERT INTO hci_coord_t (obj_id, obj_name, obj_type, context_id, x, y) VALUES (" + this.getMyM4Object().getId() + ", '" + this.getMyM4Object().getName() + "', '" + this.checkObjectType(this.getMyM4Object()) + "', " + this.getId() + ", " + this.getLocation().x + ", " + this.getLocation().y + ")";
        try {
            this.getM4Db().executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception(this.createErrorMsgPrefix() + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception(this.createErrorMsgPrefix() + d.getMessage());
        }
    }

    private String checkObjectType(M4Object theObject) throws M4Exception {
        if (theObject == null) {
            throw new M4Exception("Error when storing/retrieving coordinates of an M4 object: got NULL object for primary key!");
        }
        Class<?> type = theObject.getClass();
        for (int i = 0; i < objectTypes.length; ++i) {
            if (!objectTypes[i].isAssignableFrom(type)) continue;
            return objectDB_Names[i];
        }
        throw new M4Exception("Error when storing/retrieving coordinates of M4 object (Id: " + this.getMyM4Object().getId() + ", Name: " + this.getMyM4Object().getName() + "): wrong object type!: " + type);
    }

    protected void removeAllM4References() throws M4Exception {
        this.setMyM4Object(null);
    }

    public void print() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFromDb() throws M4Exception {
        String attributes = "obj_name, context_id, y, x";
        String query = "SELECT " + attributes + " FROM " + this.getM4TableName();
        if (this.getMyM4Object() != null) {
            query = query + " WHERE obj_id = " + this.getMyM4Object().getId();
        } else {
            if (this.getId() == 0L) {
                throw new M4Exception("Coordinates.readFromDb(): cannot load coordinates because the object whose coordinates are to be loaded is not set!");
            }
            query = query + " WHERE " + this.getIdAttributeName() + " = " + this.getId();
        }
        String error = "SQL Error when retrieving coordinates of M4 object (Id: " + this.getMyM4Object().getId() + ", Name: " + this.getMyM4Object().getName() + "): ";
        ResultSet rs = null;
        try {
            rs = this.getM4Db().executeM4SqlRead(query);
            if (rs.next()) {
                String objectName = rs.getString(ATTRIB_OBJECT_NAME);
                if (!objectName.equals(this.getMyM4Object().getName())) {
                    throw new M4Exception("Error loading coordinates for M4 object '" + this.getMyM4Object().getId() + ", Name: " + this.getMyM4Object().getName() + "): The name of this object in " + M4_TABLE_NAME + " is different, though M4-Id matches!");
                }
                this.myName = objectName;
                long myId = rs.getLong(ATTRIB_CONTEXT_ID);
                if (myId == 1L || this.getMyM4Object() != null && myId == this.getMyM4Object().getId()) {
                    myId = this.getM4Db().getNextM4SequenceValue();
                }
                this.setId(myId);
                int xCoord = rs.getInt(ATTRIB_X_COORD);
                int yCoord = rs.getInt(ATTRIB_Y_COORD);
                Point p = new Point(xCoord, yCoord);
                this.setLocation(p);
            }
            rs.close();
        }
        catch (SQLException sqle) {
            try {
                throw new M4Exception(error + sqle.getMessage());
                catch (DbConnectionClosed d) {
                    throw new M4Exception(error + d.getMessage());
                }
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
    }
}

