/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class ConceptualDatatypes
implements edu.udo.cs.miningmart.m4.ConceptualDatatypes {
    public static final String M4_TABLE_NAME = "con_datatype_t";
    public static final String ATTRIB_DATATYPE_ID = "condt_id";
    public static final String ATTRIB_DATATYPE_NAME = "condt_name";
    private HashMap idToName = new HashMap();
    private HashMap nameToId = new HashMap();

    public ConceptualDatatypes(DB db) throws M4Exception, DbConnectionClosed {
        String query = "SELECT condt_id, condt_name FROM con_datatype_t";
        ResultSet rs = null;
        try {
            rs = db.executeM4SqlRead(query);
            while (rs.next()) {
                Integer id = new Integer(rs.getInt(ATTRIB_DATATYPE_ID));
                if (rs.wasNull()) continue;
                String name = rs.getString(ATTRIB_DATATYPE_NAME);
                this.idToName.put(id, name);
                this.nameToId.put(name, id);
            }
        }
        catch (SQLException e) {
            throw new M4Exception("SQLException when trying to read the conceptual datatypes:\n" + e.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
    }

    public static boolean checkDatatypeCompatibility(String datatype1, String datatype2) {
        if (datatype1.equalsIgnoreCase(datatype2)) {
            return true;
        }
        for (int i = 0; i < datatypeCompatibilities.length; ++i) {
            if (datatypeCompatibilities[i][0].equalsIgnoreCase(datatype1) && datatypeCompatibilities[i][1].equalsIgnoreCase(datatype2)) {
                return true;
            }
            if (!datatypeCompatibilities[i][1].equalsIgnoreCase(datatype1) || !datatypeCompatibilities[i][0].equalsIgnoreCase(datatype2)) continue;
            return true;
        }
        return false;
    }

    public static String guessConceptualTypeGivenRelationalType(String relationalTypeName) throws M4Exception {
        if (relationalTypeName.equals("NUMBER")) {
            return "NUMERIC";
        }
        if (relationalTypeName.equals("STRING")) {
            return "NOMINAL";
        }
        if (relationalTypeName.equals("DATE")) {
            return "TIME";
        }
        if (relationalTypeName.equals("KEY")) {
            return "NOMINAL";
        }
        throw new M4Exception("ConceptualDatatypes.guessConceptualTypeGivenRelationalType: got unknown M4 relational data type '" + relationalTypeName + "'!");
    }

    public long getIdForName(String name) {
        Integer id = (Integer)this.nameToId.get(name);
        if (id != null) {
            return id.longValue();
        }
        return 0L;
    }

    public String getNameForId(long id) {
        Integer idI = new Integer((int)id);
        return (String)this.idToName.get(idI);
    }
}

