/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.m4.core;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.PrimaryKey;
import edu.udo.cs.miningmart.m4.Relation;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.Case;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.core.ConceptInheritance;
import edu.udo.cs.miningmart.m4.core.EstimatedStatistics;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.Parameter;
import edu.udo.cs.miningmart.m4.core.ParameterObject;
import edu.udo.cs.miningmart.m4.core.Projection;
import edu.udo.cs.miningmart.m4.utils.InterM4Communicator;
import edu.udo.cs.miningmart.m4.utils.InterM4ConceptColumnset;
import edu.udo.cs.miningmart.m4.utils.InterM4ConceptFeature;
import edu.udo.cs.miningmart.m4.utils.InterM4FromConceptProjection;
import edu.udo.cs.miningmart.m4.utils.InterM4FromConceptRelation;
import edu.udo.cs.miningmart.m4.utils.InterM4SubConceptConInh;
import edu.udo.cs.miningmart.m4.utils.InterM4SuperConceptConInh;
import edu.udo.cs.miningmart.m4.utils.InterM4ToConceptProjection;
import edu.udo.cs.miningmart.m4.utils.InterM4ToConceptRelation;
import edu.udo.cs.miningmart.m4.utils.M4Info;
import edu.udo.cs.miningmart.m4.utils.M4InfoEntry;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.m4.utils.XmlInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class Concept
extends ParameterObject
implements XmlInfo,
edu.udo.cs.miningmart.m4.Concept {
    public static final String M4_TABLE_NAME = "concept_t";
    public static final String ATTRIB_CONCEPT_ID = "con_id";
    public static final String ATTRIB_CASE_ID = "con_caid";
    public static final String ATTRIB_CONCEPT_NAME = "con_name";
    public static final String ATTRIB_CONCEPT_TYPE = "con_type";
    static final InterM4Communicator con2cs = new InterM4ConceptColumnset();
    static final InterM4Communicator con2fea = new InterM4ConceptFeature();
    static final InterM4Communicator con2ToRel = new InterM4ToConceptRelation();
    static final InterM4Communicator con2FromRel = new InterM4FromConceptRelation();
    static final InterM4Communicator con2toPro = new InterM4ToConceptProjection();
    static final InterM4Communicator con2fromPro = new InterM4FromConceptProjection();
    static final InterM4Communicator conInheritSub = new InterM4SubConceptConInh();
    static final InterM4Communicator conInheritSuper = new InterM4SuperConceptConInh();
    public static M4Info m4Info = null;
    private static M4Info xmlInfo = null;
    private final Vector myColumnSets = new Vector();
    private boolean allColumnSetsLoaded = false;
    private final Vector myFeatures = new Vector();
    private boolean allFeaturesLoaded = false;
    private final Vector myFromProjections = new Vector();
    private boolean allfromProjectionsLoaded = false;
    private final Vector myToProjections = new Vector();
    private boolean allToProjectionsLoaded = false;
    private final Vector mySubConceptsInh = new Vector();
    private boolean allSubConceptsLoaded = false;
    private final Vector mySuperConceptsInh = new Vector();
    private boolean allSuperConceptsLoaded = false;
    private final Vector myFromRelations = new Vector();
    private boolean allFromRelationsLoaded = false;
    private final Vector myToRelations = new Vector();
    private boolean allToRelationsLoaded = false;
    private String myType;
    private Case myCase;
    private EstimatedStatistics myEstimations = null;
    private Vector multiStepsColumnsets;
    private int columnsetIndex;

    public String getM4TableName() {
        return M4_TABLE_NAME;
    }

    public String getIdAttributeName() {
        return ATTRIB_CONCEPT_ID;
    }

    public M4Info getM4Info() {
        if (m4Info == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry(ATTRIB_CONCEPT_ID, "getId", "setId", Long.TYPE, "NN"), new M4InfoEntry(ATTRIB_CONCEPT_NAME, "getName", "setName", String.class, "NN"), new M4InfoEntry(ATTRIB_CASE_ID, "getTheCase", "primitiveSetCase", edu.udo.cs.miningmart.m4.Case.class, "NN"), new M4InfoEntry(ATTRIB_CONCEPT_TYPE, "getType", "setType", String.class, "NN")};
            m4Info = new M4Info(m4i);
        }
        return m4Info;
    }

    public M4Info getXmlInfo() {
        if (xmlInfo == null) {
            M4InfoEntry[] m4i = new M4InfoEntry[]{new M4InfoEntry("Name", "getName", "setName", String.class), new M4InfoEntry("Case", "getTheCase", "setTheCase", edu.udo.cs.miningmart.m4.Case.class), new M4InfoEntry("Type", "getType", "setType", String.class), new M4InfoEntry("Docu", "getDocumentation", "setDocumentation", String.class)};
            xmlInfo = new M4Info(m4i);
        }
        return xmlInfo;
    }

    public Concept(DB m4Db) {
        super(m4Db);
    }

    public void print() {
        this.doPrint(Print.M4_OBJECT, "Concept " + this.myName + "(Id = " + this.myId + ";" + " Type = " + this.myType + ") ");
        try {
            Collection features;
            Collection colSets = this.getColumnSets();
            if (colSets != null) {
                Iterator it = colSets.iterator();
                while (it.hasNext()) {
                    ((edu.udo.cs.miningmart.m4.core.Columnset)it.next()).print();
                }
            }
            if ((features = this.getFeatures()) != null) {
                Iterator it = features.iterator();
                while (it.hasNext()) {
                    ((edu.udo.cs.miningmart.m4.core.Feature)it.next()).print();
                }
            }
        }
        catch (M4Exception e) {
            this.doPrint(Print.MAX, "Warning: Exception caught while printing!");
            this.doPrint(e);
        }
        super.print();
    }

    protected Collection getObjectsInNamespace(Class typeOfObjects) throws M4Exception {
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.Columnset.class)) {
            return this.getColumnSets();
        }
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.BaseAttribute.class)) {
            return this.getAllBaseAttributes();
        }
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.MultiColumnFeature.class)) {
            return this.getAllMultiColumnFeatures();
        }
        if (typeOfObjects.isAssignableFrom(edu.udo.cs.miningmart.m4.core.Feature.class)) {
            return this.getFeatures();
        }
        throw new M4Exception("Concept.getObjectsInNamespace: unknown type of objects given: " + typeOfObjects.getName());
    }

    public void setName(String name) {
        name = this.replaceSpacesInName(name);
        super.setName(name);
    }

    public void setType(String t) throws M4Exception {
        this.setDirty();
        if (!(t.equalsIgnoreCase("DB") || t.equalsIgnoreCase("BASE") || t.equalsIgnoreCase("MINING"))) {
            throw new M4Exception("Tried to set unknown type into Concept '" + this.getName() + "': " + t);
        }
        this.myType = t.toUpperCase();
    }

    public void deleteSoon() throws M4Exception {
        Vector all = new Vector();
        all.addAll(this.getColumnSets());
        all.addAll(this.getFeatures());
        all.addAll(this.getTheFromRelationships());
        all.addAll(this.getTheToRelationships());
        all.addAll(this.getProjectionsAsFromConcept());
        all.addAll(this.getProjectionsAsToConcept());
        all.addAll(this.getConceptInheritanceAsSubConcept());
        all.addAll(this.getConceptInheritanceAsSuperConcept());
        for (M4Data m4d : new Vector(all)) {
            m4d.deleteSoon();
        }
        super.deleteSoon();
    }

    public String getType() {
        return this.myType;
    }

    public edu.udo.cs.miningmart.m4.Parameter getParameterWhereThisIsOutputConcept() throws M4Exception {
        Collection params = this.getParameterReferences();
        if (params != null) {
            for (Parameter p : params) {
                if (p == null || !p.getParameterType().equals("OUT")) continue;
                return p;
            }
        }
        return null;
    }

    public Collection getStepsWhereThisIsInputConcept() throws M4Exception {
        Collection params = this.getParameterReferences();
        Vector<Step> steps = new Vector<Step>();
        if (params != null) {
            for (Parameter p : params) {
                if (p == null || !p.getParameterType().equals("IN")) continue;
                steps.add(p.getTheStep());
            }
        }
        return steps;
    }

    public Step getStepWhereThisIsOutputConcept() throws M4Exception {
        Collection params = this.getParameterReferences();
        if (params != null) {
            for (Parameter p : params) {
                if (p == null || !p.getParameterType().equals("OUT")) continue;
                return (edu.udo.cs.miningmart.m4.core.Step)p.getTheStep();
            }
        }
        return null;
    }

    public void addColumnSet(Columnset cs) throws M4Exception {
        con2cs.checkNameExists((edu.udo.cs.miningmart.m4.core.Columnset)cs, this);
        con2cs.add(this, (edu.udo.cs.miningmart.m4.core.Columnset)cs);
    }

    public boolean removeColumnset(Columnset cs) throws M4Exception {
        return con2cs.remove(this, (edu.udo.cs.miningmart.m4.core.Columnset)cs);
    }

    public boolean hasMoreThanOneRelation() throws M4Exception {
        int number = this.getTheFromRelationships().size();
        return (number += this.getTheToRelationships().size()) > 1;
    }

    public boolean hasColumnset(Columnset cs) throws M4Exception {
        Collection csets = this.getFeatures();
        if (cs == null || csets == null) {
            return false;
        }
        return csets.contains(cs);
    }

    public void setColumnSets(Collection theColumnsets) throws M4Exception {
        con2cs.setCollectionTo(this, theColumnsets);
    }

    public Collection getColumnSets() throws M4Exception {
        if (!this.allColumnSetsLoaded && !this.isNew()) {
            this.allColumnSetsLoaded = true;
            this.readColumnSetsForConceptFromDB();
        }
        return this.myColumnSets;
    }

    public String getCurrentSuffix() {
        if (this.multiStepsColumnsets != null) {
            return "_" + this.columnsetIndex;
        }
        return "";
    }

    private void readColumnSetsForConceptFromDB() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Columnset.class).iterator();
        while (it.hasNext()) {
            this.addColumnSet((Columnset)it.next());
        }
    }

    public void initMultiStepSupport(Collection columnsets) {
        this.multiStepsColumnsets = new Vector(columnsets);
        this.resetColumnSets();
    }

    public Columnset getCurrentColumnSet() throws M4Exception {
        if (this.multiStepsColumnsets != null) {
            return (Columnset)this.multiStepsColumnsets.get(this.columnsetIndex);
        }
        Collection csets = this.getColumnSets();
        if (csets != null && !csets.isEmpty()) {
            return (Columnset)csets.iterator().next();
        }
        return null;
    }

    public void resetColumnSets() {
        this.columnsetIndex = 0;
    }

    public boolean hasNextColumnSet() throws M4Exception {
        if (this.multiStepsColumnsets != null) {
            return this.columnsetIndex + 1 < this.multiStepsColumnsets.size();
        }
        Collection c = this.getColumnSets();
        if (c == null) {
            throw new M4Exception("Concept '" + this.getName() + "', id: " + this.getId() + "\nError during call of method Concept.hasNextColumnSet(): " + "\"InputConcept\".getColumnSets() returned null.");
        }
        return false;
    }

    public Columnset getNextColumnSet() throws M4Exception {
        if (this.hasNextColumnSet()) {
            return (Columnset)this.multiStepsColumnsets.get(++this.columnsetIndex);
        }
        throw new M4Exception("Concept '" + this.getName() + "', id: " + this.getId() + "\nTried to call method getNextColumnSet() with no Columnset left!");
    }

    public edu.udo.cs.miningmart.m4.Case getTheCase() throws M4Exception {
        return this.myCase;
    }

    public void setTheCase(edu.udo.cs.miningmart.m4.Case ca) throws M4Exception {
        Case.case2con.checkNameExists(this, ca);
        Case.case2con.updateReferenceTo(this, ca);
    }

    public void primitiveSetCase(edu.udo.cs.miningmart.m4.Case ca) {
        this.setDirty();
        this.myCase = (Case)ca;
    }

    public void addFeature(Feature f) throws M4Exception {
        con2fea.checkNameExists((edu.udo.cs.miningmart.m4.core.Feature)f, this);
        con2fea.add(this, (edu.udo.cs.miningmart.m4.core.Feature)f);
        this.clearEstimations();
    }

    public Feature getFeature(int index) throws M4Exception {
        Collection fea = this.getFeatures();
        if (fea == null || index < 0 && index >= fea.size()) {
            throw new M4Exception("Concept.getFeature(): No Featurearray exists, or wrong index!");
        }
        Vector v = fea instanceof Vector ? (Vector)fea : new Vector(fea);
        return (Feature)v.get(index);
    }

    public Feature getFeature(String name) throws M4Exception {
        Collection fea = this.getFeatures();
        if (fea == null) {
            throw new M4Exception("Concept.getFeature(): No Featurearray exists!");
        }
        for (edu.udo.cs.miningmart.m4.core.Feature f : fea) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public boolean removeFeature(Feature feature) throws M4Exception {
        boolean ok = con2fea.remove(this, (edu.udo.cs.miningmart.m4.core.Feature)feature);
        this.clearEstimations();
        return ok;
    }

    public boolean removeFeatureByName(String name) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Feature f = (edu.udo.cs.miningmart.m4.core.Feature)this.getFeature(name);
        return this.removeFeature(f);
    }

    public String canFeatureBeRemoved(Feature theFeature) throws M4Exception {
        if (theFeature == null) {
            return null;
        }
        if (!this.hasFeature(theFeature)) {
            return null;
        }
        try {
            Collection steps = this.getStepsWhereThisIsInputConcept();
            Iterator it = steps.iterator();
            String errorMessage = null;
            while (it.hasNext() && errorMessage == null) {
                edu.udo.cs.miningmart.m4.core.Step oneStep = (edu.udo.cs.miningmart.m4.core.Step)it.next();
                errorMessage = this.checkErrorIfFeatureIsRemoved(oneStep, this, theFeature);
            }
            return errorMessage;
        }
        catch (M4Exception m4e) {
            throw new M4Exception("Error when checking if feature '" + theFeature.getName() + "' can be removed from concept '" + this.getName() + "':\n" + m4e.getMessage());
        }
    }

    private String checkErrorIfFeatureIsRemoved(Step step, edu.udo.cs.miningmart.m4.Concept theInputConcept, Feature theFeature) throws M4Exception {
        Concept nextInputConcept;
        String message = step.checkFeatureRemoval(theInputConcept, theFeature);
        if (message == null && (nextInputConcept = (Concept)step.getOutputConcept()) != null) {
            Collection nextFeatures = step.getCorrespondingOutputFeatures(theInputConcept, theFeature);
            for (edu.udo.cs.miningmart.m4.core.Feature nextFeature : nextFeatures) {
                Collection succs = step.getSuccessors();
                Iterator it = succs.iterator();
                while (it.hasNext() && message == null) {
                    edu.udo.cs.miningmart.m4.core.Step nextStep = (edu.udo.cs.miningmart.m4.core.Step)it.next();
                    message = this.checkErrorIfFeatureIsRemoved(nextStep, nextInputConcept, nextFeature);
                }
            }
        }
        return message;
    }

    public void setFeatures(Collection theFeatures) throws M4Exception {
        con2fea.setCollectionTo(this, theFeatures);
        this.clearEstimations();
    }

    public void removeAllFeatures() throws M4Exception {
        con2fea.setCollectionTo(this, new Vector());
        this.clearEstimations();
    }

    public Collection getFeatures() throws M4Exception {
        if (!this.allFeaturesLoaded && !this.isNew()) {
            this.allFeaturesLoaded = true;
            this.readFeaturesForConcept();
        }
        return this.myFeatures;
    }

    public String getFeatureNames() throws M4Exception {
        Collection fs = this.getFeatures();
        if (fs == null || fs.isEmpty()) {
            return "";
        }
        Iterator it = fs.iterator();
        String ret = "";
        while (it.hasNext()) {
            edu.udo.cs.miningmart.m4.core.Feature f = (edu.udo.cs.miningmart.m4.core.Feature)it.next();
            ret = ret + f.getName() + ", ";
        }
        return ret.substring(0, ret.length() - 2);
    }

    public int getNumberOfFeatures() throws M4Exception {
        Collection features = this.getFeatures();
        if (features == null) {
            return 0;
        }
        return features.size();
    }

    public boolean hasFeature(Feature f) throws M4Exception {
        Collection features = this.getFeatures();
        if (f == null || features == null) {
            return false;
        }
        return features.contains(f);
    }

    private void readFeaturesForConcept() throws M4Exception {
        this.readBaseAttributesFromDb();
        this.readMCFsFromDb();
        this.clearEstimations();
    }

    private void readBaseAttributesFromDb() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.BaseAttribute.class).iterator();
        while (it.hasNext()) {
            this.addFeature((BaseAttribute)it.next());
        }
    }

    private void readMCFsFromDb() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.MultiColumnFeature.class).iterator();
        while (it.hasNext()) {
            this.addFeature((MultiColumnFeature)it.next());
        }
    }

    public void propagateChangesToDependingConcepts(Feature changedFeature, String previousNameOfFeature) throws M4Exception {
        Parameter p;
        if (previousNameOfFeature != null && changedFeature != null) {
            this.getTheCase().storeChangedNameOfFeature(previousNameOfFeature, changedFeature.getName());
        }
        edu.udo.cs.miningmart.m4.core.Step featureCreatingStep = null;
        if (changedFeature != null && (p = (Parameter)changedFeature.getParameterWhereThisIsOutputFeature()) != null) {
            featureCreatingStep = (edu.udo.cs.miningmart.m4.core.Step)p.getTheStep();
        }
        Collection stepsToAdapt = this.getStepsWhereThisIsInputConcept();
        stepsToAdapt = this.getTheCase().sortSteps(stepsToAdapt);
        for (edu.udo.cs.miningmart.m4.core.Step aStep : stepsToAdapt) {
            if (changedFeature != null && (!aStep.isVisible(changedFeature) || featureCreatingStep != null && (aStep.equals(featureCreatingStep) || featureCreatingStep.isSuccessorOf(aStep))) || !aStep.adaptOutputToChangedInput()) continue;
            aStep.propagateOutputChanges();
        }
    }

    public Collection getTheFromRelationships() throws M4Exception {
        if (!this.allFromRelationsLoaded && !this.isNew()) {
            this.allFromRelationsLoaded = true;
            this.readRelationsFromDB(true);
        }
        return this.myFromRelations;
    }

    public Relation getRelationshipToConcept(edu.udo.cs.miningmart.m4.Concept toConcept) throws M4Exception {
        for (edu.udo.cs.miningmart.m4.core.Relation rel : this.getTheFromRelationships()) {
            if (!rel.getTheFromConcept().equals(this) || !rel.getTheToConcept().equals(toConcept)) continue;
            return rel;
        }
        return null;
    }

    public Relation getRelationshipFromConcept(edu.udo.cs.miningmart.m4.Concept fromConcept) throws M4Exception {
        for (edu.udo.cs.miningmart.m4.core.Relation rel : this.getTheToRelationships()) {
            if (!rel.getTheToConcept().equals(this) || !rel.getTheFromConcept().equals(fromConcept)) continue;
            return rel;
        }
        return null;
    }

    protected void addFromRelationship(Relation newRel) throws M4Exception {
        con2FromRel.checkNameExists((edu.udo.cs.miningmart.m4.core.Relation)newRel, this);
        con2FromRel.add(this, (edu.udo.cs.miningmart.m4.core.Relation)newRel);
    }

    protected void addToRelationship(Relation newRel) throws M4Exception {
        con2ToRel.checkNameExists((edu.udo.cs.miningmart.m4.core.Relation)newRel, this);
        con2ToRel.add(this, (edu.udo.cs.miningmart.m4.core.Relation)newRel);
    }

    public Collection getTheToRelationships() throws M4Exception {
        if (!this.allToRelationsLoaded && !this.isNew()) {
            this.allToRelationsLoaded = true;
            this.readRelationsFromDB(false);
        }
        return this.myToRelations;
    }

    public Collection getConceptInheritanceAsSuperConcept() throws M4Exception {
        if (!this.allSubConceptsLoaded && !this.isNew()) {
            this.allSubConceptsLoaded = true;
            this.readSubConceptsFromDB();
        }
        return this.mySubConceptsInh;
    }

    public Collection getConceptInheritanceAsSubConcept() throws M4Exception {
        if (!this.allSuperConceptsLoaded && !this.isNew()) {
            this.allSuperConceptsLoaded = true;
            this.readSuperConceptsFromDB();
        }
        return this.mySuperConceptsInh;
    }

    public Collection getSuperConcepts() throws M4Exception {
        Iterator it = this.getConceptInheritanceAsSubConcept().iterator();
        Vector<Concept> concepts = new Vector<Concept>();
        while (it.hasNext()) {
            Concept con;
            ConceptInheritance conInh = (ConceptInheritance)it.next();
            if (conInh == null || (con = (Concept)conInh.getSuperConcept()) == null) continue;
            concepts.add(con);
        }
        return concepts;
    }

    public Collection getSubConcepts() throws M4Exception {
        Iterator it = this.getConceptInheritanceAsSuperConcept().iterator();
        Vector<Concept> concepts = new Vector<Concept>();
        while (it.hasNext()) {
            Concept con;
            ConceptInheritance conInh = (ConceptInheritance)it.next();
            if (conInh == null || (con = (Concept)conInh.getSubConcept()) == null) continue;
            concepts.add(con);
        }
        return concepts;
    }

    public edu.udo.cs.miningmart.m4.Concept getTheSuperConcept() throws M4Exception {
        Collection col = this.getSuperConcepts();
        if (col == null || col.isEmpty()) {
            return null;
        }
        return (edu.udo.cs.miningmart.m4.Concept)col.iterator().next();
    }

    public void addSubConcept(edu.udo.cs.miningmart.m4.Concept newSubConcept) throws M4Exception {
        if (newSubConcept != null) {
            Collection col = newSubConcept.getSubConcepts();
            if (col.contains(this)) {
                String thisName = this.getName();
                String subName = newSubConcept.getName();
                throw new M4Exception("Adding/setting sub-concept (ID: " + newSubConcept.getId() + ", Name: " + (subName == null ? "<null>" : subName) + ") for concept (ID: " + this.getId() + ", Name: " + (thisName == null ? "<null>" : thisName) + ") would create an inheritance cycle!");
            }
            ConceptInheritance conInh = (ConceptInheritance)this.getM4Db().createNewInstance(ConceptInheritance.class);
            conInh.setSubConcept(newSubConcept);
            conInh.setSuperConcept(this);
        }
    }

    public void addSuperConcept(edu.udo.cs.miningmart.m4.Concept newSuperConcept) throws M4Exception {
        if (newSuperConcept != null) {
            Collection col = this.getAllSubConcepts();
            if (col.contains(newSuperConcept)) {
                String thisName = this.getName();
                String supName = newSuperConcept.getName();
                throw new M4Exception("Adding/setting super concept (ID: " + newSuperConcept.getId() + ", Name: " + (supName == null ? "<null>" : supName) + ") for concept (ID: " + this.getId() + ", Name: " + (thisName == null ? "<null>" : thisName) + ") would create an inheritance cycle!");
            }
            ConceptInheritance conInh = (ConceptInheritance)this.getM4Db().createNewInstance(ConceptInheritance.class);
            conInh.setSubConcept(this);
            conInh.setSuperConcept(newSuperConcept);
        }
    }

    public void removeSubConcept(edu.udo.cs.miningmart.m4.Concept theSubConcept) throws M4Exception {
        Iterator subIt = this.getConceptInheritanceAsSuperConcept().iterator();
        ConceptInheritance toBeRemoved = null;
        while (subIt.hasNext()) {
            ConceptInheritance mySubCon = (ConceptInheritance)subIt.next();
            if (!mySubCon.getSubConcept().equals(theSubConcept)) continue;
            toBeRemoved = mySubCon;
        }
        this.removeSubConcept(toBeRemoved);
    }

    public void removeSuperConcept(edu.udo.cs.miningmart.m4.Concept theSuperConcept) throws M4Exception {
        Iterator superIt = this.getConceptInheritanceAsSubConcept().iterator();
        ConceptInheritance toBeRemoved = null;
        while (superIt.hasNext()) {
            ConceptInheritance mySuperCon = (ConceptInheritance)superIt.next();
            if (!mySuperCon.getSubConcept().equals(theSuperConcept)) continue;
            toBeRemoved = mySuperCon;
        }
        this.removeSuperConcept(toBeRemoved);
    }

    public boolean isValidSubconcept(edu.udo.cs.miningmart.m4.Concept potentialSubConcept) throws M4Exception {
        boolean correspondingFeatureFound;
        if (potentialSubConcept == null) {
            return false;
        }
        for (edu.udo.cs.miningmart.m4.core.Feature firstF : this.getFeatures()) {
            correspondingFeatureFound = false;
            for (edu.udo.cs.miningmart.m4.core.Feature secondF : potentialSubConcept.getFeatures()) {
                if (!firstF.correspondsTo(secondF)) continue;
                correspondingFeatureFound = true;
            }
            if (correspondingFeatureFound) continue;
            return false;
        }
        for (edu.udo.cs.miningmart.m4.core.Feature firstF : potentialSubConcept.getFeatures()) {
            correspondingFeatureFound = false;
            for (edu.udo.cs.miningmart.m4.core.Feature secondF : this.getFeatures()) {
                if (!firstF.correspondsTo(secondF)) continue;
                correspondingFeatureFound = true;
            }
            if (correspondingFeatureFound) continue;
            return false;
        }
        return true;
    }

    private Collection getAllSubConcepts() throws M4Exception {
        Vector<Concept> open = new Vector<Concept>();
        HashSet<Concept> closed = new HashSet<Concept>();
        open.add(this);
        while (!open.isEmpty()) {
            Concept next = (Concept)open.firstElement();
            if (next == null) continue;
            for (Concept sub : next.getSubConcepts()) {
                if (open.contains(sub) || closed.contains(sub)) continue;
                open.add(sub);
            }
            open.remove(next);
            closed.add(next);
        }
        return closed;
    }

    public void setTheSuperConcept(edu.udo.cs.miningmart.m4.Concept newSuperConcept) throws M4Exception {
        conInheritSub.setCollectionTo(this, new Vector());
        this.addSuperConcept(newSuperConcept);
    }

    private void addSubConcept(ConceptInheritance conInh) throws M4Exception {
        conInheritSuper.add(this, conInh);
    }

    private void addSuperConcept(ConceptInheritance conInh) throws M4Exception {
        conInheritSub.add(this, conInh);
    }

    private void removeSubConcept(ConceptInheritance conInh) throws M4Exception {
        conInheritSuper.remove(this, conInh);
    }

    private void removeSuperConcept(ConceptInheritance conInh) throws M4Exception {
        conInheritSub.remove(this, conInh);
    }

    public edu.udo.cs.miningmart.m4.Projection createProjectionToConcept(edu.udo.cs.miningmart.m4.Concept toConcept, String nameOfProjection) throws M4Exception {
        Projection proj = new Projection(this.getM4Db());
        proj.setName(nameOfProjection);
        proj.setFromConcept(this);
        proj.setToConcept(toConcept);
        return proj;
    }

    public void addToProjection(edu.udo.cs.miningmart.m4.Projection projection) throws M4Exception {
        Collection col;
        if (projection != null && projection.getFromConcept() != null && (col = Projection.getTransitiveToProjectionsForConcept(this)).contains(projection.getFromConcept())) {
            projection.setFromConcept(null);
            throw new M4Exception("Setting the toConcept for this projection would result in cyclic projections!");
        }
        con2toPro.add(this, (Projection)projection);
    }

    public boolean removeToProjection(edu.udo.cs.miningmart.m4.Projection projection) throws M4Exception {
        return con2fromPro.remove(this, (Projection)projection);
    }

    public void addFromProjection(edu.udo.cs.miningmart.m4.Projection projection) throws M4Exception {
        Collection col;
        if (projection != null && projection.getToConcept() != null && (col = Projection.getTransitiveToProjectionsForConcept((Concept)((Projection)projection).getToConcept())).contains(this)) {
            projection.setToConcept(null);
            throw new M4Exception("Setting the toConcept for this projection would result in cyclic projections!");
        }
        con2fromPro.add(this, (Projection)projection);
    }

    public boolean removeFromProjection(edu.udo.cs.miningmart.m4.Projection projection) throws M4Exception {
        return con2fromPro.remove(this, (Projection)projection);
    }

    public void setTheFromProjection(edu.udo.cs.miningmart.m4.Concept newFromProjection) throws M4Exception {
        con2toPro.setCollectionTo(this, new Vector());
        if (newFromProjection != null) {
            Projection projection = (Projection)this.getM4Db().createNewInstance(Projection.class);
            projection.setFromConcept(newFromProjection);
            projection.setToConcept(this);
        }
    }

    public edu.udo.cs.miningmart.m4.Concept getTheFromProjection() throws M4Exception {
        Collection col = this.getProjectionsAsToConcept();
        if (col == null || col.isEmpty()) {
            return null;
        }
        return ((Projection)col.iterator().next()).getFromConcept();
    }

    public Collection getProjectionsAsFromConcept() throws M4Exception {
        if (!this.allfromProjectionsLoaded && !this.isNew()) {
            this.allfromProjectionsLoaded = true;
            this.readFromProjectionsFromDB();
        }
        return this.myFromProjections;
    }

    public Collection getProjectionsAsToConcept() throws M4Exception {
        if (!this.allToProjectionsLoaded && !this.isNew()) {
            this.allToProjectionsLoaded = true;
            this.readToProjectionsFromDB();
        }
        return this.myToProjections;
    }

    private void readSubConceptsFromDB() throws M4Exception {
        Collection conInhs = this.getObjectsReferencingMe(ConceptInheritance.class, "cisa_superconid");
        Iterator it = conInhs.iterator();
        while (it.hasNext()) {
            this.addSubConcept((ConceptInheritance)it.next());
        }
    }

    private void readSuperConceptsFromDB() throws M4Exception {
        Collection conInhs = this.getObjectsReferencingMe(ConceptInheritance.class, "cisa_subconid");
        Iterator it = conInhs.iterator();
        while (it.hasNext()) {
            this.addSuperConcept((ConceptInheritance)it.next());
        }
    }

    private void readFromProjectionsFromDB() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(Projection.class, "pro_fromconid").iterator();
        while (it.hasNext()) {
            this.addFromProjection((edu.udo.cs.miningmart.m4.Projection)it.next());
        }
    }

    private void readToProjectionsFromDB() throws M4Exception {
        Iterator it = this.getObjectsReferencingMe(Projection.class, "pro_toconid").iterator();
        while (it.hasNext()) {
            this.addToProjection((edu.udo.cs.miningmart.m4.Projection)it.next());
        }
    }

    private void readRelationsFromDB(boolean thisConceptIsFromConcept) throws M4Exception {
        String fkAttribute = thisConceptIsFromConcept ? "rel_fromconid" : "rel_toconid";
        Collection relations = this.getObjectsReferencingMe(edu.udo.cs.miningmart.m4.core.Relation.class, fkAttribute);
        Iterator it = relations.iterator();
        if (thisConceptIsFromConcept) {
            while (it.hasNext()) {
                this.addFromRelationship((Relation)it.next());
            }
        } else {
            while (it.hasNext()) {
                this.addToRelationship((Relation)it.next());
            }
        }
    }

    protected void removeAllM4References() throws M4Exception {
        super.removeAllM4References();
        this.setTheCase(null);
        Vector empty = new Vector(0);
        this.setFeatures(empty);
        this.setColumnSets(empty);
        con2FromRel.setCollectionTo(this, empty);
        con2ToRel.setCollectionTo(this, empty);
        con2fromPro.setCollectionTo(this, empty);
        con2toPro.setCollectionTo(this, empty);
        conInheritSub.setCollectionTo(this, empty);
        conInheritSuper.setCollectionTo(this, empty);
        this.removeDocObject();
    }

    protected boolean hasCoordinates() {
        return true;
    }

    protected Collection getGraphicallyEmbeddedObjects() throws M4Exception {
        Vector ret = new Vector();
        ret.addAll(this.getSuperConcepts());
        ret.addAll(this.getSubConcepts());
        ret.addAll(this.getTheFromRelationships());
        ret.addAll(this.getTheToRelationships());
        return ret;
    }

    public Collection getDependentObjects() throws M4Exception {
        Collection ret = super.getDependentObjects();
        ret.addAll(this.getColumnSets());
        ret.addAll(this.getFeatures());
        ret.addAll(this.getProjectionsAsFromConcept());
        ret.addAll(this.getProjectionsAsToConcept());
        ret.addAll(this.getConceptInheritanceAsSubConcept());
        ret.addAll(this.getConceptInheritanceAsSuperConcept());
        ret.addAll(this.getTheFromRelationships());
        ret.addAll(this.getTheToRelationships());
        return ret;
    }

    public boolean isRelationallyValid() throws M4Exception {
        Collection bas = this.getAllBaseAttributes();
        if (bas == null || bas.isEmpty()) {
            return false;
        }
        if (this.getType().equals("DB")) {
            Collection cs = this.getColumnSets();
            return cs != null && !cs.isEmpty();
        }
        Iterator it = null;
        try {
            it = this.getParameterReferences().iterator();
        }
        catch (M4Exception m4e) {
            super.doPrint(m4e);
            return false;
        }
        while (it.hasNext()) {
            if (((edu.udo.cs.miningmart.m4.Parameter)it.next()).getParameterType() != "OUT") continue;
            return true;
        }
        return false;
    }

    public edu.udo.cs.miningmart.m4.Concept copy(edu.udo.cs.miningmart.m4.Case newCase) throws M4Exception {
        Concept theCopy = new Concept(this.getM4Db());
        theCopy.setTheCase(newCase);
        for (edu.udo.cs.miningmart.m4.core.Feature myF : this.getFeatures()) {
            myF.copy(theCopy);
        }
        String nameOfCopy = newCase.getValidName(this.getName(), Concept.class);
        theCopy.setName(nameOfCopy);
        theCopy.setType(this.getType());
        return theCopy;
    }

    public BaseAttribute createBaseAttribute(String name, String datatype, String attributeType, String roleName) throws M4Exception {
        if (name == null || datatype == null) {
            throw new M4Exception("ConceptImpl.createBaseAttribute: got <null> for name or datatype of new BA!");
        }
        if (attributeType == null) {
            attributeType = "BASE";
        }
        edu.udo.cs.miningmart.m4.core.BaseAttribute newBA = new edu.udo.cs.miningmart.m4.core.BaseAttribute(this.getM4Db());
        newBA.setDBAttribS(attributeType);
        newBA.setConceptualDataTypeName(datatype);
        newBA.setRoleName(roleName);
        name = this.getValidName(name, edu.udo.cs.miningmart.m4.core.BaseAttribute.class);
        newBA.setName(name);
        newBA.setConcept(this);
        this.clearEstimations();
        return newBA;
    }

    public Columnset createColumnset(String name, String schema, String type) throws M4Exception {
        if (name == null || schema == null || type == null) {
            throw new M4Exception("Concept.createColumnSet: got <null> as a parameter!");
        }
        edu.udo.cs.miningmart.m4.core.Columnset newCS = new edu.udo.cs.miningmart.m4.core.Columnset(this.getM4Db());
        newCS.setType(type);
        newCS.setTheConcept(this);
        newCS.setName(name);
        newCS.setSchema(schema);
        return newCS;
    }

    public PrimaryKey createPrimaryKey(Collection keyAttribs) throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset current = (edu.udo.cs.miningmart.m4.core.Columnset)this.getCurrentColumnSet();
        if (current == null) {
            throw new M4Exception("Concept '" + this.getName() + "': cannot create a PrimaryKey because no Columnset is available!");
        }
        edu.udo.cs.miningmart.m4.core.PrimaryKey thePrimKey = null;
        if (!keyAttribs.isEmpty()) {
            thePrimKey = (edu.udo.cs.miningmart.m4.core.PrimaryKey)current.createPrimaryKey(current.getName() + "_PK");
            for (edu.udo.cs.miningmart.m4.core.BaseAttribute myBa : keyAttribs) {
                Column col = (Column)myBa.getCurrentColumn();
                if (col == null) continue;
                thePrimKey.addColumn(col);
            }
        }
        return thePrimKey;
    }

    public PrimaryKey getPrimaryKey() throws M4Exception {
        edu.udo.cs.miningmart.m4.core.Columnset current = (edu.udo.cs.miningmart.m4.core.Columnset)this.getCurrentColumnSet();
        if (current != null) {
            return current.getPrimaryKey();
        }
        return null;
    }

    public void connect(String nameOfDbObject, boolean isTable, Map columnNamesForAttribs) throws M4Exception {
        if (!this.getType().equals("DB")) {
            return;
        }
        this.removeConnection();
        String csType = isTable ? "T" : "V";
        edu.udo.cs.miningmart.m4.core.Columnset newCS = (edu.udo.cs.miningmart.m4.core.Columnset)this.createColumnset(nameOfDbObject, this.getM4Db().getBusinessSchemaName(), csType);
        newCS.createColumnsFromDbObject(nameOfDbObject);
        for (edu.udo.cs.miningmart.m4.core.BaseAttribute myBa : this.getAllBaseAttributes()) {
            String columnNameForBa = (String)columnNamesForAttribs.get(myBa);
            if (columnNameForBa == null) continue;
            Column columnForBa = (Column)newCS.getColumn(columnNameForBa);
            Vector<Column> v = new Vector<Column>();
            v.add(columnForBa);
            myBa.setColumns(v);
        }
    }

    public void removeConnection() throws M4Exception {
        if (!this.getType().equals("DB")) {
            return;
        }
        edu.udo.cs.miningmart.m4.core.Columnset current = (edu.udo.cs.miningmart.m4.core.Columnset)this.getCurrentColumnSet();
        if (current == null) {
            return;
        }
        this.removeColumnset(current);
        if (!this.getColumnSets().isEmpty()) {
            throw new M4Exception("Concept '" + this.getName() + "': found more than one columnset, although it is a DB type concept!");
        }
        if (current.getRelation() == null) {
            current.deleteSoon();
        }
    }

    public Relation createFromConceptRelation(String name, edu.udo.cs.miningmart.m4.Concept toConcept) throws M4Exception {
        if (name == null) {
            throw new M4Exception("Concept.createFromConceptRelationship: given name was <null>!");
        }
        Collection c = this.getTheFromRelationships();
        if (c != null) {
            for (edu.udo.cs.miningmart.m4.core.Relation rel : c) {
                Concept aToConcept = (Concept)rel.getTheToConcept();
                if (!rel.getName().equals(name) || aToConcept == null || toConcept == null || !aToConcept.getName().equals(toConcept.getName())) continue;
                throw new M4Exception("Could not create new Relationship in Concept " + this.getId() + ": Name '" + name + "' is not unique for ToConcept!");
            }
        }
        edu.udo.cs.miningmart.m4.core.Relation newRel = new edu.udo.cs.miningmart.m4.core.Relation(this.getM4Db());
        newRel.setTheFromConcept(this);
        newRel.setTheToConcept(toConcept);
        newRel.setName(name);
        return newRel;
    }

    public MultiColumnFeature createMultiColumnFeature(String name) throws M4Exception {
        if (name == null) {
            throw new M4Exception("ConceptImpl.createMCF: got <null> for the name!");
        }
        edu.udo.cs.miningmart.m4.core.MultiColumnFeature newMCF = new edu.udo.cs.miningmart.m4.core.MultiColumnFeature(this.getM4Db());
        newMCF.setConcept(this);
        newMCF.setName(name);
        this.clearEstimations();
        return newMCF;
    }

    public BaseAttribute getBaseAttribute(String name) throws M4Exception {
        if (name != null) {
            for (BaseAttribute b : this.getAllBaseAttributes()) {
                if (b == null || !name.equalsIgnoreCase(b.getName())) continue;
                return b;
            }
        }
        return null;
    }

    public BaseAttribute getBaseAttribute(edu.udo.cs.miningmart.m4.Column theColumn) throws M4Exception {
        if (theColumn != null) {
            for (BaseAttribute b : this.getAllBaseAttributes()) {
                if (b == null || !b.hasColumn(theColumn)) continue;
                return b;
            }
        }
        return null;
    }

    public Collection getAllBaseAttributes() throws M4Exception {
        Collection fea = this.getFeatures();
        Vector<Feature> bas = new Vector<Feature>();
        for (Feature f : fea) {
            if (f instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute && !bas.contains(f)) {
                bas.add(f);
            }
            if (!(f instanceof edu.udo.cs.miningmart.m4.core.MultiColumnFeature)) continue;
            for (edu.udo.cs.miningmart.m4.core.BaseAttribute ba : ((edu.udo.cs.miningmart.m4.core.MultiColumnFeature)f).getBaseAttributes()) {
                if (bas.contains(ba)) continue;
                bas.add(ba);
            }
        }
        return bas;
    }

    public Collection getBaseAttribsNotInMcf() throws M4Exception {
        Collection fea = this.getFeatures();
        Vector<Feature> bas = new Vector<Feature>();
        for (Feature f : fea) {
            if (!(f instanceof edu.udo.cs.miningmart.m4.core.BaseAttribute)) continue;
            bas.add(f);
        }
        return bas;
    }

    public Collection getBaseAttributesVisible(Step stepWhereVisible) throws M4Exception {
        Collection allBAs = this.getAllBaseAttributes();
        Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute> allVisibleBAs = new Vector<edu.udo.cs.miningmart.m4.core.BaseAttribute>();
        for (edu.udo.cs.miningmart.m4.core.BaseAttribute ba : allBAs) {
            if (stepWhereVisible != null && !stepWhereVisible.isVisible(ba)) continue;
            allVisibleBAs.add(ba);
        }
        return allVisibleBAs;
    }

    public void removeBaseAttribute(String name) throws M4Exception {
        BaseAttribute ba = this.getBaseAttribute(name);
        if (ba != null) {
            this.removeFeature(ba);
            this.clearEstimations();
        }
    }

    public void removeAllBaseAttributes() throws M4Exception {
        Collection c = this.getAllBaseAttributes();
        for (edu.udo.cs.miningmart.m4.core.Feature ba : new Vector(c)) {
            this.removeBaseAttribute(ba.getName());
        }
        this.clearEstimations();
    }

    public Collection getAllMultiColumnFeatures() throws M4Exception {
        Collection fea = this.getFeatures();
        Vector<Feature> mcfs = new Vector<Feature>();
        for (Feature f : fea) {
            if (!(f instanceof edu.udo.cs.miningmart.m4.core.MultiColumnFeature)) continue;
            mcfs.add(f);
        }
        return mcfs;
    }

    public void removeMultiColumnFeature(String name) throws M4Exception {
        MultiColumnFeature mcf = this.getMultiColumnFeature(name);
        if (mcf != null) {
            this.removeFeature(mcf);
        }
    }

    public void removeAllMultiColumnFeatures() throws M4Exception {
        Collection c = this.getAllMultiColumnFeatures();
        for (edu.udo.cs.miningmart.m4.core.Feature mcf : new Vector(c)) {
            this.removeBaseAttribute(mcf.getName());
        }
    }

    public MultiColumnFeature getMultiColumnFeature(String name) throws M4Exception {
        Collection mcfCol = this.getAllMultiColumnFeatures();
        for (MultiColumnFeature mcf : mcfCol) {
            if (mcf == null || !mcf.getName().equals(name)) continue;
            return mcf;
        }
        return null;
    }

    public void removeAllColumnsets() throws M4Exception {
        this.setColumnSets(new Vector());
    }

    public Columnset getColumnset(String name) throws M4Exception {
        Collection csCol = this.getColumnSets();
        for (Columnset cs : csCol) {
            if (cs == null || !cs.getName().equals(name)) continue;
            return cs;
        }
        return null;
    }

    public Columnset getColumnSetByBranch(String multiStepBranch) throws M4Exception {
        Collection csCol = this.getColumnSets();
        for (Columnset cs : csCol) {
            if (cs == null || !cs.getMultiStepBranch().equals(multiStepBranch)) continue;
            return cs;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public edu.udo.cs.miningmart.m4.EstimatedStatistics getEstimatedStatistics(Step visibleHere) throws M4Exception {
        if (this.myEstimations != null) {
            return this.myEstimations;
        }
        edu.udo.cs.miningmart.m4.core.Step conceptCreatingStep = null;
        if (this.getType().equals("DB")) {
            if (this.getCurrentColumnSet() == null) throw new M4Exception("Concept '" + this.getName() + "': cannot estimate statistics because no connection to a database object is given (concept is of type DB)!");
            this.myEstimations = new EstimatedStatistics(this);
        } else {
            conceptCreatingStep = (edu.udo.cs.miningmart.m4.core.Step)this.getStepWhereThisIsOutputConcept();
            if (conceptCreatingStep == null) {
                throw new M4Exception("Concept '" + this.getName() + "': cannot estimate statistics because the step that creates this concept cannot be determined!");
            }
            this.myEstimations = (EstimatedStatistics)conceptCreatingStep.estimateStatisticsForOutputConcept();
        }
        for (edu.udo.cs.miningmart.m4.core.BaseAttribute currentBa : this.getAllBaseAttributes()) {
            edu.udo.cs.miningmart.m4.core.Step creatingStep;
            if (currentBa.getType().equals("DB") || visibleHere != null && !visibleHere.isVisible(currentBa) || (creatingStep = (edu.udo.cs.miningmart.m4.core.Step)currentBa.getStepWhereThisIsOutputBa()) == null || creatingStep.equals(conceptCreatingStep)) continue;
            creatingStep.estimateStatisticsForOutputAttrib(this.myEstimations, currentBa);
        }
        return this.myEstimations;
    }

    public void clearEstimations() {
        this.myEstimations = null;
    }
}

